/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.StateListAnimator;
import android.content.res.TypedArray;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.Px;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.Border;
import com.facebook.litho.CommonUtils;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DefaultInternalNode;
import com.facebook.litho.DefaultNodeInfo;
import com.facebook.litho.DelegatingEventHandler;
import com.facebook.litho.DiffNode;
import com.facebook.litho.Edges;
import com.facebook.litho.EventHandler;
import com.facebook.litho.FastMath;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.Layout;
import com.facebook.litho.NodeConfig;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.R;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.SparseNodeInfo;
import com.facebook.litho.StateHandler;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.litho.TypedArrayUtils;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.WorkingRangeContainer;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.ComparableColorDrawable;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.litho.drawable.ComparableResDrawable;
import com.facebook.litho.drawable.DefaultComparableDrawable;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaConstants;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaNode;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

@ThreadConfined(value="ANY")
public class DefaultInternalNode
implements InternalNode,
Cloneable {
    private static final boolean SUPPORTS_RTL = Build.VERSION.SDK_INT >= 17;
    private static final long PFLAG_LAYOUT_DIRECTION_IS_SET = 1L;
    private static final long PFLAG_ALIGN_SELF_IS_SET = 2L;
    private static final long PFLAG_POSITION_TYPE_IS_SET = 4L;
    private static final long PFLAG_FLEX_IS_SET = 8L;
    private static final long PFLAG_FLEX_GROW_IS_SET = 16L;
    private static final long PFLAG_FLEX_SHRINK_IS_SET = 32L;
    private static final long PFLAG_FLEX_BASIS_IS_SET = 64L;
    private static final long PFLAG_IMPORTANT_FOR_ACCESSIBILITY_IS_SET = 128L;
    private static final long PFLAG_DUPLICATE_PARENT_STATE_IS_SET = 256L;
    private static final long PFLAG_MARGIN_IS_SET = 512L;
    private static final long PFLAG_PADDING_IS_SET = 1024L;
    private static final long PFLAG_POSITION_IS_SET = 2048L;
    private static final long PFLAG_WIDTH_IS_SET = 4096L;
    private static final long PFLAG_MIN_WIDTH_IS_SET = 8192L;
    private static final long PFLAG_MAX_WIDTH_IS_SET = 16384L;
    private static final long PFLAG_HEIGHT_IS_SET = 32768L;
    private static final long PFLAG_MIN_HEIGHT_IS_SET = 65536L;
    private static final long PFLAG_MAX_HEIGHT_IS_SET = 131072L;
    private static final long PFLAG_BACKGROUND_IS_SET = 262144L;
    private static final long PFLAG_FOREGROUND_IS_SET = 524288L;
    private static final long PFLAG_VISIBLE_HANDLER_IS_SET = 0x100000L;
    private static final long PFLAG_FOCUSED_HANDLER_IS_SET = 0x200000L;
    private static final long PFLAG_FULL_IMPRESSION_HANDLER_IS_SET = 0x400000L;
    private static final long PFLAG_INVISIBLE_HANDLER_IS_SET = 0x800000L;
    private static final long PFLAG_UNFOCUSED_HANDLER_IS_SET = 0x1000000L;
    private static final long PFLAG_TOUCH_EXPANSION_IS_SET = 0x2000000L;
    private static final long PFLAG_ASPECT_RATIO_IS_SET = 0x4000000L;
    private static final long PFLAG_TRANSITION_KEY_IS_SET = 0x8000000L;
    private static final long PFLAG_BORDER_IS_SET = 0x10000000L;
    private static final long PFLAG_STATE_LIST_ANIMATOR_SET = 0x20000000L;
    private static final long PFLAG_STATE_LIST_ANIMATOR_RES_SET = 0x40000000L;
    private static final long PFLAG_VISIBLE_RECT_CHANGED_HANDLER_IS_SET = 0x80000000L;
    private static final long PFLAG_TRANSITION_KEY_TYPE_IS_SET = 0x100000000L;
    private YogaNode mYogaNode;
    private ComponentContext mComponentContext;
    @ThreadConfined(value="ANY")
    private List<Component> mComponents = new ArrayList<Component>(1);
    private final int[] mBorderColors = new int[4];
    private final float[] mBorderRadius = new float[4];
    @Nullable
    private DiffNode mDiffNode;
    @Nullable
    private NodeInfo mNodeInfo;
    @Nullable
    private InternalNode.NestedTreeProps mNestedTreeProps;
    @Nullable
    private EventHandler<VisibleEvent> mVisibleHandler;
    @Nullable
    private EventHandler<FocusedVisibleEvent> mFocusedHandler;
    @Nullable
    private EventHandler<UnfocusedVisibleEvent> mUnfocusedHandler;
    @Nullable
    private EventHandler<FullImpressionVisibleEvent> mFullImpressionHandler;
    @Nullable
    private EventHandler<InvisibleEvent> mInvisibleHandler;
    @Nullable
    private EventHandler<VisibilityChangedEvent> mVisibilityChangedHandler;
    @Nullable
    private ComparableDrawable mBackground;
    @Nullable
    private ComparableDrawable mForeground;
    @Nullable
    private PathEffect mBorderPathEffect;
    @Nullable
    private StateListAnimator mStateListAnimator;
    @Nullable
    private boolean[] mIsPaddingPercent;
    @Nullable
    private Edges mTouchExpansion;
    @Nullable
    private String mTransitionKey;
    @Nullable
    private Transition.TransitionKeyType mTransitionKeyType;
    @Nullable
    private ArrayList<Transition> mTransitions;
    @Nullable
    private ArrayList<Component> mComponentsNeedingPreviousRenderData;
    @Nullable
    private ArrayList<WorkingRangeContainer.Registration> mWorkingRangeRegistrations;
    @Nullable
    private String mTestKey;
    @Nullable
    private Set<DebugComponent> mDebugComponents;
    @Nullable
    private List<Component> mUnresolvedComponents;
    private boolean mDuplicateParentState;
    private boolean mForceViewWrapping;
    private boolean mCachedMeasuresValid;
    private int mImportantForAccessibility = 0;
    @DrawableRes
    private int mStateListAnimatorRes;
    private float mVisibleHeightRatio;
    private float mVisibleWidthRatio;
    private float mResolvedTouchExpansionLeft = Float.NaN;
    private float mResolvedTouchExpansionRight = Float.NaN;
    private float mResolvedX = Float.NaN;
    private float mResolvedY = Float.NaN;
    private float mResolvedWidth = Float.NaN;
    private float mResolvedHeight = Float.NaN;
    private int mLastWidthSpec = -1;
    private int mLastHeightSpec = -1;
    private float mLastMeasuredWidth = -1.0f;
    private float mLastMeasuredHeight = -1.0f;
    private long mPrivateFlags;

    protected DefaultInternalNode(ComponentContext componentContext) {
        this(componentContext, DefaultInternalNode.createYogaNode(componentContext), true);
    }

    protected DefaultInternalNode(ComponentContext componentContext, YogaNode yogaNode) {
        this(componentContext, yogaNode, true);
    }

    protected DefaultInternalNode(ComponentContext componentContext, boolean createDebugComponentsInCtor) {
        this(componentContext, DefaultInternalNode.createYogaNode(componentContext), createDebugComponentsInCtor);
    }

    protected DefaultInternalNode(ComponentContext componentContext, YogaNode yogaNode, boolean createDebugComponentsInCtor) {
        if (createDebugComponentsInCtor) {
            this.mDebugComponents = new HashSet<DebugComponent>();
        }
        if (yogaNode != null) {
            yogaNode.setData((Object)this);
        }
        this.mYogaNode = yogaNode;
        this.mComponentContext = componentContext;
    }

    @Override
    public void addChildAt(InternalNode child, int index) {
        this.mYogaNode.addChildAt(child.getYogaNode(), index);
    }

    @Override
    public void addComponentNeedingPreviousRenderData(Component component) {
        if (this.mComponentsNeedingPreviousRenderData == null) {
            this.mComponentsNeedingPreviousRenderData = new ArrayList(1);
        }
        this.mComponentsNeedingPreviousRenderData.add(component);
    }

    @Override
    public void addTransition(Transition transition) {
        if (this.mTransitions == null) {
            this.mTransitions = new ArrayList(1);
        }
        this.mTransitions.add(transition);
    }

    @Override
    public void addWorkingRanges(List<WorkingRangeContainer.Registration> registrations) {
        if (this.mWorkingRangeRegistrations == null) {
            this.mWorkingRangeRegistrations = new ArrayList(registrations.size());
        }
        this.mWorkingRangeRegistrations.addAll(registrations);
    }

    @Override
    public InternalNode alignContent(YogaAlign alignContent) {
        this.mYogaNode.setAlignContent(alignContent);
        return this;
    }

    @Override
    public InternalNode alignItems(YogaAlign alignItems) {
        this.mYogaNode.setAlignItems(alignItems);
        return this;
    }

    @Override
    public void alignSelf(YogaAlign alignSelf) {
        this.mPrivateFlags |= 2L;
        this.mYogaNode.setAlignSelf(alignSelf);
    }

    @Override
    public void appendComponent(Component component) {
        this.mComponents.add(component);
    }

    @Override
    public void appendUnresolvedComponent(Component component) {
        if (this.mUnresolvedComponents == null) {
            this.mUnresolvedComponents = new ArrayList<Component>();
        }
        this.mUnresolvedComponents.add(component);
    }

    @Override
    public boolean areCachedMeasuresValid() {
        return this.mCachedMeasuresValid;
    }

    @Override
    public void aspectRatio(float aspectRatio) {
        this.mPrivateFlags |= 0x4000000L;
        this.mYogaNode.setAspectRatio(aspectRatio);
    }

    @Override
    public InternalNode background(@Nullable ComparableDrawable background) {
        this.mPrivateFlags |= 0x40000L;
        this.mBackground = background;
        this.setPaddingFromBackground(background);
        return this;
    }

    @Override
    @Deprecated
    public InternalNode background(@Nullable Drawable background) {
        if (background instanceof ComparableDrawable) {
            return this.background((ComparableDrawable)background);
        }
        return this.background(background != null ? DefaultComparableDrawable.create(background) : null);
    }

    @Override
    public InternalNode backgroundColor(@ColorInt int backgroundColor) {
        return this.background(ComparableColorDrawable.create(backgroundColor));
    }

    @Override
    public InternalNode backgroundRes(@DrawableRes int resId) {
        if (resId == 0) {
            return this.background((ComparableDrawable)null);
        }
        return this.background(ComparableResDrawable.create(this.mComponentContext.getAndroidContext(), resId));
    }

    @Override
    public InternalNode border(Border border) {
        this.mPrivateFlags |= 0x10000000L;
        int length = border.mEdgeWidths.length;
        for (int i = 0; i < length; ++i) {
            this.setBorderWidth(Border.edgeFromIndex(i), border.mEdgeWidths[i]);
        }
        System.arraycopy(border.mEdgeColors, 0, this.mBorderColors, 0, this.mBorderColors.length);
        System.arraycopy(border.mRadius, 0, this.mBorderRadius, 0, this.mBorderRadius.length);
        this.mBorderPathEffect = border.mPathEffect;
        return this;
    }

    @Override
    public void border(Edges width, int[] colors, float[] radii) {
        this.mPrivateFlags |= 0x10000000L;
        this.mYogaNode.setBorder(YogaEdge.LEFT, width.getRaw(YogaEdge.LEFT));
        this.mYogaNode.setBorder(YogaEdge.TOP, width.getRaw(YogaEdge.TOP));
        this.mYogaNode.setBorder(YogaEdge.RIGHT, width.getRaw(YogaEdge.RIGHT));
        this.mYogaNode.setBorder(YogaEdge.BOTTOM, width.getRaw(YogaEdge.BOTTOM));
        this.mYogaNode.setBorder(YogaEdge.VERTICAL, width.getRaw(YogaEdge.VERTICAL));
        this.mYogaNode.setBorder(YogaEdge.HORIZONTAL, width.getRaw(YogaEdge.HORIZONTAL));
        this.mYogaNode.setBorder(YogaEdge.START, width.getRaw(YogaEdge.START));
        this.mYogaNode.setBorder(YogaEdge.END, width.getRaw(YogaEdge.END));
        this.mYogaNode.setBorder(YogaEdge.ALL, width.getRaw(YogaEdge.ALL));
        System.arraycopy(colors, 0, this.mBorderColors, 0, colors.length);
        System.arraycopy(radii, 0, this.mBorderRadius, 0, radii.length);
    }

    @Override
    public void calculateLayout(float width, float height) {
        this.applyOverridesRecursive(this);
        this.mYogaNode.calculateLayout(width, height);
    }

    @Override
    public void calculateLayout() {
        this.calculateLayout(Float.NaN, Float.NaN);
    }

    @Override
    public InternalNode child(Component child) {
        if (child != null) {
            return this.child(Layout.create(this.mComponentContext, child));
        }
        return this;
    }

    @Override
    public InternalNode child(Component.Builder<?> child) {
        if (child != null) {
            this.child(child.build());
        }
        return this;
    }

    @Override
    public InternalNode child(InternalNode child) {
        if (child != null && child != ComponentContext.NULL_LAYOUT) {
            this.addChildAt(child, this.mYogaNode.getChildCount());
        }
        return this;
    }

    @Override
    public InternalNode duplicateParentState(boolean duplicateParentState) {
        this.mPrivateFlags |= 0x100L;
        this.mDuplicateParentState = duplicateParentState;
        return this;
    }

    @Override
    public void flex(float flex) {
        this.mPrivateFlags |= 8L;
        this.mYogaNode.setFlex(flex);
    }

    @Override
    public InternalNode flexBasisAuto() {
        this.mYogaNode.setFlexBasisAuto();
        return this;
    }

    @Override
    public void flexBasisPercent(float percent) {
        this.mPrivateFlags |= 0x40L;
        this.mYogaNode.setFlexBasisPercent(percent);
    }

    @Override
    public void flexBasisPx(@Px int flexBasis) {
        this.mPrivateFlags |= 0x40L;
        this.mYogaNode.setFlexBasis((float)flexBasis);
    }

    @Override
    public InternalNode flexDirection(YogaFlexDirection direction) {
        this.mYogaNode.setFlexDirection(direction);
        return this;
    }

    @Override
    public void flexGrow(float flexGrow) {
        this.mPrivateFlags |= 0x10L;
        this.mYogaNode.setFlexGrow(flexGrow);
    }

    @Override
    public void flexShrink(float flexShrink) {
        this.mPrivateFlags |= 0x20L;
        this.mYogaNode.setFlexShrink(flexShrink);
    }

    @Override
    public InternalNode focusedHandler(@Nullable EventHandler<FocusedVisibleEvent> focusedHandler) {
        this.mPrivateFlags |= 0x200000L;
        this.mFocusedHandler = DefaultInternalNode.addVisibilityHandler(this.mFocusedHandler, focusedHandler);
        return this;
    }

    @Override
    @Deprecated
    public InternalNode foreground(@Nullable Drawable foreground) {
        return this.foreground(foreground != null ? DefaultComparableDrawable.create(foreground) : null);
    }

    @Override
    public InternalNode foreground(@Nullable ComparableDrawable foreground) {
        this.mPrivateFlags |= 0x80000L;
        this.mForeground = foreground;
        return this;
    }

    @Override
    public InternalNode foregroundColor(@ColorInt int foregroundColor) {
        return this.foreground(ComparableColorDrawable.create(foregroundColor));
    }

    @Override
    public InternalNode foregroundRes(@DrawableRes int resId) {
        if (resId == 0) {
            return this.foreground((ComparableDrawable)null);
        }
        return this.foreground(ComparableResDrawable.create(this.mComponentContext.getAndroidContext(), resId));
    }

    @Override
    public InternalNode fullImpressionHandler(@Nullable EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
        this.mPrivateFlags |= 0x400000L;
        this.mFullImpressionHandler = DefaultInternalNode.addVisibilityHandler(this.mFullImpressionHandler, fullImpressionHandler);
        return this;
    }

    @Override
    public int[] getBorderColors() {
        return this.mBorderColors;
    }

    @Override
    @Nullable
    public PathEffect getBorderPathEffect() {
        return this.mBorderPathEffect;
    }

    @Override
    public float[] getBorderRadius() {
        return this.mBorderRadius;
    }

    @Override
    @Nullable
    public InternalNode getChildAt(int index) {
        return (InternalNode)this.mYogaNode.getChildAt(index).getData();
    }

    @Override
    public int getChildCount() {
        return this.mYogaNode.getChildCount();
    }

    @Override
    public int getChildIndex(InternalNode child) {
        int count = this.mYogaNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (this.mYogaNode.getChildAt(i) != child.getYogaNode()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Component> getComponents() {
        return this.mComponents;
    }

    @Override
    @Nullable
    public List<Component> getUnresolvedComponents() {
        return this.mUnresolvedComponents;
    }

    @Override
    @Nullable
    public ArrayList<Component> getComponentsNeedingPreviousRenderData() {
        return this.mComponentsNeedingPreviousRenderData;
    }

    @Override
    public ComponentContext getContext() {
        return this.mComponentContext;
    }

    @Override
    @Nullable
    public DiffNode getDiffNode() {
        return this.mDiffNode;
    }

    @Override
    public void setDiffNode(@Nullable DiffNode diffNode) {
        this.mDiffNode = diffNode;
    }

    @Override
    @Nullable
    public EventHandler<FocusedVisibleEvent> getFocusedHandler() {
        return this.mFocusedHandler;
    }

    @Override
    @Nullable
    public ComparableDrawable getForeground() {
        return this.mForeground;
    }

    @Override
    @Nullable
    public EventHandler<FullImpressionVisibleEvent> getFullImpressionHandler() {
        return this.mFullImpressionHandler;
    }

    @Override
    @Nullable
    public Component getHeadComponent() {
        return this.mComponents.isEmpty() ? null : this.mComponents.get(this.mComponents.size() - 1);
    }

    @Override
    public int getImportantForAccessibility() {
        return this.mImportantForAccessibility;
    }

    @Override
    @Nullable
    public EventHandler<InvisibleEvent> getInvisibleHandler() {
        return this.mInvisibleHandler;
    }

    @Override
    public int getLastHeightSpec() {
        return this.mLastHeightSpec;
    }

    @Override
    public void setLastHeightSpec(int heightSpec) {
        this.mLastHeightSpec = heightSpec;
    }

    @Override
    public float getLastMeasuredHeight() {
        return this.mLastMeasuredHeight;
    }

    @Override
    public void setLastMeasuredHeight(float lastMeasuredHeight) {
        this.mLastMeasuredHeight = lastMeasuredHeight;
    }

    @Override
    public float getLastMeasuredWidth() {
        return this.mLastMeasuredWidth;
    }

    @Override
    public void setLastMeasuredWidth(float lastMeasuredWidth) {
        this.mLastMeasuredWidth = lastMeasuredWidth;
    }

    @Override
    public int getLastWidthSpec() {
        return this.mLastWidthSpec;
    }

    @Override
    public void setLastWidthSpec(int widthSpec) {
        this.mLastWidthSpec = widthSpec;
    }

    @Override
    public int getLayoutBorder(YogaEdge edge) {
        return FastMath.round(this.mYogaNode.getLayoutBorder(edge));
    }

    @Override
    public float getMaxHeight() {
        return this.mYogaNode.getMaxHeight().value;
    }

    @Override
    public float getMaxWidth() {
        return this.mYogaNode.getMaxWidth().value;
    }

    @Override
    public float getMinHeight() {
        return this.mYogaNode.getMinHeight().value;
    }

    @Override
    public float getMinWidth() {
        return this.mYogaNode.getMinWidth().value;
    }

    @Override
    @Nullable
    public InternalNode getNestedTree() {
        return this.mNestedTreeProps != null ? this.mNestedTreeProps.mNestedTree : null;
    }

    @Override
    public void setNestedTree(InternalNode nestedTree) {
        if (nestedTree != ComponentContext.NULL_LAYOUT) {
            nestedTree.getOrCreateNestedTreeProps().mNestedTreeHolder = this;
        }
        this.getOrCreateNestedTreeProps().mNestedTree = nestedTree;
    }

    @Override
    @Nullable
    public InternalNode getNestedTreeHolder() {
        return this.mNestedTreeProps != null ? this.mNestedTreeProps.mNestedTreeHolder : null;
    }

    @Override
    @Nullable
    public NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    @Override
    public void setNodeInfo(NodeInfo nodeInfo) {
        this.mNodeInfo = nodeInfo;
    }

    @Override
    public InternalNode.NestedTreeProps getOrCreateNestedTreeProps() {
        if (this.mNestedTreeProps == null) {
            this.mNestedTreeProps = new InternalNode.NestedTreeProps();
        }
        return this.mNestedTreeProps;
    }

    @Override
    public NodeInfo getOrCreateNodeInfo() {
        if (this.mNodeInfo == null) {
            this.mNodeInfo = ComponentsConfiguration.isSparseNodeInfoIsEnabled ? new SparseNodeInfo() : new DefaultNodeInfo();
        }
        return this.mNodeInfo;
    }

    @Override
    @Nullable
    public InternalNode getParent() {
        if (this.mYogaNode == null || this.mYogaNode.getOwner() == null) {
            return null;
        }
        return (InternalNode)this.mYogaNode.getOwner().getData();
    }

    @Override
    @Nullable
    public TreeProps getPendingTreeProps() {
        return this.mNestedTreeProps != null ? this.mNestedTreeProps.mPendingTreeProps : null;
    }

    @Override
    @Nullable
    public Component getTailComponent() {
        return this.mComponents.isEmpty() ? null : this.mComponents.get(0);
    }

    @Override
    public void setRootComponent(Component component) {
        this.mComponents.clear();
        this.mComponents.add(component);
    }

    @Override
    @Nullable
    public StateListAnimator getStateListAnimator() {
        return this.mStateListAnimator;
    }

    @Override
    @DrawableRes
    public int getStateListAnimatorRes() {
        return this.mStateListAnimatorRes;
    }

    @Override
    public YogaDirection getStyleDirection() {
        return this.mYogaNode.getStyleDirection();
    }

    @Override
    public float getStyleHeight() {
        return this.mYogaNode.getHeight().value;
    }

    @Override
    public float getStyleWidth() {
        return this.mYogaNode.getWidth().value;
    }

    @Override
    @Nullable
    public String getTestKey() {
        return this.mTestKey;
    }

    @Override
    @Nullable
    public Edges getTouchExpansion() {
        return this.mTouchExpansion;
    }

    @Override
    public int getTouchExpansionBottom() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        return FastMath.round(this.mTouchExpansion.get(YogaEdge.BOTTOM));
    }

    @Override
    public int getTouchExpansionLeft() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        if (YogaConstants.isUndefined((float)this.mResolvedTouchExpansionLeft)) {
            this.mResolvedTouchExpansionLeft = this.resolveHorizontalEdges(this.mTouchExpansion, YogaEdge.LEFT);
        }
        return FastMath.round(this.mResolvedTouchExpansionLeft);
    }

    @Override
    public int getTouchExpansionRight() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        if (YogaConstants.isUndefined((float)this.mResolvedTouchExpansionRight)) {
            this.mResolvedTouchExpansionRight = this.resolveHorizontalEdges(this.mTouchExpansion, YogaEdge.RIGHT);
        }
        return FastMath.round(this.mResolvedTouchExpansionRight);
    }

    @Override
    public int getTouchExpansionTop() {
        if (!this.shouldApplyTouchExpansion()) {
            return 0;
        }
        return FastMath.round(this.mTouchExpansion.get(YogaEdge.TOP));
    }

    @Override
    @Nullable
    public String getTransitionKey() {
        return this.mTransitionKey;
    }

    @Override
    @Nullable
    public Transition.TransitionKeyType getTransitionKeyType() {
        return this.mTransitionKeyType;
    }

    @Override
    @Nullable
    public ArrayList<Transition> getTransitions() {
        return this.mTransitions;
    }

    @Override
    @Nullable
    public EventHandler<UnfocusedVisibleEvent> getUnfocusedHandler() {
        return this.mUnfocusedHandler;
    }

    @Override
    @Nullable
    public EventHandler<VisibilityChangedEvent> getVisibilityChangedHandler() {
        return this.mVisibilityChangedHandler;
    }

    @Override
    @Nullable
    public EventHandler<VisibleEvent> getVisibleHandler() {
        return this.mVisibleHandler;
    }

    @Override
    public float getVisibleHeightRatio() {
        return this.mVisibleHeightRatio;
    }

    @Override
    public float getVisibleWidthRatio() {
        return this.mVisibleWidthRatio;
    }

    @Override
    @Nullable
    public ArrayList<WorkingRangeContainer.Registration> getWorkingRangeRegistrations() {
        return this.mWorkingRangeRegistrations;
    }

    @Override
    public YogaNode getYogaNode() {
        return this.mYogaNode;
    }

    @Override
    public boolean hasBorderColor() {
        for (int color : this.mBorderColors) {
            if (color == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNestedTree() {
        return this.mNestedTreeProps != null && this.mNestedTreeProps.mNestedTree != null;
    }

    @Override
    public boolean hasNewLayout() {
        return this.mYogaNode.hasNewLayout();
    }

    @Override
    public boolean hasStateListAnimatorResSet() {
        return (this.mPrivateFlags & 0x40000000L) != 0L;
    }

    @Override
    public boolean hasTouchExpansion() {
        return (this.mPrivateFlags & 0x2000000L) != 0L;
    }

    @Override
    public boolean hasTransitionKey() {
        return !TextUtils.isEmpty((CharSequence)this.mTransitionKey);
    }

    @Override
    public boolean hasVisibilityHandlers() {
        return this.mVisibleHandler != null || this.mFocusedHandler != null || this.mUnfocusedHandler != null || this.mFullImpressionHandler != null || this.mInvisibleHandler != null || this.mVisibilityChangedHandler != null;
    }

    @Override
    public InternalNode heightAuto() {
        this.mYogaNode.setHeightAuto();
        return this;
    }

    @Override
    public void heightPercent(float percent) {
        this.mPrivateFlags |= 0x8000L;
        this.mYogaNode.setHeightPercent(percent);
    }

    @Override
    public void heightPx(@Px int height) {
        this.mPrivateFlags |= 0x8000L;
        this.mYogaNode.setHeight((float)height);
    }

    @Override
    public InternalNode importantForAccessibility(int importantForAccessibility) {
        this.mPrivateFlags |= 0x80L;
        this.mImportantForAccessibility = importantForAccessibility;
        return this;
    }

    @Override
    public InternalNode invisibleHandler(@Nullable EventHandler<InvisibleEvent> invisibleHandler) {
        this.mPrivateFlags |= 0x800000L;
        this.mInvisibleHandler = DefaultInternalNode.addVisibilityHandler(this.mInvisibleHandler, invisibleHandler);
        return this;
    }

    @Override
    public boolean isDuplicateParentStateEnabled() {
        return this.mDuplicateParentState;
    }

    @Override
    public boolean isForceViewWrapping() {
        return this.mForceViewWrapping;
    }

    @Override
    public boolean isImportantForAccessibilityIsSet() {
        return (this.mPrivateFlags & 0x80L) == 0L || this.mImportantForAccessibility == 0;
    }

    @Override
    public boolean isInitialized() {
        return this.mYogaNode != null && this.mComponentContext != null;
    }

    @Override
    public boolean isLayoutDirectionInherit() {
        return (this.mPrivateFlags & 1L) == 0L || this.getResolvedLayoutDirection() == YogaDirection.INHERIT;
    }

    @Override
    public boolean isNestedTreeHolder() {
        return this.mNestedTreeProps != null && this.mNestedTreeProps.mIsNestedTreeHolder;
    }

    @Override
    public void isReferenceBaseline(boolean isReferenceBaseline) {
        this.mYogaNode.setIsReferenceBaseline(isReferenceBaseline);
    }

    @Override
    public InternalNode justifyContent(YogaJustify justifyContent) {
        this.mYogaNode.setJustifyContent(justifyContent);
        return this;
    }

    @Override
    public void layoutDirection(YogaDirection direction) {
        this.mPrivateFlags |= 1L;
        this.mYogaNode.setDirection(direction);
    }

    @Override
    public void marginAuto(YogaEdge edge) {
        this.mPrivateFlags |= 0x200L;
        this.mYogaNode.setMarginAuto(edge);
    }

    @Override
    public void marginPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x200L;
        this.mYogaNode.setMarginPercent(edge, percent);
    }

    @Override
    public void marginPx(YogaEdge edge, @Px int margin) {
        this.mPrivateFlags |= 0x200L;
        this.mYogaNode.setMargin(edge, (float)margin);
    }

    @Override
    public void markIsNestedTreeHolder(TreeProps currentTreeProps) {
        this.getOrCreateNestedTreeProps().mIsNestedTreeHolder = true;
        this.getOrCreateNestedTreeProps().mPendingTreeProps = TreeProps.copy(currentTreeProps);
    }

    @Override
    public void markLayoutSeen() {
        this.mYogaNode.markLayoutSeen();
    }

    @Override
    public void maxHeightPercent(float percent) {
        this.mPrivateFlags |= 0x20000L;
        this.mYogaNode.setMaxHeightPercent(percent);
    }

    @Override
    public void maxHeightPx(@Px int maxHeight) {
        this.mPrivateFlags |= 0x20000L;
        this.mYogaNode.setMaxHeight((float)maxHeight);
    }

    @Override
    public void maxWidthPercent(float percent) {
        this.mPrivateFlags |= 0x4000L;
        this.mYogaNode.setMaxWidthPercent(percent);
    }

    @Override
    public void maxWidthPx(@Px int maxWidth) {
        this.mPrivateFlags |= 0x4000L;
        this.mYogaNode.setMaxWidth((float)maxWidth);
    }

    @Override
    public void minHeightPercent(float percent) {
        this.mPrivateFlags |= 0x10000L;
        this.mYogaNode.setMinHeightPercent(percent);
    }

    @Override
    public void minHeightPx(@Px int minHeight) {
        this.mPrivateFlags |= 0x10000L;
        this.mYogaNode.setMinHeight((float)minHeight);
    }

    @Override
    public void minWidthPercent(float percent) {
        this.mPrivateFlags |= 0x2000L;
        this.mYogaNode.setMinWidthPercent(percent);
    }

    @Override
    public void minWidthPx(@Px int minWidth) {
        this.mPrivateFlags |= 0x2000L;
        this.mYogaNode.setMinWidth((float)minWidth);
    }

    @Override
    public void paddingPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x400L;
        if (this.mNestedTreeProps != null && this.mNestedTreeProps.mIsNestedTreeHolder) {
            this.getNestedTreePadding().set(edge, percent);
            this.setIsPaddingPercent(edge, true);
        } else {
            this.mYogaNode.setPaddingPercent(edge, percent);
        }
    }

    @Override
    public void paddingPx(YogaEdge edge, @Px int padding) {
        this.mPrivateFlags |= 0x400L;
        if (this.mNestedTreeProps != null && this.mNestedTreeProps.mIsNestedTreeHolder) {
            this.getNestedTreePadding().set(edge, padding);
            this.setIsPaddingPercent(edge, false);
        } else {
            this.mYogaNode.setPadding(edge, (float)padding);
        }
    }

    @Override
    public void positionPercent(YogaEdge edge, float percent) {
        this.mPrivateFlags |= 0x800L;
        this.mYogaNode.setPositionPercent(edge, percent);
    }

    @Override
    public void positionPx(YogaEdge edge, @Px int position) {
        this.mPrivateFlags |= 0x800L;
        this.mYogaNode.setPosition(edge, (float)position);
    }

    @Override
    public void positionType(@Nullable YogaPositionType positionType) {
        this.mPrivateFlags |= 4L;
        this.mYogaNode.setPositionType(positionType);
    }

    @Override
    public YogaDirection recursivelyResolveLayoutDirection() {
        YogaNode yogaNode;
        for (yogaNode = this.mYogaNode; yogaNode != null && yogaNode.getLayoutDirection() == YogaDirection.INHERIT; yogaNode = yogaNode.getOwner()) {
        }
        return yogaNode == null ? YogaDirection.INHERIT : yogaNode.getLayoutDirection();
    }

    @Override
    public void registerDebugComponent(DebugComponent debugComponent) {
        if (this.mDebugComponents == null) {
            this.mDebugComponents = new HashSet<DebugComponent>();
        }
        this.mDebugComponents.add(debugComponent);
    }

    @Override
    public InternalNode removeChildAt(int index) {
        return (InternalNode)this.mYogaNode.removeChildAt(index).getData();
    }

    @Override
    public void resetResolvedLayoutProperties() {
        this.mResolvedTouchExpansionLeft = Float.NaN;
        this.mResolvedTouchExpansionRight = Float.NaN;
        this.mResolvedX = Float.NaN;
        this.mResolvedY = Float.NaN;
        this.mResolvedWidth = Float.NaN;
        this.mResolvedHeight = Float.NaN;
    }

    @Override
    public void setBorderWidth(YogaEdge edge, @Px int borderWidth) {
        if (this.mNestedTreeProps != null && this.mNestedTreeProps.mIsNestedTreeHolder) {
            InternalNode.NestedTreeProps props = this.getOrCreateNestedTreeProps();
            if (props.mNestedTreeBorderWidth == null) {
                props.mNestedTreeBorderWidth = new Edges();
            }
            props.mNestedTreeBorderWidth.set(edge, borderWidth);
        } else {
            this.mYogaNode.setBorder(edge, (float)borderWidth);
        }
    }

    @Override
    public void setCachedMeasuresValid(boolean valid) {
        this.mCachedMeasuresValid = valid;
    }

    @Override
    public void setMeasureFunction(YogaMeasureFunction measureFunction) {
        this.mYogaNode.setMeasureFunction(measureFunction);
    }

    @Override
    public void setStyleHeightFromSpec(int heightSpec) {
        switch (SizeSpec.getMode(heightSpec)) {
            case 0: {
                this.mYogaNode.setHeight(Float.NaN);
                break;
            }
            case -2147483648: {
                this.mYogaNode.setMaxHeight((float)SizeSpec.getSize(heightSpec));
                break;
            }
            case 0x40000000: {
                this.mYogaNode.setHeight((float)SizeSpec.getSize(heightSpec));
            }
        }
    }

    @Override
    public void setStyleWidthFromSpec(int widthSpec) {
        switch (SizeSpec.getMode(widthSpec)) {
            case 0: {
                this.mYogaNode.setWidth(Float.NaN);
                break;
            }
            case -2147483648: {
                this.mYogaNode.setMaxWidth((float)SizeSpec.getSize(widthSpec));
                break;
            }
            case 0x40000000: {
                this.mYogaNode.setWidth((float)SizeSpec.getSize(widthSpec));
            }
        }
    }

    @Override
    public boolean shouldDrawBorders() {
        return this.hasBorderColor() && (this.mYogaNode.getLayoutBorder(YogaEdge.LEFT) != 0.0f || this.mYogaNode.getLayoutBorder(YogaEdge.TOP) != 0.0f || this.mYogaNode.getLayoutBorder(YogaEdge.RIGHT) != 0.0f || this.mYogaNode.getLayoutBorder(YogaEdge.BOTTOM) != 0.0f);
    }

    @Override
    public InternalNode stateListAnimator(@Nullable StateListAnimator stateListAnimator) {
        this.mPrivateFlags |= 0x20000000L;
        this.mStateListAnimator = stateListAnimator;
        this.wrapInView();
        return this;
    }

    @Override
    public InternalNode stateListAnimatorRes(@DrawableRes int resId) {
        this.mPrivateFlags |= 0x40000000L;
        this.mStateListAnimatorRes = resId;
        this.wrapInView();
        return this;
    }

    @Override
    public InternalNode testKey(@Nullable String testKey) {
        this.mTestKey = testKey;
        return this;
    }

    @Override
    public InternalNode touchExpansionPx(YogaEdge edge, @Px int touchExpansion) {
        if (this.mTouchExpansion == null) {
            this.mTouchExpansion = new Edges();
        }
        this.mPrivateFlags |= 0x2000000L;
        this.mTouchExpansion.set(edge, touchExpansion);
        return this;
    }

    @Override
    public InternalNode transitionKey(@Nullable String key) {
        if (Build.VERSION.SDK_INT >= 14 && !TextUtils.isEmpty((CharSequence)key)) {
            this.mPrivateFlags |= 0x8000000L;
            this.mTransitionKey = key;
        }
        return this;
    }

    @Override
    public InternalNode transitionKeyType(@Nullable Transition.TransitionKeyType type) {
        this.mPrivateFlags |= 0x100000000L;
        this.mTransitionKeyType = type;
        return this;
    }

    @Override
    public InternalNode unfocusedHandler(@Nullable EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
        this.mPrivateFlags |= 0x1000000L;
        this.mUnfocusedHandler = DefaultInternalNode.addVisibilityHandler(this.mUnfocusedHandler, unfocusedHandler);
        return this;
    }

    @Override
    public void useHeightAsBaseline(boolean useHeightAsBaselineFunction) {
        if (useHeightAsBaselineFunction) {
            this.mYogaNode.setBaselineFunction(new YogaBaselineFunction(){

                public float baseline(YogaNode yogaNode, float width, float height) {
                    return height;
                }
            });
        }
    }

    @Override
    public InternalNode visibilityChangedHandler(@Nullable EventHandler<VisibilityChangedEvent> visibilityChangedHandler) {
        this.mPrivateFlags |= 0x80000000L;
        this.mVisibilityChangedHandler = DefaultInternalNode.addVisibilityHandler(this.mVisibilityChangedHandler, visibilityChangedHandler);
        return this;
    }

    @Override
    public InternalNode visibleHandler(@Nullable EventHandler<VisibleEvent> visibleHandler) {
        this.mPrivateFlags |= 0x100000L;
        this.mVisibleHandler = DefaultInternalNode.addVisibilityHandler(this.mVisibleHandler, visibleHandler);
        return this;
    }

    @Override
    public InternalNode visibleHeightRatio(float visibleHeightRatio) {
        this.mVisibleHeightRatio = visibleHeightRatio;
        return this;
    }

    @Override
    public InternalNode visibleWidthRatio(float visibleWidthRatio) {
        this.mVisibleWidthRatio = visibleWidthRatio;
        return this;
    }

    @Override
    public InternalNode widthAuto() {
        this.mYogaNode.setWidthAuto();
        return this;
    }

    @Override
    public void widthPercent(float percent) {
        this.mPrivateFlags |= 0x1000L;
        this.mYogaNode.setWidthPercent(percent);
    }

    @Override
    public void widthPx(@Px int width) {
        this.mPrivateFlags |= 0x1000L;
        this.mYogaNode.setWidth((float)width);
    }

    @Override
    public InternalNode wrap(YogaWrap wrap) {
        this.mYogaNode.setWrap(wrap);
        return this;
    }

    @Override
    public InternalNode wrapInView() {
        this.mForceViewWrapping = true;
        return this;
    }

    @Override
    @Px
    public int getX() {
        if (YogaConstants.isUndefined((float)this.mResolvedX)) {
            this.mResolvedX = this.mYogaNode.getLayoutX();
        }
        return (int)this.mResolvedX;
    }

    @Override
    @Px
    public int getY() {
        if (YogaConstants.isUndefined((float)this.mResolvedY)) {
            this.mResolvedY = this.mYogaNode.getLayoutY();
        }
        return (int)this.mResolvedY;
    }

    @Override
    @Px
    public int getWidth() {
        if (YogaConstants.isUndefined((float)this.mResolvedWidth)) {
            this.mResolvedWidth = this.mYogaNode.getLayoutWidth();
        }
        return (int)this.mResolvedWidth;
    }

    @Override
    @Px
    public int getHeight() {
        if (YogaConstants.isUndefined((float)this.mResolvedHeight)) {
            this.mResolvedHeight = this.mYogaNode.getLayoutHeight();
        }
        return (int)this.mResolvedHeight;
    }

    @Override
    @Px
    public int getPaddingTop() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.TOP));
    }

    @Override
    @Px
    public int getPaddingRight() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.RIGHT));
    }

    @Override
    @Px
    public int getPaddingBottom() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.BOTTOM));
    }

    @Override
    @Px
    public int getPaddingLeft() {
        return FastMath.round(this.mYogaNode.getLayoutPadding(YogaEdge.LEFT));
    }

    @Override
    public boolean isPaddingSet() {
        return (this.mPrivateFlags & 0x400L) != 0L;
    }

    @Override
    @Nullable
    public ComparableDrawable getBackground() {
        return this.mBackground;
    }

    @Override
    public YogaDirection getResolvedLayoutDirection() {
        return this.mYogaNode.getLayoutDirection();
    }

    @Override
    public void copyInto(InternalNode target) {
        if (target == ComponentContext.NULL_LAYOUT) {
            return;
        }
        if (this.mNodeInfo != null) {
            if (target.getNodeInfo() == null) {
                target.setNodeInfo(this.mNodeInfo);
            } else {
                this.mNodeInfo.copyInto(target.getOrCreateNodeInfo());
            }
        }
        if (target.isLayoutDirectionInherit()) {
            target.layoutDirection(this.getResolvedLayoutDirection());
        }
        if (target.isImportantForAccessibilityIsSet()) {
            target.importantForAccessibility(this.mImportantForAccessibility);
        }
        if ((this.mPrivateFlags & 0x100L) != 0L) {
            target.duplicateParentState(this.mDuplicateParentState);
        }
        if ((this.mPrivateFlags & 0x40000L) != 0L) {
            target.background(this.mBackground);
        }
        if ((this.mPrivateFlags & 0x80000L) != 0L) {
            target.foreground(this.mForeground);
        }
        if (this.mForceViewWrapping) {
            target.wrapInView();
        }
        if ((this.mPrivateFlags & 0x100000L) != 0L) {
            target.visibleHandler(this.mVisibleHandler);
        }
        if ((this.mPrivateFlags & 0x200000L) != 0L) {
            target.focusedHandler(this.mFocusedHandler);
        }
        if ((this.mPrivateFlags & 0x400000L) != 0L) {
            target.fullImpressionHandler(this.mFullImpressionHandler);
        }
        if ((this.mPrivateFlags & 0x800000L) != 0L) {
            target.invisibleHandler(this.mInvisibleHandler);
        }
        if ((this.mPrivateFlags & 0x1000000L) != 0L) {
            target.unfocusedHandler(this.mUnfocusedHandler);
        }
        if ((this.mPrivateFlags & 0x80000000L) != 0L) {
            target.visibilityChangedHandler(this.mVisibilityChangedHandler);
        }
        if (this.mTestKey != null) {
            target.testKey(this.mTestKey);
        }
        if ((this.mPrivateFlags & 0x400L) != 0L) {
            if (this.mNestedTreeProps == null || this.mNestedTreeProps.mNestedTreePadding == null) {
                throw new IllegalStateException("copyInto() must be used when resolving a nestedTree. If padding was set on the holder node, we must have a mNestedTreePadding instance");
            }
            for (int i = 0; i < Edges.EDGES_LENGTH; ++i) {
                float value = this.mNestedTreeProps.mNestedTreePadding.getRaw(i);
                if (YogaConstants.isUndefined((float)value)) continue;
                YogaEdge edge = YogaEdge.fromInt((int)i);
                if (this.isPaddingPercent(edge)) {
                    target.paddingPercent(edge, value);
                    continue;
                }
                target.paddingPx(edge, (int)value);
            }
        }
        if ((this.mPrivateFlags & 0x10000000L) != 0L) {
            if (this.mNestedTreeProps == null || this.mNestedTreeProps.mNestedTreeBorderWidth == null) {
                throw new IllegalStateException("copyInto() must be used when resolving a nestedTree.If border width was set on the holder node, we must have a mNestedTreeBorderWidth instance");
            }
            target.border(this.mNestedTreeProps.mNestedTreeBorderWidth, this.mBorderColors, this.mBorderRadius);
        }
        if ((this.mPrivateFlags & 0x8000000L) != 0L) {
            target.transitionKey(this.mTransitionKey);
        }
        if ((this.mPrivateFlags & 0x100000000L) != 0L) {
            target.transitionKeyType(this.mTransitionKeyType);
        }
        if (this.mVisibleHeightRatio != 0.0f) {
            target.visibleHeightRatio(this.mVisibleHeightRatio);
        }
        if (this.mVisibleWidthRatio != 0.0f) {
            target.visibleWidthRatio(this.mVisibleWidthRatio);
        }
        if ((this.mPrivateFlags & 0x20000000L) != 0L) {
            target.stateListAnimator(this.mStateListAnimator);
        }
        if ((this.mPrivateFlags & 0x40000000L) != 0L) {
            target.stateListAnimatorRes(this.mStateListAnimatorRes);
        }
    }

    @Override
    public void applyAttributes(TypedArray a) {
        int size = a.getIndexCount();
        for (int i = 0; i < size; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.ComponentLayout_android_layout_width) {
                int width = a.getLayoutDimension(attr, -1);
                if (width < 0) continue;
                this.widthPx(width);
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_height) {
                int height = a.getLayoutDimension(attr, -1);
                if (height < 0) continue;
                this.heightPx(height);
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_minHeight) {
                this.minHeightPx(a.getDimensionPixelSize(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_minWidth) {
                this.minWidthPx(a.getDimensionPixelSize(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_paddingLeft) {
                this.paddingPx(YogaEdge.LEFT, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_paddingTop) {
                this.paddingPx(YogaEdge.TOP, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_paddingRight) {
                this.paddingPx(YogaEdge.RIGHT, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_paddingBottom) {
                this.paddingPx(YogaEdge.BOTTOM, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_paddingStart && SUPPORTS_RTL) {
                this.paddingPx(YogaEdge.START, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_paddingEnd && SUPPORTS_RTL) {
                this.paddingPx(YogaEdge.END, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_padding) {
                this.paddingPx(YogaEdge.ALL, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_marginLeft) {
                this.marginPx(YogaEdge.LEFT, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_marginTop) {
                this.marginPx(YogaEdge.TOP, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_marginRight) {
                this.marginPx(YogaEdge.RIGHT, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_marginBottom) {
                this.marginPx(YogaEdge.BOTTOM, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_marginStart && SUPPORTS_RTL) {
                this.marginPx(YogaEdge.START, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_marginEnd && SUPPORTS_RTL) {
                this.marginPx(YogaEdge.END, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_layout_margin) {
                this.marginPx(YogaEdge.ALL, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_importantForAccessibility && Build.VERSION.SDK_INT >= 16) {
                this.importantForAccessibility(a.getInt(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_duplicateParentState) {
                this.duplicateParentState(a.getBoolean(attr, false));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_background) {
                if (TypedArrayUtils.isColorAttribute(a, R.styleable.ComponentLayout_android_background)) {
                    this.backgroundColor(a.getColor(attr, 0));
                    continue;
                }
                this.backgroundRes(a.getResourceId(attr, -1));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_foreground) {
                if (TypedArrayUtils.isColorAttribute(a, R.styleable.ComponentLayout_android_foreground)) {
                    this.foregroundColor(a.getColor(attr, 0));
                    continue;
                }
                this.foregroundRes(a.getResourceId(attr, -1));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_android_contentDescription) {
                this.getOrCreateNodeInfo().setContentDescription(a.getString(attr));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_direction) {
                this.flexDirection(YogaFlexDirection.fromInt((int)a.getInteger(attr, 0)));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_wrap) {
                this.wrap(YogaWrap.fromInt((int)a.getInteger(attr, 0)));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_justifyContent) {
                this.justifyContent(YogaJustify.fromInt((int)a.getInteger(attr, 0)));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_alignItems) {
                this.alignItems(YogaAlign.fromInt((int)a.getInteger(attr, 0)));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_alignSelf) {
                this.alignSelf(YogaAlign.fromInt((int)a.getInteger(attr, 0)));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_positionType) {
                this.positionType(YogaPositionType.fromInt((int)a.getInteger(attr, 0)));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex) {
                float flex = a.getFloat(attr, -1.0f);
                if (!(flex >= 0.0f)) continue;
                this.flex(flex);
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_left) {
                this.positionPx(YogaEdge.LEFT, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_top) {
                this.positionPx(YogaEdge.TOP, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_right) {
                this.positionPx(YogaEdge.RIGHT, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr == R.styleable.ComponentLayout_flex_bottom) {
                this.positionPx(YogaEdge.BOTTOM, a.getDimensionPixelOffset(attr, 0));
                continue;
            }
            if (attr != R.styleable.ComponentLayout_flex_layoutDirection) continue;
            int layoutDirection = a.getInteger(attr, -1);
            this.layoutDirection(YogaDirection.fromInt((int)layoutDirection));
        }
    }

    @Override
    public void assertContextSpecificStyleNotSet() {
        List<String> errorTypes = null;
        if ((this.mPrivateFlags & 2L) != 0L) {
            errorTypes = CommonUtils.addOrCreateList(errorTypes, "alignSelf");
        }
        if ((this.mPrivateFlags & 4L) != 0L) {
            errorTypes = CommonUtils.addOrCreateList(errorTypes, "positionType");
        }
        if ((this.mPrivateFlags & 8L) != 0L) {
            errorTypes = CommonUtils.addOrCreateList(errorTypes, "flex");
        }
        if ((this.mPrivateFlags & 0x10L) != 0L) {
            errorTypes = CommonUtils.addOrCreateList(errorTypes, "flexGrow");
        }
        if ((this.mPrivateFlags & 0x200L) != 0L) {
            errorTypes = CommonUtils.addOrCreateList(errorTypes, "margin");
        }
        if (errorTypes != null) {
            String errorStr = TextUtils.join((CharSequence)", ", errorTypes);
            ComponentsLogger logger = this.getContext().getLogger();
            if (logger != null) {
                logger.emitMessage(ComponentsLogger.LogLevel.WARNING, "You should not set " + errorStr + " to a root layout in " + this.getTailComponent().getClass().getSimpleName());
            }
        }
    }

    @Override
    public DefaultInternalNode deepClone() {
        YogaNode node;
        if (this == ComponentContext.NULL_LAYOUT) {
            return this;
        }
        DefaultInternalNode copy = this.clone();
        copy.mYogaNode = node = this.mYogaNode.cloneWithoutChildren();
        node.setData((Object)copy);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            copy.child(this.getChildAt(i).deepClone());
        }
        copy.resetResolvedLayoutProperties();
        return copy;
    }

    @Override
    public String getSimpleName() {
        return this.mComponents.isEmpty() ? "<null>" : this.mComponents.get(0).getSimpleName();
    }

    @Override
    public InternalNode reconcile(ComponentContext c, Component next) {
        StateHandler stateHandler = c.getStateHandler();
        Set<Object> keys = stateHandler == null ? Collections.emptySet() : stateHandler.getKeysForPendingUpdates();
        return DefaultInternalNode.reconcile(c, this, next, keys);
    }

    protected DefaultInternalNode clone() {
        try {
            return (DefaultInternalNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private boolean isPaddingPercent(YogaEdge edge) {
        return this.mIsPaddingPercent != null && this.mIsPaddingPercent[edge.intValue()];
    }

    private void applyOverridesRecursive(@Nullable InternalNode node) {
        if (ComponentsConfiguration.isDebugModeEnabled && node != null) {
            DebugComponent.applyOverrides(this.mComponentContext, node);
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.applyOverridesRecursive(node.getChildAt(i));
            }
            if (node.hasNestedTree()) {
                this.applyOverridesRecursive(node.getNestedTree());
            }
        }
    }

    @ReturnsOwnership
    private Edges getNestedTreePadding() {
        InternalNode.NestedTreeProps props = this.getOrCreateNestedTreeProps();
        if (props.mNestedTreePadding == null) {
            props.mNestedTreePadding = new Edges();
        }
        return props.mNestedTreePadding;
    }

    private float resolveHorizontalEdges(Edges spacing, YogaEdge edge) {
        YogaEdge resolvedEdge;
        boolean isRtl = this.mYogaNode.getLayoutDirection() == YogaDirection.RTL;
        switch (edge) {
            case LEFT: {
                resolvedEdge = isRtl ? YogaEdge.END : YogaEdge.START;
                break;
            }
            case RIGHT: {
                resolvedEdge = isRtl ? YogaEdge.START : YogaEdge.END;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not an horizontal padding edge: " + edge);
            }
        }
        float result = spacing.getRaw(resolvedEdge);
        if (YogaConstants.isUndefined((float)result)) {
            result = spacing.get(edge);
        }
        return result;
    }

    private void setIsPaddingPercent(YogaEdge edge, boolean isPaddingPercent) {
        if (this.mIsPaddingPercent == null && isPaddingPercent) {
            this.mIsPaddingPercent = new boolean[YogaEdge.ALL.intValue() + 1];
        }
        if (this.mIsPaddingPercent != null) {
            this.mIsPaddingPercent[edge.intValue()] = isPaddingPercent;
        }
    }

    private void setPaddingFromBackground(Drawable drawable) {
        Rect backgroundPadding;
        if (drawable != null && DefaultInternalNode.getDrawablePadding(drawable, backgroundPadding = new Rect())) {
            this.paddingPx(YogaEdge.LEFT, backgroundPadding.left);
            this.paddingPx(YogaEdge.TOP, backgroundPadding.top);
            this.paddingPx(YogaEdge.RIGHT, backgroundPadding.right);
            this.paddingPx(YogaEdge.BOTTOM, backgroundPadding.bottom);
        }
    }

    private boolean shouldApplyTouchExpansion() {
        return this.mTouchExpansion != null && this.mNodeInfo != null && this.mNodeInfo.hasTouchEventHandlers();
    }

    private void clean() {
        this.mComponents = new ArrayList<Component>();
        this.mDiffNode = null;
        this.mDebugComponents = null;
        this.resetResolvedLayoutProperties();
    }

    private void updateWith(ComponentContext c, YogaNode node, List<Component> components) {
        this.mComponentContext = c;
        this.mYogaNode = node;
        this.mYogaNode.setData((Object)this);
        this.mComponents = components;
        this.mComponentsNeedingPreviousRenderData = null;
        for (Component component : components) {
            if (!component.needsPreviousRenderData()) continue;
            if (this.mComponentsNeedingPreviousRenderData == null) {
                this.mComponentsNeedingPreviousRenderData = new ArrayList(1);
            }
            this.mComponentsNeedingPreviousRenderData.add(component);
        }
        ArrayList<WorkingRangeContainer.Registration> ranges = this.mWorkingRangeRegistrations;
        this.mWorkingRangeRegistrations = null;
        if (ranges != null && !ranges.isEmpty()) {
            this.mWorkingRangeRegistrations = new ArrayList(ranges.size());
            for (WorkingRangeContainer.Registration old : ranges) {
                Component component = old.mComponent.makeUpdatedShallowCopy(c);
                this.mWorkingRangeRegistrations.add(new WorkingRangeContainer.Registration(old.mName, old.mWorkingRange, component));
            }
        }
    }

    private List<Component> getUpdatedComponents(ComponentContext c, @Nullable Component head) {
        int size = this.mComponents.size();
        ArrayList<Component> updated = new ArrayList<Component>(size);
        for (int i = 0; i < size - 1; ++i) {
            Component component = this.mComponents.get(i).makeUpdatedShallowCopy(c);
            updated.add(component);
        }
        if (head == null) {
            head = this.mComponents.get(size - 1).makeUpdatedShallowCopy(c);
        }
        updated.add(head);
        return updated;
    }

    static YogaNode createYogaNode(ComponentContext componentContext) {
        return componentContext.mYogaNodeFactory != null ? componentContext.mYogaNodeFactory.create() : NodeConfig.createYogaNode();
    }

    @Nullable
    private static <T> EventHandler<T> addVisibilityHandler(@Nullable EventHandler<T> currentHandler, @Nullable EventHandler<T> newHandler) {
        if (currentHandler == null) {
            return newHandler;
        }
        if (newHandler == null) {
            return currentHandler;
        }
        return new DelegatingEventHandler<T>(currentHandler, newHandler);
    }

    private static boolean getDrawablePadding(Drawable drawable, Rect outRect) {
        drawable.getPadding(outRect);
        return outRect.bottom != 0 || outRect.top != 0 || outRect.left != 0 || outRect.right != 0;
    }

    private static InternalNode reconcile(ComponentContext c, DefaultInternalNode current, Component next, Set<String> keys) {
        InternalNode layout;
        int mode = DefaultInternalNode.getReconciliationMode(next.getScopedContext(), current, keys);
        switch (mode) {
            case 0: {
                layout = DefaultInternalNode.reconcile(c, current, next, keys, 0);
                break;
            }
            case 1: {
                layout = DefaultInternalNode.reconcile(c, current, next, keys, 1);
                break;
            }
            case 2: {
                layout = next.createLayout(next.getScopedContext(), false);
                break;
            }
            default: {
                throw new IllegalArgumentException(mode + " is not a valid ReconciliationMode");
            }
        }
        return layout;
    }

    private static InternalNode reconcile(ComponentContext c, DefaultInternalNode current, Component next, Set<String> keys, @ReconciliationMode int mode) {
        DefaultInternalNode layout;
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection((mode == 0 ? "copy:" : "reconcile:") + next.getSimpleName());
        }
        YogaNode currentNode = current.getYogaNode();
        if (isTracing) {
            ComponentsSystrace.beginSection("cloneYogaNode:" + next.getSimpleName());
        }
        YogaNode copiedNode = currentNode.cloneWithoutChildren();
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if ((layout = DefaultInternalNode.getCleanUpdatedShallowCopy(c, current, next, copiedNode)).getNestedTree() != null) {
            layout.getOrCreateNestedTreeProps().mNestedTree = null;
        }
        int count = currentNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultInternalNode child = (DefaultInternalNode)currentNode.getChildAt(i).getData();
            List<Component> components = child.getComponents();
            Component component = components.get(Math.max(0, components.size() - 1));
            Component updated = component.makeUpdatedShallowCopy(c);
            InternalNode copy = mode == 0 ? DefaultInternalNode.reconcile(updated.getScopedContext(), child, updated, keys, 0) : DefaultInternalNode.reconcile(updated.getScopedContext(), child, updated, keys);
            layout.child(copy);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        return layout;
    }

    private static DefaultInternalNode getCleanUpdatedShallowCopy(ComponentContext c, DefaultInternalNode current, Component head, YogaNode node) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("clone:" + head.getSimpleName());
        }
        DefaultInternalNode layout = current.clone();
        if (isTracing) {
            ComponentsSystrace.endSection();
            ComponentsSystrace.beginSection("clean:" + head.getSimpleName());
        }
        layout.clean();
        if (isTracing) {
            ComponentsSystrace.endSection();
            ComponentsSystrace.beginSection("update:" + head.getSimpleName());
        }
        List<Component> updated = current.getUpdatedComponents(c, head);
        layout.updateWith(c, node, updated);
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        return layout;
    }

    @VisibleForTesting
    @ReconciliationMode
    static int getReconciliationMode(ComponentContext c, InternalNode current, Set<String> keys) {
        Component root;
        List<Component> components = current.getComponents();
        Component component = root = components.isEmpty() ? null : components.get(0);
        if (c == null || root == null) {
            return 2;
        }
        for (Component component2 : components) {
            String key = component2.getGlobalKey();
            if (!keys.contains(key)) continue;
            return 2;
        }
        for (String key : keys) {
            if (!key.startsWith(root.getGlobalKey())) continue;
            return 1;
        }
        return 0;
    }
}

