/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import androidx.annotation.VisibleForTesting;
import com.facebook.litho.drawable.ComparableDrawable;
import java.util.List;

public class DebugOverlayDrawable
extends ComparableDrawable {
    @VisibleForTesting
    static final int COLOR_RED_SEMITRANSPARENT = Color.parseColor((String)"#22FF0000");
    @VisibleForTesting
    static final int BOX_WIDTH_PX = 16;
    private static final int COLOR_GREEN_SEMITRANSPARENT = Color.parseColor((String)"#2200FF00");
    private static final int COLOR_RED_OPAQUE = Color.parseColor((String)"#CCFF0000");
    private static final int COLOR_GREEN_OPAQUE = Color.parseColor((String)"#CC00FF00");
    private static final float TEXT_SIZE_PX = 80.0f;
    private static final int BOX_HEIGHT_PX = 100;
    private static final int SHOW_TEXT_THRESHOLD_CNT = 3;
    private final Paint textPaint = new Paint();
    private final Paint colorPaint = new Paint();
    private final List<Boolean> isLayoutCalculatedOnMainThread;
    @VisibleForTesting
    final String text;
    @VisibleForTesting
    final int overlayColor;

    public DebugOverlayDrawable(List<Boolean> isLayoutCalculatedOnMainThread) {
        this.textPaint.setColor(-16777216);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTextSize(80.0f);
        this.textPaint.setTextAlign(Paint.Align.LEFT);
        this.isLayoutCalculatedOnMainThread = isLayoutCalculatedOnMainThread;
        int size = isLayoutCalculatedOnMainThread.size();
        if (size > 0) {
            this.text = size + "x";
            this.overlayColor = isLayoutCalculatedOnMainThread.get(size - 1) != false ? COLOR_RED_SEMITRANSPARENT : COLOR_GREEN_SEMITRANSPARENT;
        } else {
            this.text = "";
            this.overlayColor = 0;
        }
    }

    public void draw(Canvas canvas) {
        int left;
        int right;
        this.colorPaint.setColor(this.overlayColor);
        Rect bounds = this.getBounds();
        canvas.drawRect(bounds, this.colorPaint);
        int count = this.isLayoutCalculatedOnMainThread.size();
        int leftEnd = bounds.left;
        int rightEnd = bounds.right;
        int top = bounds.top;
        int bottom = Math.min(top + 100, bounds.bottom);
        for (int i = 0; i < count && (right = (left = leftEnd + i * 20) + 16) < rightEnd; ++i) {
            if (this.isLayoutCalculatedOnMainThread.get(i).booleanValue()) {
                this.colorPaint.setColor(COLOR_RED_OPAQUE);
            } else {
                this.colorPaint.setColor(COLOR_GREEN_OPAQUE);
            }
            canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, this.colorPaint);
        }
        if (count > 3) {
            canvas.drawText(this.text, (float)leftEnd, (float)top + 80.0f, this.textPaint);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    public int hashCode() {
        return this.isLayoutCalculatedOnMainThread.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DebugOverlayDrawable other = (DebugOverlayDrawable)((Object)obj);
        return this.overlayColor == other.overlayColor && this.text.equals(other.text) && this.isLayoutCalculatedOnMainThread.equals(other.isLayoutCalculatedOnMainThread);
    }

    @Override
    public boolean isEquivalentTo(ComparableDrawable other) {
        return this.equals((Object)other);
    }
}

