/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.drawable.Drawable;
import com.facebook.litho.EventHandler;
import com.facebook.litho.InternalNode;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaValue;
import javax.annotation.Nullable;

public final class DebugLayoutNode {
    private InternalNode mNode;

    DebugLayoutNode(InternalNode node) {
        this.mNode = node;
    }

    @Nullable
    public Drawable getForeground() {
        return this.mNode.getForeground();
    }

    public void setForegroundColor(int color) {
        this.mNode.foregroundColor(color);
    }

    @Nullable
    public ComparableDrawable getBackground() {
        return this.mNode.getBackground();
    }

    public void setBackgroundColor(int color) {
        this.mNode.backgroundColor(color);
    }

    @Nullable
    public Integer getImportantForAccessibility() {
        return this.mNode.getImportantForAccessibility();
    }

    public void setImportantForAccessibility(int importantForAccessibility) {
        this.mNode.importantForAccessibility(importantForAccessibility);
    }

    public boolean getFocusable() {
        NodeInfo nodeInfo = this.mNode.getNodeInfo();
        if (nodeInfo != null) {
            return nodeInfo.getFocusState() == 1;
        }
        return false;
    }

    public void setFocusable(boolean focusable) {
        this.mNode.getOrCreateNodeInfo().setFocusable(focusable);
    }

    @Nullable
    public CharSequence getContentDescription() {
        NodeInfo nodeInfo = this.mNode.getNodeInfo();
        if (nodeInfo != null) {
            return nodeInfo.getContentDescription();
        }
        return null;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.mNode.getOrCreateNodeInfo().setContentDescription(contentDescription);
    }

    public void setLayoutDirection(YogaDirection yogaDirection) {
        this.mNode.layoutDirection(yogaDirection);
    }

    public YogaDirection getLayoutDirection() {
        return this.mNode.getYogaNode().getLayoutDirection();
    }

    public void setFlexDirection(YogaFlexDirection direction) {
        this.mNode.flexDirection(direction);
    }

    public YogaFlexDirection getFlexDirection() {
        return this.mNode.getYogaNode().getFlexDirection();
    }

    public void setJustifyContent(YogaJustify yogaJustify) {
        this.mNode.justifyContent(yogaJustify);
    }

    public YogaJustify getJustifyContent() {
        return this.mNode.getYogaNode().getJustifyContent();
    }

    public void setAlignItems(YogaAlign yogaAlign) {
        this.mNode.alignItems(yogaAlign);
    }

    public YogaAlign getAlignItems() {
        return this.mNode.getYogaNode().getAlignItems();
    }

    public void setAlignSelf(YogaAlign yogaAlign) {
        this.mNode.alignSelf(yogaAlign);
    }

    public YogaAlign getAlignSelf() {
        return this.mNode.getYogaNode().getAlignSelf();
    }

    public void setAlignContent(YogaAlign yogaAlign) {
        this.mNode.alignContent(yogaAlign);
    }

    public YogaAlign getAlignContent() {
        return this.mNode.getYogaNode().getAlignContent();
    }

    public void setPositionType(YogaPositionType yogaPositionType) {
        this.mNode.positionType(yogaPositionType);
    }

    public YogaPositionType getPositionType() {
        return this.mNode.getYogaNode().getPositionType();
    }

    public void setFlexGrow(float value) {
        this.mNode.flexGrow(value);
    }

    public float getFlexGrow() {
        return this.mNode.getYogaNode().getFlexGrow();
    }

    public void setFlexShrink(float value) {
        this.mNode.flexShrink(value);
    }

    public float getFlexShrink() {
        return this.mNode.getYogaNode().getFlexShrink();
    }

    public void setFlexBasis(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.flexBasisAuto();
                break;
            }
            case PERCENT: {
                this.mNode.flexBasisPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.flexBasisPx((int)value.value);
            }
        }
    }

    public YogaValue getFlexBasis() {
        return this.mNode.getYogaNode().getFlexBasis();
    }

    public void setWidth(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.widthAuto();
                break;
            }
            case PERCENT: {
                this.mNode.widthPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.widthPx((int)value.value);
            }
        }
    }

    public YogaValue getWidth() {
        return this.mNode.getYogaNode().getWidth();
    }

    public void setMinWidth(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.minWidthPx(Integer.MIN_VALUE);
                break;
            }
            case PERCENT: {
                this.mNode.minWidthPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.minWidthPx((int)value.value);
            }
        }
    }

    public YogaValue getMinWidth() {
        return this.mNode.getYogaNode().getMinWidth();
    }

    public void setMaxWidth(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.maxWidthPx(Integer.MAX_VALUE);
                break;
            }
            case PERCENT: {
                this.mNode.maxWidthPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.maxWidthPx((int)value.value);
            }
        }
    }

    public YogaValue getMaxWidth() {
        return this.mNode.getYogaNode().getMaxWidth();
    }

    public void setHeight(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.heightAuto();
                break;
            }
            case PERCENT: {
                this.mNode.heightPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.heightPx((int)value.value);
            }
        }
    }

    public YogaValue getHeight() {
        return this.mNode.getYogaNode().getHeight();
    }

    public void setMinHeight(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.minHeightPx(Integer.MIN_VALUE);
                break;
            }
            case PERCENT: {
                this.mNode.minHeightPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.minHeightPx((int)value.value);
            }
        }
    }

    public YogaValue getMinHeight() {
        return this.mNode.getYogaNode().getMinHeight();
    }

    public void setMaxHeight(YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.maxHeightPx(Integer.MAX_VALUE);
                break;
            }
            case PERCENT: {
                this.mNode.maxHeightPercent(value.value);
                break;
            }
            case POINT: {
                this.mNode.maxHeightPx((int)value.value);
            }
        }
    }

    public YogaValue getMaxHeight() {
        return this.mNode.getYogaNode().getMaxHeight();
    }

    public void setAspectRatio(float aspectRatio) {
        this.mNode.aspectRatio(aspectRatio);
    }

    public float getAspectRatio() {
        return this.mNode.getYogaNode().getAspectRatio();
    }

    public void setMargin(YogaEdge edge, YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: {
                this.mNode.marginPx(edge, 0);
                break;
            }
            case AUTO: {
                this.mNode.marginAuto(edge);
                break;
            }
            case PERCENT: {
                this.mNode.marginPercent(edge, value.value);
                break;
            }
            case POINT: {
                this.mNode.marginPx(edge, (int)value.value);
            }
        }
    }

    public YogaValue getMargin(YogaEdge edge) {
        return this.mNode.getYogaNode().getMargin(edge);
    }

    public float getResultMargin(YogaEdge edge) {
        return this.mNode.getYogaNode().getLayoutMargin(edge);
    }

    public void setPadding(YogaEdge edge, YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.paddingPx(edge, 0);
                break;
            }
            case PERCENT: {
                this.mNode.paddingPercent(edge, value.value);
                break;
            }
            case POINT: {
                this.mNode.paddingPx(edge, (int)value.value);
            }
        }
    }

    public YogaValue getPadding(YogaEdge edge) {
        return this.mNode.getYogaNode().getPadding(edge);
    }

    public float getResultPadding(YogaEdge edge) {
        return this.mNode.getYogaNode().getLayoutPadding(edge);
    }

    public void setPosition(YogaEdge edge, YogaValue value) {
        switch (value.unit) {
            case UNDEFINED: 
            case AUTO: {
                this.mNode.positionPercent(edge, Float.NaN);
                break;
            }
            case PERCENT: {
                this.mNode.positionPercent(edge, value.value);
                break;
            }
            case POINT: {
                this.mNode.positionPx(edge, (int)value.value);
            }
        }
    }

    public YogaValue getPosition(YogaEdge edge) {
        return this.mNode.getYogaNode().getPosition(edge);
    }

    public void setBorderWidth(YogaEdge edge, float value) {
        this.mNode.setBorderWidth(edge, (int)value);
    }

    public float getBorderWidth(YogaEdge edge) {
        return this.mNode.getYogaNode().getBorder(edge);
    }

    public void isReferenceBaseline(boolean isReferenceBaseline) {
        this.mNode.isReferenceBaseline(isReferenceBaseline);
    }

    @Nullable
    public EventHandler getClickHandler() {
        return this.mNode.getNodeInfo() != null ? this.mNode.getNodeInfo().getClickHandler() : null;
    }
}

