/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.text.TextUtils;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugLayoutNode;
import com.facebook.litho.LithoView;
import com.facebook.proguard.annotations.DoNotStrip;

public class DebugComponentDescriptionHelper {
    @DoNotStrip
    public static void addViewDescription(int left, int top, DebugComponent debugComponent, StringBuilder sb, boolean embedded) {
        String textContent;
        sb.append("litho.");
        sb.append(debugComponent.getComponent().getSimpleName());
        sb.append('{');
        sb.append(Integer.toHexString(debugComponent.hashCode()));
        sb.append(' ');
        LithoView lithoView = debugComponent.getLithoView();
        DebugLayoutNode layout = debugComponent.getLayoutNode();
        sb.append(lithoView != null && lithoView.getVisibility() == 0 ? "V" : ".");
        sb.append(layout != null && layout.getFocusable() ? "F" : ".");
        sb.append(lithoView != null && lithoView.isEnabled() ? "E" : ".");
        sb.append(".");
        sb.append(lithoView != null && lithoView.isHorizontalScrollBarEnabled() ? "H" : ".");
        sb.append(lithoView != null && lithoView.isVerticalScrollBarEnabled() ? "V" : ".");
        sb.append(layout != null && layout.getClickHandler() != null ? "C" : ".");
        sb.append(". .. ");
        Rect bounds = debugComponent.getBounds();
        sb.append(left + bounds.left);
        sb.append(",");
        sb.append(top + bounds.top);
        sb.append("-");
        sb.append(left + bounds.right);
        sb.append(",");
        sb.append(top + bounds.bottom);
        String testKey = debugComponent.getTestKey();
        if (testKey != null && !TextUtils.isEmpty((CharSequence)testKey)) {
            sb.append(String.format(" litho:id/%s", testKey.replace(' ', '_')));
        }
        if ((textContent = debugComponent.getTextContent()) != null && !TextUtils.isEmpty((CharSequence)textContent)) {
            sb.append(String.format(" text=\"%s\"", textContent.replace("\n", "").replace("\"", "")));
        }
        if (!embedded && layout != null && layout.getClickHandler() != null) {
            sb.append(" [clickable]");
        }
        sb.append('}');
    }
}

