/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentHost;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugLayoutNode;
import com.facebook.litho.InternalNode;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoView;
import com.facebook.litho.MountItem;
import com.facebook.litho.MountState;
import com.facebook.litho.StateContainer;
import com.facebook.litho.TextContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class DebugComponent {
    private static final Map<String, Overrider> sOverriders = new HashMap<String, Overrider>();
    private String mGlobalKey;
    private InternalNode mNode;
    private int mComponentIndex;

    private DebugComponent() {
    }

    static synchronized DebugComponent getInstance(InternalNode node, int componentIndex) {
        DebugComponent debugComponent = new DebugComponent();
        ComponentContext context = node.getContext();
        Component component = node.getComponents().get(componentIndex);
        debugComponent.mGlobalKey = DebugComponent.generateGlobalKey(context, component);
        debugComponent.mNode = node;
        debugComponent.mComponentIndex = componentIndex;
        node.registerDebugComponent(debugComponent);
        return debugComponent;
    }

    @Nullable
    public static DebugComponent getRootInstance(Component component) {
        return DebugComponent.getRootInstance(component.getScopedContext().getComponentTree());
    }

    @Nullable
    public static DebugComponent getRootInstance(LithoView view) {
        return DebugComponent.getRootInstance(view.getComponentTree());
    }

    @Nullable
    public static DebugComponent getRootInstance(@Nullable ComponentTree componentTree) {
        InternalNode root;
        LayoutState layoutState = componentTree == null ? null : componentTree.getMainThreadLayoutState();
        InternalNode internalNode = root = layoutState == null ? null : layoutState.getLayoutRoot();
        if (root != null && root != ComponentContext.NULL_LAYOUT) {
            int outerWrapperComponentIndex = Math.max(0, root.getComponents().size() - 1);
            return DebugComponent.getInstance(root, outerWrapperComponentIndex);
        }
        return null;
    }

    @Nullable
    public static DebugComponent getRootInstance(InternalNode rootInternalNode) {
        int outerWrapperComponentIndex = Math.max(0, rootInternalNode.getComponents().size() - 1);
        return DebugComponent.getInstance(rootInternalNode, outerWrapperComponentIndex);
    }

    private static String generateGlobalKey(ComponentContext context, Component component) {
        ComponentTree tree = context.getComponentTree();
        String componentKey = component.getGlobalKey();
        return System.identityHashCode(tree) + componentKey;
    }

    static void applyOverrides(ComponentContext context, Component component) {
        String key = DebugComponent.generateGlobalKey(context, component);
        Overrider overrider = sOverriders.get(key);
        if (overrider != null) {
            overrider.applyComponentOverrides(key, component);
            overrider.applyStateOverrides(key, component.getStateContainer());
        }
    }

    static void applyOverrides(ComponentContext context, InternalNode node) {
        if (node.getComponents() == null || node.getComponents().isEmpty()) {
            return;
        }
        String key = DebugComponent.generateGlobalKey(context, node.getComponents().get(0));
        Overrider overrider = sOverriders.get(key);
        if (overrider != null) {
            overrider.applyLayoutOverrides(key, new DebugLayoutNode(node));
        }
    }

    public void setOverrider(Overrider overrider) {
        sOverriders.put(this.mGlobalKey, overrider);
    }

    public List<DebugComponent> getChildComponents() {
        if (!this.isLayoutNode()) {
            int nextComponentIndex = this.mComponentIndex - 1;
            return Arrays.asList(DebugComponent.getInstance(this.mNode, nextComponentIndex));
        }
        ArrayList<DebugComponent> children = new ArrayList<DebugComponent>();
        int count = this.mNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            InternalNode childNode = this.mNode.getChildAt(i);
            int outerWrapperComponentIndex = Math.max(0, childNode.getComponents().size() - 1);
            children.add(DebugComponent.getInstance(childNode, outerWrapperComponentIndex));
        }
        InternalNode nestedTree = this.mNode.getNestedTree();
        if (nestedTree != null && nestedTree.isInitialized()) {
            int count2 = nestedTree.getChildCount();
            for (int i = 0; i < count2; ++i) {
                InternalNode childNode = nestedTree.getChildAt(i);
                children.add(DebugComponent.getInstance(childNode, Math.max(0, childNode.getComponents().size() - 1)));
            }
        }
        return children;
    }

    @Nullable
    public View getMountedView() {
        Component component = this.mNode.getTailComponent();
        if (component != null && Component.isMountViewSpec(component)) {
            return (View)this.getMountedContent();
        }
        return null;
    }

    @Nullable
    public Drawable getMountedDrawable() {
        Component component = this.mNode.getTailComponent();
        if (component != null && Component.isMountDrawableSpec(component)) {
            return (Drawable)this.getMountedContent();
        }
        return null;
    }

    @Nullable
    public LithoView getLithoView() {
        ComponentContext c = this.mNode.getContext();
        ComponentTree tree = c == null ? null : c.getComponentTree();
        return tree == null ? null : tree.getLithoView();
    }

    public Rect getBoundsInLithoView() {
        if (this.isRoot()) {
            return new Rect(0, 0, this.mNode.getWidth(), this.mNode.getHeight());
        }
        int x = DebugComponent.getXFromRoot(this.mNode);
        int y = DebugComponent.getYFromRoot(this.mNode);
        return new Rect(x, y, x + this.mNode.getWidth(), y + this.mNode.getHeight());
    }

    public Rect getBounds() {
        int x = this.mNode.getX();
        int y = this.mNode.getY();
        return new Rect(x, y, x + this.mNode.getWidth(), y + this.mNode.getHeight());
    }

    public ComponentContext getContext() {
        return this.mNode.getContext();
    }

    public boolean isLayoutNode() {
        return this.mComponentIndex == 0;
    }

    @Nullable
    public String getTestKey() {
        return this.isLayoutNode() ? this.mNode.getTestKey() : null;
    }

    @Nullable
    public String getAllTextContent() {
        LithoView lithoView = this.getLithoView();
        if (lithoView == null) {
            return null;
        }
        MountState mountState = lithoView.getMountState();
        StringBuilder sb = new StringBuilder();
        int size = mountState.getItemCount();
        for (int i = 0; i < size; ++i) {
            Component mountItemComponent;
            MountItem mountItem = mountState.getItemAt(i);
            Component component = mountItemComponent = mountItem == null ? null : mountItem.getComponent();
            if (mountItemComponent == null) continue;
            Object content = mountItem.getContent();
            if (content instanceof TextContent) {
                for (CharSequence charSequence : ((TextContent)content).getTextItems()) {
                    sb.append(charSequence);
                }
                continue;
            }
            if (!(content instanceof TextView)) continue;
            sb.append(((TextView)content).getText());
        }
        return sb.toString();
    }

    @Nullable
    public String getTextContent() {
        LithoView lithoView = this.getLithoView();
        if (lithoView == null) {
            return null;
        }
        Component component = this.getComponent();
        MountState mountState = lithoView.getMountState();
        int size = mountState.getItemCount();
        for (int i = 0; i < size; ++i) {
            Component mountItemComponent;
            MountItem mountItem = mountState.getItemAt(i);
            Component component2 = mountItemComponent = mountItem == null ? null : mountItem.getComponent();
            if (mountItemComponent == null || mountItemComponent.getId() != component.getId()) continue;
            Object content = mountItem.getContent();
            StringBuilder sb = new StringBuilder();
            if (content instanceof TextContent) {
                for (CharSequence charSequence : ((TextContent)content).getTextItems()) {
                    sb.append(charSequence);
                }
            } else if (content instanceof TextView) {
                sb.append(((TextView)content).getText());
            }
            if (sb.length() == 0) continue;
            return sb.toString();
        }
        return null;
    }

    @Nullable
    public ComponentHost getComponentHost() {
        LithoView lithoView = this.getLithoView();
        Component component = this.getComponent();
        if (lithoView == null) {
            return null;
        }
        int size = lithoView.getMountState().getItemCount();
        for (int i = 0; i < size; ++i) {
            Component mountItemComponent;
            MountItem mountItem = lithoView.getMountState().getItemAt(i);
            Component component2 = mountItemComponent = mountItem == null ? null : mountItem.getComponent();
            if (mountItemComponent == null || !mountItemComponent.isEquivalentTo(component)) continue;
            return mountItem.getHost();
        }
        return null;
    }

    @Nullable
    public String getKey() {
        return this.mNode.getComponents().get(this.mComponentIndex).getKey();
    }

    public Component getComponent() {
        return this.mNode.getComponents().get(this.mComponentIndex);
    }

    @Nullable
    public DebugLayoutNode getLayoutNode() {
        if (this.isLayoutNode()) {
            return new DebugLayoutNode(this.mNode);
        }
        return null;
    }

    public void rerender() {
        LithoView lithoView = this.getLithoView();
        if (lithoView != null) {
            lithoView.forceRelayout();
        }
    }

    @Nullable
    public StateContainer getStateContainer() {
        return this.getComponent().getStateContainer();
    }

    private static InternalNode parent(InternalNode node) {
        InternalNode parent = node.getParent();
        return parent != null ? parent : node.getNestedTreeHolder();
    }

    private static int getXFromRoot(InternalNode node) {
        if (node == null) {
            return 0;
        }
        return node.getX() + DebugComponent.getXFromRoot(DebugComponent.parent(node));
    }

    private static int getYFromRoot(InternalNode node) {
        if (node == null) {
            return 0;
        }
        return node.getY() + DebugComponent.getYFromRoot(DebugComponent.parent(node));
    }

    public String getGlobalKey() {
        return this.mGlobalKey;
    }

    public boolean canResolve() {
        return this.getComponent().canResolve();
    }

    public boolean isRoot() {
        return this.mComponentIndex == 0 && this.mNode.getParent() == null;
    }

    @Nullable
    private Object getMountedContent() {
        MountState mountState;
        if (!this.isLayoutNode()) {
            return null;
        }
        ComponentContext context = this.mNode.getContext();
        ComponentTree tree = context == null ? null : context.getComponentTree();
        LithoView view = tree == null ? null : tree.getLithoView();
        MountState mountState2 = mountState = view == null ? null : view.getMountState();
        if (mountState != null) {
            int count = mountState.getItemCount();
            for (int i = 0; i < count; ++i) {
                Component component;
                MountItem mountItem = mountState.getItemAt(i);
                Component component2 = component = mountItem == null ? null : mountItem.getComponent();
                if (component == null || component != this.mNode.getTailComponent()) continue;
                return mountItem.getContent();
            }
        }
        return null;
    }

    public static interface Overrider {
        public void applyComponentOverrides(String var1, Component var2);

        public void applyStateOverrides(String var1, StateContainer var2);

        public void applyLayoutOverrides(String var1, DebugLayoutNode var2);
    }
}

