/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import androidx.annotation.Nullable;

public class ContextUtils {
    @Nullable
    static Activity getValidActivityForContext(Context context) {
        Activity activity = ContextUtils.findActivityInContext(context);
        if (activity == null || activity.isFinishing() || ContextUtils.isActivityDestroyed(activity)) {
            return null;
        }
        return activity;
    }

    static Context getRootContext(Context context) {
        Context currentContext = context;
        while (currentContext instanceof ContextWrapper && !(currentContext instanceof Activity) && !(currentContext instanceof Application) && !(currentContext instanceof Service)) {
            currentContext = ((ContextWrapper)currentContext).getBaseContext();
        }
        return currentContext;
    }

    @Nullable
    public static Activity findActivityInContext(Context context) {
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return ContextUtils.findActivityInContext(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    private static boolean isActivityDestroyed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            return activity.isDestroyed();
        }
        return true;
    }

    public static int getTargetSdkVersion(Context context) {
        return context.getApplicationContext().getApplicationInfo().targetSdkVersion;
    }
}

