/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.DebugLayoutNode;
import com.facebook.litho.LithoView;
import com.facebook.litho.config.ComponentsConfiguration;

public class ComponentTreeDumpingHelper {
    @Nullable
    public static String dumpContextTree(@Nullable ComponentContext componentContext) {
        if (!ComponentsConfiguration.isDebugModeEnabled) {
            return "Dumping of the component tree is not support on non-internal builds";
        }
        if (componentContext == null) {
            return "ComponentContext is null";
        }
        ComponentTree componentTree = componentContext.getComponentTree();
        DebugComponent rootComponent = DebugComponent.getRootInstance(componentTree);
        if (rootComponent == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ComponentTreeDumpingHelper.logComponent(rootComponent, 0, sb);
        return sb.toString();
    }

    private static void logComponent(@Nullable DebugComponent debugComponent, int depth, StringBuilder sb) {
        if (debugComponent == null) {
            return;
        }
        sb.append(debugComponent.getComponent().getSimpleName());
        sb.append('{');
        LithoView lithoView = debugComponent.getLithoView();
        DebugLayoutNode layout = debugComponent.getLayoutNode();
        sb.append(lithoView != null && lithoView.getVisibility() == 0 ? "V" : "H");
        if (layout != null && layout.getClickHandler() != null) {
            sb.append(" [clickable]");
        }
        sb.append('}');
        for (DebugComponent child : debugComponent.getChildComponents()) {
            sb.append("\n");
            for (int i = 0; i <= depth; ++i) {
                sb.append("  ");
            }
            ComponentTreeDumpingHelper.logComponent(child, depth + 1, sb);
        }
    }
}

