/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.AttachDetachHandler;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.ContextUtils;
import com.facebook.litho.DeprecatedLithoTooltip;
import com.facebook.litho.ErrorBoundariesConfiguration;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventHandlersController;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.HandlerInstrumenter;
import com.facebook.litho.IncrementalMountHelper;
import com.facebook.litho.KeyHandler;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LithoHandler;
import com.facebook.litho.LithoTooltip;
import com.facebook.litho.LithoTooltipController;
import com.facebook.litho.LithoView;
import com.facebook.litho.LogTreePopulator;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.MountState;
import com.facebook.litho.PerfEvent;
import com.facebook.litho.RenderState;
import com.facebook.litho.RootWrapperComponentFactory;
import com.facebook.litho.Size;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateHandler;
import com.facebook.litho.ThreadPoolLayoutHandler;
import com.facebook.litho.ThreadTracingRunnable;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TooltipPosition;
import com.facebook.litho.Transition;
import com.facebook.litho.TreeProps;
import com.facebook.litho.WorkingRangeStatusHandler;
import com.facebook.litho.animation.AnimatedProperties;
import com.facebook.litho.animation.AnimatedProperty;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.perfboost.LithoPerfBooster;
import com.facebook.litho.stats.LithoStats;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class ComponentTree {
    public static final int INVALID_ID = -1;
    private static final String TAG = ComponentTree.class.getSimpleName();
    private static final int SIZE_UNINITIALIZED = -1;
    private static final String DEFAULT_LAYOUT_THREAD_NAME = "ComponentLayoutThread";
    private static final String DEFAULT_PMC_THREAD_NAME = "PreallocateMountContentThread";
    private static final String EMPTY_STRING = "";
    private static final int SCHEDULE_NONE = 0;
    private static final int SCHEDULE_LAYOUT_ASYNC = 1;
    private static final int SCHEDULE_LAYOUT_SYNC = 2;
    private static boolean sBoostPerfLayoutStateFuture = false;
    private boolean mReleased;
    private String mReleasedComponent;
    @GuardedBy(value="this")
    @Nullable
    private MeasureListener mMeasureListener;
    private static final AtomicInteger sIdGenerator = new AtomicInteger(0);
    @GuardedBy(value="ComponentTree.class")
    private static volatile Looper sDefaultLayoutThreadLooper;
    @GuardedBy(value="ComponentTree.class")
    private static volatile Looper sDefaultPreallocateMountContentThreadLooper;
    private static final ThreadLocal<WeakReference<LithoHandler>> sSyncStateUpdatesHandler;
    @Nullable
    private final IncrementalMountHelper mIncrementalMountHelper;
    private final boolean mShouldPreallocatePerMountSpec;
    private final Runnable mPreAllocateMountContentRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.preAllocateMountContent(ComponentTree.this.mShouldPreallocatePerMountSpec);
        }
    };
    private final Object mUpdateStateSyncRunnableLock = new Object();
    @GuardedBy(value="mUpdateStateSyncRunnableLock")
    @Nullable
    private UpdateStateSyncRunnable mUpdateStateSyncRunnable;
    private final ComponentContext mContext;
    private final boolean mNestedTreeResolutionExperimentEnabled;
    @Nullable
    private LithoHandler mPreAllocateMountContentHandler;
    @ThreadConfined(value="UI")
    private boolean mIsMounting;
    @ThreadConfined(value="UI")
    private final boolean mIncrementalMountEnabled;
    @ThreadConfined(value="UI")
    private final boolean mIsLayoutDiffingEnabled;
    @ThreadConfined(value="UI")
    private boolean mIsAttached;
    @ThreadConfined(value="UI")
    private final boolean mIsAsyncUpdateStateEnabled;
    @ThreadConfined(value="UI")
    private LithoView mLithoView;
    @ThreadConfined(value="UI")
    private LithoHandler mLayoutThreadHandler;
    private LithoHandler mMainThreadHandler = new LithoHandler.DefaultLithoHandler(Looper.getMainLooper());
    private final Runnable mBackgroundLayoutStateUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            ComponentTree.this.backgroundLayoutStateUpdated();
        }
    };
    private volatile NewLayoutStateReadyListener mNewLayoutStateReadyListener;
    private final Object mCurrentCalculateLayoutRunnableLock = new Object();
    @GuardedBy(value="mCurrentCalculateLayoutRunnableLock")
    @Nullable
    private CalculateLayoutRunnable mCurrentCalculateLayoutRunnable;
    private final Object mLayoutStateFutureLock = new Object();
    private final boolean mUseCancelableLayoutFutures;
    @GuardedBy(value="mLayoutStateFutureLock")
    private final List<LayoutStateFuture> mLayoutStateFutures = new ArrayList<LayoutStateFuture>();
    private volatile boolean mHasMounted;
    @ThreadConfined(value="UI")
    @Nullable
    Transition.RootBoundsTransition mRootWidthAnimation;
    @ThreadConfined(value="UI")
    @Nullable
    Transition.RootBoundsTransition mRootHeightAnimation;
    @Nullable
    @GuardedBy(value="this")
    private Component mRoot;
    @Nullable
    @GuardedBy(value="this")
    private TreeProps mRootTreeProps;
    @GuardedBy(value="this")
    private int mWidthSpec = -1;
    @GuardedBy(value="this")
    private int mHeightSpec = -1;
    @GuardedBy(value="this")
    private int mPendingLayoutWidthSpec = -1;
    @GuardedBy(value="this")
    private int mPendingLayoutHeightSpec = -1;
    @Nullable
    private LayoutState mMainThreadLayoutState;
    @GuardedBy(value="this")
    @Nullable
    private LayoutState mBackgroundLayoutState;
    @GuardedBy(value="this")
    private StateHandler mStateHandler;
    @ThreadConfined(value="UI")
    private RenderState mPreviousRenderState;
    @ThreadConfined(value="UI")
    private boolean mPreviousRenderStateSetFromBuilder = false;
    protected final int mId;
    @GuardedBy(value="this")
    private boolean mIsMeasuring;
    @GuardedBy(value="this")
    private int mScheduleLayoutAfterMeasure;
    private final EventHandlersController mEventHandlersController = new EventHandlersController();
    private final EventTriggersContainer mEventTriggersContainer = new EventTriggersContainer();
    @GuardedBy(value="this")
    private final WorkingRangeStatusHandler mWorkingRangeStatusHandler = new WorkingRangeStatusHandler();
    private boolean mForceLayout;
    private final boolean isReconciliationEnabled;
    private final boolean mMoveLayoutsBetweenThreads;
    private final boolean mCreateInitialStateOncePerThread;

    public static Builder create(ComponentContext context, Component.Builder<?> root) {
        return ComponentTree.create(context, root.build());
    }

    public static Builder create(ComponentContext context, @NonNull Component root) {
        if (root == null) {
            throw new NullPointerException("Creating a ComponentTree with a null root is not allowed!");
        }
        return new Builder(context, root);
    }

    protected ComponentTree(Builder builder) {
        StateHandler builderStateHandler;
        this.mContext = ComponentContext.withComponentTree(builder.context, this);
        this.mRoot = this.wrapRootInErrorBoundary(builder.root);
        this.mIncrementalMountEnabled = builder.incrementalMountEnabled && !this.mContext.isParentIncrementalMountDisabled();
        this.mIsLayoutDiffingEnabled = builder.isLayoutDiffingEnabled;
        this.mLayoutThreadHandler = builder.layoutThreadHandler;
        this.mShouldPreallocatePerMountSpec = builder.shouldPreallocatePerMountSpec;
        this.mPreAllocateMountContentHandler = builder.preAllocateMountContentHandler;
        this.mIsAsyncUpdateStateEnabled = builder.asyncStateUpdates;
        this.mHasMounted = builder.hasMounted;
        this.mMeasureListener = builder.mMeasureListener;
        this.mNestedTreeResolutionExperimentEnabled = builder.nestedTreeResolutionExperimentEnabled;
        this.mUseCancelableLayoutFutures = builder.useCancelableLayoutFutures;
        this.mMoveLayoutsBetweenThreads = builder.canInterruptAndMoveLayoutsBetweenThreads;
        this.isReconciliationEnabled = builder.isReconciliationEnabled;
        boolean bl = this.mCreateInitialStateOncePerThread = ComponentsConfiguration.createInitialStateOncePerThread || this.mUseCancelableLayoutFutures;
        if (this.mPreAllocateMountContentHandler == null && builder.canPreallocateOnDefaultHandler) {
            this.mPreAllocateMountContentHandler = new LithoHandler.DefaultLithoHandler(ComponentTree.getDefaultPreallocateMountContentThreadLooper());
        }
        StateHandler stateHandler = this.mStateHandler = (builderStateHandler = builder.stateHandler) == null ? StateHandler.createNewInstance(null) : builderStateHandler;
        if (builder.previousRenderState != null) {
            this.mPreviousRenderState = builder.previousRenderState;
            this.mPreviousRenderStateSetFromBuilder = true;
        }
        this.mId = builder.overrideComponentTreeId != -1 ? builder.overrideComponentTreeId : ComponentTree.generateComponentTreeId();
        this.mIncrementalMountHelper = new IncrementalMountHelper(this);
        this.mMainThreadHandler = HandlerInstrumenter.instrumentLithoHandler(this.mMainThreadHandler);
        this.mLayoutThreadHandler = ComponentTree.ensureAndInstrumentLayoutThreadHandler(this.mLayoutThreadHandler);
        if (this.mPreAllocateMountContentHandler != null) {
            this.mPreAllocateMountContentHandler = HandlerInstrumenter.instrumentLithoHandler(this.mPreAllocateMountContentHandler);
        }
    }

    private static LithoHandler ensureAndInstrumentLayoutThreadHandler(@Nullable LithoHandler handler) {
        if (handler == null) {
            handler = ComponentsConfiguration.threadPoolForBackgroundThreadsConfig == null ? new LithoHandler.DefaultLithoHandler(ComponentTree.getDefaultLayoutThreadLooper()) : new ThreadPoolLayoutHandler(ComponentsConfiguration.threadPoolForBackgroundThreadsConfig);
        } else if (sDefaultLayoutThreadLooper != null && !sBoostPerfLayoutStateFuture && ComponentsConfiguration.boostPerfLayoutStateFuture && ComponentsConfiguration.perfBoosterFactory != null) {
            LithoPerfBooster booster = ComponentsConfiguration.perfBoosterFactory.acquireInstance();
            booster.markImportantThread(new Handler(sDefaultLayoutThreadLooper));
            sBoostPerfLayoutStateFuture = true;
        }
        return HandlerInstrumenter.instrumentLithoHandler(handler);
    }

    @Nullable
    @ThreadConfined(value="UI")
    LayoutState getMainThreadLayoutState() {
        return this.mMainThreadLayoutState;
    }

    @Nullable
    @VisibleForTesting
    @GuardedBy(value="this")
    protected LayoutState getBackgroundLayoutState() {
        return this.mBackgroundLayoutState;
    }

    @CheckReturnValue
    @ReturnsOwnership
    @ThreadConfined(value="UI")
    @GuardedBy(value="this")
    private LayoutState setBestMainThreadLayoutAndReturnOldLayout() {
        ThreadUtils.assertHoldsLock(this);
        boolean isMainThreadLayoutBest = this.isBestMainThreadLayout();
        if (isMainThreadLayoutBest) {
            LayoutState toRelease = this.mBackgroundLayoutState;
            this.mBackgroundLayoutState = null;
            return toRelease;
        }
        if (this.mLithoView != null) {
            this.mLithoView.setMountStateDirty();
        }
        LayoutState toRelease = this.mMainThreadLayoutState;
        this.mMainThreadLayoutState = this.mBackgroundLayoutState;
        this.mBackgroundLayoutState = null;
        return toRelease;
    }

    @CheckReturnValue
    @ReturnsOwnership
    @ThreadConfined(value="UI")
    @GuardedBy(value="this")
    private boolean isBestMainThreadLayout() {
        ThreadUtils.assertHoldsLock(this);
        if (this.isCompatibleComponentAndSpec(this.mMainThreadLayoutState)) {
            return true;
        }
        return !ComponentTree.isCompatibleSpec(this.mBackgroundLayoutState, this.mWidthSpec, this.mHeightSpec) && ComponentTree.isCompatibleSpec(this.mMainThreadLayoutState, this.mWidthSpec, this.mHeightSpec);
    }

    public boolean hasMounted() {
        return this.mHasMounted;
    }

    public void setNewLayoutStateReadyListener(NewLayoutStateReadyListener listener) {
        this.mNewLayoutStateReadyListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void updateLayoutThreadHandler(@Nullable LithoHandler layoutThreadHandler) {
        Object object = this.mUpdateStateSyncRunnableLock;
        synchronized (object) {
            if (this.mUpdateStateSyncRunnable != null) {
                this.mLayoutThreadHandler.remove(this.mUpdateStateSyncRunnable);
            }
        }
        object = this.mCurrentCalculateLayoutRunnableLock;
        synchronized (object) {
            if (this.mCurrentCalculateLayoutRunnable != null) {
                this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
            }
        }
        this.mLayoutThreadHandler = ComponentTree.ensureAndInstrumentLayoutThreadHandler(layoutThreadHandler);
    }

    @VisibleForTesting
    public NewLayoutStateReadyListener getNewLayoutStateReadyListener() {
        return this.mNewLayoutStateReadyListener;
    }

    @ThreadConfined(value="UI")
    private void dispatchNewLayoutStateReady() {
        NewLayoutStateReadyListener listener = this.mNewLayoutStateReadyListener;
        if (listener != null) {
            listener.onNewLayoutStateReady(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundLayoutStateUpdated() {
        boolean needsAndroidLayout;
        int componentRootId;
        boolean layoutStateUpdated;
        ThreadUtils.assertMainThread();
        if (!this.mIsAttached) {
            this.dispatchNewLayoutStateReady();
            return;
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            LayoutState oldMainThreadLayoutState = this.mMainThreadLayoutState;
            this.setBestMainThreadLayoutAndReturnOldLayout();
            layoutStateUpdated = this.mMainThreadLayoutState != oldMainThreadLayoutState;
            componentRootId = this.mRoot.getId();
        }
        if (!layoutStateUpdated) {
            return;
        }
        this.dispatchNewLayoutStateReady();
        if (!this.mIsAttached) {
            return;
        }
        int viewWidth = this.mLithoView.getMeasuredWidth();
        int viewHeight = this.mLithoView.getMeasuredHeight();
        if (viewWidth == 0 && viewHeight == 0) {
            return;
        }
        boolean bl = needsAndroidLayout = !ComponentTree.isCompatibleComponentAndSize(this.mMainThreadLayoutState, componentRootId, viewWidth, viewHeight);
        if (needsAndroidLayout) {
            this.mLithoView.requestLayout();
        } else {
            this.mountComponentIfNeeded();
        }
    }

    void maybeCollectTransitions() {
        ThreadUtils.assertMainThread();
        LayoutState layoutState = this.mMainThreadLayoutState;
        if (layoutState == null || layoutState.getRootTransitionId() == null) {
            return;
        }
        MountState mountState = this.mLithoView.getMountState();
        if (mountState.isDirty()) {
            mountState.collectAllTransitions(layoutState, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach() {
        boolean needsAndroidLayout;
        int componentRootId;
        ThreadUtils.assertMainThread();
        if (this.mLithoView == null) {
            throw new IllegalStateException("Trying to attach a ComponentTree without a set View");
        }
        if (this.mIncrementalMountHelper != null) {
            this.mIncrementalMountHelper.onAttach(this.mLithoView);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mIsAttached = true;
            this.setBestMainThreadLayoutAndReturnOldLayout();
            if (this.mRoot == null) {
                throw new IllegalStateException("Trying to attach a ComponentTree with a null root. Is released: " + this.mReleased + ", Released Component name is: " + this.mReleasedComponent);
            }
            componentRootId = this.mRoot.getId();
        }
        int viewWidth = this.mLithoView.getMeasuredWidth();
        int viewHeight = this.mLithoView.getMeasuredHeight();
        if (viewWidth == 0 && viewHeight == 0) {
            return;
        }
        boolean bl = needsAndroidLayout = !ComponentTree.isCompatibleComponentAndSize(this.mMainThreadLayoutState, componentRootId, viewWidth, viewHeight);
        if (needsAndroidLayout || this.mLithoView.isMountStateDirty()) {
            this.mLithoView.requestLayout();
        } else {
            this.mLithoView.rebind();
        }
    }

    private static boolean hasSameRootContext(Context context1, Context context2) {
        return ContextUtils.getRootContext(context1) == ContextUtils.getRootContext(context2);
    }

    @ThreadConfined(value="UI")
    boolean isMounting() {
        return this.mIsMounting;
    }

    private boolean mountComponentIfNeeded() {
        if (this.mLithoView.isMountStateDirty() || this.mLithoView.mountStateNeedsRemount()) {
            if (this.mIncrementalMountEnabled) {
                this.incrementalMountComponent();
            } else {
                this.mountComponent(null, true);
            }
            return true;
        }
        return false;
    }

    void incrementalMountComponent() {
        ThreadUtils.assertMainThread();
        if (!this.mIncrementalMountEnabled) {
            throw new IllegalStateException("Calling incrementalMountComponent() but incremental mount is not enabled");
        }
        if (this.mLithoView == null) {
            return;
        }
        Rect currentVisibleArea = new Rect();
        if (ComponentsConfiguration.incrementalMountWhenNotVisible) {
            boolean isVisible;
            boolean bl = isVisible = this.mIsAttached && this.mLithoView.getLocalVisibleRect(currentVisibleArea);
            if (!isVisible) {
                currentVisibleArea.setEmpty();
            }
            this.mountComponent(currentVisibleArea, true);
        } else if (this.mLithoView.getLocalVisibleRect(currentVisibleArea) || this.animatingRootBoundsFromZero(currentVisibleArea)) {
            this.mountComponent(currentVisibleArea, true);
        }
    }

    void processVisibilityOutputs() {
        ThreadUtils.assertMainThread();
        if (!this.mIncrementalMountEnabled) {
            throw new IllegalStateException("Calling processVisibilityOutputs() but incremental mount is not enabled");
        }
        if (this.mLithoView == null) {
            return;
        }
        if (this.mMainThreadLayoutState == null) {
            Log.w((String)TAG, (String)"Main Thread Layout state is not found");
            return;
        }
        Rect currentVisibleArea = new Rect();
        if (this.mLithoView.getLocalVisibleRect(currentVisibleArea)) {
            this.mLithoView.processVisibilityOutputs(this.mMainThreadLayoutState, currentVisibleArea);
        }
    }

    private boolean animatingRootBoundsFromZero(Rect currentVisibleArea) {
        return !this.mHasMounted && (this.mRootHeightAnimation != null && currentVisibleArea.height() == 0 || this.mRootWidthAnimation != null && currentVisibleArea.width() == 0);
    }

    @ThreadConfined(value="UI")
    int getInitialAnimatedLithoViewWidth(int currentAnimatedWidth, boolean hasNewComponentTree) {
        return this.getInitialAnimatedLithoViewDimension(currentAnimatedWidth, hasNewComponentTree, this.mRootWidthAnimation, AnimatedProperties.WIDTH);
    }

    @ThreadConfined(value="UI")
    int getInitialAnimatedLithoViewHeight(int currentAnimatedHeight, boolean hasNewComponentTree) {
        return this.getInitialAnimatedLithoViewDimension(currentAnimatedHeight, hasNewComponentTree, this.mRootHeightAnimation, AnimatedProperties.HEIGHT);
    }

    private int getInitialAnimatedLithoViewDimension(int currentAnimatedDimension, boolean hasNewComponentTree, @Nullable Transition.RootBoundsTransition rootBoundsTransition, AnimatedProperty property) {
        if (rootBoundsTransition == null) {
            return -1;
        }
        if (!this.mHasMounted && rootBoundsTransition.appearTransition != null) {
            return (int)Transition.getRootAppearFromValue(rootBoundsTransition.appearTransition, this.mMainThreadLayoutState, property);
        }
        if (this.mHasMounted && !hasNewComponentTree) {
            return currentAnimatedDimension;
        }
        return -1;
    }

    @ThreadConfined(value="UI")
    void setRootWidthAnimation(@Nullable Transition.RootBoundsTransition rootWidthAnimation) {
        this.mRootWidthAnimation = rootWidthAnimation;
    }

    @ThreadConfined(value="UI")
    void setRootHeightAnimation(@Nullable Transition.RootBoundsTransition rootHeightAnimation) {
        this.mRootHeightAnimation = rootHeightAnimation;
    }

    public synchronized boolean hasCompatibleLayout(int widthSpec, int heightSpec) {
        return ComponentTree.isCompatibleSpec(this.mMainThreadLayoutState, widthSpec, heightSpec) || ComponentTree.isCompatibleSpec(this.mBackgroundLayoutState, widthSpec, heightSpec);
    }

    void mountComponent(Rect currentVisibleArea, boolean processVisibilityOutputs) {
        ThreadUtils.assertMainThread();
        if (this.mMainThreadLayoutState == null) {
            Log.w((String)TAG, (String)"Main Thread Layout state is not found");
            return;
        }
        boolean isDirtyMount = this.mLithoView.isMountStateDirty();
        if (!isDirtyMount && this.mHasMounted && ComponentsConfiguration.incrementalMountWhenNotVisible && currentVisibleArea != null && currentVisibleArea.equals((Object)this.mLithoView.getPreviousMountBounds())) {
            return;
        }
        this.mIsMounting = true;
        if (!this.mHasMounted) {
            this.mLithoView.getMountState().setIsFirstMountOfComponentTree();
            this.mHasMounted = true;
        }
        this.mLithoView.mount(this.mMainThreadLayoutState, currentVisibleArea, processVisibilityOutputs);
        if (isDirtyMount) {
            this.recordRenderData(this.mMainThreadLayoutState);
        }
        this.mIsMounting = false;
        this.mRootHeightAnimation = null;
        this.mRootWidthAnimation = null;
        if (isDirtyMount) {
            this.mLithoView.onDirtyMountComplete();
        }
    }

    void applyPreviousRenderData(LayoutState layoutState) {
        List<Component> components = layoutState.getComponentsNeedingPreviousRenderData();
        if (components == null || components.isEmpty()) {
            return;
        }
        if (this.mPreviousRenderState == null) {
            return;
        }
        this.mPreviousRenderState.applyPreviousRenderData(components);
    }

    private void recordRenderData(LayoutState layoutState) {
        List<Component> components = layoutState.getComponentsNeedingPreviousRenderData();
        if (components == null || components.isEmpty()) {
            return;
        }
        if (this.mPreviousRenderState == null) {
            this.mPreviousRenderState = new RenderState();
        }
        this.mPreviousRenderState.recordRenderData(components);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        ThreadUtils.assertMainThread();
        if (this.mIncrementalMountHelper != null) {
            this.mIncrementalMountHelper.onDetach(this.mLithoView);
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mIsAttached = false;
        }
    }

    void setLithoView(@NonNull LithoView view) {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            if (this.mLithoView != null) {
                this.mLithoView.setComponentTree(null);
            } else {
                this.detach();
            }
        } else if (this.mLithoView != null) {
            this.mLithoView.clearComponentTree();
        }
        if (!ComponentTree.hasSameRootContext(view.getContext(), this.mContext.getAndroidContext())) {
            throw new IllegalArgumentException("Base view context differs, view context is: " + view.getContext() + ", ComponentTree context is: " + this.mContext);
        }
        this.mLithoView = view;
    }

    void clearLithoView() {
        ThreadUtils.assertMainThread();
        if (this.mIsAttached) {
            throw new IllegalStateException("Clearing the LithoView while the ComponentTree is attached");
        }
        this.mLithoView = null;
    }

    void forceMainThreadLayout() {
        ThreadUtils.assertMainThread();
        LithoView lithoView = this.mLithoView;
        if (lithoView != null) {
            lithoView.forceRelayout();
        } else {
            this.mForceLayout = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="this")
    private boolean isPendingLayoutCompatible() {
        Object object = this.mCurrentCalculateLayoutRunnableLock;
        synchronized (object) {
            if (this.mCurrentCalculateLayoutRunnable != null) {
                return true;
            }
        }
        if (this.mPendingLayoutWidthSpec == -1 || this.mPendingLayoutHeightSpec == -1) {
            return false;
        }
        return MeasureComparisonUtils.areMeasureSpecsEquivalent(this.mWidthSpec, this.mPendingLayoutWidthSpec) && MeasureComparisonUtils.areMeasureSpecsEquivalent(this.mHeightSpec, this.mPendingLayoutHeightSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void measure(int widthSpec, int heightSpec, int[] measureOutput, boolean forceLayout) {
        ComponentTree componentTree;
        ThreadUtils.assertMainThread();
        Component component = null;
        TreeProps treeProps = null;
        ComponentTree componentTree2 = this;
        synchronized (componentTree2) {
            boolean shouldCalculateNewLayout;
            this.mIsMeasuring = true;
            this.mWidthSpec = widthSpec;
            this.mHeightSpec = heightSpec;
            this.setBestMainThreadLayoutAndReturnOldLayout();
            boolean bl = shouldCalculateNewLayout = !ComponentTree.isCompatibleSpec(this.mMainThreadLayoutState, this.mWidthSpec, this.mHeightSpec) || !this.mMainThreadLayoutState.isForComponentId(this.mRoot.getId()) && !this.isPendingLayoutCompatible();
            if (this.mForceLayout || forceLayout || shouldCalculateNewLayout) {
                component = this.mRoot.makeShallowCopy();
                treeProps = TreeProps.copy(this.mRootTreeProps);
                this.mForceLayout = false;
            }
        }
        if (component != null) {
            Map<String, Component> attachables;
            ArrayList<Component> components;
            LayoutState localLayoutState;
            if (this.mMainThreadLayoutState != null) {
                componentTree2 = this;
                synchronized (componentTree2) {
                    this.mMainThreadLayoutState = null;
                }
            }
            if ((localLayoutState = this.calculateLayoutState(this.mContext, component, widthSpec, heightSpec, this.mIsLayoutDiffingEnabled, null, treeProps, 6, null)) == null) {
                throw new IllegalStateException("LayoutState cannot be null for measure, this means a LayoutStateFuture was released incorrectly.");
            }
            componentTree = this;
            synchronized (componentTree) {
                StateHandler layoutStateStateHandler = localLayoutState.consumeStateHandler();
                components = new ArrayList<Component>(localLayoutState.getComponents());
                attachables = localLayoutState.consumeAttachables();
                if (layoutStateStateHandler != null) {
                    this.mStateHandler.commit(layoutStateStateHandler, this.mNestedTreeResolutionExperimentEnabled);
                }
                localLayoutState.clearComponents();
                this.mMainThreadLayoutState = localLayoutState;
            }
            AttachDetachHandler attachDetachHandler = this.mContext.getAttachDetachHandler();
            if (attachDetachHandler != null) {
                attachDetachHandler.onAttached(attachables);
            } else if (attachables != null) {
                this.mContext.getOrCreateAttachDetachHandler().onAttached(attachables);
            }
            this.bindEventAndTriggerHandlers(components);
            this.mLithoView.setMountStateDirty();
            this.dispatchNewLayoutStateReady();
        }
        measureOutput[0] = this.mMainThreadLayoutState.getWidth();
        measureOutput[1] = this.mMainThreadLayoutState.getHeight();
        int layoutScheduleType = 0;
        Component root = null;
        TreeProps rootTreeProps = null;
        componentTree = this;
        synchronized (componentTree) {
            this.mIsMeasuring = false;
            if (this.mScheduleLayoutAfterMeasure != 0) {
                layoutScheduleType = this.mScheduleLayoutAfterMeasure;
                this.mScheduleLayoutAfterMeasure = 0;
                root = this.mRoot.makeShallowCopy();
                rootTreeProps = TreeProps.copy(this.mRootTreeProps);
            }
        }
        if (layoutScheduleType != 0) {
            this.setRootAndSizeSpecInternal(root, -1, -1, layoutScheduleType == 1, null, 6, null, rootTreeProps);
        }
    }

    boolean layout() {
        ThreadUtils.assertMainThread();
        return this.mountComponentIfNeeded();
    }

    public boolean isIncrementalMountEnabled() {
        return this.mIncrementalMountEnabled;
    }

    public boolean isNestedTreeResolutionExperimentEnabled() {
        return this.mNestedTreeResolutionExperimentEnabled;
    }

    public boolean isReconciliationEnabled() {
        return this.isReconciliationEnabled;
    }

    synchronized Component getRoot() {
        return this.mRoot;
    }

    public void setRoot(Component rootComponent) {
        if (rootComponent == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(rootComponent, -1, -1, false, null, 0, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    private void preAllocateMountContent(boolean shouldPreallocatePerMountSpec) {
        LayoutState toPrePopulate;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mMainThreadLayoutState != null) {
                toPrePopulate = this.mMainThreadLayoutState;
            } else if (this.mBackgroundLayoutState != null) {
                toPrePopulate = this.mBackgroundLayoutState;
            } else {
                return;
            }
        }
        ComponentsLogger logger = this.mContext.getLogger();
        PerfEvent event = logger != null ? LogTreePopulator.populatePerfEventFromLogger(this.mContext, logger, logger.newPerformanceEvent(this.mContext, 8)) : null;
        toPrePopulate.preAllocateMountContent(shouldPreallocatePerMountSpec);
        if (logger != null) {
            logger.logPerfEvent(event);
        }
    }

    public void setRootAsync(Component rootComponent) {
        if (rootComponent == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(rootComponent, -1, -1, true, null, 1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateLazy(String componentKey, StateContainer.StateUpdate stateUpdate) {
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate, true);
        }
        LithoStats.incStateUpdateLazy(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyLazyStateUpdatesForContainer(String componentKey, StateContainer container) {
        StateHandler stateHandler;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            stateHandler = StateHandler.createShallowCopyForLazyStateUpdates(this.mStateHandler);
        }
        stateHandler.applyLazyStateUpdatesForContainer(componentKey, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateSync(String componentKey, StateContainer.StateUpdate stateUpdate, String attribution) {
        LithoHandler handler;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate, false);
        }
        LithoStats.incStateUpdateSync(1L);
        Looper looper = Looper.myLooper();
        if (looper == null) {
            Log.w((String)TAG, (String)"You cannot update state synchronously from a thread without a looper, using the default background layout thread instead");
            Object object = this.mUpdateStateSyncRunnableLock;
            synchronized (object) {
                if (this.mUpdateStateSyncRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mUpdateStateSyncRunnable);
                }
                this.mUpdateStateSyncRunnable = new UpdateStateSyncRunnable(attribution);
                String tag = EMPTY_STRING;
                if (this.mLayoutThreadHandler.isTracing()) {
                    tag = "updateStateSyncNoLooper " + attribution;
                }
                this.mLayoutThreadHandler.post(this.mUpdateStateSyncRunnable, tag);
            }
            return;
        }
        WeakReference<LithoHandler> handlerWr = sSyncStateUpdatesHandler.get();
        LithoHandler lithoHandler = handler = handlerWr != null ? (LithoHandler)handlerWr.get() : null;
        if (handler == null) {
            handler = new LithoHandler.DefaultLithoHandler(looper);
            sSyncStateUpdatesHandler.set(new WeakReference<LithoHandler>(handler));
        }
        Object object = this.mUpdateStateSyncRunnableLock;
        synchronized (object) {
            if (this.mUpdateStateSyncRunnable != null) {
                handler.remove(this.mUpdateStateSyncRunnable);
            }
            this.mUpdateStateSyncRunnable = new UpdateStateSyncRunnable(attribution);
            String tag = EMPTY_STRING;
            if (handler.isTracing()) {
                tag = "updateStateSync " + attribution;
            }
            handler.post(this.mUpdateStateSyncRunnable, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateAsync(String componentKey, StateContainer.StateUpdate stateUpdate, String attribution) {
        if (!this.mIsAsyncUpdateStateEnabled) {
            throw new RuntimeException("Triggering async state updates on this component tree is disabled, use sync state updates.");
        }
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            this.mStateHandler.queueStateUpdate(componentKey, stateUpdate, false);
        }
        this.updateStateInternal(true, attribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStateInternal(boolean isAsync, String attribution) {
        TreeProps rootTreeProps;
        Component root;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (this.mRoot == null) {
                return;
            }
            if (this.mIsMeasuring) {
                if (this.mScheduleLayoutAfterMeasure == 2) {
                    return;
                }
                this.mScheduleLayoutAfterMeasure = isAsync ? 1 : 2;
                return;
            }
            root = this.mRoot.makeShallowCopy();
            rootTreeProps = TreeProps.copy(this.mRootTreeProps);
        }
        this.setRootAndSizeSpecInternal(root, -1, -1, isAsync, null, isAsync ? 5 : 4, attribution, rootTreeProps);
    }

    StateHandler getStateHandler() {
        return this.mStateHandler;
    }

    boolean shouldCreateInitialStateOncePerThread() {
        return this.mCreateInitialStateOncePerThread;
    }

    void recordEventHandler(Component component, EventHandler eventHandler) {
        this.mEventHandlersController.recordEventHandler(component.getGlobalKey(), eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindTriggerHandler(Component component) {
        EventTriggersContainer eventTriggersContainer = this.mEventTriggersContainer;
        synchronized (eventTriggersContainer) {
            component.recordEventTrigger(this.mEventTriggersContainer);
        }
    }

    private void clearUnusedTriggerHandlers() {
        this.mEventTriggersContainer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    EventTrigger getEventTrigger(String triggerKey) {
        EventTriggersContainer eventTriggersContainer = this.mEventTriggersContainer;
        synchronized (eventTriggersContainer) {
            return this.mEventTriggersContainer.getEventTrigger(triggerKey);
        }
    }

    public synchronized void checkWorkingRangeAndDispatch(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        LayoutState layoutState;
        LayoutState layoutState2 = layoutState = this.isBestMainThreadLayout() ? this.mMainThreadLayoutState : this.mBackgroundLayoutState;
        if (layoutState != null) {
            layoutState.checkWorkingRangeAndDispatch(position, firstVisibleIndex, lastVisibleIndex, firstFullyVisibleIndex, lastFullyVisibleIndex, this.mWorkingRangeStatusHandler);
        }
    }

    private synchronized void clearWorkingRangeStatusHandler() {
        LayoutState layoutState;
        LayoutState layoutState2 = layoutState = this.isBestMainThreadLayout() ? this.mMainThreadLayoutState : this.mBackgroundLayoutState;
        if (layoutState != null) {
            layoutState.dispatchOnExitRangeIfNeeded(this.mWorkingRangeStatusHandler);
        }
        this.mWorkingRangeStatusHandler.clear();
    }

    public void setSizeSpec(int widthSpec, int heightSpec) {
        this.setSizeSpec(widthSpec, heightSpec, null);
    }

    public void setSizeSpec(int widthSpec, int heightSpec, Size output) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, false, output, 2, null, null);
    }

    public void setSizeSpecAsync(int widthSpec, int heightSpec) {
        this.setRootAndSizeSpecInternal(null, widthSpec, heightSpec, true, null, 3, null, null);
    }

    public void setRootAndSizeSpecAsync(Component root, int widthSpec, int heightSpec) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, true, null, 1, null, null);
    }

    public void setRootAndSizeSpecAsync(Component root, int widthSpec, int heightSpec, @Nullable TreeProps treeProps) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, true, null, 1, null, treeProps);
    }

    public void setRootAndSizeSpec(Component root, int widthSpec, int heightSpec) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, null, 0, null, null);
    }

    public void setRootAndSizeSpec(Component root, int widthSpec, int heightSpec, Size output) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, output, 0, null, null);
    }

    public void setRootAndSizeSpec(Component root, int widthSpec, int heightSpec, Size output, @Nullable TreeProps treeProps) {
        if (root == null) {
            throw new IllegalArgumentException("Root component can't be null");
        }
        this.setRootAndSizeSpecAndWrapper(root, widthSpec, heightSpec, false, output, 0, null, treeProps);
    }

    @Keep
    @Nullable
    public LithoView getLithoView() {
        ThreadUtils.assertMainThread();
        return this.mLithoView;
    }

    public synchronized StateHandler acquireStateHandler() {
        return StateHandler.createNewInstance(this.mStateHandler);
    }

    @Nullable
    synchronized void consumeStateUpdateTransitions(List<Transition> outList, @Nullable String logContext) {
        if (this.mStateHandler != null) {
            this.mStateHandler.consumePendingStateUpdateTransitions(outList, logContext);
        }
    }

    @ThreadConfined(value="UI")
    public RenderState consumePreviousRenderState() {
        RenderState previousRenderState = this.mPreviousRenderState;
        this.mPreviousRenderState = null;
        this.mPreviousRenderStateSetFromBuilder = false;
        return previousRenderState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    void showTooltip(DeprecatedLithoTooltip tooltip, String anchorGlobalKey, TooltipPosition tooltipPosition, int xOffset, int yOffset) {
        Map<String, Rect> componentKeysToBounds;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            componentKeysToBounds = this.mMainThreadLayoutState.getComponentKeyToBounds();
        }
        if (!componentKeysToBounds.containsKey(anchorGlobalKey)) {
            throw new IllegalArgumentException("Cannot find a component with key " + anchorGlobalKey + " to use as anchor.");
        }
        Rect anchorBounds = componentKeysToBounds.get(anchorGlobalKey);
        LithoTooltipController.showOnAnchor(tooltip, anchorBounds, (View)this.mLithoView, tooltipPosition, xOffset, yOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showTooltip(LithoTooltip lithoTooltip, String anchorGlobalKey, int xOffset, int yOffset) {
        Map<String, Rect> componentKeysToBounds;
        ThreadUtils.assertMainThread();
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            componentKeysToBounds = this.mMainThreadLayoutState.getComponentKeyToBounds();
        }
        if (!componentKeysToBounds.containsKey(anchorGlobalKey)) {
            throw new IllegalArgumentException("Cannot find a component with key " + anchorGlobalKey + " to use as anchor.");
        }
        Rect anchorBounds = componentKeysToBounds.get(anchorGlobalKey);
        lithoTooltip.showLithoTooltip((View)this.mLithoView, anchorBounds, xOffset, yOffset);
    }

    private void setRootAndSizeSpecAndWrapper(Component root, int widthSpec, int heightSpec, boolean isAsync, Size output, int source, String extraAttribution, @Nullable TreeProps treeProps) {
        this.setRootAndSizeSpecInternal(this.wrapRootInErrorBoundary(root), widthSpec, heightSpec, isAsync, output, source, extraAttribution, treeProps);
    }

    private Component wrapRootInErrorBoundary(Component originalRoot) {
        RootWrapperComponentFactory rootWrapperComponentFactory = ErrorBoundariesConfiguration.rootWrapperComponentFactory;
        return rootWrapperComponentFactory == null ? originalRoot : rootWrapperComponentFactory.createWrapper(this.mContext, originalRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRootAndSizeSpecInternal(Component root, int widthSpec, int heightSpec, boolean isAsync, @Nullable Size output, int source, String extraAttribution, @Nullable TreeProps treeProps) {
        LayoutStateFuture layoutStateFuture;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            boolean rootDidntChange;
            Map<String, List<StateContainer.StateUpdate>> pendingStateUpdates;
            if (this.mReleased) {
                return;
            }
            Map<String, List<StateContainer.StateUpdate>> map = pendingStateUpdates = this.mStateHandler == null ? null : this.mStateHandler.getPendingStateUpdates();
            if (pendingStateUpdates != null && pendingStateUpdates.size() > 0 && root != null) {
                root = root.makeShallowCopyWithNewId();
            }
            boolean rootInitialized = root != null;
            boolean treePropsInitialized = treeProps != null;
            boolean widthSpecInitialized = widthSpec != -1;
            boolean heightSpecInitialized = heightSpec != -1;
            boolean widthSpecDidntChange = !widthSpecInitialized || widthSpec == this.mWidthSpec;
            boolean heightSpecDidntChange = !heightSpecInitialized || heightSpec == this.mHeightSpec;
            boolean sizeSpecDidntChange = widthSpecDidntChange && heightSpecDidntChange;
            LayoutState mostRecentLayoutState = this.mBackgroundLayoutState != null ? this.mBackgroundLayoutState : this.mMainThreadLayoutState;
            boolean allSpecsWereInitialized = widthSpecInitialized && heightSpecInitialized && this.mWidthSpec != -1 && this.mHeightSpec != -1;
            boolean sizeSpecsAreCompatible = sizeSpecDidntChange || allSpecsWereInitialized && mostRecentLayoutState != null && LayoutState.hasCompatibleSizeSpec(this.mWidthSpec, this.mHeightSpec, widthSpec, heightSpec, mostRecentLayoutState.getWidth(), mostRecentLayoutState.getHeight());
            boolean bl = rootDidntChange = !rootInitialized || root.getId() == this.mRoot.getId();
            if (rootDidntChange && sizeSpecsAreCompatible) {
                if (output == null) {
                    return;
                }
                if (mostRecentLayoutState != null) {
                    output.height = mostRecentLayoutState.getHeight();
                    output.width = mostRecentLayoutState.getWidth();
                    return;
                }
            }
            if (widthSpecInitialized) {
                this.mWidthSpec = widthSpec;
            }
            if (heightSpecInitialized) {
                this.mHeightSpec = heightSpec;
            }
            if (rootInitialized) {
                this.mRoot = root;
            }
            if (treePropsInitialized) {
                this.mRootTreeProps = treeProps;
            }
        }
        if (isAsync && output != null) {
            throw new IllegalArgumentException("The layout can't be calculated asynchronously if we need the Size back");
        }
        LayoutStateFuture layoutStateFuture2 = layoutStateFuture = this.mUseCancelableLayoutFutures ? this.createLayoutStateFutureAndCancelRunning(this.mContext, this.mIsLayoutDiffingEnabled, treeProps, source, extraAttribution) : null;
        if (isAsync) {
            Object object = this.mCurrentCalculateLayoutRunnableLock;
            synchronized (object) {
                if (this.mCurrentCalculateLayoutRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
                }
                this.mCurrentCalculateLayoutRunnable = new CalculateLayoutRunnable(source, treeProps, extraAttribution, layoutStateFuture);
                String tag = EMPTY_STRING;
                if (this.mLayoutThreadHandler.isTracing()) {
                    tag = "calculateLayout ";
                    if (root != null) {
                        tag = tag + root.getSimpleName();
                    }
                }
                this.mLayoutThreadHandler.post(this.mCurrentCalculateLayoutRunnable, tag);
            }
        } else {
            this.calculateLayout(output, source, extraAttribution, treeProps, layoutStateFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateLayout(@Nullable Size output, int source, @Nullable String extraAttribution, @Nullable TreeProps treeProps, @Nullable LayoutStateFuture layoutStateFuture) {
        boolean noCompatibleComponent;
        LayoutState localLayoutState;
        PerfEvent layoutEvent;
        Component root;
        int heightSpec;
        int widthSpec;
        LayoutState previousLayoutState = null;
        Object object = this.mCurrentCalculateLayoutRunnableLock;
        synchronized (object) {
            if (this.mCurrentCalculateLayoutRunnable != null) {
                this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
                this.mCurrentCalculateLayoutRunnable = null;
            }
        }
        object = this;
        synchronized (object) {
            if (!this.hasSizeSpec() || this.mRoot == null) {
                return;
            }
            if (this.hasCompatibleComponentAndSpec()) {
                if (output != null) {
                    LayoutState mostRecentLayoutState = this.mBackgroundLayoutState != null ? this.mBackgroundLayoutState : this.mMainThreadLayoutState;
                    output.width = mostRecentLayoutState.getWidth();
                    output.height = mostRecentLayoutState.getHeight();
                }
                return;
            }
            widthSpec = this.mWidthSpec;
            heightSpec = this.mHeightSpec;
            this.mPendingLayoutWidthSpec = widthSpec;
            this.mPendingLayoutHeightSpec = heightSpec;
            root = this.mRoot.makeShallowCopy();
            if (this.mMainThreadLayoutState != null) {
                previousLayoutState = this.mMainThreadLayoutState;
            }
        }
        ComponentsLogger logger = this.mContext.getLogger();
        PerfEvent perfEvent = layoutEvent = logger != null ? LogTreePopulator.populatePerfEventFromLogger(this.mContext, logger, logger.newPerformanceEvent(this.mContext, 3)) : null;
        if (layoutEvent != null) {
            layoutEvent.markerAnnotate("root_component", root.getSimpleName());
            layoutEvent.markerAnnotate("is_background_layout", !ThreadUtils.isMainThread());
            layoutEvent.markerAnnotate("tree_diff_enabled", this.mIsLayoutDiffingEnabled);
            layoutEvent.markerAnnotate("attribution", extraAttribution);
        }
        LayoutState layoutState = localLayoutState = layoutStateFuture == null ? this.calculateLayoutState(this.mContext, root, widthSpec, heightSpec, this.mIsLayoutDiffingEnabled, previousLayoutState, treeProps, source, extraAttribution) : this.calculateLayoutState(layoutStateFuture);
        if (localLayoutState == null) {
            if (output != null) {
                throw new IllegalStateException("LayoutState is null, but only async operations can return a null LayoutState");
            }
            return;
        }
        if (output != null) {
            output.width = localLayoutState.getWidth();
            output.height = localLayoutState.getHeight();
        }
        ArrayList<Component> components = null;
        Map<String, Component> attachables = null;
        int rootWidth = 0;
        int rootHeight = 0;
        boolean layoutStateUpdated = false;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            this.mPendingLayoutWidthSpec = -1;
            this.mPendingLayoutHeightSpec = -1;
            boolean bl = noCompatibleComponent = !this.hasCompatibleComponentAndSpec() && ComponentTree.isCompatibleSpec(localLayoutState, this.mWidthSpec, this.mHeightSpec);
            if (noCompatibleComponent) {
                StateHandler layoutStateStateHandler = localLayoutState.consumeStateHandler();
                if (layoutStateStateHandler != null && this.mStateHandler != null) {
                    this.mStateHandler.commit(layoutStateStateHandler, this.mNestedTreeResolutionExperimentEnabled);
                }
                if (this.mMeasureListener != null) {
                    rootWidth = localLayoutState.getWidth();
                    rootHeight = localLayoutState.getHeight();
                }
                components = new ArrayList<Component>(localLayoutState.getComponents());
                localLayoutState.clearComponents();
                attachables = localLayoutState.consumeAttachables();
                this.mBackgroundLayoutState = localLayoutState;
                layoutStateUpdated = true;
            }
        }
        if (noCompatibleComponent) {
            AttachDetachHandler attachDetachHandler;
            if (this.mMeasureListener != null) {
                this.mMeasureListener.onSetRootAndSizeSpec(rootWidth, rootHeight);
            }
            if ((attachDetachHandler = this.mContext.getAttachDetachHandler()) != null) {
                attachDetachHandler.onAttached(attachables);
            } else if (attachables != null) {
                this.mContext.getOrCreateAttachDetachHandler().onAttached(attachables);
            }
        }
        if (components != null) {
            this.bindEventAndTriggerHandlers(components);
        }
        if (layoutStateUpdated) {
            this.postBackgroundLayoutStateUpdated();
        }
        if (this.mPreAllocateMountContentHandler != null) {
            this.mPreAllocateMountContentHandler.remove(this.mPreAllocateMountContentRunnable);
            String tag = EMPTY_STRING;
            if (this.mPreAllocateMountContentHandler.isTracing()) {
                tag = "preallocateLayout ";
                if (root != null) {
                    tag = tag + root.getSimpleName();
                }
            }
            this.mPreAllocateMountContentHandler.post(this.mPreAllocateMountContentRunnable, tag);
        }
        if (layoutEvent != null) {
            logger.logPerfEvent(layoutEvent);
        }
    }

    private void bindEventAndTriggerHandlers(List<Component> components) {
        this.clearUnusedTriggerHandlers();
        for (Component component : components) {
            this.mEventHandlersController.bindEventHandlers(component.getScopedContext(), component, component.getGlobalKey());
            this.bindTriggerHandler(component);
        }
        this.mEventHandlersController.clearUnusedEventHandlers();
    }

    private void postBackgroundLayoutStateUpdated() {
        if (ThreadUtils.isMainThread()) {
            this.backgroundLayoutStateUpdated();
        } else {
            String tag = EMPTY_STRING;
            if (this.mMainThreadHandler.isTracing()) {
                tag = "postBackgroundLayoutStateUpdated";
            }
            this.mMainThreadHandler.post(this.mBackgroundLayoutStateUpdateRunnable, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mIsMounting) {
            throw new IllegalStateException("Releasing a ComponentTree that is currently being mounted");
        }
        Object object = this;
        synchronized (object) {
            this.mMainThreadHandler.remove(this.mBackgroundLayoutStateUpdateRunnable);
            Object object2 = this.mCurrentCalculateLayoutRunnableLock;
            synchronized (object2) {
                if (this.mCurrentCalculateLayoutRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mCurrentCalculateLayoutRunnable);
                    this.mCurrentCalculateLayoutRunnable = null;
                }
            }
            object2 = this.mUpdateStateSyncRunnableLock;
            synchronized (object2) {
                if (this.mUpdateStateSyncRunnable != null) {
                    this.mLayoutThreadHandler.remove(this.mUpdateStateSyncRunnable);
                    this.mUpdateStateSyncRunnable = null;
                }
            }
            object2 = this.mLayoutStateFutureLock;
            synchronized (object2) {
                for (int i = 0; i < this.mLayoutStateFutures.size(); ++i) {
                    this.mLayoutStateFutures.get(i).release();
                }
                this.mLayoutStateFutures.clear();
            }
            if (this.mPreAllocateMountContentHandler != null) {
                this.mPreAllocateMountContentHandler.remove(this.mPreAllocateMountContentRunnable);
            }
            this.mReleased = true;
            this.mReleasedComponent = this.mRoot.getSimpleName();
            if (this.mLithoView != null) {
                this.mLithoView.setComponentTree(null);
            }
            this.mRoot = null;
            this.clearWorkingRangeStatusHandler();
            this.mMainThreadLayoutState = null;
            this.mBackgroundLayoutState = null;
            this.mStateHandler = null;
            this.mPreviousRenderState = null;
            this.mPreviousRenderStateSetFromBuilder = false;
        }
        object = this.mEventTriggersContainer;
        synchronized (object) {
            this.clearUnusedTriggerHandlers();
        }
        AttachDetachHandler attachDetachHandler = this.mContext.getAttachDetachHandler();
        if (attachDetachHandler != null) {
            attachDetachHandler.onDetached();
        }
    }

    @GuardedBy(value="this")
    private boolean isCompatibleComponentAndSpec(LayoutState layoutState) {
        ThreadUtils.assertHoldsLock(this);
        return this.mRoot != null && ComponentTree.isCompatibleComponentAndSpec(layoutState, this.mRoot.getId(), this.mWidthSpec, this.mHeightSpec);
    }

    @GuardedBy(value="this")
    private boolean hasCompatibleComponentAndSpec() {
        ThreadUtils.assertHoldsLock(this);
        return this.isCompatibleComponentAndSpec(this.mMainThreadLayoutState) || this.isCompatibleComponentAndSpec(this.mBackgroundLayoutState);
    }

    @GuardedBy(value="this")
    private boolean hasSizeSpec() {
        ThreadUtils.assertHoldsLock(this);
        return this.mWidthSpec != -1 && this.mHeightSpec != -1;
    }

    @Nullable
    public synchronized String getSimpleName() {
        return this.mRoot == null ? null : this.mRoot.getSimpleName();
    }

    @Nullable
    Object getCachedValue(Object cachedValueInputs) {
        if (this.isReleased()) {
            return null;
        }
        return this.mStateHandler.getCachedValue(cachedValueInputs);
    }

    void putCachedValue(Object cachedValueInputs, Object cachedValue) {
        if (this.isReleased()) {
            return;
        }
        this.mStateHandler.putCachedValue(cachedValueInputs, cachedValue);
    }

    private static synchronized Looper getDefaultLayoutThreadLooper() {
        if (sDefaultLayoutThreadLooper == null) {
            HandlerThread defaultThread = new HandlerThread(DEFAULT_LAYOUT_THREAD_NAME, 5);
            defaultThread.start();
            sDefaultLayoutThreadLooper = defaultThread.getLooper();
        }
        return sDefaultLayoutThreadLooper;
    }

    private static synchronized Looper getDefaultPreallocateMountContentThreadLooper() {
        if (sDefaultPreallocateMountContentThreadLooper == null) {
            HandlerThread defaultThread = new HandlerThread(DEFAULT_PMC_THREAD_NAME);
            defaultThread.start();
            sDefaultPreallocateMountContentThreadLooper = defaultThread.getLooper();
        }
        return sDefaultPreallocateMountContentThreadLooper;
    }

    private static boolean isCompatibleSpec(LayoutState layoutState, int widthSpec, int heightSpec) {
        return layoutState != null && layoutState.isCompatibleSpec(widthSpec, heightSpec) && layoutState.isCompatibleAccessibility();
    }

    private static boolean isCompatibleComponentAndSpec(LayoutState layoutState, int componentId, int widthSpec, int heightSpec) {
        return layoutState != null && layoutState.isCompatibleComponentAndSpec(componentId, widthSpec, heightSpec) && layoutState.isCompatibleAccessibility();
    }

    private static boolean isCompatibleComponentAndSize(LayoutState layoutState, int componentId, int width, int height) {
        return layoutState != null && layoutState.isForComponentId(componentId) && layoutState.isCompatibleSize(width, height) && layoutState.isCompatibleAccessibility();
    }

    public synchronized boolean isReleased() {
        return this.mReleased;
    }

    synchronized String getReleasedComponent() {
        return this.mReleasedComponent;
    }

    public ComponentContext getContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LayoutStateFuture createLayoutStateFutureAndCancelRunning(ComponentContext context, boolean diffingEnabled, @Nullable TreeProps treeProps, int source, @Nullable String extraAttribution) {
        Component root;
        int heightSpec;
        int widthSpec;
        LayoutState previousLayoutState = null;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            if (!this.hasSizeSpec() || this.mRoot == null) {
                return null;
            }
            widthSpec = this.mWidthSpec;
            heightSpec = this.mHeightSpec;
            this.mPendingLayoutWidthSpec = widthSpec;
            this.mPendingLayoutHeightSpec = heightSpec;
            root = this.mRoot.makeShallowCopy();
            if (this.mMainThreadLayoutState != null) {
                previousLayoutState = this.mMainThreadLayoutState;
            }
        }
        LayoutStateFuture localLayoutStateFuture = new LayoutStateFuture(context, root, widthSpec, heightSpec, diffingEnabled, previousLayoutState, treeProps, source, extraAttribution);
        boolean waitingFromSyncLayout = localLayoutStateFuture.isFromSyncLayout;
        Object object = this.mLayoutStateFutureLock;
        synchronized (object) {
            boolean canReuse = false;
            for (int i = 0; i < this.mLayoutStateFutures.size(); ++i) {
                LayoutStateFuture runningFuture = this.mLayoutStateFutures.get(i);
                if (!runningFuture.isReleased() && runningFuture.equals(localLayoutStateFuture)) {
                    localLayoutStateFuture = runningFuture;
                    canReuse = true;
                    continue;
                }
                if (!runningFuture.canBeCancelled()) continue;
                runningFuture.release();
            }
            localLayoutStateFuture.registerForResponse(waitingFromSyncLayout);
            if (!canReuse) {
                this.mLayoutStateFutures.add(localLayoutStateFuture);
            }
        }
        return localLayoutStateFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private LayoutState calculateLayoutState(LayoutStateFuture layoutStateFuture) {
        LayoutState layoutState = layoutStateFuture.runAndGet();
        Object object = this.mLayoutStateFutureLock;
        synchronized (object) {
            layoutStateFuture.unregisterForResponse();
            if (layoutStateFuture.getWaitingCount() == 0) {
                layoutStateFuture.release();
                this.mLayoutStateFutures.remove(layoutStateFuture);
            }
        }
        return layoutState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected LayoutState calculateLayoutState(ComponentContext context, Component root, int widthSpec, int heightSpec, boolean diffingEnabled, @Nullable LayoutState previousLayoutState, @Nullable TreeProps treeProps, int source, @Nullable String extraAttribution) {
        LayoutStateFuture localLayoutStateFuture = new LayoutStateFuture(context, root, widthSpec, heightSpec, diffingEnabled, previousLayoutState, treeProps, source, extraAttribution);
        boolean waitingFromSyncLayout = localLayoutStateFuture.isFromSyncLayout;
        Object object = this.mLayoutStateFutureLock;
        synchronized (object) {
            boolean canReuse = false;
            for (int i = 0; i < this.mLayoutStateFutures.size(); ++i) {
                LayoutStateFuture runningLsf = this.mLayoutStateFutures.get(i);
                if (runningLsf.isReleased() || !runningLsf.equals(localLayoutStateFuture)) continue;
                localLayoutStateFuture = runningLsf;
                canReuse = true;
                break;
            }
            if (!canReuse) {
                this.mLayoutStateFutures.add(localLayoutStateFuture);
            }
            localLayoutStateFuture.registerForResponse(waitingFromSyncLayout);
        }
        LayoutState layoutState = localLayoutStateFuture.runAndGet();
        Object object2 = this.mLayoutStateFutureLock;
        synchronized (object2) {
            localLayoutStateFuture.unregisterForResponse();
            if (localLayoutStateFuture.getWaitingCount() == 0) {
                localLayoutStateFuture.release();
                this.mLayoutStateFutures.remove(localLayoutStateFuture);
            }
        }
        return layoutState;
    }

    private LayoutState calculateLayoutStateInternal(ComponentContext context, Component root, int widthSpec, int heightSpec, boolean diffingEnabled, @Nullable LayoutState previousLayoutState, @Nullable TreeProps treeProps, int source, @Nullable String extraAttribution, @Nullable LayoutStateFuture layoutStateFuture) {
        ComponentContext contextWithStateHandler = this.getNewContextForLayout(context, treeProps, layoutStateFuture);
        return LayoutState.calculate(contextWithStateHandler, root, this.mId, widthSpec, heightSpec, diffingEnabled, previousLayoutState, source, extraAttribution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentContext getNewContextForLayout(ComponentContext context, @Nullable TreeProps treeProps, @Nullable LayoutStateFuture layoutStateFuture) {
        ComponentContext contextWithStateHandler;
        ComponentTree componentTree = this;
        synchronized (componentTree) {
            KeyHandler keyHandler = ComponentsConfiguration.useGlobalKeys || ComponentsConfiguration.isDebugModeEnabled ? new KeyHandler(this.mContext.getLogger()) : null;
            contextWithStateHandler = new ComponentContext(context, StateHandler.createNewInstance(this.mStateHandler), keyHandler, treeProps, layoutStateFuture);
        }
        return contextWithStateHandler;
    }

    @VisibleForTesting
    List<LayoutStateFuture> getLayoutStateFutures() {
        return this.mLayoutStateFutures;
    }

    public static int generateComponentTreeId() {
        return sIdGenerator.getAndIncrement();
    }

    @VisibleForTesting
    EventHandlersController getEventHandlersController() {
        return this.mEventHandlersController;
    }

    public synchronized void updateMeasureListener(@Nullable MeasureListener measureListener) {
        this.mMeasureListener = measureListener;
    }

    static {
        sSyncStateUpdatesHandler = new ThreadLocal();
    }

    public static class Builder {
        private final ComponentContext context;
        private final Component root;
        private boolean incrementalMountEnabled = true;
        private boolean isLayoutDiffingEnabled = true;
        private LithoHandler layoutThreadHandler;
        private LithoHandler preAllocateMountContentHandler;
        private StateHandler stateHandler;
        private RenderState previousRenderState;
        private boolean asyncStateUpdates = true;
        private int overrideComponentTreeId = -1;
        private boolean hasMounted = false;
        @Nullable
        private MeasureListener mMeasureListener;
        private boolean shouldPreallocatePerMountSpec;
        private boolean canPreallocateOnDefaultHandler;
        private boolean nestedTreeResolutionExperimentEnabled = ComponentsConfiguration.isNestedTreeResolutionExperimentEnabled;
        private boolean isReconciliationEnabled = ComponentsConfiguration.isReconciliationEnabled;
        private boolean canInterruptAndMoveLayoutsBetweenThreads = ComponentsConfiguration.canInterruptAndMoveLayoutsBetweenThreads;
        private boolean splitLayoutForMeasureAndRangeEstimation = ComponentsConfiguration.splitLayoutForMeasureAndRangeEstimation;
        private boolean useCancelableLayoutFutures = ComponentsConfiguration.useCancelableLayoutFutures;

        protected Builder(ComponentContext context, Component root) {
            this.context = context;
            this.root = root;
        }

        public Builder incrementalMount(boolean isEnabled) {
            this.incrementalMountEnabled = isEnabled;
            return this;
        }

        public Builder layoutDiffing(boolean enabled) {
            this.isLayoutDiffingEnabled = enabled;
            return this;
        }

        public Builder layoutThreadLooper(Looper looper) {
            if (looper != null) {
                this.layoutThreadHandler = new LithoHandler.DefaultLithoHandler(looper);
            }
            return this;
        }

        public Builder preAllocateMountContentHandler(LithoHandler handler) {
            this.preAllocateMountContentHandler = handler;
            return this;
        }

        public Builder shouldPreallocateMountContentPerMountSpec(boolean preallocatePerMountSpec) {
            this.shouldPreallocatePerMountSpec = preallocatePerMountSpec;
            return this;
        }

        public Builder preallocateOnDefaultHandler(boolean preallocateOnDefaultHandler) {
            this.canPreallocateOnDefaultHandler = preallocateOnDefaultHandler;
            return this;
        }

        public Builder layoutThreadHandler(LithoHandler handler) {
            this.layoutThreadHandler = handler;
            return this;
        }

        public Builder stateHandler(StateHandler stateHandler) {
            this.stateHandler = stateHandler;
            return this;
        }

        public Builder previousRenderState(RenderState previousRenderState) {
            this.previousRenderState = previousRenderState;
            return this;
        }

        public Builder asyncStateUpdates(boolean enabled) {
            this.asyncStateUpdates = enabled;
            return this;
        }

        public Builder overrideComponentTreeId(int overrideComponentTreeId) {
            this.overrideComponentTreeId = overrideComponentTreeId;
            return this;
        }

        public Builder hasMounted(boolean hasMounted) {
            this.hasMounted = hasMounted;
            return this;
        }

        public Builder measureListener(MeasureListener measureListener) {
            this.mMeasureListener = measureListener;
            return this;
        }

        public Builder enableNestedTreeResolutionExperiment(boolean isEnabled) {
            this.nestedTreeResolutionExperimentEnabled = isEnabled;
            return this;
        }

        public Builder isReconciliationEnabled(boolean isEnabled) {
            this.isReconciliationEnabled = isEnabled;
            return this;
        }

        public Builder useCancelableLayoutFutures(boolean isEnabled) {
            this.useCancelableLayoutFutures = isEnabled;
            return this;
        }

        public Builder canInterruptAndMoveLayoutsBetweenThreads(boolean isEnabled) {
            this.canInterruptAndMoveLayoutsBetweenThreads = isEnabled;
            return this;
        }

        public ComponentTree build() {
            return new ComponentTree(this);
        }
    }

    private final class UpdateStateSyncRunnable
    extends ThreadTracingRunnable {
        private final String mAttribution;

        public UpdateStateSyncRunnable(String attribution) {
            this.mAttribution = attribution;
        }

        @Override
        public void tracedRun(Throwable tracedThrowable) {
            ComponentTree.this.updateStateInternal(false, this.mAttribution);
        }
    }

    private class CalculateLayoutRunnable
    extends ThreadTracingRunnable {
        private final int mSource;
        @Nullable
        private final TreeProps mTreeProps;
        private final String mAttribution;
        @Nullable
        private final LayoutStateFuture mLayoutStateFuture;

        public CalculateLayoutRunnable(@Nullable int source, TreeProps treeProps, @Nullable String attribution, LayoutStateFuture layoutStateFuture) {
            this.mSource = source;
            this.mTreeProps = treeProps;
            this.mAttribution = attribution;
            this.mLayoutStateFuture = layoutStateFuture;
        }

        @Override
        public void tracedRun(Throwable tracedThrowable) {
            ComponentTree.this.calculateLayout(null, this.mSource, this.mAttribution, this.mTreeProps, this.mLayoutStateFuture);
        }
    }

    @VisibleForTesting
    class LayoutStateFuture {
        private final AtomicInteger runningThreadId = new AtomicInteger(-1);
        private final ComponentContext context;
        private final Component root;
        private final int widthSpec;
        private final int heightSpec;
        private final boolean diffingEnabled;
        @Nullable
        private final LayoutState previousLayoutState;
        @Nullable
        private final TreeProps treeProps;
        private final FutureTask<LayoutState> futureTask;
        private final AtomicInteger refCount = new AtomicInteger(0);
        private final boolean isFromSyncLayout;
        private final AtomicBoolean interrupted = new AtomicBoolean(false);
        private final int source;
        private final String extraAttribution;
        @GuardedBy(value="LayoutStateFuture.this")
        private volatile boolean released = false;
        @GuardedBy(value="LayoutStateFuture.this")
        @Nullable
        private volatile LayoutState layoutState = null;
        private boolean isBlockingSyncLayout;

        private LayoutStateFuture(final ComponentContext context, final Component root, final int widthSpec, final int heightSpec, final @Nullable boolean diffingEnabled, final @Nullable LayoutState previousLayoutState, final TreeProps treeProps, final @Nullable int source, final String extraAttribution) {
            this.context = context;
            this.root = root;
            this.widthSpec = widthSpec;
            this.heightSpec = heightSpec;
            this.diffingEnabled = diffingEnabled;
            this.previousLayoutState = previousLayoutState;
            this.treeProps = treeProps;
            this.isFromSyncLayout = this.isFromSyncLayout(source);
            this.source = source;
            this.extraAttribution = extraAttribution;
            this.futureTask = new FutureTask<LayoutState>(new Callable<LayoutState>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Nullable
                public LayoutState call() {
                    LayoutStateFuture layoutStateFuture = LayoutStateFuture.this;
                    synchronized (layoutStateFuture) {
                        if (LayoutStateFuture.this.released) {
                            return null;
                        }
                    }
                    LayoutState result = ComponentTree.this.calculateLayoutStateInternal(context, root, widthSpec, heightSpec, diffingEnabled, previousLayoutState, treeProps, source, extraAttribution, ComponentTree.this.mMoveLayoutsBetweenThreads || ComponentTree.this.mUseCancelableLayoutFutures ? LayoutStateFuture.this : null);
                    LayoutStateFuture layoutStateFuture2 = LayoutStateFuture.this;
                    synchronized (layoutStateFuture2) {
                        if (LayoutStateFuture.this.released) {
                            return null;
                        }
                        LayoutStateFuture.this.layoutState = result;
                        return result;
                    }
                }
            });
        }

        private boolean isFromSyncLayout(int source) {
            switch (source) {
                case 0: 
                case 2: 
                case 4: 
                case 6: {
                    return true;
                }
            }
            return false;
        }

        @VisibleForTesting
        synchronized void release() {
            if (this.released) {
                return;
            }
            this.layoutState = null;
            this.released = true;
        }

        boolean isReleased() {
            return this.released;
        }

        boolean isInterrupted() {
            return !ThreadUtils.isMainThread() && this.interrupted.get();
        }

        void interrupt() {
            this.interrupted.set(true);
        }

        void unregisterForResponse() {
            int newRefCount = this.refCount.decrementAndGet();
            if (newRefCount < 0) {
                throw new IllegalStateException("LayoutStateFuture ref count is below 0");
            }
        }

        void registerForResponse(boolean waitingFromSyncLayout) {
            this.refCount.incrementAndGet();
            if (waitingFromSyncLayout) {
                this.isBlockingSyncLayout = true;
            }
        }

        public int getWaitingCount() {
            return this.refCount.get();
        }

        boolean canBeCancelled() {
            return !this.isBlockingSyncLayout && !this.isFromSyncLayout;
        }

        @VisibleForTesting
        @Nullable
        LayoutState runAndGet() {
            if (ComponentTree.this.mMoveLayoutsBetweenThreads) {
                return this.runAndGetSwitchThreadsWhenUIBlocked();
            }
            return this.runAndGetIncreasePriority();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        @Nullable
        LayoutState runAndGetIncreasePriority() {
            LayoutState result;
            boolean didRaiseThreadPriority;
            int originalThreadPriority;
            int runningThreadId;
            boolean notRunningOnMyThread;
            if (this.runningThreadId.compareAndSet(-1, Process.myTid())) {
                this.futureTask.run();
            }
            boolean bl = notRunningOnMyThread = (runningThreadId = this.runningThreadId.get()) != Process.myTid();
            if (ThreadUtils.isMainThread() && !this.futureTask.isDone() && notRunningOnMyThread) {
                originalThreadPriority = ComponentsConfiguration.inheritPriorityFromUiThread ? ThreadUtils.tryInheritThreadPriorityFromCurrentThread(runningThreadId) : ThreadUtils.tryRaiseThreadPriority(runningThreadId, -4);
                didRaiseThreadPriority = true;
            } else {
                originalThreadPriority = 0;
                didRaiseThreadPriority = false;
            }
            try {
                boolean shouldTrace;
                boolean bl2 = shouldTrace = notRunningOnMyThread && ComponentsSystrace.isTracing();
                if (shouldTrace) {
                    ComponentsSystrace.beginSectionWithArgs("LayoutStateFuture.get").arg("root", this.root.getSimpleName()).arg("runningThreadId", runningThreadId).flush();
                }
                result = this.futureTask.get();
                if (shouldTrace) {
                    ComponentsSystrace.endSection();
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (InterruptedException | CancellationException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                if (didRaiseThreadPriority) {
                    try {
                        Process.setThreadPriority((int)runningThreadId, (int)originalThreadPriority);
                    }
                    catch (IllegalArgumentException | SecurityException runtimeException) {}
                }
            }
            if (result == null) {
                return null;
            }
            LayoutStateFuture layoutStateFuture = this;
            synchronized (layoutStateFuture) {
                if (this.released) {
                    return null;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @VisibleForTesting
        @Nullable
        LayoutState runAndGetSwitchThreadsWhenUIBlocked() {
            LayoutState result;
            if (this.runningThreadId.compareAndSet(-1, Process.myTid())) {
                this.futureTask.run();
            }
            int runningThreadId = this.runningThreadId.get();
            if (ThreadUtils.isMainThread() && !this.futureTask.isDone() && runningThreadId != Process.myTid() && !this.isFromSyncLayout) {
                this.interrupt();
            }
            try {
                result = this.futureTask.get();
                if (this.interrupted.get() && result.isPartialLayoutState()) {
                    result = ThreadUtils.isMainThread() ? this.resolvePartialInternalNodeAndCalculateLayout(result) : null;
                }
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
            if (result == null) {
                return null;
            }
            LayoutStateFuture layoutStateFuture = this;
            synchronized (layoutStateFuture) {
                if (this.released) {
                    return null;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LayoutState resolvePartialInternalNodeAndCalculateLayout(LayoutState partialLayoutState) {
            if (this.released) {
                return null;
            }
            LayoutState result = LayoutState.resumeCalculate(ComponentTree.this.getNewContextForLayout(this.context, this.treeProps, null), this.source, this.extraAttribution, partialLayoutState);
            LayoutStateFuture layoutStateFuture = this;
            synchronized (layoutStateFuture) {
                return this.released ? null : result;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutStateFuture that = (LayoutStateFuture)o;
            if (this.widthSpec != that.widthSpec) {
                return false;
            }
            if (this.heightSpec != that.heightSpec) {
                return false;
            }
            if (!this.context.equals(that.context)) {
                return false;
            }
            return this.root.getId() == that.root.getId();
        }

        public int hashCode() {
            int result = this.context.hashCode();
            result = 31 * result + this.root.getId();
            result = 31 * result + this.widthSpec;
            result = 31 * result + this.heightSpec;
            return result;
        }
    }

    public static interface NewLayoutStateReadyListener {
        public void onNewLayoutStateReady(ComponentTree var1);
    }

    public static interface MeasureListener {
        public void onSetRootAndSizeSpec(int var1, int var2);
    }
}

