/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Column;
import com.facebook.litho.CommonPropsCopyable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.ComponentsChainException;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DefaultMountContentPool;
import com.facebook.litho.DiffNode;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.EventTriggerTarget;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InternalNodeUtils;
import com.facebook.litho.LayoutState;
import com.facebook.litho.MountContentPool;
import com.facebook.litho.Size;
import com.facebook.litho.SizeSpec;
import com.facebook.litho.StateContainer;
import com.facebook.litho.Transition;
import com.facebook.litho.TransitionUtils;
import com.facebook.litho.TreeProps;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.yoga.YogaBaselineFunction;
import com.facebook.yoga.YogaMeasureFunction;
import com.facebook.yoga.YogaMeasureMode;
import com.facebook.yoga.YogaMeasureOutput;
import com.facebook.yoga.YogaNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

public abstract class ComponentLifecycle
implements EventDispatcher,
EventTriggerTarget {
    private static final AtomicInteger sComponentTypeId = new AtomicInteger();
    private static final int DEFAULT_MAX_PREALLOCATION = 3;
    static final int ERROR_EVENT_HANDLER_ID = "__internalOnErrorHandler".hashCode();
    private static final YogaBaselineFunction sBaselineFunction = new YogaBaselineFunction(){

        public float baseline(YogaNode cssNode, float width, float height) {
            InternalNode node = (InternalNode)cssNode.getData();
            return node.getTailComponent().onMeasureBaseline(node.getContext(), (int)width, (int)height);
        }
    };
    static final YogaMeasureFunction sMeasureFunction = new YogaMeasureFunction(){

        private Size acquireSize(int initialValue) {
            return new Size(initialValue, initialValue);
        }

        @SuppressLint(value={"WrongCall"})
        public long measure(YogaNode cssNode, float width, YogaMeasureMode widthMode, float height, YogaMeasureMode heightMode) {
            InternalNode node = (InternalNode)cssNode.getData();
            DiffNode diffNode = node.areCachedMeasuresValid() ? node.getDiffNode() : null;
            Component component = node.getTailComponent();
            boolean isTracing = ComponentsSystrace.isTracing();
            int widthSpec = SizeSpec.makeSizeSpecFromCssSpec(width, widthMode);
            int heightSpec = SizeSpec.makeSizeSpecFromCssSpec(height, heightMode);
            if (isTracing) {
                ComponentsSystrace.beginSectionWithArgs("measure:" + component.getSimpleName()).arg("widthSpec", SizeSpec.toString(widthSpec)).arg("heightSpec", SizeSpec.toString(heightSpec)).arg("componentId", component.getId()).flush();
            }
            node.setLastWidthSpec(widthSpec);
            node.setLastHeightSpec(heightSpec);
            int outputWidth = 0;
            int outputHeight = 0;
            if (Component.isNestedTree(component) || node.hasNestedTree()) {
                ComponentContext context = node.getContext();
                if (context.isNestedTreeResolutionExperimentEnabled()) {
                    if (node.getParent() != null) {
                        context = node.getParent().getContext();
                    } else if (context.getLogger() != null) {
                        context.getLogger().emitMessage(ComponentsLogger.LogLevel.ERROR, "component " + component.getSimpleName() + " is a nested tree but does not have a parent component.[mGlobalKey:" + component.getGlobalKey() + "]");
                    }
                }
                InternalNode nestedTree = LayoutState.resolveNestedTree(context, node, widthSpec, heightSpec);
                outputWidth = nestedTree.getWidth();
                outputHeight = nestedTree.getHeight();
            } else if (diffNode != null && diffNode.getLastWidthSpec() == widthSpec && diffNode.getLastHeightSpec() == heightSpec && !component.shouldAlwaysRemeasure()) {
                outputWidth = (int)diffNode.getLastMeasuredWidth();
                outputHeight = (int)diffNode.getLastMeasuredHeight();
            } else {
                Size size = this.acquireSize(Integer.MIN_VALUE);
                component.onMeasure(component.getScopedContext(), node, widthSpec, heightSpec, size);
                if (size.width < 0 || size.height < 0) {
                    throw new IllegalStateException("MeasureOutput not set, ComponentLifecycle is: " + component);
                }
                outputWidth = size.width;
                outputHeight = size.height;
                if (node.getDiffNode() != null) {
                    node.getDiffNode().setLastWidthSpec(widthSpec);
                    node.getDiffNode().setLastHeightSpec(heightSpec);
                    node.getDiffNode().setLastMeasuredWidth(outputWidth);
                    node.getDiffNode().setLastMeasuredHeight(outputHeight);
                }
            }
            node.setLastMeasuredWidth(outputWidth);
            node.setLastMeasuredHeight(outputHeight);
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
            return YogaMeasureOutput.make((int)outputWidth, (int)outputHeight);
        }
    };
    @GuardedBy(value="sTypeIdByComponentType")
    private static final Map<Object, Integer> sTypeIdByComponentType = new HashMap<Object, Integer>();
    private final int mTypeId;

    ComponentLifecycle() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ComponentLifecycle(Object type) {
        if (type == null) {
            type = this.getClass();
        }
        Map<Object, Integer> map = sTypeIdByComponentType;
        synchronized (map) {
            if (!sTypeIdByComponentType.containsKey(type)) {
                sTypeIdByComponentType.put(type, sComponentTypeId.incrementAndGet());
            }
            this.mTypeId = sTypeIdByComponentType.get(type);
        }
    }

    int getTypeId() {
        return this.mTypeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe(enableChecks=false)
    public Object createMountContent(Context c) {
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("createMountContent:" + ((Component)this).getSimpleName());
        }
        try {
            Object object = this.onCreateMountContent(c);
            return object;
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mount(ComponentContext c, Object convertContent) {
        c.enterNoStateUpdatesMethod("mount");
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onMount:" + ((Component)this).getSimpleName());
        }
        try {
            this.onMount(c, convertContent);
        }
        catch (Exception e) {
            c.exitNoStateUpdatesMethod();
            ComponentLifecycle.dispatchErrorEvent(c, e);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
        c.exitNoStateUpdatesMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(ComponentContext c, Object mountedContent) {
        c.enterNoStateUpdatesMethod("bind");
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("onBind:" + ((Component)this).getSimpleName());
        }
        try {
            this.onBind(c, mountedContent);
        }
        finally {
            if (isTracing) {
                ComponentsSystrace.endSection();
            }
        }
        c.exitNoStateUpdatesMethod();
    }

    void unbind(ComponentContext c, Object mountedContent) {
        this.onUnbind(c, mountedContent);
    }

    void unmount(ComponentContext c, Object mountedContent) {
        this.onUnmount(c, mountedContent);
    }

    InternalNode createLayout(ComponentContext context, boolean resolveNestedTree) {
        InternalNode node;
        Component component = (Component)this;
        InternalNode layoutCreatedInWillRender = component.consumeLayoutCreatedInWillRender();
        if (layoutCreatedInWillRender != null) {
            return layoutCreatedInWillRender;
        }
        boolean deferNestedTreeResolution = Component.isNestedTree((Component)this) && !resolveNestedTree;
        TreeProps parentTreeProps = context.getTreeProps();
        context.setTreeProps(this.getTreePropsForChildren(context, parentTreeProps));
        boolean isTracing = ComponentsSystrace.isTracing();
        if (isTracing) {
            ComponentsSystrace.beginSection("createLayout:" + ((Component)this).getSimpleName());
        }
        try {
            if (deferNestedTreeResolution) {
                node = InternalNodeUtils.create(context);
                node.markIsNestedTreeHolder(context.getTreeProps());
            } else if (component.canResolve()) {
                context.setTreeProps(component.getScopedContext().getTreePropsCopy());
                node = (InternalNode)component.resolve(context);
            } else {
                Component layoutComponent = this.createComponentLayout(context);
                node = layoutComponent == null || layoutComponent.getId() <= 0 ? null : context.resolveLayout(layoutComponent);
            }
        }
        catch (Throwable t) {
            throw new ComponentsChainException((Component)this, t);
        }
        if (isTracing) {
            ComponentsSystrace.endSection();
        }
        if (node == null || node == ComponentContext.NULL_LAYOUT) {
            return ComponentContext.NULL_LAYOUT;
        }
        CommonPropsCopyable commonProps = ((Component)this).getCommonPropsCopyable();
        if (commonProps != null && (deferNestedTreeResolution || !Component.isLayoutSpecWithSizeSpec((Component)this))) {
            commonProps.copyInto(context, node);
        }
        if (node.getTailComponent() == null) {
            boolean isMountSpecWithMeasure;
            boolean bl = isMountSpecWithMeasure = this.canMeasure() && Component.isMountSpec((Component)this);
            if (isMountSpecWithMeasure || deferNestedTreeResolution) {
                node.setMeasureFunction(sMeasureFunction);
            }
        }
        node.appendComponent((Component)this);
        if (TransitionUtils.areTransitionsEnabled(context.getAndroidContext())) {
            if (this.needsPreviousRenderData()) {
                node.addComponentNeedingPreviousRenderData((Component)this);
            } else {
                Transition transition = this.createTransition(context);
                if (transition != null) {
                    node.addTransition(transition);
                }
            }
        }
        if (!deferNestedTreeResolution) {
            this.onPrepare(context);
        }
        if (component.mWorkingRangeRegistrations != null && !component.mWorkingRangeRegistrations.isEmpty()) {
            node.addWorkingRanges(component.mWorkingRangeRegistrations);
        }
        return node;
    }

    @Nullable
    final Transition createTransition(ComponentContext c) {
        Transition transition = this.onCreateTransition(c);
        if (transition != null) {
            TransitionUtils.setOwnerKey(transition, ((Component)this).getGlobalKey());
        }
        return transition;
    }

    @ThreadSafe(enableChecks=false)
    private Component createComponentLayout(ComponentContext context) {
        Component layoutComponent = null;
        if (Component.isLayoutSpecWithSizeSpec((Component)this)) {
            try {
                layoutComponent = this.onCreateLayoutWithSizeSpec(context, context.getWidthSpec(), context.getHeightSpec());
            }
            catch (Exception e) {
                ComponentLifecycle.dispatchErrorEvent(context, e);
            }
        } else {
            try {
                layoutComponent = this.onCreateLayout(context);
            }
            catch (Exception e) {
                ComponentLifecycle.dispatchErrorEvent(context, e);
            }
        }
        return layoutComponent;
    }

    public static void dispatchErrorEvent(ComponentContext c, Exception e) {
        if (!ComponentsConfiguration.enableOnErrorHandling) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        ErrorEvent errorEvent = new ErrorEvent();
        errorEvent.exception = e;
        ComponentLifecycle.dispatchErrorEvent(c, errorEvent);
    }

    public static void dispatchErrorEvent(ComponentContext c, ErrorEvent e) {
        EventHandler<ErrorEvent> errorHandler = c.getComponentScope().getErrorHandler();
        if (errorHandler != null) {
            errorHandler.dispatchEvent(e);
        }
    }

    void loadStyle(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        c.setDefStyle(defStyleAttr, defStyleRes);
        this.onLoadStyle(c);
        c.setDefStyle(0, 0);
    }

    void loadStyle(ComponentContext c) {
        this.onLoadStyle(c);
    }

    protected void populateTreeProps(TreeProps parentTreeProps) {
    }

    protected TreeProps getTreePropsForChildren(ComponentContext c, TreeProps previousTreeProps) {
        return previousTreeProps;
    }

    protected Component onCreateLayout(ComponentContext c) {
        return Column.create(c).build();
    }

    protected Component onCreateLayoutWithSizeSpec(ComponentContext c, int widthSpec, int heightSpec) {
        return Column.create(c).build();
    }

    protected ComponentLayout resolve(ComponentContext c) {
        return this.createLayout(c, false);
    }

    protected void onPrepare(ComponentContext c) {
    }

    protected void onLoadStyle(ComponentContext c) {
    }

    protected void onBoundsDefined(ComponentContext c, ComponentLayout layout) {
    }

    protected int onMeasureBaseline(ComponentContext c, int width, int height) {
        return height;
    }

    protected boolean canMeasure() {
        return false;
    }

    protected boolean isLayoutSpecWithSizeSpecCheck() {
        return false;
    }

    protected void onMeasure(ComponentContext c, ComponentLayout layout, int widthSpec, int heightSpec, Size size) {
        throw new IllegalStateException("You must override onMeasure() if you return true in canMeasure(), ComponentLifecycle is: " + this);
    }

    protected boolean hasChildLithoViews() {
        return false;
    }

    protected boolean shouldUseDisplayList() {
        return false;
    }

    protected Object onCreateMountContent(Context context) {
        throw new RuntimeException("Trying to mount a MountSpec that doesn't implement @OnCreateMountContent");
    }

    protected MountContentPool onCreateMountContentPool() {
        return new DefaultMountContentPool(this.getClass().getSimpleName(), this.poolSize(), true);
    }

    protected void onMount(ComponentContext c, Object convertContent) {
    }

    protected void onUnmount(ComponentContext c, Object mountedContent) {
    }

    protected void onBind(ComponentContext c, Object mountedContent) {
    }

    protected void onUnbind(ComponentContext c, Object mountedContent) {
    }

    public MountType getMountType() {
        return MountType.NONE;
    }

    protected void onPopulateAccessibilityNode(View host, AccessibilityNodeInfoCompat accessibilityNode) {
    }

    protected void onPopulateExtraAccessibilityNode(AccessibilityNodeInfoCompat accessibilityNode, int extraNodeIndex, int componentBoundsX, int componentBoundsY) {
    }

    protected int getExtraAccessibilityNodeAt(int x, int y) {
        return Integer.MIN_VALUE;
    }

    protected int getExtraAccessibilityNodesCount() {
        return 0;
    }

    protected boolean implementsExtraAccessibilityNodes() {
        return false;
    }

    protected boolean implementsAccessibility() {
        return false;
    }

    protected void transferState(StateContainer previousStateContainer, StateContainer nextStateContainer) {
    }

    protected void createInitialState(ComponentContext c) {
    }

    protected void onError(ComponentContext c, Exception e) {
        throw new RuntimeException(e);
    }

    @Override
    @Nullable
    public Object dispatchOnEvent(EventHandler eventHandler, Object eventState) {
        if (ComponentsConfiguration.enableOnErrorHandling && eventHandler.id == ERROR_EVENT_HANDLER_ID) {
            ((Component)this).getErrorHandler().dispatchEvent((ErrorEvent)eventState);
        }
        return null;
    }

    @Override
    @Nullable
    public Object acceptTriggerEvent(EventTrigger eventTrigger, Object eventState, Object[] params) {
        return null;
    }

    protected void dispatchOnEnteredRange(String name) {
    }

    protected void dispatchOnExitedRange(String name) {
    }

    protected boolean isPureRender() {
        return false;
    }

    protected boolean callsShouldUpdateOnMount() {
        return false;
    }

    protected boolean isMountSizeDependent() {
        return false;
    }

    @ThreadSafe
    protected int poolSize() {
        return 3;
    }

    protected boolean canPreallocate() {
        return false;
    }

    final boolean shouldComponentUpdate(Component previous, Component next) {
        if (this.isPureRender()) {
            return this.shouldUpdate(previous, next);
        }
        return true;
    }

    protected boolean shouldUpdate(Component previous, Component next) {
        return !previous.isEquivalentTo(next);
    }

    boolean canUsePreviousLayout(ComponentContext context) {
        return ComponentsConfiguration.enableShouldCreateLayoutWithNewSizeSpec && !this.onShouldCreateLayoutWithNewSizeSpec(context, context.getWidthSpec(), context.getHeightSpec());
    }

    protected boolean onShouldCreateLayoutWithNewSizeSpec(ComponentContext context, int newWidthSpec, int newHeightSpec) {
        return true;
    }

    @Nullable
    protected Transition onCreateTransition(ComponentContext c) {
        return null;
    }

    protected static <E> EventHandler<E> newEventHandler(ComponentContext c, int id2, Object[] params) {
        EventHandler eventHandler = c.newEventHandler(id2, params);
        if (c.getComponentTree() != null) {
            c.getComponentTree().recordEventHandler(c.getComponentScope(), eventHandler);
        }
        return eventHandler;
    }

    protected static <E> EventHandler<E> newEventHandler(Component c, int id2, Object[] params) {
        EventHandler eventHandler = new EventHandler(c, id2, params);
        if (c.getScopedContext() != null && c.getScopedContext().getComponentTree() != null) {
            c.getScopedContext().getComponentTree().recordEventHandler(c, eventHandler);
        }
        return eventHandler;
    }

    protected static <E> EventTrigger<E> newEventTrigger(ComponentContext c, String childKey, int id2) {
        return c.newEventTrigger(childKey, id2);
    }

    @Nullable
    protected static EventTrigger getEventTrigger(ComponentContext c, int id2, String key) {
        if (c.getComponentScope() == null) {
            return null;
        }
        EventTrigger trigger = c.getComponentTree().getEventTrigger(c.getComponentScope().getGlobalKey() + id2 + key);
        if (trigger == null) {
            return null;
        }
        return trigger;
    }

    protected boolean needsPreviousRenderData() {
        return false;
    }

    @Nullable
    protected RenderData recordRenderData(RenderData toRecycle) {
        return null;
    }

    protected void applyPreviousRenderData(RenderData previousRenderData) {
    }

    protected boolean hasState() {
        return false;
    }

    protected boolean shouldAlwaysRemeasure() {
        return false;
    }

    protected void onAttached(ComponentContext c) {
    }

    protected void onDetached(ComponentContext c) {
    }

    protected boolean hasAttachDetachCallback() {
        return false;
    }

    private static class CreateLayoutException
    extends RuntimeException {
        CreateLayoutException(Component c, Throwable cause) {
            super(c.getSimpleName());
            this.initCause(cause);
            this.setStackTrace(new StackTraceElement[0]);
        }
    }

    public static interface RenderData {
    }

    public static interface TransitionContainer {
        public List<Transition> consumeTransitions();
    }

    public static enum MountType {
        NONE,
        DRAWABLE,
        VIEW;

    }
}

