/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.config.ComponentsConfiguration;

public class ComponentHostRecycleUtil {
    static boolean shouldSkipRecyclingComponentHost(int mountIndex, String rootComponentName) {
        boolean isMountIndexBisectEnabled = ComponentsConfiguration.isMountIndexBisectEnabled;
        boolean isRootComponentBisectEnabled = ComponentsConfiguration.isRootComponentBisectEnabled;
        if (!isMountIndexBisectEnabled && !isRootComponentBisectEnabled) {
            return false;
        }
        if (!isRootComponentBisectEnabled) {
            return ComponentHostRecycleUtil.passesMountIndexBisect(mountIndex);
        }
        if (!isMountIndexBisectEnabled) {
            return ComponentHostRecycleUtil.passesRootComponentBisect(rootComponentName);
        }
        return ComponentHostRecycleUtil.passesMountIndexBisect(mountIndex) && ComponentHostRecycleUtil.passesRootComponentBisect(rootComponentName);
    }

    private static boolean passesRootComponentBisect(String rootComponentName) {
        String start = ComponentsConfiguration.rootComponentBisectStart;
        String end = ComponentsConfiguration.rootComponentBisectEnd;
        return rootComponentName.compareToIgnoreCase(start) >= 0 && rootComponentName.compareToIgnoreCase(end) <= 0;
    }

    private static boolean passesMountIndexBisect(int mountIndex) {
        return mountIndex >= ComponentsConfiguration.mountIndexBisectStart && mountIndex <= ComponentsConfiguration.mountIndexBisectEnd;
    }
}

