/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.collection.SparseArrayCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.litho.AccessibilityUtils;
import com.facebook.litho.ComponentAccessibilityDelegate;
import com.facebook.litho.ComponentClickListener;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentFocusChangeListener;
import com.facebook.litho.ComponentHostUtils;
import com.facebook.litho.ComponentLongClickListener;
import com.facebook.litho.ComponentTouchListener;
import com.facebook.litho.ComponentsSystrace;
import com.facebook.litho.DebugDraw;
import com.facebook.litho.EventDispatcherUtils;
import com.facebook.litho.EventHandler;
import com.facebook.litho.ImageContent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.MountItem;
import com.facebook.litho.NodeInfo;
import com.facebook.litho.R;
import com.facebook.litho.TextContent;
import com.facebook.litho.ThreadUtils;
import com.facebook.litho.TouchExpansionDelegate;
import com.facebook.litho.Touchable;
import com.facebook.litho.TransitionId;
import com.facebook.litho.ViewNodeInfo;
import com.facebook.proguard.annotations.DoNotStrip;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@DoNotStrip
public class ComponentHost
extends ViewGroup {
    private static final int SCRAP_ARRAY_INITIAL_SIZE = 4;
    private SparseArrayCompat<MountItem> mMountItems;
    private SparseArrayCompat<MountItem> mScrapMountItemsArray;
    private SparseArrayCompat<MountItem> mViewMountItems;
    private SparseArrayCompat<MountItem> mScrapViewMountItemsArray;
    private SparseArrayCompat<MountItem> mDrawableMountItems;
    private SparseArrayCompat<MountItem> mScrapDrawableMountItems;
    private ArrayList<MountItem> mDisappearingItems;
    private CharSequence mContentDescription;
    private Object mViewTag;
    private SparseArray<Object> mViewTags;
    private boolean mWasInvalidatedWhileSuppressed;
    private boolean mWasInvalidatedForAccessibilityWhileSuppressed;
    private boolean mWasRequestedFocusWhileSuppressed;
    private boolean mSuppressInvalidations;
    private final InterleavedDispatchDraw mDispatchDraw = new InterleavedDispatchDraw();
    private int[] mChildDrawingOrder = new int[0];
    private boolean mIsChildDrawingOrderDirty;
    private long mParentHostMarker;
    private boolean mInLayout;
    @Nullable
    private ComponentAccessibilityDelegate mComponentAccessibilityDelegate;
    private boolean mIsComponentAccessibilityDelegateSet = false;
    private ComponentClickListener mOnClickListener;
    private ComponentLongClickListener mOnLongClickListener;
    private ComponentFocusChangeListener mOnFocusChangeListener;
    private ComponentTouchListener mOnTouchListener;
    private EventHandler<InterceptTouchEvent> mOnInterceptTouchEventHandler;
    private TouchExpansionDelegate mTouchExpansionDelegate;
    private boolean mClipChildren = true;
    private boolean mClippingTemporaryDisabled = false;
    private boolean mClippingToRestore = false;

    public ComponentHost(Context context) {
        this(context, null);
    }

    public ComponentHost(Context context, AttributeSet attrs) {
        this(new ComponentContext(context), attrs);
    }

    public ComponentHost(ComponentContext context) {
        this(context, null);
    }

    public ComponentHost(ComponentContext context, AttributeSet attrs) {
        super(context.getAndroidContext(), attrs);
        this.setWillNotDraw(false);
        this.setChildrenDrawingOrderEnabled(true);
        this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(context.getAndroidContext()));
        this.mMountItems = new SparseArrayCompat();
        this.mViewMountItems = new SparseArrayCompat();
        this.mDrawableMountItems = new SparseArrayCompat();
        this.mDisappearingItems = new ArrayList();
    }

    void setParentHostMarker(long parentHostMarker) {
        this.mParentHostMarker = parentHostMarker;
    }

    long getParentHostMarker() {
        return this.mParentHostMarker;
    }

    public void mount(int index, MountItem mountItem, Rect bounds) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.mountDrawable(index, mountItem, bounds);
        } else if (content instanceof View) {
            this.ensureViewMountItems();
            this.mViewMountItems.put(index, (Object)mountItem);
            this.mountView((View)content, mountItem.getLayoutFlags());
            this.maybeRegisterTouchExpansion(index, mountItem);
        }
        this.ensureMountItems();
        this.mMountItems.put(index, (Object)mountItem);
        ComponentHostUtils.maybeInvalidateAccessibilityState(mountItem);
    }

    private void ensureMountItems() {
        if (this.mMountItems == null) {
            this.mMountItems = new SparseArrayCompat();
        }
    }

    private void ensureViewMountItems() {
        if (this.mViewMountItems == null) {
            this.mViewMountItems = new SparseArrayCompat();
        }
    }

    private void ensureDrawableMountItems() {
        if (this.mDrawableMountItems == null) {
            this.mDrawableMountItems = new SparseArrayCompat();
        }
    }

    private void ensureDisappearingItems() {
        if (this.mDisappearingItems == null) {
            this.mDisappearingItems = new ArrayList();
        }
    }

    void unmount(MountItem item) {
        this.ensureMountItems();
        int index = this.mMountItems.keyAt(this.mMountItems.indexOfValue((Object)item));
        this.unmount(index, item);
    }

    public void unmount(int index, MountItem mountItem) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.ensureDrawableMountItems();
            this.unmountDrawable(mountItem);
            ComponentHostUtils.removeItem(index, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        } else if (content instanceof View) {
            this.unmountView((View)content);
            this.ensureViewMountItems();
            ComponentHostUtils.removeItem(index, this.mViewMountItems, this.mScrapViewMountItemsArray);
            this.mIsChildDrawingOrderDirty = true;
            this.maybeUnregisterTouchExpansion(index, mountItem);
        }
        this.ensureMountItems();
        ComponentHostUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        ComponentHostUtils.maybeInvalidateAccessibilityState(mountItem);
    }

    void startUnmountDisappearingItem(int index, MountItem mountItem) {
        Object content = mountItem.getContent();
        if (content instanceof Drawable) {
            this.ensureDrawableMountItems();
            ComponentHostUtils.removeItem(index, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        } else if (content instanceof View) {
            this.ensureViewMountItems();
            ComponentHostUtils.removeItem(index, this.mViewMountItems, this.mScrapViewMountItemsArray);
            this.mIsChildDrawingOrderDirty = true;
            this.maybeUnregisterTouchExpansion(index, mountItem);
        }
        this.ensureMountItems();
        ComponentHostUtils.removeItem(index, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        this.ensureDisappearingItems();
        this.mDisappearingItems.add(mountItem);
    }

    void unmountDisappearingItem(MountItem disappearingItem) {
        this.ensureDisappearingItems();
        if (!this.mDisappearingItems.remove(disappearingItem)) {
            TransitionId transitionId = disappearingItem.getTransitionId();
            throw new RuntimeException("Tried to remove non-existent disappearing item, transitionId: " + transitionId);
        }
        Object content = disappearingItem.getContent();
        if (content instanceof Drawable) {
            this.unmountDrawable(disappearingItem);
        } else if (content instanceof View) {
            this.unmountView((View)content);
        }
        ComponentHostUtils.maybeInvalidateAccessibilityState(disappearingItem);
    }

    boolean hasDisappearingItems() {
        return this.mDisappearingItems != null && !this.mDisappearingItems.isEmpty();
    }

    @Nullable
    List<TransitionId> getDisappearingItemTransitionIds() {
        if (!this.hasDisappearingItems()) {
            return null;
        }
        ArrayList<TransitionId> ids = new ArrayList<TransitionId>();
        int size = this.mDisappearingItems.size();
        for (int i = 0; i < size; ++i) {
            ids.add(this.mDisappearingItems.get(i).getTransitionId());
        }
        return ids;
    }

    private void maybeMoveTouchExpansionIndexes(MountItem item, int oldIndex, int newIndex) {
        ViewNodeInfo viewNodeInfo = item.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        Rect expandedTouchBounds = viewNodeInfo.getExpandedTouchBounds();
        if (expandedTouchBounds == null || this.mTouchExpansionDelegate == null) {
            return;
        }
        this.mTouchExpansionDelegate.moveTouchExpansionIndexes(oldIndex, newIndex);
    }

    void maybeRegisterTouchExpansion(int index, MountItem mountItem) {
        ViewNodeInfo viewNodeInfo = mountItem.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        Rect expandedTouchBounds = viewNodeInfo.getExpandedTouchBounds();
        if (expandedTouchBounds == null) {
            return;
        }
        if (((Object)((Object)this)).equals(mountItem.getContent())) {
            return;
        }
        if (this.mTouchExpansionDelegate == null) {
            this.mTouchExpansionDelegate = new TouchExpansionDelegate(this);
            this.setTouchDelegate(this.mTouchExpansionDelegate);
        }
        this.mTouchExpansionDelegate.registerTouchExpansion(index, (View)mountItem.getContent(), expandedTouchBounds);
    }

    void maybeUnregisterTouchExpansion(int index, MountItem mountItem) {
        ViewNodeInfo viewNodeInfo = mountItem.getViewNodeInfo();
        if (viewNodeInfo == null) {
            return;
        }
        if (this.mTouchExpansionDelegate == null || viewNodeInfo.getExpandedTouchBounds() == null) {
            return;
        }
        if (((Object)((Object)this)).equals(mountItem.getContent())) {
            return;
        }
        this.mTouchExpansionDelegate.unregisterTouchExpansion(index);
    }

    int getMountItemCount() {
        return this.mMountItems == null ? 0 : this.mMountItems.size();
    }

    MountItem getMountItemAt(int index) {
        return (MountItem)this.mMountItems.valueAt(index);
    }

    @Nullable
    MountItem getAccessibleMountItem() {
        for (int i = 0; i < this.getMountItemCount(); ++i) {
            MountItem item = this.getMountItemAt(i);
            if (!item.isAccessible()) continue;
            return item;
        }
        return null;
    }

    public List<Drawable> getDrawables() {
        if (this.mDrawableMountItems == null || this.mDrawableMountItems.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Drawable> drawables = new ArrayList<Drawable>(this.mDrawableMountItems.size());
        int size = this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            drawables.add(drawable);
        }
        return drawables;
    }

    public List<String> getContentNames() {
        if (this.mMountItems == null || this.mMountItems.size() == 0) {
            return Collections.emptyList();
        }
        int contentSize = this.mMountItems.size();
        ArrayList<String> contentNames = new ArrayList<String>(contentSize);
        for (int i = 0; i < contentSize; ++i) {
            contentNames.add(ComponentHost.getMountItemName(this.getMountItemAt(i)));
        }
        return contentNames;
    }

    @DoNotStrip
    public TextContent getTextContent() {
        this.ensureMountItems();
        return ComponentHostUtils.extractTextContent(ComponentHostUtils.extractContent(this.mMountItems));
    }

    public ImageContent getImageContent() {
        this.ensureMountItems();
        return ComponentHostUtils.extractImageContent(ComponentHostUtils.extractContent(this.mMountItems));
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.mContentDescription = contentDescription;
        if (!TextUtils.isEmpty((CharSequence)contentDescription) && ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }
        this.invalidateAccessibilityState();
    }

    public void setTag(int key, Object tag) {
        super.setTag(key, tag);
        if (key == R.id.component_node_info && tag != null) {
            this.refreshAccessibilityDelegatesIfNeeded(AccessibilityUtils.isAccessibilityEnabled(this.getContext()));
            if (this.mComponentAccessibilityDelegate != null) {
                this.mComponentAccessibilityDelegate.setNodeInfo((NodeInfo)tag);
            }
        }
    }

    void moveItem(MountItem item, int oldIndex, int newIndex) {
        if (item == null && this.mScrapMountItemsArray != null) {
            item = (MountItem)this.mScrapMountItemsArray.get(oldIndex);
        }
        if (item == null) {
            return;
        }
        this.maybeMoveTouchExpansionIndexes(item, oldIndex, newIndex);
        Object content = item.getContent();
        this.ensureViewMountItems();
        if (content instanceof Drawable) {
            this.moveDrawableItem(item, oldIndex, newIndex);
        } else if (content instanceof View) {
            this.mIsChildDrawingOrderDirty = true;
            ComponentHost.startTemporaryDetach((View)content);
            if (this.mViewMountItems.get(newIndex) != null) {
                this.ensureScrapViewMountItemsArray();
                ComponentHostUtils.scrapItemAt(newIndex, this.mViewMountItems, this.mScrapViewMountItemsArray);
            }
            ComponentHostUtils.moveItem(oldIndex, newIndex, this.mViewMountItems, this.mScrapViewMountItemsArray);
        }
        this.ensureMountItems();
        if (this.mMountItems.get(newIndex) != null) {
            this.ensureScrapMountItemsArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mMountItems, this.mScrapMountItemsArray);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mMountItems, this.mScrapMountItemsArray);
        this.releaseScrapDataStructuresIfNeeded();
        if (content instanceof View) {
            ComponentHost.finishTemporaryDetach((View)content);
        }
    }

    public void setViewTag(Object viewTag) {
        this.mViewTag = viewTag;
    }

    public void setViewTags(SparseArray<Object> viewTags) {
        this.mViewTags = viewTags;
    }

    void setComponentClickListener(ComponentClickListener listener) {
        this.mOnClickListener = listener;
        this.setOnClickListener(listener);
    }

    ComponentClickListener getComponentClickListener() {
        return this.mOnClickListener;
    }

    void setComponentLongClickListener(ComponentLongClickListener listener) {
        this.mOnLongClickListener = listener;
        this.setOnLongClickListener(listener);
    }

    ComponentLongClickListener getComponentLongClickListener() {
        return this.mOnLongClickListener;
    }

    void setComponentFocusChangeListener(ComponentFocusChangeListener listener) {
        this.mOnFocusChangeListener = listener;
        this.setOnFocusChangeListener(listener);
    }

    ComponentFocusChangeListener getComponentFocusChangeListener() {
        return this.mOnFocusChangeListener;
    }

    void setComponentTouchListener(ComponentTouchListener listener) {
        this.mOnTouchListener = listener;
        this.setOnTouchListener(listener);
    }

    void setInterceptTouchEventHandler(EventHandler<InterceptTouchEvent> interceptTouchEventHandler) {
        this.mOnInterceptTouchEventHandler = interceptTouchEventHandler;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventHandler != null) {
            return EventDispatcherUtils.dispatchOnInterceptTouch(this.mOnInterceptTouchEventHandler, (View)this, ev);
        }
        return super.onInterceptTouchEvent(ev);
    }

    public ComponentTouchListener getComponentTouchListener() {
        return this.mOnTouchListener;
    }

    void suppressInvalidations(boolean suppressInvalidations) {
        if (this.mSuppressInvalidations == suppressInvalidations) {
            return;
        }
        this.mSuppressInvalidations = suppressInvalidations;
        if (!this.mSuppressInvalidations) {
            if (this.mWasInvalidatedWhileSuppressed) {
                this.invalidate();
                this.mWasInvalidatedWhileSuppressed = false;
            }
            if (this.mWasInvalidatedForAccessibilityWhileSuppressed) {
                this.invalidateAccessibilityState();
                this.mWasInvalidatedForAccessibilityWhileSuppressed = false;
            }
            if (this.mWasRequestedFocusWhileSuppressed) {
                View root = this.getRootView();
                if (root != null) {
                    root.requestFocus();
                }
                this.mWasRequestedFocusWhileSuppressed = false;
            }
        }
    }

    void invalidateAccessibilityState() {
        if (!this.mIsComponentAccessibilityDelegateSet) {
            return;
        }
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedForAccessibilityWhileSuppressed = true;
            return;
        }
        if (this.mComponentAccessibilityDelegate != null && this.implementsVirtualViews()) {
            this.mComponentAccessibilityDelegate.invalidateRoot();
        }
    }

    public boolean dispatchHoverEvent(MotionEvent event) {
        return this.mComponentAccessibilityDelegate != null && this.implementsVirtualViews() && this.mComponentAccessibilityDelegate.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    private boolean implementsVirtualViews() {
        MountItem item = this.getAccessibleMountItem();
        return item != null && item.getComponent().implementsExtraAccessibilityNodes();
    }

    public List<CharSequence> getContentDescriptions() {
        int size;
        ArrayList<CharSequence> contentDescriptions = new ArrayList<CharSequence>();
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            CharSequence contentDescription;
            NodeInfo nodeInfo = ((MountItem)this.mDrawableMountItems.valueAt(i)).getNodeInfo();
            if (nodeInfo == null || (contentDescription = nodeInfo.getContentDescription()) == null) continue;
            contentDescriptions.add(contentDescription);
        }
        CharSequence hostContentDescription = this.getContentDescription();
        if (hostContentDescription != null) {
            contentDescriptions.add(hostContentDescription);
        }
        return contentDescriptions;
    }

    private void mountView(View view, int flags) {
        view.setDuplicateParentStateEnabled(MountItem.isDuplicateParentState(flags));
        this.mIsChildDrawingOrderDirty = true;
        if (view instanceof ComponentHost && view.getParent() == this) {
            ComponentHost.finishTemporaryDetach(view);
            view.setVisibility(0);
            return;
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
            view.setLayoutParams(lp);
        }
        if (this.mInLayout) {
            super.addViewInLayout(view, -1, view.getLayoutParams(), true);
        } else {
            super.addView(view, -1, view.getLayoutParams());
        }
    }

    private void unmountView(View view) {
        this.mIsChildDrawingOrderDirty = true;
        if (this.mInLayout) {
            super.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    TouchExpansionDelegate getTouchExpansionDelegate() {
        return this.mTouchExpansionDelegate;
    }

    public void dispatchDraw(Canvas canvas) {
        int size;
        this.mDispatchDraw.start(canvas);
        super.dispatchDraw(canvas);
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        this.mDispatchDraw.end();
        int n = size = this.mDisappearingItems == null ? 0 : this.mDisappearingItems.size();
        for (int index = 0; index < size; ++index) {
            Object content = this.mDisappearingItems.get(index).getContent();
            if (!(content instanceof Drawable)) continue;
            ((Drawable)content).draw(canvas);
        }
        DebugDraw.draw(this, canvas);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        this.updateChildDrawingOrderIfNeeded();
        if (this.mDispatchDraw.isRunning()) {
            this.mDispatchDraw.drawNext();
        }
        return this.mChildDrawingOrder[i];
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        ThreadUtils.assertMainThread();
        boolean handled = false;
        if (this.isEnabled()) {
            for (int i = (this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size()) - 1; i >= 0; --i) {
                Touchable t;
                MountItem item = (MountItem)this.mDrawableMountItems.valueAt(i);
                if (!(item.getContent() instanceof Touchable) || MountItem.isTouchableDisabled(item.getLayoutFlags()) || !(t = (Touchable)item.getContent()).shouldHandleTouchEvent(event) || !t.onTouchEvent(event, (View)this)) continue;
                handled = true;
                break;
            }
        }
        if (!handled) {
            handled = super.onTouchEvent(event);
        }
        return handled;
    }

    void performLayout(boolean changed, int l, int t, int r, int b) {
    }

    protected final void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mInLayout = true;
        this.performLayout(changed, l, t, r, b);
        this.mInLayout = false;
    }

    public void requestLayout() {
        ComponentHost parent = this;
        while (parent instanceof ComponentHost) {
            ComponentHost host = parent;
            if (!host.shouldRequestLayout()) {
                return;
            }
            parent = parent.getParent();
        }
        super.requestLayout();
    }

    protected boolean shouldRequestLayout() {
        return !this.mInLayout;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected boolean verifyDrawable(Drawable who) {
        return true;
    }

    protected void drawableStateChanged() {
        int size;
        super.drawableStateChanged();
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mDrawableMountItems.valueAt(i);
            ComponentHostUtils.maybeSetDrawableState((View)this, (Drawable)mountItem.getContent(), mountItem.getLayoutFlags(), mountItem.getNodeInfo());
        }
    }

    public void jumpDrawablesToCurrentState() {
        int size;
        super.jumpDrawablesToCurrentState();
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            DrawableCompat.jumpToCurrentState((Drawable)drawable);
        }
    }

    public void setVisibility(int visibility) {
        int size;
        super.setVisibility(visibility);
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            Drawable drawable = (Drawable)((MountItem)this.mDrawableMountItems.valueAt(i)).getContent();
            drawable.setVisible(visibility == 0, false);
        }
    }

    @DoNotStrip
    public Object getTag() {
        if (this.mViewTag != null) {
            return this.mViewTag;
        }
        return super.getTag();
    }

    public Object getTag(int key) {
        Object value;
        if (this.mViewTags != null && (value = this.mViewTags.get(key)) != null) {
            return value;
        }
        return super.getTag(key);
    }

    public void invalidate(Rect dirty) {
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedWhileSuppressed = true;
            return;
        }
        super.invalidate(dirty);
    }

    public void invalidate(int l, int t, int r, int b) {
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedWhileSuppressed = true;
            return;
        }
        super.invalidate(l, t, r, b);
    }

    public void invalidate() {
        if (this.mSuppressInvalidations) {
            this.mWasInvalidatedWhileSuppressed = true;
            return;
        }
        super.invalidate();
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        boolean nullArgumentsRequestFocusCall;
        boolean bl = nullArgumentsRequestFocusCall = direction == 130 && previouslyFocusedRect == null;
        if (nullArgumentsRequestFocusCall && this.mSuppressInvalidations) {
            this.mWasRequestedFocusWhileSuppressed = true;
            return false;
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    protected void refreshAccessibilityDelegatesIfNeeded(boolean isAccessibilityEnabled) {
        if (isAccessibilityEnabled == this.mIsComponentAccessibilityDelegateSet) {
            return;
        }
        if (isAccessibilityEnabled && this.mComponentAccessibilityDelegate == null) {
            this.mComponentAccessibilityDelegate = new ComponentAccessibilityDelegate((View)this, this.isFocusable(), ViewCompat.getImportantForAccessibility((View)this));
        }
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)(isAccessibilityEnabled ? this.mComponentAccessibilityDelegate : null));
        this.mIsComponentAccessibilityDelegateSet = isAccessibilityEnabled;
        if (!isAccessibilityEnabled) {
            return;
        }
        int size = this.getChildCount();
        for (int i = 0; i < size; ++i) {
            View child = this.getChildAt(i);
            if (child instanceof ComponentHost) {
                ((ComponentHost)child).refreshAccessibilityDelegatesIfNeeded(true);
                continue;
            }
            NodeInfo nodeInfo = (NodeInfo)child.getTag(R.id.component_node_info);
            if (nodeInfo == null) continue;
            ViewCompat.setAccessibilityDelegate((View)child, (AccessibilityDelegateCompat)new ComponentAccessibilityDelegate(child, nodeInfo, child.isFocusable(), ViewCompat.getImportantForAccessibility((View)child)));
        }
    }

    public void setAccessibilityDelegate(View.AccessibilityDelegate accessibilityDelegate) {
        super.setAccessibilityDelegate(accessibilityDelegate);
        this.mIsComponentAccessibilityDelegateSet = false;
    }

    public void setClipChildren(boolean clipChildren) {
        if (this.mClippingTemporaryDisabled) {
            this.mClippingToRestore = clipChildren;
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            this.mClipChildren = clipChildren;
        }
        super.setClipChildren(clipChildren);
    }

    public boolean getClipChildren() {
        if (Build.VERSION.SDK_INT < 18) {
            return this.mClipChildren;
        }
        return super.getClipChildren();
    }

    void temporaryDisableChildClipping() {
        if (this.mClippingTemporaryDisabled) {
            return;
        }
        this.mClippingToRestore = Build.VERSION.SDK_INT >= 18 ? this.getClipChildren() : this.mClipChildren;
        this.setClipChildren(false);
        this.mClippingTemporaryDisabled = true;
    }

    void restoreChildClipping() {
        if (!this.mClippingTemporaryDisabled) {
            return;
        }
        this.mClippingTemporaryDisabled = false;
        this.setClipChildren(this.mClippingToRestore);
    }

    @Deprecated
    public void addView(View child) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void addView(View child, int index) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params, boolean preventRequestLayout) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected void attachViewToParent(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("Adding Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeView(View view) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewInLayout(View view) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewsInLayout(int start, int count) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViewAt(int index) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeViews(int start, int count) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    public void removeAllViewsInLayout() {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @Deprecated
    protected void removeDetachedView(View child, boolean animate) {
        throw new UnsupportedOperationException("Removing Views manually within LithoViews is not supported");
    }

    @VisibleForTesting
    public void addViewForTest(View view) {
        ViewGroup.LayoutParams params = view.getLayoutParams() == null ? this.generateDefaultLayoutParams() : view.getLayoutParams();
        super.addView(view, -1, params);
    }

    @Nullable
    public List<Drawable> getLinkedDrawablesForAnimation() {
        int size;
        ArrayList<Drawable> drawables = null;
        int n = size = this.mDrawableMountItems == null ? 0 : this.mDrawableMountItems.size();
        for (int i = 0; i < size; ++i) {
            MountItem mountItem = (MountItem)this.mDrawableMountItems.valueAt(i);
            if ((mountItem.getLayoutFlags() & 4) == 0) continue;
            if (drawables == null) {
                drawables = new ArrayList<Drawable>();
            }
            drawables.add((Drawable)mountItem.getContent());
        }
        return drawables;
    }

    private void updateChildDrawingOrderIfNeeded() {
        int size;
        int i;
        if (!this.mIsChildDrawingOrderDirty) {
            return;
        }
        int childCount = this.getChildCount();
        if (this.mChildDrawingOrder.length < childCount) {
            this.mChildDrawingOrder = new int[childCount + 5];
        }
        int index = 0;
        int viewMountItemCount = this.mViewMountItems == null ? 0 : this.mViewMountItems.size();
        for (i = 0; i < viewMountItemCount; ++i) {
            View child = (View)((MountItem)this.mViewMountItems.valueAt(i)).getContent();
            this.mChildDrawingOrder[index++] = this.indexOfChild(child);
        }
        int n = size = this.mDisappearingItems == null ? 0 : this.mDisappearingItems.size();
        for (i = 0; i < size; ++i) {
            Object child = this.mDisappearingItems.get(i).getContent();
            if (!(child instanceof View)) continue;
            this.mChildDrawingOrder[index++] = this.indexOfChild((View)child);
        }
        this.mIsChildDrawingOrderDirty = false;
    }

    private void ensureScrapViewMountItemsArray() {
        if (this.mScrapViewMountItemsArray == null) {
            this.mScrapViewMountItemsArray = new SparseArrayCompat(4);
        }
    }

    private void ensureScrapMountItemsArray() {
        if (this.mScrapMountItemsArray == null) {
            this.mScrapMountItemsArray = new SparseArrayCompat(4);
        }
    }

    private void releaseScrapDataStructuresIfNeeded() {
        if (this.mScrapMountItemsArray != null && this.mScrapMountItemsArray.size() == 0) {
            this.mScrapMountItemsArray = null;
        }
        if (this.mScrapViewMountItemsArray != null && this.mScrapViewMountItemsArray.size() == 0) {
            this.mScrapViewMountItemsArray = null;
        }
    }

    private void mountDrawable(int index, MountItem mountItem, Rect bounds) {
        ThreadUtils.assertMainThread();
        this.ensureDrawableMountItems();
        this.mDrawableMountItems.put(index, (Object)mountItem);
        Drawable drawable = (Drawable)mountItem.getContent();
        ComponentHostUtils.mountDrawable((View)this, drawable, bounds, mountItem.getLayoutFlags(), mountItem.getNodeInfo());
    }

    private void unmountDrawable(MountItem mountItem) {
        ThreadUtils.assertMainThread();
        Drawable drawable = (Drawable)mountItem.getContent();
        drawable.setCallback(null);
        this.invalidate(drawable.getBounds());
        this.releaseScrapDataStructuresIfNeeded();
    }

    private void moveDrawableItem(MountItem item, int oldIndex, int newIndex) {
        ThreadUtils.assertMainThread();
        this.ensureDrawableMountItems();
        if (this.mDrawableMountItems.get(newIndex) != null) {
            this.ensureScrapDrawableMountItemsArray();
            ComponentHostUtils.scrapItemAt(newIndex, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        }
        ComponentHostUtils.moveItem(oldIndex, newIndex, this.mDrawableMountItems, this.mScrapDrawableMountItems);
        this.invalidate();
        this.releaseScrapDataStructuresIfNeeded();
    }

    private void ensureScrapDrawableMountItemsArray() {
        if (this.mScrapDrawableMountItems == null) {
            this.mScrapDrawableMountItems = new SparseArrayCompat(4);
        }
    }

    private static void startTemporaryDetach(View view) {
        if (Build.VERSION.SDK_INT >= 19) {
            view.cancelPendingInputEvents();
        }
        ViewCompat.dispatchStartTemporaryDetach((View)view);
    }

    private static void finishTemporaryDetach(View view) {
        ViewCompat.dispatchFinishTemporaryDetach((View)view);
    }

    private static String getMountItemName(MountItem mountItem) {
        return mountItem.getComponent().getSimpleName();
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (action == 512 || action == 256) {
            CharSequence contentDesc = null;
            if (!TextUtils.isEmpty((CharSequence)this.getContentDescription())) {
                contentDesc = this.getContentDescription();
            } else if (!this.getContentDescriptions().isEmpty()) {
                contentDesc = TextUtils.join((CharSequence)", ", this.getContentDescriptions());
            } else if (!this.getTextContent().getTextItems().isEmpty()) {
                contentDesc = TextUtils.join((CharSequence)", ", this.getTextContent().getTextItems());
            }
            if (contentDesc == null) {
                return false;
            }
            this.mContentDescription = contentDesc;
            super.setContentDescription(this.mContentDescription);
        }
        return super.performAccessibilityAction(action, arguments);
    }

    private class InterleavedDispatchDraw {
        private Canvas mCanvas;
        private int mDrawIndex;
        private int mItemsToDraw;

        private InterleavedDispatchDraw() {
        }

        private void start(Canvas canvas) {
            this.mCanvas = canvas;
            this.mDrawIndex = 0;
            this.mItemsToDraw = ComponentHost.this.mMountItems == null ? 0 : ComponentHost.this.mMountItems.size();
        }

        private boolean isRunning() {
            return this.mCanvas != null && this.mDrawIndex < this.mItemsToDraw;
        }

        private void drawNext() {
            int size;
            if (this.mCanvas == null) {
                return;
            }
            int n = size = ComponentHost.this.mMountItems == null ? 0 : ComponentHost.this.mMountItems.size();
            for (int i = this.mDrawIndex; i < size; ++i) {
                MountItem mountItem = (MountItem)ComponentHost.this.mMountItems.valueAt(i);
                Object content = mountItem.getContent();
                if (content instanceof View) {
                    this.mDrawIndex = i + 1;
                    return;
                }
                if (!mountItem.isBound()) continue;
                boolean isTracing = ComponentsSystrace.isTracing();
                if (isTracing) {
                    ComponentsSystrace.beginSection("draw: " + ComponentHost.getMountItemName(mountItem));
                }
                ((Drawable)content).draw(this.mCanvas);
                if (!isTracing) continue;
                ComponentsSystrace.endSection();
            }
            this.mDrawIndex = this.mItemsToDraw;
        }

        private void end() {
            this.mCanvas = null;
        }
    }
}

