/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Looper;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.litho.AttachDetachHandler;
import com.facebook.litho.CommonPropsCopyable;
import com.facebook.litho.Component;
import com.facebook.litho.ComponentTree;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.DebugComponent;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTrigger;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InternalNodeUtils;
import com.facebook.litho.KeyHandler;
import com.facebook.litho.NoOpInternalNode;
import com.facebook.litho.R;
import com.facebook.litho.ResourceCache;
import com.facebook.litho.StateContainer;
import com.facebook.litho.StateHandler;
import com.facebook.litho.TreeProps;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.yoga.YogaNode;

public class ComponentContext {
    public static final InternalNode NULL_LAYOUT = new NoOpInternalNode();
    private final Context mContext;
    @Nullable
    private final String mLogTag;
    private final ComponentsLogger mLogger;
    @Nullable
    private final StateHandler mStateHandler;
    final YogaNodeFactory mYogaNodeFactory;
    @Nullable
    private final KeyHandler mKeyHandler;
    @Nullable
    private volatile AttachDetachHandler mAttachDetachHandler;
    private String mNoStateUpdatesMethod;
    @ThreadConfined(value="ANY")
    private Component mComponentScope;
    @ThreadConfined(value="ANY")
    private final ResourceCache mResourceCache;
    @ThreadConfined(value="ANY")
    private int mWidthSpec;
    @ThreadConfined(value="ANY")
    private int mHeightSpec;
    @ThreadConfined(value="ANY")
    @Nullable
    private TreeProps mTreeProps;
    @ThreadConfined(value="ANY")
    private ComponentTree mComponentTree;
    @StyleRes
    @ThreadConfined(value="ANY")
    private int mDefStyleRes = 0;
    @AttrRes
    @ThreadConfined(value="ANY")
    private int mDefStyleAttr = 0;
    private final boolean mIsParentIncrementalMountDisabled;
    private ComponentTree.LayoutStateFuture mLayoutStateFuture;

    public ComponentContext(Context context, @Nullable String logTag, ComponentsLogger logger, @Nullable StateHandler stateHandler, @Nullable KeyHandler keyHandler, @Nullable TreeProps treeProps, YogaNodeFactory yogaNodeFactory, boolean isParentIncrementalMountDisabled) {
        if (logger != null && logTag == null) {
            throw new IllegalStateException("When a ComponentsLogger is set, a LogTag must be set");
        }
        this.mContext = context;
        this.mResourceCache = ResourceCache.getLatest(context.getResources().getConfiguration());
        this.mTreeProps = treeProps;
        this.mLogger = logger;
        this.mLogTag = logTag;
        this.mStateHandler = stateHandler;
        this.mKeyHandler = keyHandler;
        this.mYogaNodeFactory = yogaNodeFactory;
        this.mIsParentIncrementalMountDisabled = isParentIncrementalMountDisabled;
    }

    public ComponentContext(Context context, @Nullable String logTag, ComponentsLogger logger, @Nullable StateHandler stateHandler, @Nullable KeyHandler keyHandler, @Nullable TreeProps treeProps, YogaNodeFactory yogaNodeFactory) {
        this(context, logTag, logger, stateHandler, keyHandler, treeProps, yogaNodeFactory, false);
    }

    public ComponentContext(ComponentContext context, @Nullable StateHandler stateHandler, @Nullable KeyHandler keyHandler, @Nullable TreeProps treeProps, @Nullable ComponentTree.LayoutStateFuture layoutStateFuture) {
        this(context, stateHandler, null, keyHandler, treeProps, layoutStateFuture);
    }

    public ComponentContext(ComponentContext context, @Nullable StateHandler stateHandler, @Nullable AttachDetachHandler attachDetachHandler, @Nullable KeyHandler keyHandler, @Nullable TreeProps treeProps, @Nullable ComponentTree.LayoutStateFuture layoutStateFuture) {
        this.mContext = context.getAndroidContext();
        this.mResourceCache = context.mResourceCache;
        this.mWidthSpec = context.mWidthSpec;
        this.mHeightSpec = context.mHeightSpec;
        this.mComponentScope = context.mComponentScope;
        this.mComponentTree = context.mComponentTree;
        this.mLogger = context.mLogger;
        this.mLogTag = context.mLogTag != null || this.mComponentTree == null ? context.mLogTag : this.mComponentTree.getSimpleName();
        this.mYogaNodeFactory = context.mYogaNodeFactory;
        this.mStateHandler = stateHandler != null ? stateHandler : context.mStateHandler;
        this.mAttachDetachHandler = attachDetachHandler != null ? attachDetachHandler : context.mAttachDetachHandler;
        this.mKeyHandler = keyHandler != null ? keyHandler : context.mKeyHandler;
        this.mTreeProps = treeProps != null ? treeProps : context.mTreeProps;
        this.mLayoutStateFuture = layoutStateFuture == null ? context.mLayoutStateFuture : layoutStateFuture;
        this.mIsParentIncrementalMountDisabled = context.mIsParentIncrementalMountDisabled;
    }

    public ComponentContext(Context context, @Nullable String logTag, ComponentsLogger logger, @Nullable StateHandler stateHandler, @Nullable KeyHandler keyHandler, @Nullable TreeProps treeProps) {
        this(context, logTag, logger, stateHandler, keyHandler, treeProps, null);
    }

    public ComponentContext(Context context, @Nullable String logTag, ComponentsLogger logger, @Nullable TreeProps treeProps) {
        this(context, logTag, logger, null, null, treeProps);
    }

    public ComponentContext(Context context, @Nullable String logTag, ComponentsLogger logger) {
        this(context, logTag, logger, null, null, null);
    }

    public ComponentContext(Context context, StateHandler stateHandler) {
        this(context, null, null, stateHandler, null, null);
    }

    public ComponentContext(Context context, YogaNodeFactory yogaNodeFactory) {
        this(context, null, null, null, null, null, yogaNodeFactory);
    }

    public ComponentContext(ComponentContext context) {
        this(context, context.mStateHandler, context.mAttachDetachHandler, context.mKeyHandler, context.mTreeProps, context.mLayoutStateFuture);
    }

    public ComponentContext(Context context) {
        this(context, null, null, null, null, null);
    }

    ComponentContext makeNewCopy() {
        return new ComponentContext(this);
    }

    public final Context getAndroidContext() {
        return this.mContext;
    }

    public final Context getApplicationContext() {
        return this.mContext.getApplicationContext();
    }

    public Resources getResources() {
        return this.mContext.getResources();
    }

    public final Looper getMainLooper() {
        return this.mContext.getMainLooper();
    }

    public CharSequence getText(@StringRes int resId) {
        return this.mContext.getResources().getText(resId);
    }

    public String getString(@StringRes int resId) {
        return this.mContext.getResources().getString(resId);
    }

    public String getString(@StringRes int resId, Object ... formatArgs) {
        return this.mContext.getResources().getString(resId, formatArgs);
    }

    public int getColor(@ColorRes int id2) {
        return this.mContext.getResources().getColor(id2);
    }

    public Component getComponentScope() {
        return this.mComponentScope;
    }

    @VisibleForTesting
    public ComponentTree.LayoutStateFuture getLayoutStateFuture() {
        return this.mLayoutStateFuture;
    }

    public void updateStateSync(StateContainer.StateUpdate stateUpdate, String attribution) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateSync(this.mComponentScope.getGlobalKey(), stateUpdate, attribution);
    }

    public void updateStateAsync(StateContainer.StateUpdate stateUpdate, String attribution) {
        this.checkIfNoStateUpdatesMethod();
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateAsync(this.mComponentScope.getGlobalKey(), stateUpdate, attribution);
    }

    public void updateStateWithTransition(StateContainer.StateUpdate stateUpdate, String attribution) {
        this.updateStateAsync(stateUpdate, attribution);
    }

    public void updateStateLazy(StateContainer.StateUpdate stateUpdate) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.updateStateLazy(this.mComponentScope.getGlobalKey(), stateUpdate);
    }

    public void applyLazyStateUpdatesForContainer(StateContainer container) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.applyLazyStateUpdatesForContainer(this.mComponentScope.getGlobalKey(), container);
    }

    void enterNoStateUpdatesMethod(String noStateUpdatesMethod) {
        this.mNoStateUpdatesMethod = noStateUpdatesMethod;
    }

    void exitNoStateUpdatesMethod() {
        this.mNoStateUpdatesMethod = null;
    }

    private void checkIfNoStateUpdatesMethod() {
        if (this.mNoStateUpdatesMethod != null) {
            throw new IllegalStateException("Updating the state of a component during " + this.mNoStateUpdatesMethod + " leads to unexpected behaviour, consider using lazy state updates.");
        }
    }

    void setDefStyle(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this.mDefStyleAttr = defStyleAttr;
        this.mDefStyleRes = defStyleRes;
    }

    public TypedArray obtainStyledAttributes(int[] attrs, @AttrRes int defStyleAttr) {
        return this.mContext.obtainStyledAttributes(null, attrs, defStyleAttr != 0 ? defStyleAttr : this.mDefStyleAttr, this.mDefStyleRes);
    }

    public String getLogTag() {
        return this.mLogTag;
    }

    public YogaNodeFactory getYogaNodeFactory() {
        return this.mYogaNodeFactory;
    }

    @Nullable
    public ComponentsLogger getLogger() {
        return this.mLogger;
    }

    ComponentTree getComponentTree() {
        return this.mComponentTree;
    }

    protected void setTreeProps(@Nullable TreeProps treeProps) {
        this.mTreeProps = treeProps;
    }

    @Nullable
    protected TreeProps getTreeProps() {
        return this.mTreeProps;
    }

    @Nullable
    public <T> T getTreeProp(Class<T> key) {
        return this.mTreeProps == null ? null : (T)this.mTreeProps.get(key);
    }

    @Nullable
    public TreeProps getTreePropsCopy() {
        return TreeProps.copy(this.mTreeProps);
    }

    public ResourceCache getResourceCache() {
        return this.mResourceCache;
    }

    EventHandler newEventHandler(int id2) {
        return new EventHandler(this.mComponentScope, id2);
    }

    public <E> EventHandler<E> newEventHandler(int id2, Object[] params) {
        return new EventHandler(this.mComponentScope, id2, params);
    }

    @Nullable
    public Object getCachedValue(Object cachedValueInputs) {
        if (this.mComponentTree == null) {
            return null;
        }
        return this.mComponentTree.getCachedValue(cachedValueInputs);
    }

    public void putCachedValue(Object cachedValueInputs, Object cachedValue) {
        if (this.mComponentTree == null) {
            return;
        }
        this.mComponentTree.putCachedValue(cachedValueInputs, cachedValue);
    }

    <E> EventTrigger<E> newEventTrigger(String childKey, int id2) {
        String parentKey = this.mComponentScope == null ? "" : this.mComponentScope.getGlobalKey();
        return new EventTrigger(parentKey, id2, childKey);
    }

    InternalNode newLayoutBuilder(@AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        InternalNode node = InternalNodeUtils.create(this);
        this.applyStyle(node, defStyleAttr, defStyleRes);
        return node;
    }

    InternalNode newLayoutBuilder(Component component, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        InternalNode node;
        InternalNode layoutCreatedInWillRender = component.consumeLayoutCreatedInWillRender();
        if (layoutCreatedInWillRender != null) {
            return layoutCreatedInWillRender;
        }
        component = component.getThreadSafeInstance();
        component.updateInternalChildState(this);
        if (ComponentsConfiguration.isDebugModeEnabled) {
            DebugComponent.applyOverrides(this, component);
        }
        if ((node = component.createLayout(component.getScopedContext(), false)) != NULL_LAYOUT) {
            this.applyStyle(node, defStyleAttr, defStyleRes);
        }
        return node;
    }

    InternalNode resolveLayout(Component component) {
        CommonPropsCopyable props;
        InternalNode layoutCreatedInWillRender = component.consumeLayoutCreatedInWillRender();
        if (layoutCreatedInWillRender != null) {
            return layoutCreatedInWillRender;
        }
        component = component.getThreadSafeInstance();
        component.updateInternalChildState(this);
        if (ComponentsConfiguration.isDebugModeEnabled) {
            DebugComponent.applyOverrides(this, component);
        }
        InternalNode node = (InternalNode)component.resolve(component.getScopedContext());
        if (component.canResolve() && (props = component.getCommonPropsCopyable()) != null) {
            props.copyInto(component.getScopedContext(), node);
        }
        return node;
    }

    int getWidthSpec() {
        return this.mWidthSpec;
    }

    void setWidthSpec(int widthSpec) {
        this.mWidthSpec = widthSpec;
    }

    int getHeightSpec() {
        return this.mHeightSpec;
    }

    void setHeightSpec(int heightSpec) {
        this.mHeightSpec = heightSpec;
    }

    @Nullable
    StateHandler getStateHandler() {
        return this.mStateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AttachDetachHandler getOrCreateAttachDetachHandler() {
        AttachDetachHandler localAttachDetachHandler = this.mAttachDetachHandler;
        if (localAttachDetachHandler == null) {
            ComponentContext componentContext = this;
            synchronized (componentContext) {
                localAttachDetachHandler = this.mAttachDetachHandler;
                if (localAttachDetachHandler == null) {
                    this.mAttachDetachHandler = localAttachDetachHandler = new AttachDetachHandler();
                }
            }
        }
        return localAttachDetachHandler;
    }

    @Nullable
    AttachDetachHandler getAttachDetachHandler() {
        return this.mAttachDetachHandler;
    }

    @Nullable
    KeyHandler getKeyHandler() {
        return this.mKeyHandler;
    }

    void applyStyle(InternalNode node, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (defStyleAttr != 0 || defStyleRes != 0) {
            this.setDefStyle(defStyleAttr, defStyleRes);
            TypedArray typedArray = this.mContext.obtainStyledAttributes(null, R.styleable.ComponentLayout, defStyleAttr, defStyleRes);
            node.applyAttributes(typedArray);
            typedArray.recycle();
            this.setDefStyle(0, 0);
        }
    }

    boolean isParentIncrementalMountDisabled() {
        return this.mIsParentIncrementalMountDisabled;
    }

    static ComponentContext withComponentTree(ComponentContext context, ComponentTree componentTree) {
        ComponentContext componentContext = new ComponentContext(context, new StateHandler(), null, null, null);
        componentContext.mComponentTree = componentTree;
        componentContext.mComponentScope = null;
        componentContext.mLayoutStateFuture = null;
        return componentContext;
    }

    @VisibleForTesting(otherwise=3)
    public static ComponentContext withComponentScope(ComponentContext context, Component scope) {
        ComponentContext componentContext = context.makeNewCopy();
        componentContext.mComponentScope = scope;
        componentContext.mComponentTree = context.mComponentTree;
        return componentContext;
    }

    public static boolean isIncrementalMountDisabled(ComponentContext c) {
        return c.mComponentTree != null && !c.mComponentTree.isIncrementalMountEnabled();
    }

    public boolean isNestedTreeResolutionExperimentEnabled() {
        if (this.getComponentTree() != null) {
            return this.getComponentTree().isNestedTreeResolutionExperimentEnabled();
        }
        return false;
    }

    boolean wasLayoutCanceled() {
        return this.mLayoutStateFuture == null ? false : this.mLayoutStateFuture.isReleased();
    }

    public boolean isReconciliationEnabled() {
        if (this.getComponentTree() != null) {
            return this.getComponentTree().isReconciliationEnabled();
        }
        return ComponentsConfiguration.isReconciliationEnabled;
    }

    boolean wasLayoutInterrupted() {
        return this.mLayoutStateFuture == null ? false : this.mLayoutStateFuture.isInterrupted();
    }

    public static interface YogaNodeFactory {
        public YogaNode create();
    }
}

