/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.animation.AnimatorInflater;
import android.animation.StateListAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.ViewOutlineProvider;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.annotation.GuardedBy;
import androidx.annotation.Px;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ReturnsOwnership;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Border;
import com.facebook.litho.ClickEvent;
import com.facebook.litho.CommonProps;
import com.facebook.litho.CommonPropsCopyable;
import com.facebook.litho.CommonPropsHolder;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentKeyUtils;
import com.facebook.litho.ComponentLifecycle;
import com.facebook.litho.ComponentUtils;
import com.facebook.litho.ComponentsLogger;
import com.facebook.litho.DispatchPopulateAccessibilityEventEvent;
import com.facebook.litho.DynamicValue;
import com.facebook.litho.Equivalence;
import com.facebook.litho.ErrorEvent;
import com.facebook.litho.EventDispatcher;
import com.facebook.litho.EventHandler;
import com.facebook.litho.EventTriggersContainer;
import com.facebook.litho.FocusChangedEvent;
import com.facebook.litho.FocusedVisibleEvent;
import com.facebook.litho.FullImpressionVisibleEvent;
import com.facebook.litho.HasEventDispatcher;
import com.facebook.litho.HasEventTrigger;
import com.facebook.litho.HostComponent;
import com.facebook.litho.InterceptTouchEvent;
import com.facebook.litho.InternalNode;
import com.facebook.litho.InvisibleEvent;
import com.facebook.litho.KeyHandler;
import com.facebook.litho.Layout;
import com.facebook.litho.LayoutState;
import com.facebook.litho.LongClickEvent;
import com.facebook.litho.MeasureComparisonUtils;
import com.facebook.litho.OnInitializeAccessibilityEventEvent;
import com.facebook.litho.OnInitializeAccessibilityNodeInfoEvent;
import com.facebook.litho.OnPopulateAccessibilityEventEvent;
import com.facebook.litho.OnRequestSendAccessibilityEventEvent;
import com.facebook.litho.PerformAccessibilityActionEvent;
import com.facebook.litho.ResourceResolver;
import com.facebook.litho.SendAccessibilityEventEvent;
import com.facebook.litho.SendAccessibilityEventUncheckedEvent;
import com.facebook.litho.Size;
import com.facebook.litho.SparseCommonPropsHolder;
import com.facebook.litho.StateContainer;
import com.facebook.litho.TouchEvent;
import com.facebook.litho.Transition;
import com.facebook.litho.UnfocusedVisibleEvent;
import com.facebook.litho.VisibilityChangedEvent;
import com.facebook.litho.VisibleEvent;
import com.facebook.litho.WorkingRange;
import com.facebook.litho.WorkingRangeContainer;
import com.facebook.litho.config.ComponentsConfiguration;
import com.facebook.litho.drawable.ComparableColorDrawable;
import com.facebook.litho.drawable.ComparableDrawable;
import com.facebook.litho.drawable.ComparableResDrawable;
import com.facebook.litho.drawable.DefaultComparableDrawable;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaEdge;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaPositionType;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

public abstract class Component
extends ComponentLifecycle
implements Cloneable,
HasEventDispatcher,
HasEventTrigger,
Equivalence<Component> {
    private static final AtomicInteger sIdGenerator = new AtomicInteger(1);
    private static final DynamicValue[] sEmptyArray = new DynamicValue[0];
    private int mId = sIdGenerator.getAndIncrement();
    @Nullable
    private String mOwnerGlobalKey;
    private String mGlobalKey;
    @Nullable
    private String mKey;
    private boolean mHasManualKey;
    @GuardedBy(value="this")
    private AtomicBoolean mLayoutVersionGenerator = new AtomicBoolean();
    @Nullable
    @ThreadConfined(value="ANY")
    private ComponentContext mScopedContext;
    private boolean mIsLayoutStarted = false;
    @Nullable
    @ThreadConfined(value="ANY")
    @GuardedBy(value="this")
    public ConcurrentHashMap<Long, InternalNode> mThreadIdToLastMeasuredLayout;
    @Nullable
    private CommonProps mCommonProps;
    @Nullable
    private SparseArray<DynamicValue<?>> mCommonDynamicProps;
    @Nullable
    private SparseIntArray mChildCounters;
    @Nullable
    private Set<String> mManualKeys;
    @Nullable
    private EventHandler<ErrorEvent> mErrorEventHandler;
    @Nullable
    private InternalNode mLayoutCreatedInWillRender;
    @Nullable
    List<WorkingRangeContainer.Registration> mWorkingRangeRegistrations;
    private final String mSimpleName;

    protected Component(String simpleName) {
        this(simpleName, null);
    }

    protected Component(String simpleName, Object type) {
        super(type);
        this.mSimpleName = simpleName;
    }

    public String getSimpleName() {
        Component delegate = this.getSimpleNameDelegate();
        if (delegate == null) {
            return this.mSimpleName;
        }
        return this.mSimpleName + "(" + Component.getFirstNonSimpleNameDelegate(delegate).getSimpleName() + ")";
    }

    @Nullable
    protected Component getSimpleNameDelegate() {
        return null;
    }

    @Override
    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (this.getId() == other.getId()) {
            return true;
        }
        return ComponentUtils.hasEquivalentFields(this, other);
    }

    @Nullable
    protected StateContainer getStateContainer() {
        return null;
    }

    public ComponentContext getScopedContext() {
        return this.mScopedContext;
    }

    public void setScopedContext(ComponentContext scopedContext) {
        this.mScopedContext = scopedContext;
        if (this.mLayoutCreatedInWillRender != null) {
            Component.assertSameBaseContext(scopedContext, this.mLayoutCreatedInWillRender.getContext());
        }
    }

    private static void assertSameBaseContext(ComponentContext scopedContext, ComponentContext willRenderContext) {
        ComponentsLogger logger;
        if (scopedContext.getAndroidContext() != willRenderContext.getAndroidContext() && (logger = scopedContext.getLogger()) != null) {
            logger.emitMessage(ComponentsLogger.LogLevel.ERROR, "Found mismatching base contexts between the Component's Context (" + scopedContext.getAndroidContext() + ") and the Context used in willRender (" + willRenderContext.getAndroidContext() + ")!");
        }
    }

    synchronized void markLayoutStarted() {
        if (this.mIsLayoutStarted) {
            throw new IllegalStateException("Duplicate layout of a component: " + this);
        }
        this.mIsLayoutStarted = true;
    }

    protected int getId() {
        return this.mId;
    }

    @Nullable
    String getOwnerGlobalKey() {
        return this.mOwnerGlobalKey;
    }

    String getGlobalKey() {
        return this.mGlobalKey;
    }

    @ThreadSafe(enableChecks=false)
    void setGlobalKey(String key) {
        this.mGlobalKey = key;
    }

    boolean hasManualKey() {
        return this.mHasManualKey;
    }

    String getKey() {
        if (this.mKey == null && !this.mHasManualKey) {
            this.mKey = Integer.toString(this.getTypeId());
        }
        return this.mKey;
    }

    void setKey(String key) {
        this.mHasManualKey = true;
        this.mKey = key;
    }

    private String generateUniqueGlobalKeyForChild(Component component, String key) {
        String childKey = ComponentKeyUtils.getKeyWithSeparator(this.getGlobalKey(), key);
        KeyHandler keyHandler = this.mScopedContext.getKeyHandler();
        if (keyHandler == null) {
            return childKey;
        }
        if (this.mScopedContext.isNestedTreeResolutionExperimentEnabled()) {
            int childCount;
            if (component.mHasManualKey) {
                if (this.mManualKeys == null) {
                    this.mManualKeys = new HashSet<String>();
                }
                if (this.mManualKeys.contains(childKey)) {
                    this.logDuplicateManualKeyWarning(component, key);
                } else {
                    this.mManualKeys.add(childKey);
                    this.getChildCountAndIncrement(component);
                    return childKey;
                }
            }
            if ((childCount = this.getChildCountAndIncrement(component)) == 0) {
                return childKey;
            }
            return ComponentKeyUtils.getKeyForChildPosition(childKey, childCount);
        }
        if (keyHandler.hasKey(childKey)) {
            if (component.mHasManualKey) {
                this.logDuplicateManualKeyWarning(component, key);
            }
            return ComponentKeyUtils.getKeyForChildPosition(childKey, this.getChildCountAndIncrement(component));
        }
        return childKey;
    }

    private int getChildCountAndIncrement(Component component) {
        if (this.mChildCounters == null) {
            this.mChildCounters = new SparseIntArray();
        }
        int typeId = component.getTypeId();
        int count = this.mChildCounters.get(typeId, 0);
        this.mChildCounters.put(typeId, count + 1);
        return count;
    }

    private void logDuplicateManualKeyWarning(Component component, String key) {
        ComponentsLogger logger = this.mScopedContext.getLogger();
        if (logger != null) {
            logger.emitMessage(ComponentsLogger.LogLevel.WARNING, "The manual key " + key + " you are setting on this " + component.getSimpleName() + " is a duplicate and will be changed into a unique one. This will result in unexpected behavior if you don't change it.");
        }
    }

    public Component makeShallowCopy() {
        try {
            Component component = (Component)super.clone();
            component.mGlobalKey = null;
            component.mIsLayoutStarted = false;
            component.mHasManualKey = false;
            component.mLayoutVersionGenerator = new AtomicBoolean();
            component.mScopedContext = null;
            component.mChildCounters = null;
            component.mManualKeys = null;
            return component;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    Component makeShallowCopyWithNewId() {
        Component component = this.makeShallowCopy();
        component.mId = sIdGenerator.incrementAndGet();
        return component;
    }

    Component makeUpdatedShallowCopy(ComponentContext c) {
        Component clone = this.makeShallowCopy();
        clone.setGlobalKey(this.getGlobalKey());
        clone.copyInterStageImpl(this);
        clone.updateInternalChildState(c);
        return clone;
    }

    @Nullable
    InternalNode getCachedLayout() {
        return this.mThreadIdToLastMeasuredLayout == null ? null : this.mThreadIdToLastMeasuredLayout.get(Thread.currentThread().getId());
    }

    public void clearCachedLayout() {
        if (this.getCachedLayout() != null) {
            this.mThreadIdToLastMeasuredLayout.remove(Thread.currentThread().getId());
        }
    }

    void reset() {
        this.mIsLayoutStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measure(ComponentContext c, int widthSpec, int heightSpec, Size outputSize) {
        InternalNode lastMeasuredLayout = this.getCachedLayout();
        if (lastMeasuredLayout == null || !MeasureComparisonUtils.isMeasureSpecCompatible(lastMeasuredLayout.getLastWidthSpec(), widthSpec, lastMeasuredLayout.getWidth()) || !MeasureComparisonUtils.isMeasureSpecCompatible(lastMeasuredLayout.getLastHeightSpec(), heightSpec, lastMeasuredLayout.getHeight())) {
            this.clearCachedLayout();
            lastMeasuredLayout = LayoutState.createAndMeasureTreeForComponent(c, this, widthSpec, heightSpec);
            Component component = this;
            synchronized (component) {
                if (this.mThreadIdToLastMeasuredLayout == null) {
                    this.mThreadIdToLastMeasuredLayout = new ConcurrentHashMap(2);
                }
            }
            this.mThreadIdToLastMeasuredLayout.put(Thread.currentThread().getId(), lastMeasuredLayout);
            if (Component.isLayoutSpec(this)) {
                lastMeasuredLayout.setLastWidthSpec(widthSpec);
                lastMeasuredLayout.setLastHeightSpec(heightSpec);
                lastMeasuredLayout.setLastMeasuredWidth(lastMeasuredLayout.getWidth());
                lastMeasuredLayout.setLastMeasuredHeight(lastMeasuredLayout.getHeight());
            }
        }
        outputSize.width = lastMeasuredLayout.getWidth();
        outputSize.height = lastMeasuredLayout.getHeight();
    }

    protected void copyInterStageImpl(Component component) {
    }

    static boolean isHostSpec(@Nullable Component component) {
        return component instanceof HostComponent;
    }

    static boolean isLayoutSpec(@Nullable Component component) {
        return component != null && component.getMountType() == ComponentLifecycle.MountType.NONE;
    }

    static boolean isMountSpec(@Nullable Component component) {
        return component != null && component.getMountType() != ComponentLifecycle.MountType.NONE;
    }

    static boolean isMountDrawableSpec(@Nullable Component component) {
        return component != null && component.getMountType() == ComponentLifecycle.MountType.DRAWABLE;
    }

    static boolean isMountViewSpec(@Nullable Component component) {
        return component != null && component.getMountType() == ComponentLifecycle.MountType.VIEW;
    }

    static boolean isLayoutSpecWithSizeSpec(@Nullable Component component) {
        return Component.isLayoutSpec(component) && component.canMeasure();
    }

    static boolean isNestedTree(@Nullable Component component) {
        return Component.isLayoutSpecWithSizeSpec(component) || component != null && component.getCachedLayout() != null;
    }

    private static Component getFirstNonSimpleNameDelegate(Component component) {
        Component current = component;
        while (current.getSimpleNameDelegate() != null) {
            current = current.getSimpleNameDelegate();
        }
        return current;
    }

    @Deprecated
    public static boolean willRender(ComponentContext c, Component component) {
        if (component == null) {
            return false;
        }
        ComponentContext scopedContext = component.getScopedContext();
        if (scopedContext != null) {
            Component.assertSameBaseContext(scopedContext, c);
        }
        if (component.mLayoutCreatedInWillRender != null) {
            return Component.willRender(component.mLayoutCreatedInWillRender);
        }
        component.mLayoutCreatedInWillRender = Layout.create(c, component);
        return Component.willRender(component.mLayoutCreatedInWillRender);
    }

    private static boolean willRender(InternalNode node) {
        if (node == null || ComponentContext.NULL_LAYOUT.equals(node)) {
            return false;
        }
        if (node.isNestedTreeHolder()) {
            throw new IllegalArgumentException("Cannot check willRender on a component that uses @OnCreateLayoutWithSizeSpec! Try wrapping this component in one that uses @OnCreateLayout if possible.");
        }
        return true;
    }

    InternalNode consumeLayoutCreatedInWillRender() {
        InternalNode layout = this.mLayoutCreatedInWillRender;
        this.mLayoutCreatedInWillRender = null;
        return layout;
    }

    @VisibleForTesting(otherwise=2)
    InternalNode getLayoutCreatedInWillRenderForTesting() {
        return this.mLayoutCreatedInWillRender;
    }

    @VisibleForTesting(otherwise=3)
    protected void updateInternalChildState(ComponentContext parentContext) {
        boolean isRefactoredKeyGenerationEnabled;
        if (!(!ComponentsConfiguration.isDebugModeEnabled && !ComponentsConfiguration.useGlobalKeys || (isRefactoredKeyGenerationEnabled = parentContext.isNestedTreeResolutionExperimentEnabled()) && this.getGlobalKey() != null)) {
            String globalKey = this.generateKey(parentContext);
            this.setGlobalKey(globalKey);
            KeyHandler keyHandler = parentContext.getKeyHandler();
            if (!isRefactoredKeyGenerationEnabled && keyHandler != null) {
                keyHandler.registerKey(this);
            }
        }
        this.applyStateUpdates(parentContext);
        this.generateErrorEventHandler(parentContext);
        if (this.mLayoutVersionGenerator != null) {
            this.mLayoutVersionGenerator.set(true);
        }
    }

    private String generateKey(ComponentContext parentContext) {
        String globalKey;
        Component parentScope = parentContext.getComponentScope();
        String key = this.getKey();
        if (parentScope == null) {
            globalKey = key;
        } else if (parentScope.getGlobalKey() == null) {
            ComponentsLogger logger = parentContext.getLogger();
            if (logger != null) {
                logger.emitMessage(ComponentsLogger.LogLevel.ERROR, "Trying to generate parent-based key for component " + this.getSimpleName() + " , but parent " + parentScope.getSimpleName() + " has a null global key \". This is most likely a configuration mistake, check the value of ComponentsConfiguration.useGlobalKeys.");
            }
            globalKey = "null" + key;
        } else {
            globalKey = parentScope.generateUniqueGlobalKeyForChild(this, key);
        }
        return globalKey;
    }

    private void generateErrorEventHandler(ComponentContext parentContext) {
        if (ComponentsConfiguration.enableOnErrorHandling && this.mErrorEventHandler == null) {
            HasEventDispatcher parentEventDispatcherProvider = parentContext.getComponentScope();
            if (parentEventDispatcherProvider == null) {
                parentEventDispatcherProvider = new DefaultErrorEventDispatcher();
            }
            this.mErrorEventHandler = new EventHandler(parentEventDispatcherProvider, ERROR_EVENT_HANDLER_ID, new Object[]{parentContext});
        }
    }

    private void applyStateUpdates(ComponentContext c) {
        this.setScopedContext(ComponentContext.withComponentScope(c, this));
        this.populateTreeProps(this.getScopedContext().getTreeProps());
        if (this.hasState()) {
            c.getStateHandler().applyStateUpdatesForComponent(this);
        }
    }

    Component getThreadSafeInstance() {
        if (this.mLayoutVersionGenerator == null) {
            return this;
        }
        boolean shouldCreateNewInstance = this.mLayoutVersionGenerator.getAndSet(true);
        return shouldCreateNewInstance ? this.makeShallowCopy() : this;
    }

    @Override
    public void recordEventTrigger(EventTriggersContainer container) {
    }

    protected boolean canResolve() {
        return false;
    }

    @Nullable
    CommonPropsCopyable getCommonPropsCopyable() {
        return this.mCommonProps;
    }

    @Nullable
    public CommonProps getCommonProps() {
        return this.mCommonProps;
    }

    private CommonProps getOrCreateCommonProps() {
        if (this.mCommonProps == null) {
            this.mCommonProps = ComponentsConfiguration.isSparseCommonPropsHolderIsEnabled ? new SparseCommonPropsHolder() : new CommonPropsHolder();
        }
        return this.mCommonProps;
    }

    private SparseArray<DynamicValue<?>> getOrCreateCommonDynamicProps() {
        if (this.mCommonDynamicProps == null) {
            this.mCommonDynamicProps = new SparseArray();
        }
        return this.mCommonDynamicProps;
    }

    @Nullable
    SparseArray<DynamicValue<?>> getCommonDynamicProps() {
        return this.mCommonDynamicProps;
    }

    boolean hasCommonDynamicProps() {
        return this.mCommonDynamicProps != null;
    }

    @Override
    @Deprecated
    public EventDispatcher getEventDispatcher() {
        return this;
    }

    @Nullable
    EventHandler<ErrorEvent> getErrorHandler() {
        return this.mErrorEventHandler;
    }

    protected static void registerWorkingRange(String name, WorkingRange workingRange, Component component) {
        if (component.mWorkingRangeRegistrations == null) {
            component.mWorkingRangeRegistrations = new ArrayList<WorkingRangeContainer.Registration>();
        }
        component.mWorkingRangeRegistrations.add(new WorkingRangeContainer.Registration(name, workingRange, component));
    }

    public boolean hasBackgroundSet() {
        return this.mCommonProps != null && this.mCommonProps.getBackground() != null;
    }

    public boolean hasClickHandlerSet() {
        return this.mCommonProps != null && this.mCommonProps.getNullableNodeInfo() != null && this.mCommonProps.getNullableNodeInfo().getClickHandler() != null;
    }

    protected DynamicValue[] getDynamicProps() {
        return sEmptyArray;
    }

    protected void bindDynamicProp(int dynamicPropIndex, Object value, Object content) {
        throw new RuntimeException("Components that have dynamic Props must override this method");
    }

    protected static <T> T retrieveValue(DynamicValue<T> dynamicValue) {
        return dynamicValue.get();
    }

    private static class DefaultErrorEventDispatcher
    implements HasEventDispatcher {
        private DefaultErrorEventDispatcher() {
        }

        @Override
        public EventDispatcher getEventDispatcher() {
            return new EventDispatcher(){

                @Override
                @Nullable
                public Object dispatchOnEvent(EventHandler eventHandler, Object eventState) {
                    if (eventHandler.id == ComponentLifecycle.ERROR_EVENT_HANDLER_ID) {
                        Exception e = ((ErrorEvent)eventState).exception;
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            };
        }
    }

    public static abstract class ContainerBuilder<T extends ContainerBuilder<T>>
    extends Builder<T> {
        public abstract T child(@Nullable Component var1);

        public abstract T child(@Nullable Builder<?> var1);

        public abstract T alignContent(@Nullable YogaAlign var1);

        public abstract T alignItems(@Nullable YogaAlign var1);

        public abstract T justifyContent(@Nullable YogaJustify var1);

        public abstract T wrap(@Nullable YogaWrap var1);

        public abstract T reverse(boolean var1);
    }

    public static abstract class Builder<T extends Builder<T>> {
        @Nullable
        private ComponentContext mContext;
        private Component mComponent;
        protected ResourceResolver mResourceResolver;

        protected void init(ComponentContext c, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, Component component) {
            this.mResourceResolver = new ResourceResolver(c);
            this.mComponent = component;
            this.mContext = c;
            Component owner = this.getOwner();
            if (owner != null) {
                this.mComponent.mOwnerGlobalKey = owner.getGlobalKey();
            }
            if (defStyleAttr != 0 || defStyleRes != 0) {
                this.mComponent.getOrCreateCommonProps().setStyle(defStyleAttr, defStyleRes);
                component.loadStyle(c, defStyleAttr, defStyleRes);
            }
        }

        @Nullable
        public ComponentContext getContext() {
            return this.mContext;
        }

        public abstract T getThis();

        public T key(@Nullable String key) {
            if (key == null) {
                ComponentsLogger logger = this.mContext.getLogger();
                if (logger != null) {
                    String componentName = this.mContext.getComponentScope() != null ? this.mContext.getComponentScope().getSimpleName() : "unknown component";
                    String message = "Setting a null key from " + componentName + " which is usually a mistake! If it is not, explicitly set the String 'null'";
                    logger.emitMessage(ComponentsLogger.LogLevel.ERROR, message);
                }
                key = "null";
            }
            this.mComponent.setKey(key);
            return this.getThis();
        }

        protected static void checkArgs(int requiredPropsCount, BitSet required, String[] requiredPropsNames) {
            if (required != null && required.nextClearBit(0) < requiredPropsCount) {
                ArrayList<String> missingProps = new ArrayList<String>();
                for (int i = 0; i < requiredPropsCount; ++i) {
                    if (required.get(i)) continue;
                    missingProps.add(requiredPropsNames[i]);
                }
                throw new IllegalStateException("The following props are not marked as optional and were not supplied: " + Arrays.toString(missingProps.toArray()));
            }
        }

        @ReturnsOwnership
        public abstract Component build();

        public T layoutDirection(@Nullable YogaDirection layoutDirection) {
            this.mComponent.getOrCreateCommonProps().layoutDirection(layoutDirection);
            return this.getThis();
        }

        public T alignSelf(@Nullable YogaAlign alignSelf) {
            this.mComponent.getOrCreateCommonProps().alignSelf(alignSelf);
            return this.getThis();
        }

        public T positionType(@Nullable YogaPositionType positionType) {
            this.mComponent.getOrCreateCommonProps().positionType(positionType);
            return this.getThis();
        }

        public T flex(float flex) {
            this.mComponent.getOrCreateCommonProps().flex(flex);
            return this.getThis();
        }

        public T flexGrow(float flexGrow) {
            this.mComponent.getOrCreateCommonProps().flexGrow(flexGrow);
            return this.getThis();
        }

        public T flexShrink(float flexShrink) {
            this.mComponent.getOrCreateCommonProps().flexShrink(flexShrink);
            return this.getThis();
        }

        public T flexBasisPx(@Px int flexBasis) {
            this.mComponent.getOrCreateCommonProps().flexBasisPx(flexBasis);
            return this.getThis();
        }

        public T flexBasisPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().flexBasisPercent(percent);
            return this.getThis();
        }

        public T flexBasisAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.flexBasisPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T flexBasisAttr(@AttrRes int resId) {
            return this.flexBasisAttr(resId, 0);
        }

        public T flexBasisRes(@DimenRes int resId) {
            return this.flexBasisPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T flexBasisDip(@Dimension(unit=0) float flexBasis) {
            return this.flexBasisPx(this.mResourceResolver.dipsToPixels(flexBasis));
        }

        public T importantForAccessibility(int importantForAccessibility) {
            this.mComponent.getOrCreateCommonProps().importantForAccessibility(importantForAccessibility);
            return this.getThis();
        }

        public T duplicateParentState(boolean duplicateParentState) {
            this.mComponent.getOrCreateCommonProps().duplicateParentState(duplicateParentState);
            return this.getThis();
        }

        public T marginPx(@Nullable YogaEdge edge, @Px int margin) {
            this.mComponent.getOrCreateCommonProps().marginPx(edge, margin);
            return this.getThis();
        }

        public T marginPercent(@Nullable YogaEdge edge, float percent) {
            this.mComponent.getOrCreateCommonProps().marginPercent(edge, percent);
            return this.getThis();
        }

        public T marginAuto(@Nullable YogaEdge edge) {
            this.mComponent.getOrCreateCommonProps().marginAuto(edge);
            return this.getThis();
        }

        public T marginAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.marginPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T marginAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.marginAttr(edge, resId, 0);
        }

        public T marginRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.marginPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T marginDip(@Nullable YogaEdge edge, @Dimension(unit=0) float margin) {
            return this.marginPx(edge, this.mResourceResolver.dipsToPixels(margin));
        }

        public T paddingPx(@Nullable YogaEdge edge, @Px int padding) {
            this.mComponent.getOrCreateCommonProps().paddingPx(edge, padding);
            return this.getThis();
        }

        public T paddingPercent(@Nullable YogaEdge edge, float percent) {
            this.mComponent.getOrCreateCommonProps().paddingPercent(edge, percent);
            return this.getThis();
        }

        public T paddingAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.paddingPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T paddingAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.paddingAttr(edge, resId, 0);
        }

        public T paddingRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.paddingPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T paddingDip(@Nullable YogaEdge edge, @Dimension(unit=0) float padding) {
            return this.paddingPx(edge, this.mResourceResolver.dipsToPixels(padding));
        }

        public T border(@Nullable Border border) {
            this.mComponent.getOrCreateCommonProps().border(border);
            return this.getThis();
        }

        public T positionPx(@Nullable YogaEdge edge, @Px int position) {
            this.mComponent.getOrCreateCommonProps().positionPx(edge, position);
            return this.getThis();
        }

        public T positionPercent(@Nullable YogaEdge edge, float percent) {
            this.mComponent.getOrCreateCommonProps().positionPercent(edge, percent);
            return this.getThis();
        }

        public T positionAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.positionPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T positionAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.positionAttr(edge, resId, 0);
        }

        public T positionRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.positionPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T positionDip(@Nullable YogaEdge edge, @Dimension(unit=0) float position) {
            return this.positionPx(edge, this.mResourceResolver.dipsToPixels(position));
        }

        public T widthPx(@Px int width) {
            this.mComponent.getOrCreateCommonProps().widthPx(width);
            return this.getThis();
        }

        public T widthPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().widthPercent(percent);
            return this.getThis();
        }

        public T widthRes(@DimenRes int resId) {
            return this.widthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T widthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.widthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T widthAttr(@AttrRes int resId) {
            return this.widthAttr(resId, 0);
        }

        public T widthDip(@Dimension(unit=0) float width) {
            return this.widthPx(this.mResourceResolver.dipsToPixels(width));
        }

        public T minWidthPx(@Px int minWidth) {
            this.mComponent.getOrCreateCommonProps().minWidthPx(minWidth);
            return this.getThis();
        }

        public T minWidthPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().minWidthPercent(percent);
            return this.getThis();
        }

        public T minWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.minWidthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T minWidthAttr(@AttrRes int resId) {
            return this.minWidthAttr(resId, 0);
        }

        public T minWidthRes(@DimenRes int resId) {
            return this.minWidthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T minWidthDip(@Dimension(unit=0) float minWidth) {
            return this.minWidthPx(this.mResourceResolver.dipsToPixels(minWidth));
        }

        public T maxWidthPx(@Px int maxWidth) {
            this.mComponent.getOrCreateCommonProps().maxWidthPx(maxWidth);
            return this.getThis();
        }

        public T maxWidthPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().maxWidthPercent(percent);
            return this.getThis();
        }

        public T maxWidthAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.maxWidthPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T maxWidthAttr(@AttrRes int resId) {
            return this.maxWidthAttr(resId, 0);
        }

        public T maxWidthRes(@DimenRes int resId) {
            return this.maxWidthPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T maxWidthDip(@Dimension(unit=0) float maxWidth) {
            return this.maxWidthPx(this.mResourceResolver.dipsToPixels(maxWidth));
        }

        public T heightPx(@Px int height) {
            this.mComponent.getOrCreateCommonProps().heightPx(height);
            return this.getThis();
        }

        public T heightPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().heightPercent(percent);
            return this.getThis();
        }

        public T heightRes(@DimenRes int resId) {
            return this.heightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T heightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.heightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T heightAttr(@AttrRes int resId) {
            return this.heightAttr(resId, 0);
        }

        public T heightDip(@Dimension(unit=0) float height) {
            return this.heightPx(this.mResourceResolver.dipsToPixels(height));
        }

        public T minHeightPx(@Px int minHeight) {
            this.mComponent.getOrCreateCommonProps().minHeightPx(minHeight);
            return this.getThis();
        }

        public T minHeightPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().minHeightPercent(percent);
            return this.getThis();
        }

        public T minHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.minHeightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T minHeightAttr(@AttrRes int resId) {
            return this.minHeightAttr(resId, 0);
        }

        public T minHeightRes(@DimenRes int resId) {
            return this.minHeightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T minHeightDip(@Dimension(unit=0) float minHeight) {
            return this.minHeightPx(this.mResourceResolver.dipsToPixels(minHeight));
        }

        public T maxHeightPx(@Px int maxHeight) {
            this.mComponent.getOrCreateCommonProps().maxHeightPx(maxHeight);
            return this.getThis();
        }

        public T maxHeightPercent(float percent) {
            this.mComponent.getOrCreateCommonProps().maxHeightPercent(percent);
            return this.getThis();
        }

        public T maxHeightAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.maxHeightPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T maxHeightAttr(@AttrRes int resId) {
            return this.maxHeightAttr(resId, 0);
        }

        public T maxHeightRes(@DimenRes int resId) {
            return this.maxHeightPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T maxHeightDip(@Dimension(unit=0) float maxHeight) {
            return this.maxHeightPx(this.mResourceResolver.dipsToPixels(maxHeight));
        }

        public T aspectRatio(float aspectRatio) {
            this.mComponent.getOrCreateCommonProps().aspectRatio(aspectRatio);
            return this.getThis();
        }

        public T isReferenceBaseline(boolean isReferenceBaseline) {
            this.mComponent.getOrCreateCommonProps().isReferenceBaseline(isReferenceBaseline);
            return this.getThis();
        }

        public T touchExpansionPx(@Nullable YogaEdge edge, @Px int touchExpansion) {
            this.mComponent.getOrCreateCommonProps().touchExpansionPx(edge, touchExpansion);
            return this.getThis();
        }

        public T touchExpansionAttr(@Nullable YogaEdge edge, @AttrRes int resId, @DimenRes int defaultResId) {
            return this.touchExpansionPx(edge, this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T touchExpansionAttr(@Nullable YogaEdge edge, @AttrRes int resId) {
            return this.touchExpansionAttr(edge, resId, 0);
        }

        public T touchExpansionRes(@Nullable YogaEdge edge, @DimenRes int resId) {
            return this.touchExpansionPx(edge, this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T touchExpansionDip(@Nullable YogaEdge edge, @Dimension(unit=0) float touchExpansion) {
            return this.touchExpansionPx(edge, this.mResourceResolver.dipsToPixels(touchExpansion));
        }

        @Deprecated
        public T background(@Nullable Drawable background) {
            if (background instanceof ComparableDrawable || background == null) {
                return this.background((ComparableDrawable)background);
            }
            return this.background(DefaultComparableDrawable.create(background));
        }

        public T background(@Nullable ComparableDrawable background) {
            this.mComponent.getOrCreateCommonProps().background(background);
            return this.getThis();
        }

        public T backgroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
            return this.backgroundRes(this.mResourceResolver.resolveResIdAttr(resId, defaultResId));
        }

        public T backgroundAttr(@AttrRes int resId) {
            return this.backgroundAttr(resId, 0);
        }

        public T backgroundRes(@DrawableRes int resId) {
            if (resId == 0) {
                return this.background((ComparableDrawable)null);
            }
            return this.background(ComparableResDrawable.create(this.mContext.getAndroidContext(), resId));
        }

        public T backgroundColor(@ColorInt int backgroundColor) {
            return this.background(ComparableColorDrawable.create(backgroundColor));
        }

        public T backgroundColor(DynamicValue<Integer> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(7, value);
            return this.getThis();
        }

        public T foreground(@Nullable ComparableDrawable foreground) {
            this.mComponent.getOrCreateCommonProps().foreground(foreground);
            return this.getThis();
        }

        @Deprecated
        public T foreground(@Nullable Drawable foreground) {
            if (foreground instanceof ComparableDrawable || foreground == null) {
                return this.foreground((ComparableDrawable)foreground);
            }
            return this.foreground(foreground != null ? DefaultComparableDrawable.create(foreground) : null);
        }

        public T foregroundAttr(@AttrRes int resId, @DrawableRes int defaultResId) {
            return this.foregroundRes(this.mResourceResolver.resolveResIdAttr(resId, defaultResId));
        }

        public T foregroundAttr(@AttrRes int resId) {
            return this.foregroundAttr(resId, 0);
        }

        public T foregroundRes(@DrawableRes int resId) {
            if (resId == 0) {
                return this.foreground((ComparableDrawable)null);
            }
            return this.foreground(ComparableResDrawable.create(this.mContext.getAndroidContext(), resId));
        }

        public T foregroundColor(@ColorInt int foregroundColor) {
            return this.foreground(ComparableColorDrawable.create(foregroundColor));
        }

        public T wrapInView() {
            this.mComponent.getOrCreateCommonProps().wrapInView();
            return this.getThis();
        }

        public T clickHandler(@Nullable EventHandler<ClickEvent> clickHandler) {
            this.mComponent.getOrCreateCommonProps().clickHandler(clickHandler);
            return this.getThis();
        }

        public T longClickHandler(@Nullable EventHandler<LongClickEvent> longClickHandler) {
            this.mComponent.getOrCreateCommonProps().longClickHandler(longClickHandler);
            return this.getThis();
        }

        public T focusChangeHandler(@Nullable EventHandler<FocusChangedEvent> focusChangeHandler) {
            this.mComponent.getOrCreateCommonProps().focusChangeHandler(focusChangeHandler);
            return this.getThis();
        }

        public T touchHandler(@Nullable EventHandler<TouchEvent> touchHandler) {
            this.mComponent.getOrCreateCommonProps().touchHandler(touchHandler);
            return this.getThis();
        }

        public T interceptTouchHandler(@Nullable EventHandler<InterceptTouchEvent> interceptTouchHandler) {
            this.mComponent.getOrCreateCommonProps().interceptTouchHandler(interceptTouchHandler);
            return this.getThis();
        }

        public T focusable(boolean isFocusable) {
            this.mComponent.getOrCreateCommonProps().focusable(isFocusable);
            return this.getThis();
        }

        public T clickable(boolean isClickable) {
            this.mComponent.getOrCreateCommonProps().clickable(isClickable);
            return this.getThis();
        }

        public T enabled(boolean isEnabled) {
            this.mComponent.getOrCreateCommonProps().enabled(isEnabled);
            return this.getThis();
        }

        public T selected(boolean isSelected) {
            this.mComponent.getOrCreateCommonProps().selected(isSelected);
            return this.getThis();
        }

        public T visibleHeightRatio(float visibleHeightRatio) {
            this.mComponent.getOrCreateCommonProps().visibleHeightRatio(visibleHeightRatio);
            return this.getThis();
        }

        public T visibleWidthRatio(float visibleWidthRatio) {
            this.mComponent.getOrCreateCommonProps().visibleWidthRatio(visibleWidthRatio);
            return this.getThis();
        }

        public T visibleHandler(@Nullable EventHandler<VisibleEvent> visibleHandler) {
            this.mComponent.getOrCreateCommonProps().visibleHandler(visibleHandler);
            return this.getThis();
        }

        public T focusedHandler(@Nullable EventHandler<FocusedVisibleEvent> focusedHandler) {
            this.mComponent.getOrCreateCommonProps().focusedHandler(focusedHandler);
            return this.getThis();
        }

        public T unfocusedHandler(@Nullable EventHandler<UnfocusedVisibleEvent> unfocusedHandler) {
            this.mComponent.getOrCreateCommonProps().unfocusedHandler(unfocusedHandler);
            return this.getThis();
        }

        public T fullImpressionHandler(@Nullable EventHandler<FullImpressionVisibleEvent> fullImpressionHandler) {
            this.mComponent.getOrCreateCommonProps().fullImpressionHandler(fullImpressionHandler);
            return this.getThis();
        }

        public T invisibleHandler(@Nullable EventHandler<InvisibleEvent> invisibleHandler) {
            this.mComponent.getOrCreateCommonProps().invisibleHandler(invisibleHandler);
            return this.getThis();
        }

        public T visibilityChangedHandler(@Nullable EventHandler<VisibilityChangedEvent> visibilityChangedHandler) {
            this.mComponent.getOrCreateCommonProps().visibilityChangedHandler(visibilityChangedHandler);
            return this.getThis();
        }

        public T contentDescription(@Nullable CharSequence contentDescription) {
            this.mComponent.getOrCreateCommonProps().contentDescription(contentDescription);
            return this.getThis();
        }

        public T contentDescription(@StringRes int stringId) {
            return this.contentDescription(this.mContext.getAndroidContext().getResources().getString(stringId));
        }

        public T contentDescription(@StringRes int stringId, Object ... formatArgs) {
            return this.contentDescription(this.mContext.getAndroidContext().getResources().getString(stringId, formatArgs));
        }

        public T viewTag(@Nullable Object viewTag) {
            this.mComponent.getOrCreateCommonProps().viewTag(viewTag);
            return this.getThis();
        }

        public T viewTags(@Nullable SparseArray<Object> viewTags) {
            this.mComponent.getOrCreateCommonProps().viewTags(viewTags);
            return this.getThis();
        }

        public T shadowElevationPx(float shadowElevation) {
            this.mComponent.getOrCreateCommonProps().shadowElevationPx(shadowElevation);
            return this.getThis();
        }

        public T shadowElevationAttr(@AttrRes int resId, @DimenRes int defaultResId) {
            return this.shadowElevationPx(this.mResourceResolver.resolveDimenSizeAttr(resId, defaultResId));
        }

        public T shadowElevationAttr(@AttrRes int resId) {
            return this.shadowElevationAttr(resId, 0);
        }

        public T shadowElevationRes(@DimenRes int resId) {
            return this.shadowElevationPx(this.mResourceResolver.resolveDimenSizeRes(resId));
        }

        public T shadowElevationDip(@Dimension(unit=0) float shadowElevation) {
            return this.shadowElevationPx(this.mResourceResolver.dipsToPixels(shadowElevation));
        }

        public T outlineProvider(@Nullable ViewOutlineProvider outlineProvider) {
            this.mComponent.getOrCreateCommonProps().outlineProvider(outlineProvider);
            return this.getThis();
        }

        public T clipToOutline(boolean clipToOutline) {
            this.mComponent.getOrCreateCommonProps().clipToOutline(clipToOutline);
            return this.getThis();
        }

        public T clipChildren(boolean clipChildren) {
            this.mComponent.getOrCreateCommonProps().clipChildren(clipChildren);
            return this.getThis();
        }

        public T testKey(@Nullable String testKey) {
            this.mComponent.getOrCreateCommonProps().testKey(testKey);
            return this.getThis();
        }

        public T accessibilityRole(@Nullable String role) {
            this.mComponent.getOrCreateCommonProps().accessibilityRole(role);
            return this.getThis();
        }

        public T accessibilityRoleDescription(CharSequence roleDescription) {
            this.mComponent.getOrCreateCommonProps().accessibilityRoleDescription(roleDescription);
            return this.getThis();
        }

        public T accessibilityRoleDescription(@StringRes int stringId) {
            return this.accessibilityRoleDescription(this.mContext.getResources().getString(stringId));
        }

        public T accessibilityRoleDescription(@StringRes int stringId, Object ... formatArgs) {
            return this.accessibilityRoleDescription(this.mContext.getResources().getString(stringId, formatArgs));
        }

        public T dispatchPopulateAccessibilityEventHandler(@Nullable EventHandler<DispatchPopulateAccessibilityEventEvent> dispatchPopulateAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().dispatchPopulateAccessibilityEventHandler(dispatchPopulateAccessibilityEventHandler);
            return this.getThis();
        }

        public T onInitializeAccessibilityEventHandler(@Nullable EventHandler<OnInitializeAccessibilityEventEvent> onInitializeAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().onInitializeAccessibilityEventHandler(onInitializeAccessibilityEventHandler);
            return this.getThis();
        }

        public T onInitializeAccessibilityNodeInfoHandler(@Nullable EventHandler<OnInitializeAccessibilityNodeInfoEvent> onInitializeAccessibilityNodeInfoHandler) {
            this.mComponent.getOrCreateCommonProps().onInitializeAccessibilityNodeInfoHandler(onInitializeAccessibilityNodeInfoHandler);
            return this.getThis();
        }

        public T onPopulateAccessibilityEventHandler(@Nullable EventHandler<OnPopulateAccessibilityEventEvent> onPopulateAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().onPopulateAccessibilityEventHandler(onPopulateAccessibilityEventHandler);
            return this.getThis();
        }

        public T onRequestSendAccessibilityEventHandler(@Nullable EventHandler<OnRequestSendAccessibilityEventEvent> onRequestSendAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().onRequestSendAccessibilityEventHandler(onRequestSendAccessibilityEventHandler);
            return this.getThis();
        }

        public T performAccessibilityActionHandler(@Nullable EventHandler<PerformAccessibilityActionEvent> performAccessibilityActionHandler) {
            this.mComponent.getOrCreateCommonProps().performAccessibilityActionHandler(performAccessibilityActionHandler);
            return this.getThis();
        }

        public T sendAccessibilityEventHandler(@Nullable EventHandler<SendAccessibilityEventEvent> sendAccessibilityEventHandler) {
            this.mComponent.getOrCreateCommonProps().sendAccessibilityEventHandler(sendAccessibilityEventHandler);
            return this.getThis();
        }

        public T sendAccessibilityEventUncheckedHandler(@Nullable EventHandler<SendAccessibilityEventUncheckedEvent> sendAccessibilityEventUncheckedHandler) {
            this.mComponent.getOrCreateCommonProps().sendAccessibilityEventUncheckedHandler(sendAccessibilityEventUncheckedHandler);
            return this.getThis();
        }

        public T transitionKey(@Nullable String key) {
            this.mComponent.getOrCreateCommonProps().transitionKey(key);
            if (this.mComponent.getOrCreateCommonProps().getTransitionKeyType() == null) {
                this.transitionKeyType(Transition.DEFAULT_TRANSITION_KEY_TYPE);
            }
            return this.getThis();
        }

        public T transitionKeyType(Transition.TransitionKeyType type) {
            if (type == null) {
                throw new IllegalArgumentException("TransitionKeyType must not be null");
            }
            this.mComponent.getOrCreateCommonProps().transitionKeyType(type);
            return this.getThis();
        }

        public T alpha(float alpha) {
            this.mComponent.getOrCreateCommonProps().alpha(alpha);
            return this.getThis();
        }

        public T alpha(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(1, value);
            return this.getThis();
        }

        public T scale(float scale) {
            this.mComponent.getOrCreateCommonProps().scale(scale);
            return this.getThis();
        }

        public T scaleX(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(4, value);
            return this.getThis();
        }

        public T scaleY(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(5, value);
            return this.getThis();
        }

        public T translationX(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(2, value);
            return this.getThis();
        }

        public T translationY(DynamicValue<Float> value) {
            this.mComponent.getOrCreateCommonDynamicProps().put(3, value);
            return this.getThis();
        }

        public T rotation(float rotation) {
            this.mComponent.getOrCreateCommonProps().rotation(rotation);
            return this.getThis();
        }

        public T rotationX(float rotationX) {
            this.mComponent.getOrCreateCommonProps().rotationX(rotationX);
            return this.getThis();
        }

        public T rotationY(float rotationY) {
            this.mComponent.getOrCreateCommonProps().rotationY(rotationY);
            return this.getThis();
        }

        public T stateListAnimator(@Nullable StateListAnimator stateListAnimator) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.mComponent.getOrCreateCommonProps().stateListAnimator(stateListAnimator);
            }
            return this.getThis();
        }

        public T stateListAnimatorRes(@DrawableRes int resId) {
            if (Build.VERSION.SDK_INT >= 26) {
                return this.stateListAnimator(AnimatorInflater.loadStateListAnimator((Context)this.mContext.getAndroidContext(), (int)resId));
            }
            if (Build.VERSION.SDK_INT >= 21) {
                this.mComponent.getOrCreateCommonProps().stateListAnimatorRes(resId);
            }
            return this.getThis();
        }

        public T useHeightAsBaseline(boolean useHeightAsBaseline) {
            this.mComponent.getOrCreateCommonProps().useHeightAsBaseline(useHeightAsBaseline);
            return this.getThis();
        }

        public boolean hasClickHandlerSet() {
            return this.mComponent.hasClickHandlerSet();
        }

        public boolean hasBackgroundSet() {
            return this.mComponent.hasBackgroundSet();
        }

        private Component getOwner() {
            return this.mContext.getComponentScope();
        }
    }
}

