/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.Component;
import com.facebook.litho.ComponentContext;
import com.facebook.litho.ComponentLayout;
import com.facebook.litho.InternalNode;
import com.facebook.litho.annotations.Prop;
import com.facebook.yoga.YogaAlign;
import com.facebook.yoga.YogaFlexDirection;
import com.facebook.yoga.YogaJustify;
import com.facebook.yoga.YogaWrap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class Column
extends Component {
    @Nullable
    @Prop(optional=true)
    List<Component> children;
    @Nullable
    @Prop(optional=true)
    private YogaAlign alignItems;
    @Nullable
    @Prop(optional=true)
    private YogaAlign alignContent;
    @Nullable
    @Prop(optional=true)
    private YogaJustify justifyContent;
    @Nullable
    @Prop(optional=true)
    private YogaWrap wrap;
    @Prop(optional=true)
    private boolean reverse;

    private Column(String simpleName) {
        super(simpleName);
    }

    @Override
    protected boolean canResolve() {
        return true;
    }

    public static Builder create(ComponentContext context) {
        return Column.create(context, 0, 0, "Column");
    }

    public static Builder create(ComponentContext context, String simpleName) {
        return Column.create(context, 0, 0, simpleName);
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes) {
        return Column.create(context, defStyleAttr, defStyleRes, "Column");
    }

    public static Builder create(ComponentContext context, int defStyleAttr, int defStyleRes, String simpleName) {
        Builder builder = new Builder();
        builder.init(context, defStyleAttr, defStyleRes, new Column(simpleName));
        return builder;
    }

    @Override
    protected Component onCreateLayout(ComponentContext c) {
        return this;
    }

    @Override
    protected ComponentLayout resolve(ComponentContext c) {
        InternalNode node = c.newLayoutBuilder(0, 0).flexDirection(this.reverse ? YogaFlexDirection.COLUMN_REVERSE : YogaFlexDirection.COLUMN);
        if (this.alignItems != null) {
            node.alignItems(this.alignItems);
        }
        if (this.alignContent != null) {
            node.alignContent(this.alignContent);
        }
        if (this.justifyContent != null) {
            node.justifyContent(this.justifyContent);
        }
        if (this.wrap != null) {
            node.wrap(this.wrap);
        }
        if (this.children != null) {
            for (Component child : this.children) {
                if (c.wasLayoutCanceled()) {
                    return ComponentContext.NULL_LAYOUT;
                }
                if (c.wasLayoutInterrupted()) {
                    node.appendUnresolvedComponent(child);
                    continue;
                }
                node.child(child);
            }
        }
        return node;
    }

    @Override
    public boolean isEquivalentTo(Component other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Column column = (Column)other;
        if (this.getId() == column.getId()) {
            return true;
        }
        if (this.children != null) {
            if (column.children == null || this.children.size() != column.children.size()) {
                return false;
            }
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                if (this.children.get(i).isEquivalentTo(column.children.get(i))) continue;
                return false;
            }
        } else if (column.children != null) {
            return false;
        }
        if (this.alignItems != null ? !this.alignItems.equals((Object)column.alignItems) : column.alignItems != null) {
            return false;
        }
        if (this.alignContent != null ? !this.alignContent.equals((Object)column.alignContent) : column.alignContent != null) {
            return false;
        }
        if (this.justifyContent != null ? !this.justifyContent.equals((Object)column.justifyContent) : column.justifyContent != null) {
            return false;
        }
        return this.reverse == column.reverse;
    }

    public static class Builder
    extends Component.ContainerBuilder<Builder> {
        Column mColumn;
        ComponentContext mContext;

        private void init(ComponentContext context, int defStyleAttr, int defStyleRes, Column column) {
            super.init(context, defStyleAttr, defStyleRes, column);
            this.mColumn = column;
            this.mContext = context;
        }

        @Override
        public Builder child(@Nullable Component child) {
            if (child == null) {
                return this;
            }
            if (this.mColumn.children == null) {
                this.mColumn.children = new ArrayList<Component>();
            }
            this.mColumn.children.add(child);
            return this;
        }

        @Override
        public Builder child(@Nullable Component.Builder<?> child) {
            if (child == null) {
                return this;
            }
            return this.child(child.build());
        }

        @Override
        public Builder alignContent(YogaAlign alignContent) {
            this.mColumn.alignContent = alignContent;
            return this;
        }

        @Override
        public Builder alignItems(YogaAlign alignItems) {
            this.mColumn.alignItems = alignItems;
            return this;
        }

        @Override
        public Builder justifyContent(YogaJustify justifyContent) {
            this.mColumn.justifyContent = justifyContent;
            return this;
        }

        @Override
        public Builder wrap(YogaWrap wrap) {
            this.mColumn.wrap = wrap;
            return this;
        }

        @Override
        public Builder reverse(boolean reverse) {
            this.mColumn.reverse = reverse;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public Column build() {
            return this.mColumn;
        }
    }
}

