/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import com.facebook.litho.WorkingRange;

public class BoundaryWorkingRange
implements WorkingRange {
    private static final int OFFSET = 1;
    private final int mOffset;

    public BoundaryWorkingRange() {
        this(1);
    }

    public BoundaryWorkingRange(int offset) {
        this.mOffset = offset;
    }

    @Override
    public boolean shouldEnterRange(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        return BoundaryWorkingRange.isInRange(position, firstVisibleIndex, lastVisibleIndex, this.mOffset);
    }

    @Override
    public boolean shouldExitRange(int position, int firstVisibleIndex, int lastVisibleIndex, int firstFullyVisibleIndex, int lastFullyVisibleIndex) {
        return !BoundaryWorkingRange.isInRange(position, firstVisibleIndex, lastVisibleIndex, this.mOffset);
    }

    private static boolean isInRange(int position, int firstVisiblePosition, int lastVisiblePosition, int offset) {
        int lowerBound = firstVisiblePosition - offset;
        int upperBound = lastVisiblePosition + offset;
        return position >= lowerBound && position <= upperBound;
    }
}

