/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.litho.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

@ThreadSafe
public class AttachDetachHandler {
    @GuardedBy(value="this")
    @Nullable
    private Map<String, Component> mAttached;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAttached(@Nullable Map<String, Component> attachable) {
        Map<String, Component> toDetach;
        Map<String, Component> toAttach;
        Iterator<Component> iterator = this;
        synchronized (iterator) {
            toAttach = AttachDetachHandler.composeAttach(attachable, this.mAttached);
            toDetach = AttachDetachHandler.composeDetach(attachable, this.mAttached);
            this.mAttached = attachable != null ? new HashMap<String, Component>(attachable) : null;
        }
        if (toDetach != null) {
            for (Component component : toDetach.values()) {
                component.onDetached(component.getScopedContext());
            }
        }
        if (toAttach != null) {
            for (Component component : toAttach.values()) {
                component.onAttached(component.getScopedContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDetached() {
        ArrayList<Component> toDetach;
        AttachDetachHandler attachDetachHandler = this;
        synchronized (attachDetachHandler) {
            if (this.mAttached == null) {
                return;
            }
            toDetach = new ArrayList<Component>(this.mAttached.values());
            this.mAttached.clear();
        }
        int size = toDetach.size();
        for (int i = 0; i < size; ++i) {
            Component component = (Component)toDetach.get(i);
            component.onDetached(component.getScopedContext());
        }
    }

    @GuardedBy(value="this")
    @Nullable
    private static Map<String, Component> composeAttach(@Nullable Map<String, Component> attachable, @Nullable Map<String, Component> attached) {
        HashMap<String, Component> toAttach = null;
        if (attachable != null) {
            toAttach = new HashMap<String, Component>(attachable);
            if (attached != null) {
                toAttach.keySet().removeAll(attached.keySet());
            }
        }
        return toAttach;
    }

    @GuardedBy(value="this")
    @Nullable
    private static Map<String, Component> composeDetach(@Nullable Map<String, Component> attachable, @Nullable Map<String, Component> attached) {
        HashMap<String, Component> toDetach = null;
        if (attached != null) {
            toDetach = new HashMap<String, Component>(attached);
            if (attachable != null) {
                toDetach.keySet().removeAll(attachable.keySet());
            }
        }
        return toDetach;
    }

    @VisibleForTesting
    @Nullable
    Map<String, Component> getAttached() {
        return this.mAttached;
    }
}

