/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.litho;

import android.util.Log;
import com.facebook.litho.LayoutOutput;
import com.facebook.litho.LayoutState;
import com.facebook.litho.config.ComponentsConfiguration;

public class AnimationsDebug {
    public static final boolean ENABLED = ComponentsConfiguration.isEndToEndTestRun;
    static final String TAG = "LithoAnimationDebug";

    static void debugPrintLayoutState(LayoutState layoutState) {
        if (!ENABLED) {
            return;
        }
        for (int i = 0; i < layoutState.getMountableOutputCount(); ++i) {
            LayoutOutput output = layoutState.getMountableOutputAt(i);
            Log.d((String)TAG, (String)("" + i + " [" + output.getId() + "] (" + output.getTransitionId() + ") host => (" + output.getHostMarker() + ")"));
        }
    }

    static void debugPrintAnimationLockedIndices(LayoutState layoutState, int[] animationLockedIndices) {
        if (!ENABLED) {
            return;
        }
        if (animationLockedIndices != null) {
            for (int i = 0; i < animationLockedIndices.length; ++i) {
                LayoutOutput output = layoutState.getMountableOutputAt(i);
                Log.d((String)TAG, (String)("" + i + " [" + output.getId() + "] (" + output.getTransitionId() + ") host => (" + output.getHostMarker() + "), locked ref count: " + animationLockedIndices[i]));
            }
        }
    }
}

