/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.CommentType;
import com.facebook.ktfmt.kdoc.CommentTypeKt;
import com.facebook.ktfmt.kdoc.FormattingTask;
import com.facebook.ktfmt.kdoc.KDocFormattingOptions;
import com.facebook.ktfmt.kdoc.Paragraph;
import com.facebook.ktfmt.kdoc.ParagraphList;
import com.facebook.ktfmt.kdoc.ParagraphListBuilder;
import com.facebook.ktfmt.kdoc.UtilitiesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocFormatter;", "", "options", "Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;", "(Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;)V", "reformatComment", "", "task", "Lcom/facebook/ktfmt/kdoc/FormattingTask;", "comment", "initialIndent", "stripTrailingSpaces", "", "lineComment", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ktfmt"})
public final class KDocFormatter {
    @NotNull
    private final KDocFormattingOptions options;

    public KDocFormatter(@NotNull KDocFormattingOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
    }

    @NotNull
    public final String reformatComment(@NotNull String comment, @NotNull String initialIndent) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)initialIndent, (String)"initialIndent");
        return this.reformatComment(new FormattingTask(this.options, comment, initialIndent, null, null, null, 56, null));
    }

    @NotNull
    public final String reformatComment(@NotNull FormattingTask task) {
        String string;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String indent = task.getSecondaryIndent();
        int indentSize = UtilitiesKt.getIndentSize(indent, this.options);
        int firstIndentSize = UtilitiesKt.getIndentSize(task.getInitialIndent(), this.options);
        String comment = task.getComment();
        boolean lineComment = CommentTypeKt.isLineComment(comment);
        boolean blockComment = CommentTypeKt.isBlockComment(comment);
        ParagraphList paragraphs = new ParagraphListBuilder(comment, this.options, task).scan(indentSize);
        CommentType commentType = task.getType();
        String lineSeparator = '\n' + indent + commentType.getLinePrefix();
        String prefix = commentType.getPrefix();
        boolean it = this.options.getCollapseSingleLine();
        boolean bl2 = false;
        boolean collapseLine = this.options.getAlternate() ? !it : it;
        if (paragraphs.isSingleParagraph() && collapseLine && !lineComment) {
            String suffix;
            String string2;
            Paragraph paragraph = (Paragraph)CollectionsKt.firstOrNull((Iterable)paragraphs);
            if (paragraph == null) {
                string2 = "";
            } else {
                String bl2 = paragraph.getText();
                if (bl2 == null) {
                    string2 = "";
                } else {
                    string2 = ((Object)StringsKt.trim((CharSequence)bl2)).toString();
                    if (string2 == null) {
                        string2 = "";
                    }
                }
            }
            String trimmed = string2;
            int width = Math.min(this.options.getMaxLineWidth() - firstIndentSize - commentType.singleLineOverhead(), this.options.getMaxCommentWidth());
            String string3 = suffix = ((CharSequence)commentType.getSuffix()).length() == 0 ? "" : Intrinsics.stringPlus((String)" ", (Object)commentType.getSuffix());
            if (trimmed.length() <= width) {
                return prefix + ' ' + trimmed + suffix;
            }
            if (indentSize < firstIndentSize) {
                int nextLineWidth = Math.min(this.options.getMaxLineWidth() - indentSize - commentType.singleLineOverhead(), this.options.getMaxCommentWidth());
                if (trimmed.length() <= nextLineWidth) {
                    return prefix + ' ' + trimmed + suffix;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (lineComment) {
            sb.append(' ');
        } else {
            sb.append(lineSeparator);
        }
        for (Paragraph paragraph : paragraphs) {
            if (paragraph.getSeparate()) {
                this.stripTrailingSpaces(lineComment, sb);
                sb.append(lineSeparator);
            }
            String text = paragraph.getText();
            if (paragraph.getPreformatted() || paragraph.getTable()) {
                sb.append(text);
                this.stripTrailingSpaces(lineComment, sb);
                sb.append(lineSeparator);
                continue;
            }
            int lineWithoutIndent = this.options.getMaxLineWidth() - commentType.lineOverhead();
            int quoteAdjustment = paragraph.getQuoted() ? 2 : 0;
            int maxLineWidth = Math.min(this.options.getMaxCommentWidth(), lineWithoutIndent - indentSize) - quoteAdjustment;
            int firstMaxLineWidth = StringsKt.indexOf$default((CharSequence)sb, (char)'\n', (int)0, (boolean)false, (int)6, null) == -1 ? Math.min(this.options.getMaxCommentWidth(), lineWithoutIndent - firstIndentSize) - quoteAdjustment : maxLineWidth;
            List<String> lines = paragraph.reflow(firstMaxLineWidth, maxLineWidth);
            boolean first = true;
            String hangingIndent = paragraph.getHangingIndent();
            for (String line2 : lines) {
                sb.append(paragraph.getIndent());
                if (first && !paragraph.getContinuation()) {
                    first = false;
                } else {
                    sb.append(hangingIndent);
                }
                if (paragraph.getQuoted()) {
                    sb.append("> ");
                }
                if (((CharSequence)line2).length() == 0) {
                    this.stripTrailingSpaces(lineComment, sb);
                } else {
                    sb.append(line2);
                }
                sb.append(lineSeparator);
            }
        }
        if (!lineComment) {
            if (StringsKt.endsWith$default((CharSequence)sb, (CharSequence)"* ", (boolean)false, (int)2, null)) {
                sb.setLength(sb.length() - 2);
            }
            sb.append("*/");
        } else if (StringsKt.endsWith$default((CharSequence)sb, (CharSequence)lineSeparator, (boolean)false, (int)2, null)) {
            StringsKt.removeSuffix((CharSequence)sb, (CharSequence)lineSeparator);
        }
        if (lineComment) {
            string = ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((CharSequence)StringsKt.trim((CharSequence)sb), (CharSequence)"//"))).toString();
        } else if (blockComment) {
            String paragraph = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)paragraph, (String)"sb.toString()");
            string = StringsKt.replace$default((String)paragraph, (String)Intrinsics.stringPlus((String)lineSeparator, (Object)"\n"), (String)"\n\n", (boolean)false, (int)4, null);
        } else {
            String paragraph = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)paragraph, (String)"{\n          sb.toString()\n        }");
            string = paragraph;
        }
        String formatted = string;
        int separatorIndex = StringsKt.indexOf$default((CharSequence)comment, (char)'\n', (int)0, (boolean)false, (int)6, null);
        return separatorIndex > 0 && comment.charAt(separatorIndex - 1) == '\r' ? StringsKt.replace$default((String)formatted, (String)"\n", (String)"\r\n", (boolean)false, (int)4, null) : formatted;
    }

    private final void stripTrailingSpaces(boolean lineComment, StringBuilder sb) {
        if (!lineComment && StringsKt.endsWith$default((CharSequence)sb, (CharSequence)"* ", (boolean)false, (int)2, null)) {
            sb.setLength(sb.length() - 1);
        } else if (lineComment && StringsKt.endsWith$default((CharSequence)sb, (CharSequence)"// ", (boolean)false, (int)2, null)) {
            sb.setLength(sb.length() - 1);
        }
    }
}

