/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.webpsupport;

import android.annotation.SuppressLint;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.Build;
import android.util.TypedValue;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.webp.BitmapCreator;
import com.facebook.common.webp.WebpBitmapFactory;
import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imagepipeline.nativecode.StaticWebpNativeLoader;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

@DoNotStrip
public class WebpBitmapFactoryImpl
implements WebpBitmapFactory {
    private static final int HEADER_SIZE = 20;
    private static final int IN_TEMP_BUFFER_SIZE = 8192;
    public static final boolean IN_BITMAP_SUPPORTED = Build.VERSION.SDK_INT >= 11;
    private static WebpBitmapFactory.WebpErrorLogger mWebpErrorLogger;
    private static BitmapCreator mBitmapCreator;

    public void setBitmapCreator(BitmapCreator bitmapCreator) {
        mBitmapCreator = bitmapCreator;
    }

    private static InputStream wrapToMarkSupportedStream(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream, 20);
        }
        return inputStream;
    }

    private static byte[] getWebpHeader(InputStream inputStream, BitmapFactory.Options opts) {
        inputStream.mark(20);
        byte[] header = opts != null && opts.inTempStorage != null && opts.inTempStorage.length >= 20 ? opts.inTempStorage : new byte[20];
        try {
            inputStream.read(header, 0, 20);
            inputStream.reset();
        }
        catch (IOException exp) {
            return null;
        }
        return header;
    }

    private static void setDensityFromOptions(Bitmap outputBitmap, BitmapFactory.Options opts) {
        if (outputBitmap == null || opts == null) {
            return;
        }
        int density = opts.inDensity;
        if (density != 0) {
            outputBitmap.setDensity(density);
            int targetDensity = opts.inTargetDensity;
            if (targetDensity == 0 || density == targetDensity || density == opts.inScreenDensity) {
                return;
            }
            if (opts.inScaled) {
                outputBitmap.setDensity(targetDensity);
            }
        } else if (IN_BITMAP_SUPPORTED && opts.inBitmap != null) {
            outputBitmap.setDensity(160);
        }
    }

    public void setWebpErrorLogger(WebpBitmapFactory.WebpErrorLogger webpErrorLogger) {
        mWebpErrorLogger = webpErrorLogger;
    }

    public Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        return WebpBitmapFactoryImpl.hookDecodeFileDescriptor(fd, outPadding, opts);
    }

    public Bitmap decodeStream(InputStream inputStream, Rect outPadding, BitmapFactory.Options opts) {
        return WebpBitmapFactoryImpl.hookDecodeStream(inputStream, outPadding, opts);
    }

    public Bitmap decodeFile(String pathName, BitmapFactory.Options opts) {
        return WebpBitmapFactoryImpl.hookDecodeFile(pathName, opts);
    }

    public Bitmap decodeByteArray(byte[] array, int offset, int length, BitmapFactory.Options opts) {
        return WebpBitmapFactoryImpl.hookDecodeByteArray(array, offset, length, opts);
    }

    @DoNotStrip
    public static Bitmap hookDecodeByteArray(byte[] array, int offset, int length, BitmapFactory.Options opts) {
        Bitmap bitmap;
        StaticWebpNativeLoader.ensure();
        if (WebpSupportStatus.sIsWebpSupportRequired && WebpSupportStatus.isWebpHeader((byte[])array, (int)offset, (int)length)) {
            bitmap = WebpBitmapFactoryImpl.nativeDecodeByteArray(array, offset, length, opts, WebpBitmapFactoryImpl.getScaleFromOptions(opts), WebpBitmapFactoryImpl.getInTempStorageFromOptions(opts));
            if (bitmap == null) {
                WebpBitmapFactoryImpl.sendWebpErrorLog("webp_direct_decode_array");
            }
            WebpBitmapFactoryImpl.setWebpBitmapOptions(bitmap, opts);
        } else {
            bitmap = WebpBitmapFactoryImpl.originalDecodeByteArray(array, offset, length, opts);
            if (bitmap == null) {
                WebpBitmapFactoryImpl.sendWebpErrorLog("webp_direct_decode_array_failed_on_no_webp");
            }
        }
        return bitmap;
    }

    @DoNotStrip
    private static Bitmap originalDecodeByteArray(byte[] array, int offset, int length, BitmapFactory.Options opts) {
        return BitmapFactory.decodeByteArray((byte[])array, (int)offset, (int)length, (BitmapFactory.Options)opts);
    }

    @DoNotStrip
    public static Bitmap hookDecodeByteArray(byte[] array, int offset, int length) {
        return WebpBitmapFactoryImpl.hookDecodeByteArray(array, offset, length, null);
    }

    @DoNotStrip
    private static Bitmap originalDecodeByteArray(byte[] array, int offset, int length) {
        return BitmapFactory.decodeByteArray((byte[])array, (int)offset, (int)length);
    }

    @DoNotStrip
    public static Bitmap hookDecodeStream(InputStream inputStream, Rect outPadding, BitmapFactory.Options opts) {
        Bitmap bitmap;
        StaticWebpNativeLoader.ensure();
        inputStream = WebpBitmapFactoryImpl.wrapToMarkSupportedStream(inputStream);
        byte[] header = WebpBitmapFactoryImpl.getWebpHeader(inputStream, opts);
        if (WebpSupportStatus.sIsWebpSupportRequired && WebpSupportStatus.isWebpHeader((byte[])header, (int)0, (int)20)) {
            bitmap = WebpBitmapFactoryImpl.nativeDecodeStream(inputStream, opts, WebpBitmapFactoryImpl.getScaleFromOptions(opts), WebpBitmapFactoryImpl.getInTempStorageFromOptions(opts));
            if (bitmap == null) {
                WebpBitmapFactoryImpl.sendWebpErrorLog("webp_direct_decode_stream");
            }
            WebpBitmapFactoryImpl.setWebpBitmapOptions(bitmap, opts);
            WebpBitmapFactoryImpl.setPaddingDefaultValues(outPadding);
        } else {
            bitmap = WebpBitmapFactoryImpl.originalDecodeStream(inputStream, outPadding, opts);
            if (bitmap == null) {
                WebpBitmapFactoryImpl.sendWebpErrorLog("webp_direct_decode_stream_failed_on_no_webp");
            }
        }
        return bitmap;
    }

    @DoNotStrip
    private static Bitmap originalDecodeStream(InputStream inputStream, Rect outPadding, BitmapFactory.Options opts) {
        return BitmapFactory.decodeStream((InputStream)inputStream, (Rect)outPadding, (BitmapFactory.Options)opts);
    }

    @DoNotStrip
    public static Bitmap hookDecodeStream(InputStream inputStream) {
        return WebpBitmapFactoryImpl.hookDecodeStream(inputStream, null, null);
    }

    @DoNotStrip
    private static Bitmap originalDecodeStream(InputStream inputStream) {
        return BitmapFactory.decodeStream((InputStream)inputStream);
    }

    @DoNotStrip
    public static Bitmap hookDecodeFile(String pathName, BitmapFactory.Options opts) {
        Bitmap bitmap = null;
        try (FileInputStream stream = new FileInputStream(pathName);){
            bitmap = WebpBitmapFactoryImpl.hookDecodeStream(stream, null, opts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    @DoNotStrip
    public static Bitmap hookDecodeFile(String pathName) {
        return WebpBitmapFactoryImpl.hookDecodeFile(pathName, null);
    }

    @DoNotStrip
    public static Bitmap hookDecodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        if (opts == null) {
            opts = new BitmapFactory.Options();
        }
        if (opts.inDensity == 0 && value != null) {
            int density = value.density;
            if (density == 0) {
                opts.inDensity = 160;
            } else if (density != 65535) {
                opts.inDensity = density;
            }
        }
        if (opts.inTargetDensity == 0 && res != null) {
            opts.inTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        return WebpBitmapFactoryImpl.hookDecodeStream(is, pad, opts);
    }

    @DoNotStrip
    private static Bitmap originalDecodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        return BitmapFactory.decodeResourceStream((Resources)res, (TypedValue)value, (InputStream)is, (Rect)pad, (BitmapFactory.Options)opts);
    }

    @DoNotStrip
    public static Bitmap hookDecodeResource(Resources res, int id, BitmapFactory.Options opts) {
        Bitmap bm = null;
        TypedValue value = new TypedValue();
        try (InputStream is = res.openRawResource(id, value);){
            bm = WebpBitmapFactoryImpl.hookDecodeResourceStream(res, value, is, null, opts);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IN_BITMAP_SUPPORTED && bm == null && opts != null && opts.inBitmap != null) {
            throw new IllegalArgumentException("Problem decoding into existing bitmap");
        }
        return bm;
    }

    @DoNotStrip
    private static Bitmap originalDecodeResource(Resources res, int id, BitmapFactory.Options opts) {
        return BitmapFactory.decodeResource((Resources)res, (int)id, (BitmapFactory.Options)opts);
    }

    @DoNotStrip
    public static Bitmap hookDecodeResource(Resources res, int id) {
        return WebpBitmapFactoryImpl.hookDecodeResource(res, id, null);
    }

    @DoNotStrip
    private static Bitmap originalDecodeResource(Resources res, int id) {
        return BitmapFactory.decodeResource((Resources)res, (int)id);
    }

    @DoNotStrip
    private static boolean setOutDimensions(BitmapFactory.Options options, int imageWidth, int imageHeight) {
        if (options != null && options.inJustDecodeBounds) {
            options.outWidth = imageWidth;
            options.outHeight = imageHeight;
            return true;
        }
        return false;
    }

    @DoNotStrip
    private static void setPaddingDefaultValues(@Nullable Rect padding) {
        if (padding != null) {
            padding.top = -1;
            padding.left = -1;
            padding.bottom = -1;
            padding.right = -1;
        }
    }

    @DoNotStrip
    private static void setBitmapSize(@Nullable BitmapFactory.Options options, int width, int height) {
        if (options != null) {
            options.outWidth = width;
            options.outHeight = height;
        }
    }

    @DoNotStrip
    private static Bitmap originalDecodeFile(String pathName, BitmapFactory.Options opts) {
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)opts);
    }

    @DoNotStrip
    private static Bitmap originalDecodeFile(String pathName) {
        return BitmapFactory.decodeFile((String)pathName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DoNotStrip
    public static Bitmap hookDecodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        Bitmap bitmap;
        StaticWebpNativeLoader.ensure();
        boolean isWebp = false;
        long originalSeekPosition = WebpBitmapFactoryImpl.nativeSeek(fd, 0L, false);
        if (originalSeekPosition != -1L) {
            InputStream inputStream = WebpBitmapFactoryImpl.wrapToMarkSupportedStream(new FileInputStream(fd));
            try {
                byte[] header = WebpBitmapFactoryImpl.getWebpHeader(inputStream, opts);
                if (WebpSupportStatus.sIsWebpSupportRequired && WebpSupportStatus.isWebpHeader((byte[])header, (int)0, (int)20)) {
                    bitmap = WebpBitmapFactoryImpl.nativeDecodeStream(inputStream, opts, WebpBitmapFactoryImpl.getScaleFromOptions(opts), WebpBitmapFactoryImpl.getInTempStorageFromOptions(opts));
                    if (bitmap == null) {
                        WebpBitmapFactoryImpl.sendWebpErrorLog("webp_direct_decode_fd");
                    }
                    WebpBitmapFactoryImpl.setPaddingDefaultValues(outPadding);
                    WebpBitmapFactoryImpl.setWebpBitmapOptions(bitmap, opts);
                    return bitmap;
                }
                WebpBitmapFactoryImpl.nativeSeek(fd, originalSeekPosition, true);
                bitmap = WebpBitmapFactoryImpl.originalDecodeFileDescriptor(fd, outPadding, opts);
                if (bitmap != null) return bitmap;
                WebpBitmapFactoryImpl.sendWebpErrorLog("webp_direct_decode_fd_failed_on_no_webp");
                return bitmap;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        bitmap = WebpBitmapFactoryImpl.hookDecodeStream(new FileInputStream(fd), outPadding, opts);
        WebpBitmapFactoryImpl.setPaddingDefaultValues(outPadding);
        return bitmap;
    }

    @DoNotStrip
    private static Bitmap originalDecodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, (Rect)outPadding, (BitmapFactory.Options)opts);
    }

    @DoNotStrip
    public static Bitmap hookDecodeFileDescriptor(FileDescriptor fd) {
        return WebpBitmapFactoryImpl.hookDecodeFileDescriptor(fd, null, null);
    }

    @DoNotStrip
    private static Bitmap originalDecodeFileDescriptor(FileDescriptor fd) {
        return BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
    }

    private static void setWebpBitmapOptions(Bitmap bitmap, BitmapFactory.Options opts) {
        WebpBitmapFactoryImpl.setDensityFromOptions(bitmap, opts);
        if (opts != null) {
            opts.outMimeType = "image/webp";
        }
    }

    @DoNotStrip
    @SuppressLint(value={"NewApi"})
    private static boolean shouldPremultiply(BitmapFactory.Options options) {
        if (Build.VERSION.SDK_INT >= 19 && options != null) {
            return options.inPremultiplied;
        }
        return true;
    }

    @DoNotStrip
    private static Bitmap createBitmap(int width, int height, BitmapFactory.Options options) {
        if (IN_BITMAP_SUPPORTED && options != null && options.inBitmap != null && options.inBitmap.isMutable()) {
            return options.inBitmap;
        }
        return mBitmapCreator.createNakedBitmap(width, height, Bitmap.Config.ARGB_8888);
    }

    @DoNotStrip
    private static native Bitmap nativeDecodeStream(InputStream var0, BitmapFactory.Options var1, float var2, byte[] var3);

    @DoNotStrip
    private static native Bitmap nativeDecodeByteArray(byte[] var0, int var1, int var2, BitmapFactory.Options var3, float var4, byte[] var5);

    @DoNotStrip
    private static native long nativeSeek(FileDescriptor var0, long var1, boolean var3);

    @DoNotStrip
    private static byte[] getInTempStorageFromOptions(@Nullable BitmapFactory.Options options) {
        if (options != null && options.inTempStorage != null) {
            return options.inTempStorage;
        }
        return new byte[8192];
    }

    @DoNotStrip
    private static float getScaleFromOptions(BitmapFactory.Options options) {
        float scale = 1.0f;
        if (options != null) {
            int sampleSize = options.inSampleSize;
            if (sampleSize > 1) {
                scale = 1.0f / (float)sampleSize;
            }
            if (options.inScaled) {
                int density = options.inDensity;
                int targetDensity = options.inTargetDensity;
                int screenDensity = options.inScreenDensity;
                if (density != 0 && targetDensity != 0 && density != screenDensity) {
                    scale = (float)targetDensity / (float)density;
                }
            }
        }
        return scale;
    }

    private static void sendWebpErrorLog(String message) {
        if (mWebpErrorLogger != null) {
            mWebpErrorLogger.onWebpErrorLog(message, "decoding_failure");
        }
    }
}

