/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.ColorSpace;
import android.graphics.Rect;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pools;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.DecodeBufferHelper;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.streams.LimitedInputStream;
import com.facebook.common.streams.TailAppendingInputStream;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.DummyBitmapPool;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import com.facebook.imagepipeline.platform.PlatformDecoderOptions;
import com.facebook.imagepipeline.platform.PreverificationHelper;
import com.facebook.infer.annotation.Nullsafe;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class DefaultDecoder
implements PlatformDecoder {
    private static final Class<?> TAG = DefaultDecoder.class;
    private final BitmapPool mBitmapPool;
    private boolean mAvoidPoolGet;
    private boolean mAvoidPoolRelease;
    @Nullable
    private final PreverificationHelper mPreverificationHelper = Build.VERSION.SDK_INT >= 26 ? new PreverificationHelper() : null;
    @VisibleForTesting
    final Pools.Pool<ByteBuffer> mDecodeBuffers;
    private static final byte[] EOI_TAIL = new byte[]{-1, -39};

    public DefaultDecoder(BitmapPool bitmapPool, Pools.Pool<ByteBuffer> decodeBuffers, PlatformDecoderOptions platformDecoderOptions) {
        this.mBitmapPool = bitmapPool;
        if (bitmapPool instanceof DummyBitmapPool) {
            this.mAvoidPoolGet = platformDecoderOptions.getAvoidPoolGet();
            this.mAvoidPoolRelease = platformDecoderOptions.getAvoidPoolRelease();
        }
        this.mDecodeBuffers = decodeBuffers;
    }

    @Override
    @Nullable
    public CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode) {
        return this.decodeFromEncodedImageWithColorSpace(encodedImage, bitmapConfig, regionToDecode, null);
    }

    @Override
    @Nullable
    public CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode, int length) {
        return this.decodeJPEGFromEncodedImageWithColorSpace(encodedImage, bitmapConfig, regionToDecode, length, null);
    }

    @Override
    @Nullable
    public CloseableReference<Bitmap> decodeFromEncodedImageWithColorSpace(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode, @Nullable ColorSpace colorSpace) {
        BitmapFactory.Options options = DefaultDecoder.getDecodeOptionsForStream(encodedImage, bitmapConfig, this.mAvoidPoolGet);
        boolean retryOnFail = options.inPreferredConfig != Bitmap.Config.ARGB_8888;
        try {
            InputStream s = (InputStream)Preconditions.checkNotNull((Object)encodedImage.getInputStream());
            return this.decodeFromStream(s, options, regionToDecode, colorSpace);
        }
        catch (RuntimeException re) {
            if (retryOnFail) {
                return this.decodeFromEncodedImageWithColorSpace(encodedImage, Bitmap.Config.ARGB_8888, regionToDecode, colorSpace);
            }
            throw re;
        }
    }

    @Override
    @Nullable
    public CloseableReference<Bitmap> decodeJPEGFromEncodedImageWithColorSpace(EncodedImage encodedImage, Bitmap.Config bitmapConfig, @Nullable Rect regionToDecode, int length, @Nullable ColorSpace colorSpace) {
        boolean isJpegComplete = encodedImage.isCompleteAt(length);
        BitmapFactory.Options options = DefaultDecoder.getDecodeOptionsForStream(encodedImage, bitmapConfig, this.mAvoidPoolGet);
        InputStream jpegDataStream = encodedImage.getInputStream();
        Preconditions.checkNotNull((Object)jpegDataStream);
        if (encodedImage.getSize() > length) {
            jpegDataStream = new LimitedInputStream(jpegDataStream, length);
        }
        if (!isJpegComplete) {
            jpegDataStream = new TailAppendingInputStream(jpegDataStream, EOI_TAIL);
        }
        boolean retryOnFail = options.inPreferredConfig != Bitmap.Config.ARGB_8888;
        try {
            CloseableReference<Bitmap> closeableReference = this.decodeFromStream(jpegDataStream, options, regionToDecode, colorSpace);
            return closeableReference;
        }
        catch (RuntimeException re) {
            if (retryOnFail) {
                CloseableReference<Bitmap> closeableReference = this.decodeJPEGFromEncodedImageWithColorSpace(encodedImage, Bitmap.Config.ARGB_8888, regionToDecode, length, colorSpace);
                return closeableReference;
            }
            throw re;
        }
        finally {
            try {
                jpegDataStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    protected CloseableReference<Bitmap> decodeStaticImageFromStream(InputStream inputStream, BitmapFactory.Options options, @Nullable Rect regionToDecode) {
        return this.decodeFromStream(inputStream, options, regionToDecode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private CloseableReference<Bitmap> decodeFromStream(InputStream inputStream, BitmapFactory.Options options, @Nullable Rect regionToDecode, @Nullable ColorSpace colorSpace) {
        Preconditions.checkNotNull((Object)inputStream);
        int targetWidth = options.outWidth;
        int targetHeight = options.outHeight;
        if (regionToDecode != null) {
            targetWidth = regionToDecode.width() / options.inSampleSize;
            targetHeight = regionToDecode.height() / options.inSampleSize;
        }
        Bitmap bitmapToReuse = null;
        boolean shouldUseHardwareBitmapConfig = false;
        if (Build.VERSION.SDK_INT >= 26) {
            boolean bl = shouldUseHardwareBitmapConfig = this.mPreverificationHelper != null && this.mPreverificationHelper.shouldUseHardwareBitmapConfig(options.inPreferredConfig);
        }
        if (regionToDecode == null && shouldUseHardwareBitmapConfig) {
            options.inMutable = false;
        } else {
            int sizeInBytes;
            if (regionToDecode != null && shouldUseHardwareBitmapConfig) {
                options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            }
            if (!this.mAvoidPoolGet && (bitmapToReuse = (Bitmap)this.mBitmapPool.get(sizeInBytes = this.getBitmapSize(targetWidth, targetHeight, options))) == null) {
                throw new NullPointerException("BitmapPool.get returned null");
            }
        }
        options.inBitmap = bitmapToReuse;
        if (Build.VERSION.SDK_INT >= 26) {
            options.inPreferredColorSpace = colorSpace == null ? ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB) : colorSpace;
        }
        Bitmap decodedBitmap = null;
        ByteBuffer byteBuffer = (ByteBuffer)this.mDecodeBuffers.acquire();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(DecodeBufferHelper.getRecommendedDecodeBufferSize());
        }
        try {
            options.inTempStorage = byteBuffer.array();
            if (Build.VERSION.SDK_INT >= 19 && regionToDecode != null && bitmapToReuse != null && options.inPreferredConfig != null) {
                BitmapRegionDecoder bitmapRegionDecoder = null;
                try {
                    bitmapToReuse.reconfigure(targetWidth, targetHeight, options.inPreferredConfig);
                    bitmapRegionDecoder = BitmapRegionDecoder.newInstance((InputStream)inputStream, (boolean)true);
                    if (bitmapRegionDecoder != null) {
                        decodedBitmap = bitmapRegionDecoder.decodeRegion(regionToDecode, options);
                    }
                }
                catch (IOException e) {
                    FLog.e(TAG, (String)"Could not decode region %s, decoding full bitmap instead.", (Object[])new Object[]{regionToDecode});
                }
                finally {
                    if (bitmapRegionDecoder != null) {
                        bitmapRegionDecoder.recycle();
                    }
                }
            }
            if (decodedBitmap == null) {
                decodedBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
        }
        catch (IllegalArgumentException e) {
            if (bitmapToReuse != null) {
                this.mBitmapPool.release(bitmapToReuse);
            }
            try {
                inputStream.reset();
                Bitmap naiveDecodedBitmap = BitmapFactory.decodeStream((InputStream)inputStream);
                if (naiveDecodedBitmap == null) {
                    throw e;
                }
                CloseableReference closeableReference = CloseableReference.of((Object)naiveDecodedBitmap, (ResourceReleaser)SimpleBitmapReleaser.getInstance());
                return closeableReference;
            }
            catch (IOException re) {
                throw e;
            }
        }
        catch (RuntimeException re) {
            if (bitmapToReuse != null) {
                this.mBitmapPool.release(bitmapToReuse);
            }
            throw re;
        }
        finally {
            this.mDecodeBuffers.release((Object)byteBuffer);
        }
        if (bitmapToReuse != null && bitmapToReuse != decodedBitmap) {
            this.mBitmapPool.release(bitmapToReuse);
            if (decodedBitmap != null) {
                decodedBitmap.recycle();
            }
            throw new IllegalStateException();
        }
        if (this.mAvoidPoolRelease) {
            return CloseableReference.of((Object)decodedBitmap, (ResourceReleaser)NoOpResourceReleaser.INSTANCE);
        }
        return CloseableReference.of((Object)decodedBitmap, (ResourceReleaser)this.mBitmapPool);
    }

    private static BitmapFactory.Options getDecodeOptionsForStream(EncodedImage encodedImage, Bitmap.Config bitmapConfig, boolean skipDecoding) {
        boolean isHardwareBitmap;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = encodedImage.getSampleSize();
        options.inJustDecodeBounds = true;
        options.inDither = true;
        boolean bl = isHardwareBitmap = Build.VERSION.SDK_INT >= 26 && bitmapConfig == Bitmap.Config.HARDWARE;
        if (!isHardwareBitmap) {
            options.inPreferredConfig = bitmapConfig;
        }
        options.inMutable = true;
        if (!skipDecoding) {
            BitmapFactory.decodeStream((InputStream)encodedImage.getInputStream(), null, (BitmapFactory.Options)options);
            if (options.outWidth == -1 || options.outHeight == -1) {
                throw new IllegalArgumentException();
            }
        }
        if (isHardwareBitmap) {
            options.inPreferredConfig = bitmapConfig;
        }
        options.inJustDecodeBounds = false;
        return options;
    }

    public abstract int getBitmapSize(int var1, int var2, BitmapFactory.Options var3);

    private static final class NoOpResourceReleaser
    implements ResourceReleaser<Bitmap> {
        private static final NoOpResourceReleaser INSTANCE = new NoOpResourceReleaser();

        private NoOpResourceReleaser() {
        }

        public void release(Bitmap value) {
        }
    }
}

