/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorSpace;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.util.Pair;
import androidx.core.util.Pools;
import com.facebook.common.memory.DecodeBufferHelper;
import com.facebook.imageutils.ImageMetaData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007J \u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u001e\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0007J \u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J\u0012\u0010#\u001a\u00020$2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0007J&\u0010%\u001a\u0004\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J\u0012\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010,H\u0007J\"\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010,H\u0007J\n\u00100\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\bH\u0002J\u0010\u00104\u001a\u0002022\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u00105\u001a\u0002022\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J\b\u00106\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/facebook/imageutils/BitmapUtil;", "", "<init>", "()V", "POOL_SIZE", "", "DECODE_BUFFERS", "Landroidx/core/util/Pools$SynchronizedPool;", "Ljava/nio/ByteBuffer;", "getDECODE_BUFFERS", "()Landroidx/core/util/Pools$SynchronizedPool;", "DECODE_BUFFERS$delegate", "Lkotlin/Lazy;", "ALPHA_8_BYTES_PER_PIXEL", "ARGB_4444_BYTES_PER_PIXEL", "ARGB_8888_BYTES_PER_PIXEL", "RGB_565_BYTES_PER_PIXEL", "RGBA_F16_BYTES_PER_PIXEL", "RGBA_1010102_BYTES_PER_PIXEL", "MAX_BITMAP_DIMENSION", "", "useDecodeBufferHelper", "", "fixDecodeDrmImageCrash", "getSizeInBytes", "bitmap", "Landroid/graphics/Bitmap;", "decodeDimensions", "Landroid/util/Pair;", "bytes", "", "uri", "Landroid/net/Uri;", "inputStream", "Ljava/io/InputStream;", "decodeDimensionsAndColorSpace", "Lcom/facebook/imageutils/ImageMetaData;", "decodeStreamInternal", "outPadding", "Landroid/graphics/Rect;", "options", "Landroid/graphics/BitmapFactory$Options;", "getPixelSizeForBitmapConfig", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "getSizeInByteForBitmap", "width", "height", "acquireByteBuffer", "releaseByteBuffer", "", "byteBuffer", "setUseDecodeBufferHelper", "setFixDecodeDrmImageCrash", "obtainByteBuffer", "imagepipeline-base_release"})
@SourceDebugExtension(value={"SMAP\nBitmapUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapUtil.kt\ncom/facebook/imageutils/BitmapUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public final class BitmapUtil {
    @NotNull
    public static final BitmapUtil INSTANCE = new BitmapUtil();
    private static final int POOL_SIZE = 12;
    @NotNull
    private static final Lazy DECODE_BUFFERS$delegate = LazyKt.lazy(BitmapUtil::DECODE_BUFFERS_delegate$lambda$0);
    public static final int ALPHA_8_BYTES_PER_PIXEL = 1;
    public static final int ARGB_4444_BYTES_PER_PIXEL = 2;
    public static final int ARGB_8888_BYTES_PER_PIXEL = 4;
    public static final int RGB_565_BYTES_PER_PIXEL = 2;
    public static final int RGBA_F16_BYTES_PER_PIXEL = 8;
    public static final int RGBA_1010102_BYTES_PER_PIXEL = 4;
    public static final float MAX_BITMAP_DIMENSION = 2048.0f;
    private static boolean useDecodeBufferHelper;
    private static boolean fixDecodeDrmImageCrash;

    private BitmapUtil() {
    }

    private final Pools.SynchronizedPool<ByteBuffer> getDECODE_BUFFERS() {
        Lazy lazy = DECODE_BUFFERS$delegate;
        return (Pools.SynchronizedPool)lazy.getValue();
    }

    @JvmStatic
    @SuppressLint(value={"NewApi"})
    public static final int getSizeInBytes(@Nullable Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 19) {
            try {
                return bitmap.getAllocationByteCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return bitmap.getByteCount();
    }

    @JvmStatic
    @Nullable
    public static final Pair<Integer, Integer> decodeDimensions(@Nullable byte[] bytes) {
        return BitmapUtil.decodeDimensions(new ByteArrayInputStream(bytes));
    }

    @JvmStatic
    @Nullable
    public static final Pair<Integer, Integer> decodeDimensions(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)uri.getPath(), (BitmapFactory.Options)options);
        return options.outWidth == -1 || options.outHeight == -1 ? null : new Pair((Object)options.outWidth, (Object)options.outHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Pair<Integer, Integer> decodeDimensions(@Nullable InputStream inputStream) {
        Pair pair;
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ByteBuffer byteBuffer = INSTANCE.obtainByteBuffer();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            options.inTempStorage = byteBuffer.array();
            INSTANCE.decodeStreamInternal(inputStream, null, options);
            pair = options.outWidth == -1 || options.outHeight == -1 ? null : new Pair((Object)options.outWidth, (Object)options.outHeight);
        }
        finally {
            INSTANCE.releaseByteBuffer(byteBuffer);
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final ImageMetaData decodeDimensionsAndColorSpace(@Nullable InputStream inputStream) {
        ImageMetaData imageMetaData;
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        ByteBuffer byteBuffer = INSTANCE.obtainByteBuffer();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            options.inTempStorage = byteBuffer.array();
            INSTANCE.decodeStreamInternal(inputStream, null, options);
            ColorSpace colorSpace = Build.VERSION.SDK_INT >= 26 ? options.outColorSpace : null;
            imageMetaData = new ImageMetaData(options.outWidth, options.outHeight, colorSpace);
        }
        finally {
            INSTANCE.releaseByteBuffer(byteBuffer);
        }
        return imageMetaData;
    }

    @Nullable
    public final Bitmap decodeStreamInternal(@Nullable InputStream inputStream, @Nullable Rect outPadding, @Nullable BitmapFactory.Options options) {
        if (fixDecodeDrmImageCrash) {
            Bitmap bitmap;
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream, (Rect)outPadding, (BitmapFactory.Options)options);
            }
            catch (IllegalArgumentException ex) {
                bitmap = null;
            }
            return bitmap;
        }
        return BitmapFactory.decodeStream((InputStream)inputStream, (Rect)outPadding, (BitmapFactory.Options)options);
    }

    @JvmStatic
    @SuppressLint(value={"NewApi"})
    public static final int getPixelSizeForBitmapConfig(@Nullable Bitmap.Config bitmapConfig) {
        int n;
        Bitmap.Config config = bitmapConfig;
        switch (config == null ? -1 : WhenMappings.$EnumSwitchMapping$0[config.ordinal()]) {
            case 1: {
                n = 4;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case 6: {
                n = 4;
                break;
            }
            case 7: {
                n = 4;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The provided Bitmap.Config is not supported");
            }
        }
        return n;
    }

    @JvmStatic
    public static final int getSizeInByteForBitmap(int width, int height, @Nullable Bitmap.Config bitmapConfig) {
        if (!(width > 0)) {
            boolean $i$a$-require-BitmapUtil$getSizeInByteForBitmap$32 = false;
            String $i$a$-require-BitmapUtil$getSizeInByteForBitmap$32 = "width must be > 0, width is: " + width;
            throw new IllegalArgumentException($i$a$-require-BitmapUtil$getSizeInByteForBitmap$32.toString());
        }
        if (!(height > 0)) {
            boolean $i$a$-require-BitmapUtil$getSizeInByteForBitmap$42 = false;
            String $i$a$-require-BitmapUtil$getSizeInByteForBitmap$42 = "height must be > 0, height is: " + height;
            throw new IllegalArgumentException($i$a$-require-BitmapUtil$getSizeInByteForBitmap$42.toString());
        }
        int pixelSize = BitmapUtil.getPixelSizeForBitmapConfig(bitmapConfig);
        int size = width * height * pixelSize;
        if (!(size > 0)) {
            boolean bl = false;
            String string = "size must be > 0: size: " + size + ", width: " + width + ", height: " + height + ", pixelSize: " + pixelSize;
            throw new IllegalStateException(string.toString());
        }
        return size;
    }

    private final ByteBuffer acquireByteBuffer() {
        return useDecodeBufferHelper ? DecodeBufferHelper.INSTANCE.acquire() : (ByteBuffer)this.getDECODE_BUFFERS().acquire();
    }

    private final void releaseByteBuffer(ByteBuffer byteBuffer) {
        if (!useDecodeBufferHelper) {
            this.getDECODE_BUFFERS().release((Object)byteBuffer);
        }
    }

    @JvmStatic
    public static final void setUseDecodeBufferHelper(boolean useDecodeBufferHelper) {
        BitmapUtil.useDecodeBufferHelper = useDecodeBufferHelper;
    }

    @JvmStatic
    public static final void setFixDecodeDrmImageCrash(boolean fixDecodeDrmImageCrash) {
        BitmapUtil.fixDecodeDrmImageCrash = fixDecodeDrmImageCrash;
    }

    private final ByteBuffer obtainByteBuffer() {
        ByteBuffer byteBuffer = this.acquireByteBuffer();
        if (byteBuffer == null) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(DecodeBufferHelper.getRecommendedDecodeBufferSize());
            byteBuffer = byteBuffer2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"allocate(...)");
        }
        return byteBuffer;
    }

    private static final Pools.SynchronizedPool DECODE_BUFFERS_delegate$lambda$0() {
        return new Pools.SynchronizedPool(12);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.Config.values().length];
            try {
                nArray[Bitmap.Config.ARGB_8888.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.Config.ALPHA_8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.Config.ARGB_4444.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.Config.RGB_565.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.Config.RGBA_F16.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.Config.RGBA_1010102.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.Config.HARDWARE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

