/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\"\u0010\u0013\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0007J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/facebook/imagepipeline/transcoder/DownsampleUtil;", "", "<init>", "()V", "DEFAULT_SAMPLE_SIZE", "", "INTERVAL_ROUNDING", "", "determineSampleSize", "rotationOptions", "Lcom/facebook/imagepipeline/common/RotationOptions;", "resizeOptions", "Lcom/facebook/imagepipeline/common/ResizeOptions;", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "maxBitmapDimension", "determineSampleSizeJPEG", "pixelSize", "maxBitmapSizeInBytes", "determineDownsampleRatio", "ratioToSampleSize", "ratio", "ratioToSampleSizeJPEG", "getRotationAngle", "roundToPowerOfTwo", "sampleSize", "imagepipeline-base_release"})
public final class DownsampleUtil {
    @NotNull
    public static final DownsampleUtil INSTANCE = new DownsampleUtil();
    public static final int DEFAULT_SAMPLE_SIZE = 1;
    private static final float INTERVAL_ROUNDING = 0.33333334f;

    private DownsampleUtil() {
    }

    @JvmStatic
    public static final int determineSampleSize(@NotNull RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @NotNull EncodedImage encodedImage, int maxBitmapDimension) {
        float computedMaxBitmapSize;
        Intrinsics.checkNotNullParameter((Object)rotationOptions, (String)"rotationOptions");
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        if (!EncodedImage.isMetaDataAvailable(encodedImage)) {
            return 1;
        }
        float ratio = DownsampleUtil.determineDownsampleRatio(rotationOptions, resizeOptions, encodedImage);
        int sampleSize = encodedImage.getImageFormat() == DefaultImageFormats.JPEG ? DownsampleUtil.ratioToSampleSizeJPEG(ratio) : DownsampleUtil.ratioToSampleSize(ratio);
        int maxDimension = Math.max(encodedImage.getHeight(), encodedImage.getWidth());
        ResizeOptions resizeOptions2 = resizeOptions;
        float f = computedMaxBitmapSize = resizeOptions2 != null ? resizeOptions2.maxBitmapDimension : (float)maxBitmapDimension;
        while ((float)(maxDimension / sampleSize) > computedMaxBitmapSize) {
            if (encodedImage.getImageFormat() == DefaultImageFormats.JPEG) {
                sampleSize *= 2;
                continue;
            }
            ++sampleSize;
        }
        return sampleSize;
    }

    @JvmStatic
    public static final int determineSampleSizeJPEG(@NotNull EncodedImage encodedImage, int pixelSize, int maxBitmapSizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        int sampleSize = encodedImage.getSampleSize();
        int base = encodedImage.getWidth() * encodedImage.getHeight() * pixelSize;
        while (base / sampleSize / sampleSize > maxBitmapSizeInBytes) {
            sampleSize *= 2;
        }
        return sampleSize;
    }

    @JvmStatic
    @VisibleForTesting
    public static final float determineDownsampleRatio(@NotNull RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @NotNull EncodedImage encodedImage) {
        Intrinsics.checkNotNullParameter((Object)rotationOptions, (String)"rotationOptions");
        Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
        if (!EncodedImage.isMetaDataAvailable(encodedImage)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (resizeOptions == null || resizeOptions.height <= 0 || resizeOptions.width <= 0 || encodedImage.getWidth() == 0 || encodedImage.getHeight() == 0) {
            return 1.0f;
        }
        int rotationAngle = INSTANCE.getRotationAngle(rotationOptions, encodedImage);
        boolean swapDimensions = rotationAngle == 90 || rotationAngle == 270;
        int widthAfterRotation = swapDimensions ? encodedImage.getHeight() : encodedImage.getWidth();
        int heightAfterRotation = swapDimensions ? encodedImage.getWidth() : encodedImage.getHeight();
        float widthRatio = (float)resizeOptions.width / (float)widthAfterRotation;
        float heightRatio = (float)resizeOptions.height / (float)heightAfterRotation;
        float ratio = RangesKt.coerceAtLeast((float)widthRatio, (float)heightRatio);
        Object[] objectArray = new Object[]{resizeOptions.width, resizeOptions.height, widthAfterRotation, heightAfterRotation, Float.valueOf(widthRatio), Float.valueOf(heightRatio), Float.valueOf(ratio)};
        FLog.v((String)"DownsampleUtil", (String)"Downsample - Specified size: %dx%d, image size: %dx%d ratio: %.1f x %.1f, ratio: %.3f", (Object[])objectArray);
        return ratio;
    }

    @JvmStatic
    @VisibleForTesting
    public static final int ratioToSampleSize(float ratio) {
        if (ratio > 0.6666667f) {
            return 1;
        }
        int sampleSize = 2;
        double intervalLength;
        double compare;
        while (!((compare = 1.0 / (double)sampleSize + (intervalLength = 1.0 / (Math.pow(sampleSize, 2.0) - (double)sampleSize)) * (double)0.33333334f) <= (double)ratio)) {
            ++sampleSize;
        }
        return sampleSize - 1;
    }

    @JvmStatic
    @VisibleForTesting
    public static final int ratioToSampleSizeJPEG(float ratio) {
        if (ratio > 0.6666667f) {
            return 1;
        }
        int sampleSize = 2;
        double intervalLength;
        double compare;
        while (!((compare = 1.0 / (double)(2 * sampleSize) + (intervalLength = 1.0 / (double)(2 * sampleSize)) * (double)0.33333334f) <= (double)ratio)) {
            sampleSize *= 2;
        }
        return sampleSize;
    }

    private final int getRotationAngle(RotationOptions rotationOptions, EncodedImage encodedImage) {
        if (!rotationOptions.useImageMetadata()) {
            return 0;
        }
        int rotationAngle = encodedImage.getRotationAngle();
        if (!(rotationAngle == 0 || rotationAngle == 90 || rotationAngle == 180 || rotationAngle == 270)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return rotationAngle;
    }

    @JvmStatic
    @VisibleForTesting
    public static final int roundToPowerOfTwo(int sampleSize) {
        int compare = 1;
        while (compare < sampleSize) {
            compare *= 2;
        }
        return compare;
    }
}

