/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CountingLruMap;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0002\n\u000bB\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector;", "K", "V", "", "countingBitmapCache", "Lcom/facebook/imagepipeline/cache/CountingMemoryCache;", "<init>", "(Lcom/facebook/imagepipeline/cache/CountingMemoryCache;)V", "dumpCacheContent", "Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector$DumpInfo;", "DumpInfoEntry", "DumpInfo", "imagepipeline-base_release"})
public final class CountingMemoryCacheInspector<K, V> {
    @NotNull
    private final CountingMemoryCache<K, V> countingBitmapCache;

    public CountingMemoryCacheInspector(@NotNull CountingMemoryCache<K, V> countingBitmapCache) {
        Intrinsics.checkNotNullParameter(countingBitmapCache, (String)"countingBitmapCache");
        this.countingBitmapCache = countingBitmapCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final DumpInfo<K, V> dumpCacheContent() {
        CountingMemoryCache<K, V> countingMemoryCache = this.countingBitmapCache;
        synchronized (countingMemoryCache) {
            void var3_4;
            CountingLruMap countingLruMap;
            DumpInfo dumpInfo;
            block7: {
                boolean bl = false;
                int n = this.countingBitmapCache.getSizeInBytes();
                int n2 = this.countingBitmapCache.getEvictionQueueSizeInBytes();
                MemoryCacheParams memoryCacheParams = this.countingBitmapCache.getMemoryCacheParams();
                Intrinsics.checkNotNullExpressionValue((Object)memoryCacheParams, (String)"getMemoryCacheParams(...)");
                dumpInfo = new DumpInfo(n, n2, memoryCacheParams);
                if (this.countingBitmapCache.getCachedEntries() != null) break block7;
                DumpInfo dumpInfo2 = dumpInfo;
                return dumpInfo2;
            }
            CountingLruMap maybeCachedEntries = countingLruMap;
            ArrayList<Map.Entry<K, CountingMemoryCache.Entry<K, V>>> arrayList = maybeCachedEntries.getMatchingEntries(null);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"getMatchingEntries(...)");
            List cachedEntries = arrayList;
            Iterator iterator = cachedEntries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Bitmap, Object> entry = (CountingMemoryCache.Entry)((Map.Entry)iterator.next()).getValue();
                DumpInfoEntry dumpEntry = new DumpInfoEntry(((CountingMemoryCache.Entry)((Object)entry)).key, ((CountingMemoryCache.Entry)((Object)entry)).valueRef);
                boolean bl = ((CountingMemoryCache.Entry)((Object)entry)).clientCount > 0 ? dumpInfo.sharedEntries.add(dumpEntry) : dumpInfo.lruEntries.add(dumpEntry);
            }
            Map<Bitmap, Object> otherEntries = this.countingBitmapCache.getOtherEntries();
            if (otherEntries != null) {
                for (Map.Entry<Bitmap, Object> entry : otherEntries.entrySet()) {
                    if (entry == null || ((Bitmap)entry.getKey()).isRecycled()) continue;
                    dumpInfo.otherEntries.put((Bitmap)entry.getKey(), entry.getValue());
                }
            }
            void var10_12 = var3_4;
            return var10_12;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00030\u00138\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector$DumpInfo;", "K", "V", "", "size", "", "lruSize", "params", "Lcom/facebook/imagepipeline/cache/MemoryCacheParams;", "<init>", "(IILcom/facebook/imagepipeline/cache/MemoryCacheParams;)V", "maxSize", "maxEntriesCount", "maxEntrySize", "lruEntries", "", "Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector$DumpInfoEntry;", "sharedEntries", "otherEntries", "", "Landroid/graphics/Bitmap;", "release", "", "imagepipeline-base_release"})
    public static final class DumpInfo<K, V> {
        @JvmField
        public final int maxSize;
        @JvmField
        public final int maxEntriesCount;
        @JvmField
        public final int maxEntrySize;
        @JvmField
        public final int size;
        @JvmField
        public final int lruSize;
        @JvmField
        @NotNull
        public final List<DumpInfoEntry<K, V>> lruEntries;
        @JvmField
        @NotNull
        public final List<DumpInfoEntry<K, V>> sharedEntries;
        @JvmField
        @NotNull
        public final Map<Bitmap, Object> otherEntries;

        public DumpInfo(int size, int lruSize, @NotNull MemoryCacheParams params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.maxSize = params.maxCacheSize;
            this.maxEntriesCount = params.maxCacheEntries;
            this.maxEntrySize = params.maxCacheEntrySize;
            this.size = size;
            this.lruSize = lruSize;
            this.lruEntries = new ArrayList();
            this.sharedEntries = new ArrayList();
            this.otherEntries = new HashMap();
        }

        public final void release() {
            for (DumpInfoEntry<K, V> entry : this.lruEntries) {
                entry.release();
            }
            for (DumpInfoEntry<K, V> entry : this.sharedEntries) {
                entry.release();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fR\u0012\u0010\u0004\u001a\u00028\u00028\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0003\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/imagepipeline/cache/CountingMemoryCacheInspector$DumpInfoEntry;", "K", "V", "", "key", "valueRef", "Lcom/facebook/common/references/CloseableReference;", "<init>", "(Ljava/lang/Object;Lcom/facebook/common/references/CloseableReference;)V", "Ljava/lang/Object;", "value", "release", "", "imagepipeline-base_release"})
    public static final class DumpInfoEntry<K, V> {
        @JvmField
        public final K key;
        @JvmField
        @Nullable
        public final CloseableReference<V> value;

        public DumpInfoEntry(K key, @Nullable CloseableReference<V> valueRef) {
            K k = key;
            if (k == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            this.key = k;
            this.value = CloseableReference.cloneOrNull(valueRef);
        }

        public final void release() {
            CloseableReference.closeSafely(this.value);
        }
    }
}

