/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Predicate;
import com.facebook.imagepipeline.cache.ValueDescriptor;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class CountingLruMap<K, V> {
    private final ValueDescriptor<V> mValueDescriptor;
    @GuardedBy(value="this")
    private final LinkedHashMap<K, V> mMap = new LinkedHashMap();
    @GuardedBy(value="this")
    private int mSizeInBytes = 0;

    public CountingLruMap(ValueDescriptor<V> valueDescriptor) {
        this.mValueDescriptor = valueDescriptor;
    }

    @VisibleForTesting
    synchronized ArrayList<K> getKeys() {
        return new ArrayList<K>(this.mMap.keySet());
    }

    @VisibleForTesting
    synchronized ArrayList<V> getValues() {
        return new ArrayList<V>(this.mMap.values());
    }

    public synchronized int getCount() {
        return this.mMap.size();
    }

    public synchronized int getSizeInBytes() {
        return this.mSizeInBytes;
    }

    @Nullable
    public synchronized K getFirstKey() {
        return this.mMap.isEmpty() ? null : (K)this.mMap.keySet().iterator().next();
    }

    public synchronized ArrayList<Map.Entry<K, V>> getMatchingEntries(@Nullable Predicate<K> predicate) {
        ArrayList<Map.Entry<K, V>> matchingEntries = new ArrayList<Map.Entry<K, V>>(this.mMap.entrySet().size());
        for (Map.Entry<K, V> entry : this.mMap.entrySet()) {
            if (predicate != null && !predicate.apply(entry.getKey())) continue;
            matchingEntries.add(entry);
        }
        return matchingEntries;
    }

    public synchronized boolean contains(K key) {
        return this.mMap.containsKey(key);
    }

    @Nullable
    public synchronized V get(K key) {
        return this.mMap.get(key);
    }

    @Nullable
    public synchronized V put(K key, V value) {
        Object oldValue = this.mMap.remove(key);
        this.mSizeInBytes -= this.getValueSizeInBytes(oldValue);
        this.mMap.put(key, value);
        this.mSizeInBytes += this.getValueSizeInBytes(value);
        return oldValue;
    }

    @Nullable
    public synchronized V remove(K key) {
        Object oldValue = this.mMap.remove(key);
        this.mSizeInBytes -= this.getValueSizeInBytes(oldValue);
        return oldValue;
    }

    public synchronized ArrayList<V> removeAll(@Nullable Predicate<K> predicate) {
        ArrayList<V> oldValues = new ArrayList<V>();
        Iterator<Map.Entry<K, V>> iterator = this.mMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (predicate != null && !predicate.apply(entry.getKey())) continue;
            oldValues.add(entry.getValue());
            this.mSizeInBytes -= this.getValueSizeInBytes(entry.getValue());
            iterator.remove();
        }
        return oldValues;
    }

    public synchronized ArrayList<V> clear() {
        ArrayList<V> oldValues = new ArrayList<V>(this.mMap.values());
        this.mMap.clear();
        this.mSizeInBytes = 0;
        return oldValues;
    }

    public synchronized void resetSize() {
        if (this.mMap.isEmpty()) {
            this.mSizeInBytes = 0;
        }
    }

    private int getValueSizeInBytes(@Nullable V value) {
        return value == null ? 0 : this.mValueDescriptor.getSizeInBytes(value);
    }
}

