/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.common;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import java.util.List;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class MultiCacheKey
implements CacheKey {
    final List<CacheKey> mCacheKeys;

    public MultiCacheKey(List<CacheKey> cacheKeys) {
        this.mCacheKeys = (List)Preconditions.checkNotNull(cacheKeys);
    }

    public List<CacheKey> getCacheKeys() {
        return this.mCacheKeys;
    }

    @Override
    public String toString() {
        return "MultiCacheKey:" + this.mCacheKeys.toString();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MultiCacheKey) {
            MultiCacheKey otherKey = (MultiCacheKey)o;
            return this.mCacheKeys.equals(otherKey.mCacheKeys);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mCacheKeys.hashCode();
    }

    @Override
    public boolean containsUri(Uri uri) {
        for (int i = 0; i < this.mCacheKeys.size(); ++i) {
            if (!this.mCacheKeys.get(i).containsUri(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUriString() {
        return this.mCacheKeys.get(0).getUriString();
    }

    @Override
    public boolean isResourceIdForDebugging() {
        return false;
    }
}

