/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.media;

import android.webkit.MimeTypeMap;
import androidx.annotation.Nullable;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Map;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class MimeTypeMapWrapper {
    private static final MimeTypeMap sMimeTypeMap = MimeTypeMap.getSingleton();
    private static final Map<String, String> sMimeTypeToExtensionMap = ImmutableMap.of("image/heif", "heif", "image/heic", "heic");
    private static final Map<String, String> sExtensionToMimeTypeMap = ImmutableMap.of("heif", "image/heif", "heic", "image/heic");

    @Nullable
    public static String getExtensionFromMimeType(String mimeType) {
        String result = sMimeTypeToExtensionMap.get(mimeType);
        if (result != null) {
            return result;
        }
        return sMimeTypeMap.getExtensionFromMimeType(mimeType);
    }

    @Nullable
    public static String getMimeTypeFromExtension(String extension) {
        String result = sExtensionToMimeTypeMap.get(extension);
        if (result != null) {
            return result;
        }
        return sMimeTypeMap.getMimeTypeFromExtension(extension);
    }

    public static boolean hasExtension(String extension) {
        return sExtensionToMimeTypeMap.containsKey(extension) || sMimeTypeMap.hasExtension(extension);
    }

    public static boolean hasMimeType(String mimeType) {
        return sMimeTypeToExtensionMap.containsKey(mimeType) || sMimeTypeMap.hasMimeType(mimeType);
    }
}

