/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.references;

import android.graphics.Bitmap;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Closeables;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.DefaultCloseableReference;
import com.facebook.common.references.FinalizerCloseableReference;
import com.facebook.common.references.HasBitmap;
import com.facebook.common.references.NoOpCloseableReference;
import com.facebook.common.references.RefCountCloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.references.SharedReference;
import com.facebook.infer.annotation.FalseOnNull;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.PropagatesNullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class CloseableReference<T>
implements Cloneable,
Closeable {
    public static final int REF_TYPE_DEFAULT = 0;
    public static final int REF_TYPE_FINALIZER = 1;
    public static final int REF_TYPE_REF_COUNT = 2;
    public static final int REF_TYPE_NOOP = 3;
    private static Class<CloseableReference> TAG = CloseableReference.class;
    @CloseableRefType
    private static int sBitmapCloseableRefType = 0;
    @GuardedBy(value="this")
    protected boolean mIsClosed = false;
    protected final SharedReference<T> mSharedReference;
    @Nullable
    protected final LeakHandler mLeakHandler;
    @Nullable
    protected final Throwable mStacktrace;
    private static final ResourceReleaser<Closeable> DEFAULT_CLOSEABLE_RELEASER = new ResourceReleaser<Closeable>(){

        @Override
        public void release(Closeable value) {
            try {
                Closeables.close(value, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    private static final LeakHandler DEFAULT_LEAK_HANDLER = new LeakHandler(){

        @Override
        public void reportLeak(SharedReference<Object> reference, @Nullable Throwable stacktrace) {
            Object ref = reference.get();
            FLog.w(TAG, "Finalized without closing: %x %x (type = %s)", System.identityHashCode(this), System.identityHashCode(reference), ref == null ? null : ref.getClass().getName());
        }

        @Override
        public boolean requiresStacktrace() {
            return false;
        }
    };

    public static void setDisableCloseableReferencesForBitmaps(@CloseableRefType int bitmapCloseableRefType) {
        sBitmapCloseableRefType = bitmapCloseableRefType;
    }

    protected CloseableReference(SharedReference<T> sharedReference, @Nullable LeakHandler leakHandler, @Nullable Throwable stacktrace) {
        this.mSharedReference = Preconditions.checkNotNull(sharedReference);
        sharedReference.addReference();
        this.mLeakHandler = leakHandler;
        this.mStacktrace = stacktrace;
    }

    protected CloseableReference(T t, @Nullable ResourceReleaser<T> resourceReleaser, @Nullable LeakHandler leakHandler, @Nullable Throwable stacktrace, boolean keepAlive) {
        this.mSharedReference = new SharedReference<T>(t, resourceReleaser, keepAlive);
        this.mLeakHandler = leakHandler;
        this.mStacktrace = stacktrace;
    }

    public static <T extends Closeable> CloseableReference<T> of(@PropagatesNullable T t) {
        return CloseableReference.of(t, DEFAULT_CLOSEABLE_RELEASER);
    }

    public static <T> CloseableReference<T> of(@PropagatesNullable T t, ResourceReleaser<T> resourceReleaser) {
        return CloseableReference.of(t, resourceReleaser, DEFAULT_LEAK_HANDLER);
    }

    public static <T extends Closeable> CloseableReference<T> of(@Nullable @PropagatesNullable T t, LeakHandler leakHandler) {
        if (t == null) {
            return null;
        }
        return CloseableReference.of(t, DEFAULT_CLOSEABLE_RELEASER, leakHandler, leakHandler.requiresStacktrace() ? new Throwable() : null);
    }

    public static <T> CloseableReference<T> of(@PropagatesNullable T t, ResourceReleaser<T> resourceReleaser, LeakHandler leakHandler) {
        if (t == null) {
            return null;
        }
        return CloseableReference.of(t, resourceReleaser, leakHandler, leakHandler.requiresStacktrace() ? new Throwable() : null);
    }

    public static <T> CloseableReference<T> of(@PropagatesNullable T t, ResourceReleaser<T> resourceReleaser, LeakHandler leakHandler, @Nullable Throwable stacktrace) {
        if (t == null) {
            return null;
        }
        if (t instanceof Bitmap || t instanceof HasBitmap) {
            switch (sBitmapCloseableRefType) {
                case 1: {
                    return new FinalizerCloseableReference<T>(t, resourceReleaser, leakHandler, stacktrace);
                }
                case 2: {
                    return new RefCountCloseableReference<T>(t, resourceReleaser, leakHandler, stacktrace);
                }
                case 3: {
                    return new NoOpCloseableReference<T>(t);
                }
            }
        }
        return new DefaultCloseableReference<T>(t, resourceReleaser, leakHandler, stacktrace);
    }

    public synchronized T get() {
        Preconditions.checkState(!this.mIsClosed);
        return Preconditions.checkNotNull(this.mSharedReference.get());
    }

    public abstract CloseableReference<T> clone();

    @Nullable
    public synchronized CloseableReference<T> cloneOrNull() {
        if (this.isValid()) {
            return this.clone();
        }
        return null;
    }

    public synchronized boolean isValid() {
        return !this.mIsClosed;
    }

    @VisibleForTesting
    public synchronized SharedReference<T> getUnderlyingReferenceTestOnly() {
        return this.mSharedReference;
    }

    public int getValueHash() {
        return this.isValid() ? System.identityHashCode(this.mSharedReference.get()) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        CloseableReference closeableReference = this;
        synchronized (closeableReference) {
            if (this.mIsClosed) {
                return;
            }
            this.mIsClosed = true;
        }
        this.mSharedReference.deleteReference();
    }

    @FalseOnNull
    public static boolean isValid(@Nullable CloseableReference<?> ref) {
        return ref != null && ref.isValid();
    }

    @Nullable
    public static <T> CloseableReference<T> cloneOrNull(@Nullable CloseableReference<T> ref) {
        return ref != null ? ref.cloneOrNull() : null;
    }

    public static <T> List<CloseableReference<T>> cloneOrNull(@PropagatesNullable Collection<CloseableReference<T>> refs) {
        if (refs == null) {
            return null;
        }
        ArrayList<CloseableReference<T>> ret = new ArrayList<CloseableReference<T>>(refs.size());
        for (CloseableReference<T> ref : refs) {
            ret.add(CloseableReference.cloneOrNull(ref));
        }
        return ret;
    }

    public static void closeSafely(@Nullable CloseableReference<?> ref) {
        if (ref != null) {
            ref.close();
        }
    }

    public static void closeSafely(@Nullable Iterable<? extends CloseableReference<?>> references) {
        if (references != null) {
            for (CloseableReference<?> ref : references) {
                CloseableReference.closeSafely(ref);
            }
        }
    }

    public static interface LeakHandler {
        public void reportLeak(SharedReference<Object> var1, @Nullable Throwable var2);

        public boolean requiresStacktrace();
    }

    public static @interface CloseableRefType {
    }
}

