/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget.text.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ReplacementSpan;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BetterImageSpan
extends ReplacementSpan {
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    protected int mWidth;
    protected int mHeight;
    private Rect mBounds;
    private final int mAlignment;
    private final Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();
    private final Drawable mDrawable;
    private final Rect mMargin;

    public static final int normalizeAlignment(int alignment) {
        switch (alignment) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    public BetterImageSpan(Drawable drawable) {
        this(drawable, 1);
    }

    public BetterImageSpan(Drawable drawable, int verticalAlignment) {
        this(drawable, verticalAlignment, new Rect());
    }

    public BetterImageSpan(Drawable drawable, int verticalAlignment, Rect margin) {
        this.mDrawable = drawable;
        this.mAlignment = verticalAlignment;
        this.mMargin = margin;
        this.updateBounds();
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public Rect getMargin() {
        return this.mMargin;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fontMetrics) {
        this.updateBounds();
        if (fontMetrics == null) {
            return this.mWidth;
        }
        return this.calculateLineWidthAndFontHeight(fontMetrics);
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        paint.getFontMetricsInt(this.mFontMetricsInt);
        int iconTop = this.getIconTop(y, this.mFontMetricsInt.ascent, this.mFontMetricsInt.descent, top, bottom);
        float iconLeft = x + (float)this.mMargin.left;
        canvas.translate(iconLeft, (float)iconTop);
        this.mDrawable.draw(canvas);
        canvas.translate(-iconLeft, (float)(-iconTop));
    }

    public void updateBounds() {
        this.mBounds = this.mDrawable.getBounds();
        this.mWidth = this.mBounds.width() + this.mMargin.left + this.mMargin.right;
        this.mHeight = this.mBounds.height();
    }

    protected int getOffsetAboveBaseline(int ascent, int descent) {
        switch (this.mAlignment) {
            case 0: {
                return descent - this.mHeight - this.mMargin.bottom;
            }
            case 2: {
                int textHeight = descent - ascent + this.mMargin.top + this.mMargin.bottom;
                int offset = (textHeight - this.mHeight) / 2;
                return ascent + offset - this.mMargin.bottom;
            }
        }
        return -this.mHeight - this.mMargin.bottom;
    }

    protected int getIconTop(int baseline, int ascent, int descent, int top, int bottom) {
        return baseline + this.getOffsetAboveBaseline(this.mFontMetricsInt.ascent, this.mFontMetricsInt.descent);
    }

    protected int calculateLineWidthAndFontHeight(Paint.FontMetricsInt fontMetrics) {
        int offsetAbove = this.getOffsetAboveBaseline(fontMetrics.ascent, fontMetrics.descent);
        int offsetBelow = this.mHeight + offsetAbove;
        if (this.mAlignment == 2) {
            offsetAbove -= this.mMargin.top;
            offsetBelow += this.mMargin.bottom;
        } else {
            offsetAbove -= this.mMargin.top;
        }
        this.updateFontHeight(fontMetrics, offsetAbove, offsetBelow);
        return this.mWidth;
    }

    protected void updateFontHeight(Paint.FontMetricsInt fontMetrics, int offsetAbove, int offsetBelow) {
        if (offsetAbove < fontMetrics.ascent) {
            fontMetrics.ascent = offsetAbove;
        }
        if (offsetAbove < fontMetrics.top) {
            fontMetrics.top = offsetAbove;
        }
        if (offsetBelow > fontMetrics.descent) {
            fontMetrics.descent = offsetBelow;
        }
        if (offsetBelow > fontMetrics.bottom) {
            fontMetrics.bottom = offsetBelow;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BetterImageSpanAlignment {
    }
}

