/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.datasource;

import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.datasource.AbstractDataSource;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
public class IncreasingQualityDataSourceSupplier<T>
implements Supplier<DataSource<T>> {
    private final List<Supplier<DataSource<T>>> mDataSourceSuppliers;
    private final boolean mDataSourceLazy;

    private IncreasingQualityDataSourceSupplier(List<Supplier<DataSource<T>>> dataSourceSuppliers, boolean dataSourceLazy) {
        Preconditions.checkArgument(!dataSourceSuppliers.isEmpty(), "List of suppliers is empty!");
        this.mDataSourceSuppliers = dataSourceSuppliers;
        this.mDataSourceLazy = dataSourceLazy;
    }

    public static <T> IncreasingQualityDataSourceSupplier<T> create(List<Supplier<DataSource<T>>> dataSourceSuppliers) {
        return IncreasingQualityDataSourceSupplier.create(dataSourceSuppliers, false);
    }

    public static <T> IncreasingQualityDataSourceSupplier<T> create(List<Supplier<DataSource<T>>> dataSourceSuppliers, boolean dataSourceLazy) {
        return new IncreasingQualityDataSourceSupplier<T>(dataSourceSuppliers, dataSourceLazy);
    }

    @Override
    public DataSource<T> get() {
        return new IncreasingQualityDataSource();
    }

    public int hashCode() {
        return this.mDataSourceSuppliers.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof IncreasingQualityDataSourceSupplier)) {
            return false;
        }
        IncreasingQualityDataSourceSupplier that = (IncreasingQualityDataSourceSupplier)other;
        return Objects.equal(this.mDataSourceSuppliers, that.mDataSourceSuppliers);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("list", this.mDataSourceSuppliers).toString();
    }

    @ThreadSafe
    private class IncreasingQualityDataSource
    extends AbstractDataSource<T> {
        @Nullable
        @GuardedBy(value="IncreasingQualityDataSource.this")
        private ArrayList<DataSource<T>> mDataSources;
        @GuardedBy(value="IncreasingQualityDataSource.this")
        private int mIndexOfDataSourceWithResult;
        private int mNumberOfDataSources;
        private AtomicInteger mFinishedDataSources;
        @Nullable
        private Throwable mDelayedError;
        @Nullable
        private Map<String, Object> mDelayedExtras;

        public IncreasingQualityDataSource() {
            if (!IncreasingQualityDataSourceSupplier.this.mDataSourceLazy) {
                this.ensureDataSourceInitialized();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureDataSourceInitialized() {
            if (this.mFinishedDataSources != null) {
                return;
            }
            IncreasingQualityDataSource increasingQualityDataSource = this;
            synchronized (increasingQualityDataSource) {
                if (this.mFinishedDataSources == null) {
                    int n;
                    this.mFinishedDataSources = new AtomicInteger(0);
                    this.mNumberOfDataSources = n = IncreasingQualityDataSourceSupplier.this.mDataSourceSuppliers.size();
                    this.mIndexOfDataSourceWithResult = n;
                    this.mDataSources = new ArrayList(n);
                    for (int i = 0; i < n; ++i) {
                        DataSource dataSource = IncreasingQualityDataSourceSupplier.this.mDataSourceSuppliers.get(i).get();
                        this.mDataSources.add(dataSource);
                        dataSource.subscribe(new InternalDataSubscriber(i), CallerThreadExecutor.getInstance());
                        if (dataSource.hasResult()) break;
                    }
                }
            }
        }

        @Nullable
        private synchronized DataSource<T> getDataSource(int i) {
            return this.mDataSources != null && i < this.mDataSources.size() ? this.mDataSources.get(i) : null;
        }

        @Nullable
        private synchronized DataSource<T> getAndClearDataSource(int i) {
            return this.mDataSources != null && i < this.mDataSources.size() ? (DataSource)this.mDataSources.set(i, null) : null;
        }

        @Nullable
        private synchronized DataSource<T> getDataSourceWithResult() {
            return this.getDataSource(this.mIndexOfDataSourceWithResult);
        }

        @Override
        @Nullable
        public synchronized T getResult() {
            DataSource dataSourceWithResult;
            if (IncreasingQualityDataSourceSupplier.this.mDataSourceLazy) {
                this.ensureDataSourceInitialized();
            }
            return (dataSourceWithResult = this.getDataSourceWithResult()) != null ? (Object)dataSourceWithResult.getResult() : null;
        }

        @Override
        public synchronized boolean hasResult() {
            DataSource dataSourceWithResult;
            if (IncreasingQualityDataSourceSupplier.this.mDataSourceLazy) {
                this.ensureDataSourceInitialized();
            }
            return (dataSourceWithResult = this.getDataSourceWithResult()) != null && dataSourceWithResult.hasResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            ArrayList dataSources;
            if (IncreasingQualityDataSourceSupplier.this.mDataSourceLazy) {
                this.ensureDataSourceInitialized();
            }
            IncreasingQualityDataSource increasingQualityDataSource = this;
            synchronized (increasingQualityDataSource) {
                if (!super.close()) {
                    return false;
                }
                dataSources = this.mDataSources;
                this.mDataSources = null;
            }
            if (dataSources != null) {
                for (int i = 0; i < dataSources.size(); ++i) {
                    this.closeSafely(dataSources.get(i));
                }
            }
            return true;
        }

        private void onDataSourceNewResult(int index, DataSource<T> dataSource) {
            this.maybeSetIndexOfDataSourceWithResult(index, dataSource, dataSource.isFinished());
            if (dataSource == this.getDataSourceWithResult()) {
                this.setResult(null, index == 0 && dataSource.isFinished(), dataSource.getExtras());
            }
            this.maybeSetFailure();
        }

        private void onDataSourceFailed(int index, DataSource<T> dataSource) {
            this.closeSafely(this.tryGetAndClearDataSource(index, dataSource));
            if (index == 0) {
                this.mDelayedError = dataSource.getFailureCause();
                this.mDelayedExtras = dataSource.getExtras();
            }
            this.maybeSetFailure();
        }

        private void maybeSetFailure() {
            int finished = this.mFinishedDataSources.incrementAndGet();
            if (finished == this.mNumberOfDataSources && this.mDelayedError != null) {
                this.setFailure(this.mDelayedError, this.mDelayedExtras);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeSetIndexOfDataSourceWithResult(int index, DataSource<T> dataSource, boolean isFinished) {
            int newIndexOfDataSourceWithResult;
            IncreasingQualityDataSource increasingQualityDataSource = this;
            synchronized (increasingQualityDataSource) {
                int oldIndexOfDataSourceWithResult = this.mIndexOfDataSourceWithResult;
                newIndexOfDataSourceWithResult = this.mIndexOfDataSourceWithResult;
                if (dataSource != this.getDataSource(index) || index == this.mIndexOfDataSourceWithResult) {
                    return;
                }
                if (this.getDataSourceWithResult() == null || isFinished && index < this.mIndexOfDataSourceWithResult) {
                    newIndexOfDataSourceWithResult = index;
                    this.mIndexOfDataSourceWithResult = index;
                }
            }
            for (int i = oldIndexOfDataSourceWithResult; i > newIndexOfDataSourceWithResult; --i) {
                this.closeSafely(this.getAndClearDataSource(i));
            }
        }

        @Nullable
        private synchronized DataSource<T> tryGetAndClearDataSource(int i, DataSource<T> dataSource) {
            if (dataSource == this.getDataSourceWithResult()) {
                return null;
            }
            if (dataSource == this.getDataSource(i)) {
                return this.getAndClearDataSource(i);
            }
            return dataSource;
        }

        private void closeSafely(DataSource<T> dataSource) {
            if (dataSource != null) {
                dataSource.close();
            }
        }

        private class InternalDataSubscriber
        implements DataSubscriber<T> {
            private int mIndex;

            public InternalDataSubscriber(int index) {
                this.mIndex = index;
            }

            @Override
            public void onNewResult(DataSource<T> dataSource) {
                if (dataSource.hasResult()) {
                    IncreasingQualityDataSource.this.onDataSourceNewResult(this.mIndex, dataSource);
                } else if (dataSource.isFinished()) {
                    IncreasingQualityDataSource.this.onDataSourceFailed(this.mIndex, dataSource);
                }
            }

            @Override
            public void onFailure(DataSource<T> dataSource) {
                IncreasingQualityDataSource.this.onDataSourceFailed(this.mIndex, dataSource);
            }

            @Override
            public void onCancellation(DataSource<T> dataSource) {
            }

            @Override
            public void onProgressUpdate(DataSource<T> dataSource) {
                if (this.mIndex == 0) {
                    IncreasingQualityDataSource.this.setProgress(dataSource.getProgress());
                }
            }
        }
    }
}

