/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.datasource;

import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.datasource.AbstractDataSource;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.infer.annotation.Nullsafe;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
public class FirstAvailableDataSourceSupplier<T>
implements Supplier<DataSource<T>> {
    private final List<Supplier<DataSource<T>>> mDataSourceSuppliers;

    private FirstAvailableDataSourceSupplier(List<Supplier<DataSource<T>>> dataSourceSuppliers) {
        Preconditions.checkArgument(!dataSourceSuppliers.isEmpty(), "List of suppliers is empty!");
        this.mDataSourceSuppliers = dataSourceSuppliers;
    }

    public static <T> FirstAvailableDataSourceSupplier<T> create(List<Supplier<DataSource<T>>> dataSourceSuppliers) {
        return new FirstAvailableDataSourceSupplier<T>(dataSourceSuppliers);
    }

    @Override
    public DataSource<T> get() {
        return new FirstAvailableDataSource();
    }

    public int hashCode() {
        return this.mDataSourceSuppliers.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FirstAvailableDataSourceSupplier)) {
            return false;
        }
        FirstAvailableDataSourceSupplier that = (FirstAvailableDataSourceSupplier)other;
        return Objects.equal(this.mDataSourceSuppliers, that.mDataSourceSuppliers);
    }

    public String toString() {
        return Objects.toStringHelper(this).add("list", this.mDataSourceSuppliers).toString();
    }

    @ThreadSafe
    private class FirstAvailableDataSource
    extends AbstractDataSource<T> {
        private int mIndex = 0;
        @Nullable
        private DataSource<T> mCurrentDataSource = null;
        @Nullable
        private DataSource<T> mDataSourceWithResult = null;

        public FirstAvailableDataSource() {
            if (!this.startNextDataSource()) {
                this.setFailure(new RuntimeException("No data source supplier or supplier returned null."));
            }
        }

        @Override
        @Nullable
        public synchronized T getResult() {
            DataSource dataSourceWithResult = this.getDataSourceWithResult();
            return dataSourceWithResult != null ? (Object)dataSourceWithResult.getResult() : null;
        }

        @Override
        public synchronized boolean hasResult() {
            DataSource dataSourceWithResult = this.getDataSourceWithResult();
            return dataSourceWithResult != null && dataSourceWithResult.hasResult();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close() {
            DataSource dataSourceWithResult;
            DataSource currentDataSource;
            FirstAvailableDataSource firstAvailableDataSource = this;
            synchronized (firstAvailableDataSource) {
                if (!super.close()) {
                    return false;
                }
                currentDataSource = this.mCurrentDataSource;
                this.mCurrentDataSource = null;
                dataSourceWithResult = this.mDataSourceWithResult;
                this.mDataSourceWithResult = null;
            }
            this.closeSafely(dataSourceWithResult);
            this.closeSafely(currentDataSource);
            return true;
        }

        private boolean startNextDataSource() {
            DataSource dataSource;
            Supplier dataSourceSupplier = this.getNextSupplier();
            DataSource dataSource2 = dataSource = dataSourceSupplier != null ? dataSourceSupplier.get() : null;
            if (this.setCurrentDataSource(dataSource) && dataSource != null) {
                dataSource.subscribe(new InternalDataSubscriber(), CallerThreadExecutor.getInstance());
                return true;
            }
            this.closeSafely(dataSource);
            return false;
        }

        @Nullable
        private synchronized Supplier<DataSource<T>> getNextSupplier() {
            if (!this.isClosed() && this.mIndex < FirstAvailableDataSourceSupplier.this.mDataSourceSuppliers.size()) {
                return FirstAvailableDataSourceSupplier.this.mDataSourceSuppliers.get(this.mIndex++);
            }
            return null;
        }

        private synchronized boolean setCurrentDataSource(DataSource<T> dataSource) {
            if (this.isClosed()) {
                return false;
            }
            this.mCurrentDataSource = dataSource;
            return true;
        }

        private synchronized boolean clearCurrentDataSource(DataSource<T> dataSource) {
            if (this.isClosed() || dataSource != this.mCurrentDataSource) {
                return false;
            }
            this.mCurrentDataSource = null;
            return true;
        }

        @Nullable
        private synchronized DataSource<T> getDataSourceWithResult() {
            return this.mDataSourceWithResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeSetDataSourceWithResult(DataSource<T> dataSource, boolean isFinished) {
            DataSource oldDataSource = null;
            FirstAvailableDataSource firstAvailableDataSource = this;
            synchronized (firstAvailableDataSource) {
                if (dataSource != this.mCurrentDataSource || dataSource == this.mDataSourceWithResult) {
                    return;
                }
                if (this.mDataSourceWithResult == null || isFinished) {
                    oldDataSource = this.mDataSourceWithResult;
                    this.mDataSourceWithResult = dataSource;
                }
            }
            this.closeSafely(oldDataSource);
        }

        private void onDataSourceFailed(DataSource<T> dataSource) {
            if (!this.clearCurrentDataSource(dataSource)) {
                return;
            }
            if (dataSource != this.getDataSourceWithResult()) {
                this.closeSafely(dataSource);
            }
            if (!this.startNextDataSource()) {
                this.setFailure(dataSource.getFailureCause(), dataSource.getExtras());
            }
        }

        private void onDataSourceNewResult(DataSource<T> dataSource) {
            this.maybeSetDataSourceWithResult(dataSource, dataSource.isFinished());
            if (dataSource == this.getDataSourceWithResult()) {
                this.setResult(null, dataSource.isFinished(), dataSource.getExtras());
            }
        }

        private void closeSafely(@Nullable DataSource<T> dataSource) {
            if (dataSource != null) {
                dataSource.close();
            }
        }

        private class InternalDataSubscriber
        implements DataSubscriber<T> {
            private InternalDataSubscriber() {
            }

            @Override
            public void onFailure(DataSource<T> dataSource) {
                FirstAvailableDataSource.this.onDataSourceFailed(dataSource);
            }

            @Override
            public void onCancellation(DataSource<T> dataSource) {
            }

            @Override
            public void onNewResult(DataSource<T> dataSource) {
                if (dataSource.hasResult()) {
                    FirstAvailableDataSource.this.onDataSourceNewResult(dataSource);
                } else if (dataSource.isFinished()) {
                    FirstAvailableDataSource.this.onDataSourceFailed(dataSource);
                }
            }

            @Override
            public void onProgressUpdate(DataSource<T> dataSource) {
                float oldProgress = FirstAvailableDataSource.this.getProgress();
                FirstAvailableDataSource.this.setProgress(Math.max(oldProgress, dataSource.getProgress()));
            }
        }
    }
}

