/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.datasource;

import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nonnull;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public abstract class BaseDataSubscriber<T>
implements DataSubscriber<T> {
    @Override
    public void onNewResult(@Nonnull DataSource<T> dataSource) {
        boolean shouldClose = dataSource.isFinished();
        try {
            this.onNewResultImpl(dataSource);
        }
        finally {
            if (shouldClose) {
                dataSource.close();
            }
        }
    }

    @Override
    public void onFailure(@Nonnull DataSource<T> dataSource) {
        try {
            this.onFailureImpl(dataSource);
        }
        finally {
            dataSource.close();
        }
    }

    @Override
    public void onCancellation(@Nonnull DataSource<T> dataSource) {
    }

    @Override
    public void onProgressUpdate(@Nonnull DataSource<T> dataSource) {
    }

    protected abstract void onNewResultImpl(@Nonnull DataSource<T> var1);

    protected abstract void onFailureImpl(@Nonnull DataSource<T> var1);
}

