/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.util;

import com.facebook.infer.annotation.Functional;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public enum TriState {
    YES,
    NO,
    UNSET;


    @Functional
    public boolean isSet() {
        return this != UNSET;
    }

    @Functional
    public static TriState valueOf(boolean bool) {
        return bool ? YES : NO;
    }

    @Functional
    public static TriState valueOf(@Nullable Boolean bool) {
        return bool != null ? TriState.valueOf((boolean)bool) : UNSET;
    }

    @Functional
    public boolean asBoolean() {
        switch (this) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case UNSET: {
                throw new IllegalStateException("No boolean equivalent for UNSET");
            }
        }
        throw new IllegalStateException("Unrecognized TriState value: " + (Object)((Object)this));
    }

    @Functional
    public boolean asBoolean(boolean defaultValue) {
        switch (this) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case UNSET: {
                return defaultValue;
            }
        }
        throw new IllegalStateException("Unrecognized TriState value: " + (Object)((Object)this));
    }

    @Nullable
    @Functional
    public Boolean asBooleanObject() {
        switch (this) {
            case YES: {
                return Boolean.TRUE;
            }
            case NO: {
                return Boolean.FALSE;
            }
            case UNSET: {
                return null;
            }
        }
        throw new IllegalStateException("Unrecognized TriState value: " + (Object)((Object)this));
    }

    @Functional
    public int getDbValue() {
        switch (this) {
            case YES: {
                return 1;
            }
            case NO: {
                return 2;
            }
        }
        return 3;
    }

    @Functional
    public static TriState fromDbValue(int value) {
        switch (value) {
            case 1: {
                return YES;
            }
            case 2: {
                return NO;
            }
        }
        return UNSET;
    }
}

