/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.statfs;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import com.facebook.common.internal.Throwables;
import com.facebook.infer.annotation.Nullsafe;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class StatFsHelper {
    public static final int DEFAULT_DISK_YELLOW_LEVEL_IN_MB = 400;
    public static final long DEFAULT_DISK_YELLOW_LEVEL_IN_BYTES = 0x19000000L;
    public static final int DEFAULT_DISK_RED_LEVEL_IN_MB = 100;
    public static final long DEFAULT_DISK_RED_LEVEL_IN_BYTES = 0x6400000L;
    public static final long DEFAULT_DISK_OLIVE_LEVEL_IN_BYTES = 1048576000L;
    private static StatFsHelper sStatsFsHelper;
    private static final long RESTAT_INTERVAL_MS;
    @Nullable
    private volatile StatFs mInternalStatFs = null;
    @Nullable
    private volatile File mInternalPath;
    @Nullable
    private volatile StatFs mExternalStatFs = null;
    @Nullable
    private volatile File mExternalPath;
    @GuardedBy(value="lock")
    private long mLastRestatTime;
    private final Lock lock = new ReentrantLock();
    private volatile boolean mInitialized = false;

    public static synchronized StatFsHelper getInstance() {
        if (sStatsFsHelper == null) {
            sStatsFsHelper = new StatFsHelper();
        }
        return sStatsFsHelper;
    }

    protected StatFsHelper() {
    }

    private void ensureInitialized() {
        if (!this.mInitialized) {
            this.lock.lock();
            try {
                if (!this.mInitialized) {
                    this.mInternalPath = Environment.getDataDirectory();
                    this.mExternalPath = Environment.getExternalStorageDirectory();
                    this.updateStats();
                    this.mInitialized = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean testLowDiskSpace(StorageType storageType, long freeSpaceThreshold) {
        this.ensureInitialized();
        long availableStorageSpace = this.getAvailableStorageSpace(storageType);
        if (availableStorageSpace > 0L) {
            return availableStorageSpace < freeSpaceThreshold;
        }
        return true;
    }

    @SuppressLint(value={"DeprecatedMethod"})
    public long getFreeStorageSpace(StorageType storageType) {
        StatFs statFS;
        this.ensureInitialized();
        this.maybeUpdateStats();
        StatFs statFs = statFS = storageType == StorageType.INTERNAL ? this.mInternalStatFs : this.mExternalStatFs;
        if (statFS != null) {
            long availableBlocks;
            long blockSize;
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = statFS.getBlockSizeLong();
                availableBlocks = statFS.getFreeBlocksLong();
            } else {
                blockSize = statFS.getBlockSize();
                availableBlocks = statFS.getFreeBlocks();
            }
            return blockSize * availableBlocks;
        }
        return -1L;
    }

    @SuppressLint(value={"DeprecatedMethod"})
    public long getTotalStorageSpace(StorageType storageType) {
        StatFs statFS;
        this.ensureInitialized();
        this.maybeUpdateStats();
        StatFs statFs = statFS = storageType == StorageType.INTERNAL ? this.mInternalStatFs : this.mExternalStatFs;
        if (statFS != null) {
            long totalBlocks;
            long blockSize;
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = statFS.getBlockSizeLong();
                totalBlocks = statFS.getBlockCountLong();
            } else {
                blockSize = statFS.getBlockSize();
                totalBlocks = statFS.getBlockCount();
            }
            return blockSize * totalBlocks;
        }
        return -1L;
    }

    @SuppressLint(value={"DeprecatedMethod"})
    public long getAvailableStorageSpace(StorageType storageType) {
        StatFs statFS;
        this.ensureInitialized();
        this.maybeUpdateStats();
        StatFs statFs = statFS = storageType == StorageType.INTERNAL ? this.mInternalStatFs : this.mExternalStatFs;
        if (statFS != null) {
            long availableBlocks;
            long blockSize;
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = statFS.getBlockSizeLong();
                availableBlocks = statFS.getAvailableBlocksLong();
            } else {
                blockSize = statFS.getBlockSize();
                availableBlocks = statFS.getAvailableBlocks();
            }
            return blockSize * availableBlocks;
        }
        return 0L;
    }

    public boolean isLowSpaceCondition() {
        return this.getAvailableStorageSpace(StorageType.INTERNAL) < 0x19000000L;
    }

    public boolean isVeryLowSpaceCondition() {
        return this.getAvailableStorageSpace(StorageType.INTERNAL) < 0x6400000L;
    }

    public boolean isHighSpaceCondition() {
        return this.getAvailableStorageSpace(StorageType.INTERNAL) > 1048576000L;
    }

    private void maybeUpdateStats() {
        if (this.lock.tryLock()) {
            try {
                if (SystemClock.uptimeMillis() - this.mLastRestatTime > RESTAT_INTERVAL_MS) {
                    this.updateStats();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void resetStats() {
        if (this.lock.tryLock()) {
            try {
                this.ensureInitialized();
                this.updateStats();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @GuardedBy(value="lock")
    private void updateStats() {
        this.mInternalStatFs = this.updateStatsHelper(this.mInternalStatFs, this.mInternalPath);
        this.mExternalStatFs = this.updateStatsHelper(this.mExternalStatFs, this.mExternalPath);
        this.mLastRestatTime = SystemClock.uptimeMillis();
    }

    @Nullable
    private StatFs updateStatsHelper(@Nullable StatFs statfs, @Nullable File dir) {
        if (dir == null || !dir.exists()) {
            return null;
        }
        try {
            if (statfs == null) {
                statfs = StatFsHelper.createStatFs(dir.getAbsolutePath());
            } else {
                statfs.restat(dir.getAbsolutePath());
            }
        }
        catch (IllegalArgumentException ex) {
            statfs = null;
        }
        catch (Throwable ex) {
            throw Throwables.propagate(ex);
        }
        return statfs;
    }

    protected static StatFs createStatFs(String path) {
        return new StatFs(path);
    }

    static {
        RESTAT_INTERVAL_MS = TimeUnit.MINUTES.toMillis(2L);
    }

    public static enum StorageType {
        INTERNAL,
        EXTERNAL;

    }
}

