/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.memory;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.infer.annotation.Nullsafe;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@NotThreadSafe
public class PooledByteBufferInputStream
extends InputStream {
    @VisibleForTesting
    final PooledByteBuffer mPooledByteBuffer;
    @VisibleForTesting
    int mOffset;
    @VisibleForTesting
    int mMark;

    public PooledByteBufferInputStream(PooledByteBuffer pooledByteBuffer) {
        Preconditions.checkArgument(!pooledByteBuffer.isClosed());
        this.mPooledByteBuffer = Preconditions.checkNotNull(pooledByteBuffer);
        this.mOffset = 0;
        this.mMark = 0;
    }

    @Override
    public int available() {
        return this.mPooledByteBuffer.size() - this.mOffset;
    }

    @Override
    public void mark(int readlimit) {
        this.mMark = this.mOffset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        if (this.available() <= 0) {
            return -1;
        }
        return this.mPooledByteBuffer.read(this.mOffset++) & 0xFF;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + length);
        }
        int available = this.available();
        if (available <= 0) {
            return -1;
        }
        if (length <= 0) {
            return 0;
        }
        int numToRead = Math.min(available, length);
        this.mPooledByteBuffer.read(this.mOffset, buffer, offset, numToRead);
        this.mOffset += numToRead;
        return numToRead;
    }

    @Override
    public void reset() {
        this.mOffset = this.mMark;
    }

    @Override
    public long skip(long byteCount) {
        Preconditions.checkArgument(byteCount >= 0L);
        int skipped = Math.min((int)byteCount, this.available());
        this.mOffset += skipped;
        return skipped;
    }
}

