/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.infer.annotation.Nullsafe;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class PooledByteArrayBufferedInputStream
extends InputStream {
    private static final String TAG = "PooledByteInputStream";
    private final InputStream mInputStream;
    private final byte[] mByteArray;
    private final ResourceReleaser<byte[]> mResourceReleaser;
    private int mBufferedSize;
    private int mBufferOffset;
    private boolean mClosed;

    public PooledByteArrayBufferedInputStream(InputStream inputStream, byte[] byteArray, ResourceReleaser<byte[]> resourceReleaser) {
        this.mInputStream = Preconditions.checkNotNull(inputStream);
        this.mByteArray = Preconditions.checkNotNull(byteArray);
        this.mResourceReleaser = Preconditions.checkNotNull(resourceReleaser);
        this.mBufferedSize = 0;
        this.mBufferOffset = 0;
        this.mClosed = false;
    }

    @Override
    public int read() throws IOException {
        Preconditions.checkState(this.mBufferOffset <= this.mBufferedSize);
        this.ensureNotClosed();
        if (!this.ensureDataInBuffer()) {
            return -1;
        }
        return this.mByteArray[this.mBufferOffset++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        Preconditions.checkState(this.mBufferOffset <= this.mBufferedSize);
        this.ensureNotClosed();
        if (!this.ensureDataInBuffer()) {
            return -1;
        }
        int bytesToRead = Math.min(this.mBufferedSize - this.mBufferOffset, length);
        System.arraycopy(this.mByteArray, this.mBufferOffset, buffer, offset, bytesToRead);
        this.mBufferOffset += bytesToRead;
        return bytesToRead;
    }

    @Override
    public int available() throws IOException {
        Preconditions.checkState(this.mBufferOffset <= this.mBufferedSize);
        this.ensureNotClosed();
        return this.mBufferedSize - this.mBufferOffset + this.mInputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mResourceReleaser.release(this.mByteArray);
            super.close();
        }
    }

    @Override
    public long skip(long byteCount) throws IOException {
        Preconditions.checkState(this.mBufferOffset <= this.mBufferedSize);
        this.ensureNotClosed();
        int bytesLeftInBuffer = this.mBufferedSize - this.mBufferOffset;
        if ((long)bytesLeftInBuffer >= byteCount) {
            this.mBufferOffset = (int)((long)this.mBufferOffset + byteCount);
            return byteCount;
        }
        this.mBufferOffset = this.mBufferedSize;
        return (long)bytesLeftInBuffer + this.mInputStream.skip(byteCount - (long)bytesLeftInBuffer);
    }

    private boolean ensureDataInBuffer() throws IOException {
        if (this.mBufferOffset < this.mBufferedSize) {
            return true;
        }
        int readData = this.mInputStream.read(this.mByteArray);
        if (readData <= 0) {
            return false;
        }
        this.mBufferedSize = readData;
        this.mBufferOffset = 0;
        return true;
    }

    private void ensureNotClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("stream already closed");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.mClosed) {
            FLog.e(TAG, "Finalized without closing");
            this.close();
        }
        super.finalize();
    }
}

