/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.memory;

import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public enum MemoryTrimType {
    OnCloseToDalvikHeapLimit(0.5),
    OnSystemMemoryCriticallyLowWhileAppInForeground(1.0),
    OnSystemLowMemoryWhileAppInForeground(0.5),
    OnSystemLowMemoryWhileAppInBackgroundLowSeverity(1.0),
    OnSystemModerateMemory(0.5),
    OnAppBackgrounded(1.0),
    OnJavaMemoryRed(1.0),
    OnJavaMemoryYellow(0.5),
    OnSystemMemoryRed(1.0),
    OnSystemMemoryYellow(0.5);

    private double mSuggestedTrimRatio;

    private MemoryTrimType(double suggestedTrimRatio) {
        this.mSuggestedTrimRatio = suggestedTrimRatio;
    }

    public double getSuggestedTrimRatio() {
        return this.mSuggestedTrimRatio;
    }

    public static MemoryTrimType fromInt(int type) {
        for (MemoryTrimType trimType : MemoryTrimType.values()) {
            if (trimType.ordinal() != type) continue;
            return trimType;
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }
}

