/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.webp;

import android.graphics.BitmapFactory;
import android.os.Build;
import android.util.Base64;
import com.facebook.common.webp.WebpBitmapFactory;
import com.facebook.infer.annotation.Nullsafe;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class WebpSupportStatus {
    public static final boolean sIsSimpleWebpSupported = Build.VERSION.SDK_INT >= 14;
    public static final boolean sIsExtendedWebpSupported = WebpSupportStatus.isExtendedWebpSupported();
    @Nullable
    public static WebpBitmapFactory sWebpBitmapFactory = null;
    private static boolean sWebpLibraryChecked = false;
    private static final String VP8X_WEBP_BASE64 = "UklGRkoAAABXRUJQVlA4WAoAAAAQAAAAAAAAAAAAQUxQSAwAAAARBxAR/Q9ERP8DAABWUDggGAAAABQBAJ0BKgEAAQAAAP4AAA3AAP7mtQAAAA==";
    private static final int SIMPLE_WEBP_HEADER_LENGTH = 20;
    private static final int EXTENDED_WEBP_HEADER_LENGTH = 21;
    private static final byte[] WEBP_RIFF_BYTES = WebpSupportStatus.asciiBytes("RIFF");
    private static final byte[] WEBP_NAME_BYTES = WebpSupportStatus.asciiBytes("WEBP");
    private static final byte[] WEBP_VP8_BYTES = WebpSupportStatus.asciiBytes("VP8 ");
    private static final byte[] WEBP_VP8L_BYTES = WebpSupportStatus.asciiBytes("VP8L");
    private static final byte[] WEBP_VP8X_BYTES = WebpSupportStatus.asciiBytes("VP8X");

    @Nullable
    public static WebpBitmapFactory loadWebpBitmapFactoryIfExists() {
        if (sWebpLibraryChecked) {
            return sWebpBitmapFactory;
        }
        WebpBitmapFactory loadedWebpBitmapFactory = null;
        try {
            loadedWebpBitmapFactory = (WebpBitmapFactory)Class.forName("com.facebook.webpsupport.WebpBitmapFactoryImpl").newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sWebpLibraryChecked = true;
        return loadedWebpBitmapFactory;
    }

    private static byte[] asciiBytes(String value) {
        try {
            return value.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("ASCII not found!", uee);
        }
    }

    private static boolean isExtendedWebpSupported() {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        if (Build.VERSION.SDK_INT == 17) {
            byte[] decodedBytes = Base64.decode((String)VP8X_WEBP_BASE64, (int)0);
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length, (BitmapFactory.Options)opts);
            if (opts.outHeight != 1 || opts.outWidth != 1) {
                return false;
            }
        }
        return true;
    }

    public static boolean isWebpSupportedByPlatform(byte[] imageHeaderBytes, int offset, int headerSize) {
        if (WebpSupportStatus.isSimpleWebpHeader(imageHeaderBytes, offset)) {
            return sIsSimpleWebpSupported;
        }
        if (WebpSupportStatus.isLosslessWebpHeader(imageHeaderBytes, offset)) {
            return sIsExtendedWebpSupported;
        }
        if (WebpSupportStatus.isExtendedWebpHeader(imageHeaderBytes, offset, headerSize)) {
            if (WebpSupportStatus.isAnimatedWebpHeader(imageHeaderBytes, offset)) {
                return false;
            }
            return sIsExtendedWebpSupported;
        }
        return false;
    }

    public static boolean isAnimatedWebpHeader(byte[] imageHeaderBytes, int offset) {
        boolean isVp8x = WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset + 12, WEBP_VP8X_BYTES);
        boolean hasAnimationBit = (imageHeaderBytes[offset + 20] & 2) == 2;
        return isVp8x && hasAnimationBit;
    }

    public static boolean isSimpleWebpHeader(byte[] imageHeaderBytes, int offset) {
        return WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset + 12, WEBP_VP8_BYTES);
    }

    public static boolean isLosslessWebpHeader(byte[] imageHeaderBytes, int offset) {
        return WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset + 12, WEBP_VP8L_BYTES);
    }

    public static boolean isExtendedWebpHeader(byte[] imageHeaderBytes, int offset, int headerSize) {
        return headerSize >= 21 && WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset + 12, WEBP_VP8X_BYTES);
    }

    public static boolean isExtendedWebpHeaderWithAlpha(byte[] imageHeaderBytes, int offset) {
        boolean isVp8x = WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset + 12, WEBP_VP8X_BYTES);
        boolean hasAlphaBit = (imageHeaderBytes[offset + 20] & 0x10) == 16;
        return isVp8x && hasAlphaBit;
    }

    public static boolean isWebpHeader(byte[] imageHeaderBytes, int offset, int headerSize) {
        return headerSize >= 20 && WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset, WEBP_RIFF_BYTES) && WebpSupportStatus.matchBytePattern(imageHeaderBytes, offset + 8, WEBP_NAME_BYTES);
    }

    private static boolean matchBytePattern(byte[] byteArray, int offset, byte[] pattern) {
        if (pattern == null || byteArray == null) {
            return false;
        }
        if (pattern.length + offset > byteArray.length) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (byteArray[i + offset] == pattern[i]) continue;
            return false;
        }
        return true;
    }
}

