/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.util;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import com.facebook.common.internal.Preconditions;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.PropagatesNullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class UriUtil {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String LOCAL_FILE_SCHEME = "file";
    public static final String LOCAL_CONTENT_SCHEME = "content";
    private static final Uri LOCAL_CONTACT_IMAGE_URI = Uri.withAppendedPath((Uri)((Uri)Assertions.assumeNotNull((Object)ContactsContract.AUTHORITY_URI)), (String)"display_photo");
    public static final String LOCAL_ASSET_SCHEME = "asset";
    public static final String LOCAL_RESOURCE_SCHEME = "res";
    public static final String QUALIFIED_RESOURCE_SCHEME = "android.resource";
    public static final String DATA_SCHEME = "data";

    @Nullable
    public static URL uriToUrl(@Nullable @PropagatesNullable Uri uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URL(uri.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isNetworkUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return HTTPS_SCHEME.equals(scheme) || HTTP_SCHEME.equals(scheme);
    }

    public static boolean isLocalFileUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_FILE_SCHEME.equals(scheme);
    }

    public static boolean isLocalContentUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_CONTENT_SCHEME.equals(scheme);
    }

    public static boolean isLocalContactUri(Uri uri) {
        if (uri.getPath() == null) {
            return false;
        }
        return UriUtil.isLocalContentUri(uri) && "com.android.contacts".equals(uri.getAuthority()) && !uri.getPath().startsWith((String)Assertions.assumeNotNull((Object)LOCAL_CONTACT_IMAGE_URI.getPath()));
    }

    public static boolean isLocalCameraUri(Uri uri) {
        String uriString = uri.toString();
        return uriString.startsWith(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString()) || uriString.startsWith(MediaStore.Images.Media.INTERNAL_CONTENT_URI.toString());
    }

    public static boolean isLocalAssetUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_ASSET_SCHEME.equals(scheme);
    }

    public static boolean isLocalResourceUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return LOCAL_RESOURCE_SCHEME.equals(scheme);
    }

    public static boolean isQualifiedResourceUri(@Nullable Uri uri) {
        String scheme = UriUtil.getSchemeOrNull(uri);
        return QUALIFIED_RESOURCE_SCHEME.equals(scheme);
    }

    public static boolean isDataUri(@Nullable Uri uri) {
        return DATA_SCHEME.equals(UriUtil.getSchemeOrNull(uri));
    }

    @Nullable
    public static String getSchemeOrNull(@Nullable Uri uri) {
        return uri == null ? null : uri.getScheme();
    }

    @Nullable
    public static Uri parseUriOrNull(@Nullable String uriAsString) {
        return uriAsString != null ? Uri.parse((String)uriAsString) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getRealPathFromUri(ContentResolver contentResolver, Uri srcUri) {
        String result = null;
        Uri uri = srcUri;
        String mimeTypeString = contentResolver.getType(uri);
        if (UriUtil.isLocalContentUri(uri)) {
            boolean isVideo = mimeTypeString != null && mimeTypeString.startsWith("video/");
            String selection = null;
            String[] selectionArgs = null;
            if (Build.VERSION.SDK_INT >= 19 && "com.android.providers.media.documents".equals(uri.getAuthority())) {
                String documentId = DocumentsContract.getDocumentId((Uri)uri);
                Preconditions.checkNotNull(documentId);
                uri = Preconditions.checkNotNull(UriUtil.getExternalContentUri(isVideo));
                selection = UriUtil.getMediaIdString(isVideo) + "=?";
                selectionArgs = new String[]{documentId.split(":")[1]};
            }
            try (Cursor cursor = contentResolver.query(uri, new String[]{UriUtil.getDataPathString(isVideo)}, selection, selectionArgs, null);){
                if (cursor == null) return result;
                if (!cursor.moveToFirst()) return result;
                int idx = cursor.getColumnIndexOrThrow(UriUtil.getDataPathString(isVideo));
                if (idx == -1) return result;
                result = cursor.getString(idx);
                return result;
            }
        } else {
            if (!UriUtil.isLocalFileUri(uri)) return result;
            return uri.getPath();
        }
    }

    private static Uri getExternalContentUri(boolean isVideo) {
        return isVideo ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    }

    private static String getMediaIdString(boolean isVideo) {
        return isVideo ? "_id" : "_id";
    }

    private static String getDataPathString(boolean isVideo) {
        return isVideo ? "_data" : "_data";
    }

    @Nullable
    public static AssetFileDescriptor getAssetFileDescriptor(ContentResolver contentResolver, Uri srcUri) {
        if (UriUtil.isLocalContentUri(srcUri)) {
            try {
                return contentResolver.openAssetFileDescriptor(srcUri, "r");
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public static Uri getUriForFile(File file) {
        return Uri.fromFile((File)file);
    }

    public static Uri getUriForResourceId(int resourceId) {
        return new Uri.Builder().scheme(LOCAL_RESOURCE_SCHEME).path(String.valueOf(resourceId)).build();
    }

    public static Uri getUriForQualifiedResource(String packageName, int resourceId) {
        return new Uri.Builder().scheme(QUALIFIED_RESOURCE_SCHEME).authority(packageName).path(String.valueOf(resourceId)).build();
    }
}

