/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.time;

import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.time.Clock;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface MonotonicClock {
    @DoNotStrip
    public long nowNanos();

    @DoNotStrip
    default public long now() {
        return TimeUnit.NANOSECONDS.toMillis(this.nowNanos());
    }

    public static MonotonicClock of(Clock provider) {
        return new MonotonicClockWrapper(provider);
    }

    public static final class MonotonicClockWrapper
    implements MonotonicClock {
        private final Clock provider;
        private long mLast;

        private MonotonicClockWrapper(Clock provider) {
            this.provider = provider;
            this.mLast = provider.now();
        }

        @Override
        public long nowNanos() {
            return TimeUnit.MILLISECONDS.toNanos(this.now());
        }

        @Override
        public long now() {
            this.mLast = Math.max(this.mLast, this.provider.now());
            return this.mLast;
        }
    }
}

