/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.media;

import androidx.annotation.NonNull;
import com.facebook.common.media.MimeTypeMapWrapper;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0002J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0007J\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0007J\u0012\u0010\f\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u000e\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007R\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/common/media/MediaUtils;", "", "()V", "ADDITIONAL_ALLOWED_MIME_TYPES", "", "", "extractExtension", "path", "extractMime", "isNonNativeSupportedMimeType", "", "mimeType", "isPhoto", "isThreeD", "isVideo", "fbcore_release"})
public final class MediaUtils {
    @NotNull
    public static final MediaUtils INSTANCE = new MediaUtils();
    @JvmField
    @NotNull
    public static final Map<String, String> ADDITIONAL_ALLOWED_MIME_TYPES;

    private MediaUtils() {
    }

    @JvmStatic
    public static final boolean isPhoto(@Nullable String mimeType) {
        String string = mimeType;
        return string != null ? StringsKt.startsWith$default((String)string, (String)"image/", (boolean)false, (int)2, null) : false;
    }

    @JvmStatic
    public static final boolean isVideo(@Nullable String mimeType) {
        String string = mimeType;
        return string != null ? StringsKt.startsWith$default((String)string, (String)"video/", (boolean)false, (int)2, null) : false;
    }

    @JvmStatic
    public static final boolean isThreeD(@Nullable String mimeType) {
        return Intrinsics.areEqual((Object)mimeType, (Object)"model/gltf-binary");
    }

    @JvmStatic
    @Nullable
    public static final String extractMime(@NonNull @NotNull String path) {
        String string;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                string = INSTANCE.extractExtension(path);
                if (string == null) break block4;
                String string2 = string;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                string = string3;
                if (string3 != null) break block5;
            }
            return null;
        }
        String extension = string;
        String string4 = MimeTypeMapWrapper.getMimeTypeFromExtension(extension);
        if (string4 == null) {
            string4 = ADDITIONAL_ALLOWED_MIME_TYPES.get(extension);
        }
        return string4;
    }

    private final String extractExtension(@NonNull String path) {
        String string;
        int pos = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (pos < 0 || pos == path.length() - 1) {
            string = null;
        } else {
            String string2 = path.substring(pos + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    @JvmStatic
    public static final boolean isNonNativeSupportedMimeType(@NonNull @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return ADDITIONAL_ALLOWED_MIME_TYPES.containsValue(mimeType);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"mkv", (Object)"video/x-matroska"), TuplesKt.to((Object)"glb", (Object)"model/gltf-binary")};
        ADDITIONAL_ALLOWED_MIME_TYPES = MapsKt.mapOf((Pair[])pairArray);
    }
}

