/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.debug;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.drawee.debug.listener.ImageLoadingTimeListener;
import com.facebook.drawee.drawable.ScalingUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;

public class DebugControllerOverlayDrawable
extends Drawable
implements ImageLoadingTimeListener {
    private static final String NO_CONTROLLER_ID = "none";
    @VisibleForTesting
    static final int TEXT_COLOR_IMAGE_OK = -16711936;
    @VisibleForTesting
    static final int TEXT_COLOR_IMAGE_ALMOST_OK = -256;
    @VisibleForTesting
    static final int TEXT_COLOR_IMAGE_NOT_OK = -65536;
    private static final float IMAGE_SIZE_THRESHOLD_OK = 0.1f;
    private static final float IMAGE_SIZE_THRESHOLD_NOT_OK = 0.5f;
    private static final int OUTLINE_COLOR = -26624;
    private static final int TEXT_BACKGROUND_COLOR = 0x66000000;
    private static final int TEXT_COLOR = -1;
    private static final int OUTLINE_STROKE_WIDTH_PX = 2;
    private static final int MAX_TEXT_SIZE_PX = 40;
    private static final int MIN_TEXT_SIZE_PX = 10;
    private static final int TEXT_LINE_SPACING_PX = 8;
    private static final int TEXT_PADDING_PX = 10;
    private static final int MAX_NUMBER_OF_LINES = 9;
    private static final int MAX_LINE_WIDTH_EM = 8;
    private String mControllerId;
    @Nullable
    private String mImageId;
    private int mWidthPx;
    private int mHeightPx;
    private int mImageSizeBytes;
    @Nullable
    private String mImageFormat;
    @Nullable
    private ScalingUtils.ScaleType mScaleType;
    private HashMap<String, String> mAdditionalData = new HashMap();
    private int mFrameCount;
    private int mLoopCount;
    private int mTextGravity = 80;
    private final Paint mPaint = new Paint(1);
    private final Matrix mMatrix = new Matrix();
    private final Rect mRect = new Rect();
    private final RectF mRectF = new RectF();
    private int mStartTextXPx;
    private int mStartTextYPx;
    private int mLineIncrementPx;
    private int mCurrentTextXPx;
    private int mCurrentTextYPx;
    private long mFinalImageTimeMs;
    @Nullable
    private String mOriginText;
    private int mOriginColor = -1;
    private int mOverlayColor = 0;

    public DebugControllerOverlayDrawable() {
        this.reset();
    }

    public void reset() {
        this.mWidthPx = -1;
        this.mHeightPx = -1;
        this.mImageSizeBytes = -1;
        this.mAdditionalData = new HashMap();
        this.mFrameCount = -1;
        this.mLoopCount = -1;
        this.mImageFormat = null;
        this.setControllerId(null);
        this.mFinalImageTimeMs = -1L;
        this.mOriginText = null;
        this.mOriginColor = -1;
        this.invalidateSelf();
    }

    public void setTextGravity(int textGravity) {
        this.mTextGravity = textGravity;
        this.invalidateSelf();
    }

    public void setControllerId(@Nullable String controllerId) {
        this.mControllerId = controllerId != null ? controllerId : NO_CONTROLLER_ID;
        this.invalidateSelf();
    }

    public void setImageId(@Nullable String imageId) {
        this.mImageId = imageId;
        this.invalidateSelf();
    }

    public void setDimensions(int widthPx, int heightPx) {
        this.mWidthPx = widthPx;
        this.mHeightPx = heightPx;
        this.invalidateSelf();
    }

    public void setAnimationInfo(int frameCount, int loopCount) {
        this.mFrameCount = frameCount;
        this.mLoopCount = loopCount;
        this.invalidateSelf();
    }

    public void setOrigin(String text, int color) {
        this.mOriginText = text;
        this.mOriginColor = color;
        this.invalidateSelf();
    }

    public void setImageSize(int imageSizeBytes) {
        this.mImageSizeBytes = imageSizeBytes;
    }

    public void addAdditionalData(String key, String value) {
        this.mAdditionalData.put(key, value);
    }

    public void setImageFormat(@Nullable String imageFormat) {
        this.mImageFormat = imageFormat;
    }

    public void setScaleType(@Nullable ScalingUtils.ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    public void setOverlayColor(int overlayColor) {
        this.mOverlayColor = overlayColor;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.prepareDebugTextParameters(bounds, 9, 8);
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(2.0f);
        this.mPaint.setColor(-26624);
        canvas.drawRect((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mOverlayColor);
        canvas.drawRect((float)bounds.left, (float)bounds.top, (float)bounds.right, (float)bounds.bottom, this.mPaint);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setStrokeWidth(0.0f);
        this.mPaint.setColor(-1);
        this.mCurrentTextXPx = this.mStartTextXPx;
        this.mCurrentTextYPx = this.mStartTextYPx;
        if (this.mImageId != null) {
            this.addDebugText(canvas, "IDs", DebugControllerOverlayDrawable.format("%s, %s", this.mControllerId, this.mImageId));
        } else {
            this.addDebugText(canvas, "ID", this.mControllerId);
        }
        this.addDebugText(canvas, "D", DebugControllerOverlayDrawable.format("%dx%d", bounds.width(), bounds.height()));
        if (bounds.height() > 0) {
            this.addDebugText(canvas, "DAR", Float.valueOf((float)bounds.width() / (float)bounds.height()));
        }
        int sizeColor = this.determineSizeHintColor(this.mWidthPx, this.mHeightPx, this.mScaleType);
        this.addDebugText(canvas, "I", DebugControllerOverlayDrawable.format("%dx%d", this.mWidthPx, this.mHeightPx), sizeColor);
        if (this.mHeightPx > 0) {
            this.addDebugText(canvas, "IAR", Float.valueOf((float)this.mWidthPx / (float)this.mHeightPx));
        }
        this.addDebugText(canvas, "I", DebugControllerOverlayDrawable.format("%d KiB", this.mImageSizeBytes / 1024));
        if (this.mImageFormat != null) {
            this.addDebugText(canvas, "i format", this.mImageFormat);
        }
        if (this.mFrameCount > 0) {
            this.addDebugText(canvas, "anim", DebugControllerOverlayDrawable.format("f %d, l %d", this.mFrameCount, this.mLoopCount));
        }
        if (this.mScaleType != null) {
            this.addDebugText(canvas, "scale", this.mScaleType);
        }
        if (this.mFinalImageTimeMs >= 0L) {
            this.addDebugText(canvas, "t", DebugControllerOverlayDrawable.format("%d ms", this.mFinalImageTimeMs));
        }
        if (this.mOriginText != null) {
            this.addDebugText(canvas, "origin", this.mOriginText, this.mOriginColor);
        }
        for (Map.Entry<String, String> entry : this.mAdditionalData.entrySet()) {
            this.addDebugText(canvas, entry.getKey(), entry.getValue());
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    private void prepareDebugTextParameters(Rect bounds, int numberOfLines, int maxLineLengthEm) {
        int textSizePx = Math.min(bounds.width() / maxLineLengthEm, bounds.height() / numberOfLines);
        textSizePx = Math.min(40, Math.max(10, textSizePx));
        this.mPaint.setTextSize((float)textSizePx);
        this.mLineIncrementPx = textSizePx + 8;
        if (this.mTextGravity == 80) {
            this.mLineIncrementPx *= -1;
        }
        this.mStartTextXPx = bounds.left + 10;
        this.mStartTextYPx = this.mTextGravity == 80 ? bounds.bottom - 10 : bounds.top + 10 + 10;
    }

    private static String format(String text, Object ... args) {
        return args == null ? text : String.format(Locale.US, text, args);
    }

    private void addDebugText(Canvas canvas, String label, Object value) {
        this.addDebugText(canvas, label, String.valueOf(value), -1);
    }

    private void addDebugText(Canvas canvas, String label, String value) {
        this.addDebugText(canvas, label, value, -1);
    }

    private void addDebugText(Canvas canvas, String label, String value, int valueColor) {
        String labelColon = label + ": ";
        float labelWidth = this.mPaint.measureText(labelColon);
        float valueWidth = this.mPaint.measureText(value);
        int margin = 4;
        this.mPaint.setColor(0x66000000);
        canvas.drawRect((float)(this.mCurrentTextXPx - 4), (float)(this.mCurrentTextYPx + 8), (float)this.mCurrentTextXPx + labelWidth + valueWidth + 4.0f, (float)(this.mCurrentTextYPx + this.mLineIncrementPx + 8), this.mPaint);
        this.mPaint.setColor(-1);
        canvas.drawText(labelColon, (float)this.mCurrentTextXPx, (float)this.mCurrentTextYPx, this.mPaint);
        this.mPaint.setColor(valueColor);
        canvas.drawText(value, (float)this.mCurrentTextXPx + labelWidth, (float)this.mCurrentTextYPx, this.mPaint);
        this.mCurrentTextYPx += this.mLineIncrementPx;
    }

    @VisibleForTesting
    int determineSizeHintColor(int imageWidth, int imageHeight, @Nullable ScalingUtils.ScaleType scaleType) {
        int visibleDrawnAreaWidth = this.getBounds().width();
        int visibleDrawnAreaHeight = this.getBounds().height();
        if (visibleDrawnAreaWidth <= 0 || visibleDrawnAreaHeight <= 0 || imageWidth <= 0 || imageHeight <= 0) {
            return -65536;
        }
        if (scaleType != null) {
            this.mRect.top = 0;
            this.mRect.left = 0;
            this.mRect.right = visibleDrawnAreaWidth;
            this.mRect.bottom = visibleDrawnAreaHeight;
            this.mMatrix.reset();
            scaleType.getTransform(this.mMatrix, this.mRect, imageWidth, imageHeight, 0.0f, 0.0f);
            this.mRectF.top = 0.0f;
            this.mRectF.left = 0.0f;
            this.mRectF.right = imageWidth;
            this.mRectF.bottom = imageHeight;
            this.mMatrix.mapRect(this.mRectF);
            int drawnAreaWidth = (int)this.mRectF.width();
            int drawnAreaHeight = (int)this.mRectF.height();
            visibleDrawnAreaWidth = Math.min(visibleDrawnAreaWidth, drawnAreaWidth);
            visibleDrawnAreaHeight = Math.min(visibleDrawnAreaHeight, drawnAreaHeight);
        }
        float scaledImageWidthThresholdOk = (float)visibleDrawnAreaWidth * 0.1f;
        float scaledImageWidthThresholdNotOk = (float)visibleDrawnAreaWidth * 0.5f;
        float scaledImageHeightThresholdOk = (float)visibleDrawnAreaHeight * 0.1f;
        float scaledImageHeightThresholdNotOk = (float)visibleDrawnAreaHeight * 0.5f;
        int absWidthDifference = Math.abs(imageWidth - visibleDrawnAreaWidth);
        int absHeightDifference = Math.abs(imageHeight - visibleDrawnAreaHeight);
        if ((float)absWidthDifference < scaledImageWidthThresholdOk && (float)absHeightDifference < scaledImageHeightThresholdOk) {
            return -16711936;
        }
        if ((float)absWidthDifference < scaledImageWidthThresholdNotOk && (float)absHeightDifference < scaledImageHeightThresholdNotOk) {
            return -256;
        }
        return -65536;
    }

    public void setFinalImageTimeMs(long finalImageTimeMs) {
        this.mFinalImageTimeMs = finalImageTimeMs;
    }

    @Override
    public void onFinalImageSet(long finalImageTimeMs) {
        this.mFinalImageTimeMs = finalImageTimeMs;
        this.invalidateSelf();
    }
}

