/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.webpdrawable;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.animated.webp.WebPFrame;
import com.facebook.animated.webp.WebPImage;
import com.facebook.fresco.animation.backend.AnimationBackend;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class WebpAnimationBackend
implements AnimationBackend {
    private final Rect mRenderDstRect = new Rect();
    private final Rect mRenderSrcRect = new Rect();
    private final WebPImage mWebPImage;
    private Rect mBounds;
    @Nullable
    @GuardedBy(value="this")
    private Bitmap mTempBitmap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebpAnimationBackend create(String filePath) throws IOException {
        WebpAnimationBackend webpAnimationBackend;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(filePath));
            ((InputStream)is).mark(Integer.MAX_VALUE);
            byte[] targetArray = new byte[((InputStream)is).available()];
            ((InputStream)is).read(targetArray);
            WebPImage webPImage = WebPImage.createFromByteArray(targetArray);
            ((InputStream)is).reset();
            webpAnimationBackend = new WebpAnimationBackend(webPImage);
        }
        catch (Throwable throwable) {
            WebpAnimationBackend.closeSilently(is);
            throw throwable;
        }
        WebpAnimationBackend.closeSilently(is);
        return webpAnimationBackend;
    }

    private WebpAnimationBackend(WebPImage webPImage) {
        this.mWebPImage = webPImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawFrame(Drawable parent, Canvas canvas, int frameNumber) {
        WebPFrame frame = this.mWebPImage.getFrame(frameNumber);
        double xScale = (double)this.mBounds.width() / (double)parent.getIntrinsicWidth();
        double yScale = (double)this.mBounds.height() / (double)parent.getIntrinsicHeight();
        int frameWidth = (int)Math.round((double)frame.getWidth() * xScale);
        int frameHeight = (int)Math.round((double)frame.getHeight() * yScale);
        int xOffset = (int)((double)frame.getXOffset() * xScale);
        int yOffset = (int)((double)frame.getYOffset() * yScale);
        WebpAnimationBackend webpAnimationBackend = this;
        synchronized (webpAnimationBackend) {
            int renderedWidth = this.mBounds.width();
            int renderedHeight = this.mBounds.height();
            this.prepareTempBitmapForThisSize(renderedWidth, renderedHeight);
            if (this.mTempBitmap == null) {
                return false;
            }
            frame.renderFrame(frameWidth, frameHeight, this.mTempBitmap);
            this.mRenderSrcRect.set(0, 0, renderedWidth, renderedHeight);
            this.mRenderDstRect.set(xOffset, yOffset, xOffset + renderedWidth, yOffset + renderedHeight);
            canvas.drawBitmap(this.mTempBitmap, this.mRenderSrcRect, this.mRenderDstRect, null);
        }
        return true;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public synchronized void setBounds(Rect bounds) {
        this.mBounds = bounds;
    }

    public int getIntrinsicWidth() {
        return this.mWebPImage.getWidth();
    }

    public int getIntrinsicHeight() {
        return this.mWebPImage.getHeight();
    }

    public int getSizeInBytes() {
        return 0;
    }

    public void clear() {
        this.mWebPImage.dispose();
    }

    public int getFrameCount() {
        return this.mWebPImage.getFrameCount();
    }

    public int getFrameDurationMs(int frameNumber) {
        return this.mWebPImage.getFrameDurations()[frameNumber];
    }

    public int getLoopCount() {
        return this.mWebPImage.getLoopCount();
    }

    private synchronized void prepareTempBitmapForThisSize(int width, int height) {
        if (this.mTempBitmap != null && (this.mTempBitmap.getWidth() < width || this.mTempBitmap.getHeight() < height)) {
            this.clearTempBitmap();
        }
        if (this.mTempBitmap == null) {
            this.mTempBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        this.mTempBitmap.eraseColor(0);
    }

    private synchronized void clearTempBitmap() {
        if (this.mTempBitmap != null) {
            this.mTempBitmap.recycle();
            this.mTempBitmap = null;
        }
    }

    private static void closeSilently(@Nullable Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

