/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.animated.webp;

import com.facebook.animated.webp.WebPFrame;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.factory.AnimatedImageDecoder;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.nativecode.StaticWebpNativeLoader;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@DoNotStrip
public class WebPImage
implements AnimatedImage,
AnimatedImageDecoder {
    @DoNotStrip
    private long mNativeContext;

    @DoNotStrip
    public WebPImage() {
    }

    @DoNotStrip
    WebPImage(long nativeContext) {
        this.mNativeContext = nativeContext;
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    public void dispose() {
        this.nativeDispose();
    }

    public static WebPImage createFromByteArray(byte[] source) {
        StaticWebpNativeLoader.ensure();
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        return WebPImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    public static WebPImage createFromByteBuffer(ByteBuffer byteBuffer) {
        StaticWebpNativeLoader.ensure();
        byteBuffer.rewind();
        return WebPImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    public static WebPImage createFromNativeMemory(long nativePtr, int sizeInBytes) {
        StaticWebpNativeLoader.ensure();
        Preconditions.checkArgument((nativePtr != 0L ? 1 : 0) != 0);
        return WebPImage.nativeCreateFromNativeMemory(nativePtr, sizeInBytes);
    }

    public AnimatedImage decodeFromNativeMemory(long nativePtr, int sizeInBytes, ImageDecodeOptions options) {
        return WebPImage.createFromNativeMemory(nativePtr, sizeInBytes);
    }

    public AnimatedImage decodeFromByteBuffer(ByteBuffer byteBuffer, ImageDecodeOptions options) {
        return WebPImage.createFromByteBuffer(byteBuffer);
    }

    public int getWidth() {
        return this.nativeGetWidth();
    }

    public int getHeight() {
        return this.nativeGetHeight();
    }

    public int getFrameCount() {
        return this.nativeGetFrameCount();
    }

    public int getDuration() {
        return this.nativeGetDuration();
    }

    public int[] getFrameDurations() {
        return this.nativeGetFrameDurations();
    }

    public int getLoopCount() {
        return this.nativeGetLoopCount();
    }

    public WebPFrame getFrame(int frameNumber) {
        return this.nativeGetFrame(frameNumber);
    }

    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    public boolean doesRenderSupportScaling() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        WebPFrame frame = this.getFrame(frameNumber);
        try {
            AnimatedDrawableFrameInfo animatedDrawableFrameInfo = new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), frame.isBlendWithPreviousFrame() ? AnimatedDrawableFrameInfo.BlendOperation.BLEND_WITH_PREVIOUS : AnimatedDrawableFrameInfo.BlendOperation.NO_BLEND, frame.shouldDisposeToBackgroundColor() ? AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND : AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT);
            return animatedDrawableFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    private static native WebPImage nativeCreateFromDirectByteBuffer(ByteBuffer var0);

    private static native WebPImage nativeCreateFromNativeMemory(long var0, int var2);

    private native int nativeGetWidth();

    private native int nativeGetHeight();

    private native int nativeGetDuration();

    private native int nativeGetFrameCount();

    private native int[] nativeGetFrameDurations();

    private native int nativeGetLoopCount();

    private native WebPFrame nativeGetFrame(int var1);

    private native int nativeGetSizeInBytes();

    private native void nativeDispose();

    private native void nativeFinalize();
}

