/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation.ondemandanimation;

import android.os.Handler;
import android.os.HandlerThread;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.DynamicRenderingFps;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoaderFactory;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameResult;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0016\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationCoordinator;", "", "<init>", "()V", "FREQUENCY_PERFORMANCE_MS", "", "FREQUENCY_LOADERS_MS", "FPS_STEP_PERCENTAGE", "", "MIN_RENDERING_FPS_PERCENTAGE", "successCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "failuresCounter", "criticalCounter", "runningAnimations", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/DynamicRenderingFps;", "", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "handler$delegate", "Lkotlin/Lazy;", "calculatePerformance", "Ljava/lang/Runnable;", "clearUnusedFrameLoaders", "schedulePerformance", "", "scheduleLoaders", "updateRenderingFps", "", "animation", "delta", "onRenderFrame", "frameResult", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameResult;", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nAnimationCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnimationCoordinator.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationCoordinator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,130:1\n216#2,2:131\n216#2,2:133\n*S KotlinDebug\n*F\n+ 1 AnimationCoordinator.kt\ncom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/AnimationCoordinator\n*L\n53#1:131,2\n58#1:133,2\n*E\n"})
public final class AnimationCoordinator {
    @NotNull
    public static final AnimationCoordinator INSTANCE = new AnimationCoordinator();
    private static final long FREQUENCY_PERFORMANCE_MS = 2000L;
    private static final long FREQUENCY_LOADERS_MS = 10000L;
    private static final float FPS_STEP_PERCENTAGE = 0.2f;
    private static final float MIN_RENDERING_FPS_PERCENTAGE = 0.5f;
    @NotNull
    private static final AtomicInteger successCounter = new AtomicInteger(0);
    @NotNull
    private static final AtomicInteger failuresCounter = new AtomicInteger(0);
    @NotNull
    private static final AtomicInteger criticalCounter = new AtomicInteger(0);
    @NotNull
    private static final ConcurrentHashMap<DynamicRenderingFps, Integer> runningAnimations = new ConcurrentHashMap();
    @NotNull
    private static final Lazy handler$delegate = LazyKt.lazy(AnimationCoordinator::handler_delegate$lambda$0);
    @NotNull
    private static final Runnable calculatePerformance = AnimationCoordinator::calculatePerformance$lambda$3;
    @NotNull
    private static final Runnable clearUnusedFrameLoaders = AnimationCoordinator::clearUnusedFrameLoaders$lambda$4;

    private AnimationCoordinator() {
    }

    private final Handler getHandler() {
        Lazy lazy = handler$delegate;
        return (Handler)lazy.getValue();
    }

    private final boolean schedulePerformance() {
        return this.getHandler().postDelayed(calculatePerformance, 2000L);
    }

    private final boolean scheduleLoaders() {
        return this.getHandler().postDelayed(clearUnusedFrameLoaders, 10000L);
    }

    private final void updateRenderingFps(DynamicRenderingFps animation, int delta) {
        int minRenderingFps = (int)RangesKt.coerceAtLeast((float)((float)animation.getAnimationFps() * 0.5f), (float)1.0f);
        int renderingFps = RangesKt.coerceIn((int)(animation.getRenderingFps() + delta), (int)minRenderingFps, (int)animation.getAnimationFps());
        if (renderingFps != animation.getRenderingFps()) {
            animation.setRenderingFps(renderingFps);
        }
    }

    public final void onRenderFrame(@NotNull DynamicRenderingFps animation, @NotNull FrameResult frameResult) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)frameResult, (String)"frameResult");
        if (!runningAnimations.contains(animation)) {
            int fps = animation.getAnimationFps();
            int fpsStep = (int)((float)fps * 0.2f);
            Integer n = fpsStep;
            ((Map)runningAnimations).put(animation, n);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[frameResult.getType().ordinal()]) {
            case 1: {
                int n = successCounter.incrementAndGet();
                break;
            }
            case 2: {
                int n = failuresCounter.incrementAndGet();
                break;
            }
            case 3: {
                int n = criticalCounter.incrementAndGet();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Handler handler_delegate$lambda$0() {
        HandlerThread handlerThread = new HandlerThread("FrescoAnimationWorker");
        handlerThread.start();
        return new Handler(handlerThread.getLooper());
    }

    private static final void calculatePerformance$lambda$3() {
        float critical;
        float failures;
        float success = successCounter.getAndSet(0);
        float totalFrames = success + (failures = (float)failuresCounter.getAndSet(0)) + (critical = (float)criticalCounter.getAndSet(0));
        if (totalFrames > 0.0f) {
            float successRatio = success / totalFrames;
            float failuresRatio = failures / totalFrames;
            float criticalRatio = critical / totalFrames;
            if (failuresRatio > 0.25f || criticalRatio > 0.1f) {
                Map $this$forEach$iv = runningAnimations;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    DynamicRenderingFps animation = (DynamicRenderingFps)entry.getKey();
                    int fpsStep = ((Number)entry.getValue()).intValue();
                    INSTANCE.updateRenderingFps(animation, -fpsStep);
                }
            } else if (successRatio > 0.98f) {
                Map $this$forEach$iv = runningAnimations;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    DynamicRenderingFps animation = (DynamicRenderingFps)entry.getKey();
                    int fpsStep = ((Number)entry.getValue()).intValue();
                    INSTANCE.updateRenderingFps(animation, fpsStep);
                }
            }
            runningAnimations.clear();
        }
        INSTANCE.schedulePerformance();
    }

    private static final void clearUnusedFrameLoaders$lambda$4() {
        long maxUnusedTime = System.currentTimeMillis() - 10000L;
        FrameLoaderFactory.Companion.clearUnusedUntil(new Date(maxUnusedTime));
        INSTANCE.scheduleLoaders();
    }

    static {
        INSTANCE.getHandler().post(calculatePerformance);
        INSTANCE.getHandler().post(clearUnusedFrameLoaders);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FrameResult.FrameType.values().length];
            try {
                nArray[FrameResult.FrameType.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrameResult.FrameType.NEAREST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FrameResult.FrameType.MISSING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

