/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.preparation;

import android.graphics.Bitmap;
import androidx.annotation.UiThread;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.fresco.animation.bitmap.BitmapFrameRenderer;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparationStrategy;
import com.facebook.fresco.animation.bitmap.preparation.BitmapFramePreparer;
import com.facebook.fresco.animation.bitmap.preparation.FrameLoaderStrategy;
import com.facebook.fresco.animation.bitmap.preparation.FrameSize;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.AnimationCoordinator;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.DynamicRenderingFps;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoader;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameLoaderFactory;
import com.facebook.fresco.animation.bitmap.preparation.ondemandanimation.FrameResult;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0019\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010 H\u0017J(\u0010!\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0017J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0002J\f\u0010)\u001a\u00020\u0010*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00138BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006*"}, d2={"Lcom/facebook/fresco/animation/bitmap/preparation/FrameLoaderStrategy;", "Lcom/facebook/fresco/animation/bitmap/preparation/BitmapFramePreparationStrategy;", "source", "", "animationInformation", "Lcom/facebook/fresco/animation/backend/AnimationInformation;", "bitmapFrameRenderer", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;", "frameLoaderFactory", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameLoaderFactory;", "downscaleFrameToDrawableDimensions", "", "<init>", "(Ljava/lang/String;Lcom/facebook/fresco/animation/backend/AnimationInformation;Lcom/facebook/fresco/animation/bitmap/BitmapFrameRenderer;Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameLoaderFactory;Z)V", "cacheKey", "animationWidth", "", "animationHeight", "frameLoader", "Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameLoader;", "getFrameLoader", "()Lcom/facebook/fresco/animation/bitmap/preparation/ondemandanimation/FrameLoader;", "maxAnimationFps", "currentFps", "dynamicFpsRender", "com/facebook/fresco/animation/bitmap/preparation/FrameLoaderStrategy$dynamicFpsRender$1", "Lcom/facebook/fresco/animation/bitmap/preparation/FrameLoaderStrategy$dynamicFpsRender$1;", "prepareFrames", "", "canvasWidth", "canvasHeight", "onAnimationLoaded", "Lkotlin/Function0;", "getBitmapFrame", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "frameNumber", "onStop", "clearFrames", "calculateFrameSize", "Lcom/facebook/fresco/animation/bitmap/preparation/FrameSize;", "fps", "animated-drawable_release"})
@SourceDebugExtension(value={"SMAP\nFrameLoaderStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameLoaderStrategy.kt\ncom/facebook/fresco/animation/bitmap/preparation/FrameLoaderStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class FrameLoaderStrategy
implements BitmapFramePreparationStrategy {
    @NotNull
    private final AnimationInformation animationInformation;
    @NotNull
    private final BitmapFrameRenderer bitmapFrameRenderer;
    @NotNull
    private final FrameLoaderFactory frameLoaderFactory;
    private final boolean downscaleFrameToDrawableDimensions;
    @NotNull
    private final String cacheKey;
    private final int animationWidth;
    private final int animationHeight;
    @Nullable
    private FrameLoader frameLoader;
    private final int maxAnimationFps;
    private int currentFps;
    @NotNull
    private final dynamicFpsRender.1 dynamicFpsRender;

    public FrameLoaderStrategy(@Nullable String source, @NotNull AnimationInformation animationInformation, @NotNull BitmapFrameRenderer bitmapFrameRenderer, @NotNull FrameLoaderFactory frameLoaderFactory, boolean downscaleFrameToDrawableDimensions) {
        Intrinsics.checkNotNullParameter((Object)animationInformation, (String)"animationInformation");
        Intrinsics.checkNotNullParameter((Object)bitmapFrameRenderer, (String)"bitmapFrameRenderer");
        Intrinsics.checkNotNullParameter((Object)frameLoaderFactory, (String)"frameLoaderFactory");
        this.animationInformation = animationInformation;
        this.bitmapFrameRenderer = bitmapFrameRenderer;
        this.frameLoaderFactory = frameLoaderFactory;
        this.downscaleFrameToDrawableDimensions = downscaleFrameToDrawableDimensions;
        String string = source;
        if (string == null) {
            string = String.valueOf(this.hashCode());
        }
        this.cacheKey = string;
        this.animationWidth = this.animationInformation.width();
        this.animationHeight = this.animationInformation.height();
        this.currentFps = this.maxAnimationFps = this.fps(this.animationInformation);
        this.dynamicFpsRender = new DynamicRenderingFps(this){
            private final int animationFps;
            final /* synthetic */ FrameLoaderStrategy this$0;
            {
                this.this$0 = $receiver;
                this.animationFps = FrameLoaderStrategy.access$getMaxAnimationFps$p($receiver);
            }

            public int getAnimationFps() {
                return this.animationFps;
            }

            public int getRenderingFps() {
                return FrameLoaderStrategy.access$getCurrentFps$p(this.this$0);
            }

            public void setRenderingFps(int renderingFps) {
                block1: {
                    if (renderingFps == FrameLoaderStrategy.access$getCurrentFps$p(this.this$0)) break block1;
                    FrameLoaderStrategy.access$setCurrentFps$p(this.this$0, RangesKt.coerceIn((int)renderingFps, (int)1, (int)FrameLoaderStrategy.access$getMaxAnimationFps$p(this.this$0)));
                    FrameLoader frameLoader = FrameLoaderStrategy.access$getFrameLoader(this.this$0);
                    if (frameLoader != null) {
                        frameLoader.compressToFps(FrameLoaderStrategy.access$getCurrentFps$p(this.this$0));
                    }
                }
            }
        };
    }

    private final FrameLoader getFrameLoader() {
        if (this.frameLoader == null) {
            this.frameLoader = this.frameLoaderFactory.createBufferLoader(this.cacheKey, this.bitmapFrameRenderer, this.animationInformation);
        }
        return this.frameLoader;
    }

    @Override
    @UiThread
    public void prepareFrames(int canvasWidth, int canvasHeight, @Nullable Function0<Unit> onAnimationLoaded) {
        block2: {
            if (canvasWidth <= 0 || canvasHeight <= 0 || this.animationWidth <= 0 || this.animationHeight <= 0) {
                return;
            }
            FrameSize frameSize = this.calculateFrameSize(canvasWidth, canvasHeight);
            FrameLoader frameLoader = this.getFrameLoader();
            if (frameLoader == null) break block2;
            int n = frameSize.getWidth();
            int n2 = frameSize.getWidth();
            Function0 function0 = onAnimationLoaded;
            if (function0 == null) {
                function0 = FrameLoaderStrategy::prepareFrames$lambda$0;
            }
            frameLoader.prepareFrames(n, n2, function0);
        }
    }

    @Override
    @UiThread
    @Nullable
    public CloseableReference<Bitmap> getBitmapFrame(int frameNumber, int canvasWidth, int canvasHeight) {
        FrameResult frame;
        FrameSize frameSize = this.calculateFrameSize(canvasWidth, canvasHeight);
        FrameLoader frameLoader = this.getFrameLoader();
        FrameResult frameResult = frame = frameLoader != null ? frameLoader.getFrame(frameNumber, frameSize.getWidth(), frameSize.getHeight()) : null;
        if (frameResult != null) {
            FrameResult it = frameResult;
            boolean bl = false;
            AnimationCoordinator.INSTANCE.onRenderFrame(this.dynamicFpsRender, it);
        }
        FrameResult frameResult2 = frame;
        return frameResult2 != null ? frameResult2.getBitmapRef() : null;
    }

    @Override
    public void onStop() {
        FrameLoader frameLoader = this.getFrameLoader();
        if (frameLoader != null) {
            frameLoader.onStop();
        }
        this.clearFrames();
    }

    @Override
    public void clearFrames() {
        FrameLoader frameLoader = this.getFrameLoader();
        if (frameLoader != null) {
            FrameLoader it = frameLoader;
            boolean bl = false;
            FrameLoaderFactory.Companion.saveUnusedFrame(this.cacheKey, it);
        }
        this.frameLoader = null;
    }

    private final FrameSize calculateFrameSize(int canvasWidth, int canvasHeight) {
        if (!this.downscaleFrameToDrawableDimensions) {
            return new FrameSize(this.animationWidth, this.animationHeight);
        }
        int bitmapWidth = this.animationWidth;
        int bitmapHeight = this.animationHeight;
        if (canvasWidth < this.animationWidth || canvasHeight < this.animationHeight) {
            double ratioW = (double)this.animationWidth / (double)this.animationHeight;
            if (canvasHeight > canvasWidth) {
                bitmapHeight = RangesKt.coerceAtMost((int)canvasHeight, (int)this.animationHeight);
                bitmapWidth = (int)((double)bitmapHeight * ratioW);
            } else {
                bitmapWidth = RangesKt.coerceAtMost((int)canvasWidth, (int)this.animationWidth);
                bitmapHeight = (int)((double)bitmapWidth / ratioW);
            }
        }
        return new FrameSize(bitmapWidth, bitmapHeight);
    }

    private final int fps(AnimationInformation $this$fps) {
        return (int)RangesKt.coerceAtLeast((long)(TimeUnit.SECONDS.toMillis(1L) / (long)($this$fps.getLoopDurationMs() / $this$fps.getFrameCount())), (long)1L);
    }

    @Override
    public void prepareFrames(@NotNull BitmapFramePreparer bitmapFramePreparer, @NotNull BitmapFrameCache bitmapFrameCache, @NotNull AnimationBackend animationBackend, int lastDrawnFrameNumber, @Nullable Function0<Unit> onAnimationLoaded) {
        BitmapFramePreparationStrategy.DefaultImpls.prepareFrames(this, bitmapFramePreparer, bitmapFrameCache, animationBackend, lastDrawnFrameNumber, onAnimationLoaded);
    }

    private static final Unit prepareFrames$lambda$0() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ int access$getMaxAnimationFps$p(FrameLoaderStrategy $this) {
        return $this.maxAnimationFps;
    }

    public static final /* synthetic */ int access$getCurrentFps$p(FrameLoaderStrategy $this) {
        return $this.currentFps;
    }

    public static final /* synthetic */ void access$setCurrentFps$p(FrameLoaderStrategy $this, int n) {
        $this.currentFps = n;
    }

    public static final /* synthetic */ FrameLoader access$getFrameLoader(FrameLoaderStrategy $this) {
        return $this.getFrameLoader();
    }
}

