/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.bitmap.cache;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.fresco.animation.bitmap.BitmapFrameCache;
import com.facebook.imageutils.BitmapUtil;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016J(\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0005H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u0018\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J&\u0010\u001b\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\u00172\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lcom/facebook/fresco/animation/bitmap/cache/KeepLastFrameCache;", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache;", "<init>", "()V", "lastFrameNumber", "", "frameCacheListener", "Lcom/facebook/fresco/animation/bitmap/BitmapFrameCache$FrameCacheListener;", "lastBitmapReference", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "getCachedFrame", "frameNumber", "getFallbackFrame", "getBitmapToReuseForFrame", "width", "height", "contains", "", "sizeInBytes", "getSizeInBytes", "()I", "clear", "", "onFrameRendered", "bitmapReference", "frameType", "onFramePrepared", "setFrameCacheListener", "closeAndResetLastBitmapReference", "Companion", "animated-drawable_release"})
public final class KeepLastFrameCache
implements BitmapFrameCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int lastFrameNumber = -1;
    @Nullable
    private BitmapFrameCache.FrameCacheListener frameCacheListener;
    @GuardedBy(value="this")
    @Nullable
    private CloseableReference<Bitmap> lastBitmapReference;
    private static final int FRAME_NUMBER_UNSET = -1;

    @Override
    @Nullable
    public synchronized CloseableReference<Bitmap> getCachedFrame(int frameNumber) {
        return this.lastFrameNumber == frameNumber ? CloseableReference.cloneOrNull(this.lastBitmapReference) : null;
    }

    @Override
    @Nullable
    public synchronized CloseableReference<Bitmap> getFallbackFrame(int frameNumber) {
        return CloseableReference.cloneOrNull(this.lastBitmapReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized CloseableReference<Bitmap> getBitmapToReuseForFrame(int frameNumber, int width, int height) {
        CloseableReference closeableReference;
        try {
            closeableReference = CloseableReference.cloneOrNull(this.lastBitmapReference);
        }
        finally {
            this.closeAndResetLastBitmapReference();
        }
        return closeableReference;
    }

    @Override
    public synchronized boolean contains(int frameNumber) {
        return frameNumber == this.lastFrameNumber && CloseableReference.isValid(this.lastBitmapReference);
    }

    @Override
    public synchronized int getSizeInBytes() {
        int n;
        if (this.lastBitmapReference == null) {
            n = 0;
        } else {
            CloseableReference<Bitmap> closeableReference = this.lastBitmapReference;
            Intrinsics.checkNotNull(closeableReference);
            n = BitmapUtil.getSizeInBytes((Bitmap)((Bitmap)closeableReference.get()));
        }
        return n;
    }

    @Override
    public synchronized void clear() {
        this.closeAndResetLastBitmapReference();
    }

    @Override
    public synchronized void onFrameRendered(int frameNumber, @NotNull CloseableReference<Bitmap> bitmapReference, int frameType) {
        Intrinsics.checkNotNullParameter(bitmapReference, (String)"bitmapReference");
        if (this.lastBitmapReference != null) {
            CloseableReference<Bitmap> closeableReference = this.lastBitmapReference;
            if (Intrinsics.areEqual((Object)bitmapReference.get(), (Object)(closeableReference != null ? (Bitmap)closeableReference.get() : null))) {
                return;
            }
        }
        CloseableReference.closeSafely(this.lastBitmapReference);
        if (this.lastFrameNumber != -1) {
            BitmapFrameCache.FrameCacheListener frameCacheListener = this.frameCacheListener;
            if (frameCacheListener != null) {
                frameCacheListener.onFrameEvicted(this, this.lastFrameNumber);
            }
        }
        this.lastBitmapReference = CloseableReference.cloneOrNull(bitmapReference);
        BitmapFrameCache.FrameCacheListener frameCacheListener = this.frameCacheListener;
        if (frameCacheListener != null) {
            frameCacheListener.onFrameCached(this, frameNumber);
        }
        this.lastFrameNumber = frameNumber;
    }

    @Override
    public void onFramePrepared(int frameNumber, @NotNull CloseableReference<Bitmap> bitmapReference, int frameType) {
        Intrinsics.checkNotNullParameter(bitmapReference, (String)"bitmapReference");
    }

    @Override
    public void setFrameCacheListener(@Nullable BitmapFrameCache.FrameCacheListener frameCacheListener) {
        this.frameCacheListener = frameCacheListener;
    }

    private final synchronized void closeAndResetLastBitmapReference() {
        if (this.lastFrameNumber != -1) {
            BitmapFrameCache.FrameCacheListener frameCacheListener = this.frameCacheListener;
            if (frameCacheListener != null) {
                frameCacheListener.onFrameEvicted(this, this.lastFrameNumber);
            }
        }
        CloseableReference.closeSafely(this.lastBitmapReference);
        this.lastBitmapReference = null;
        this.lastFrameNumber = -1;
    }

    @Override
    public boolean onAnimationPrepared(@NotNull Map<Integer, ? extends CloseableReference<Bitmap>> frameBitmaps) {
        return BitmapFrameCache.DefaultImpls.onAnimationPrepared(this, frameBitmaps);
    }

    @Override
    public boolean isAnimationReady() {
        return BitmapFrameCache.DefaultImpls.isAnimationReady(this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/fresco/animation/bitmap/cache/KeepLastFrameCache$Companion;", "", "<init>", "()V", "FRAME_NUMBER_UNSET", "", "animated-drawable_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

