/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable.animator;

import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class AnimatedDrawable2ValueAnimatorHelper {
    @Nullable
    public static ValueAnimator createValueAnimator(AnimatedDrawable2 animatedDrawable, int maxDurationMs) {
        ValueAnimator animator = AnimatedDrawable2ValueAnimatorHelper.createValueAnimator(animatedDrawable, animatedDrawable.getLoopCount(), animatedDrawable.getLoopDurationMs());
        if (animator == null) {
            return null;
        }
        int repeatCount = (int)Math.max((long)maxDurationMs / animatedDrawable.getLoopDurationMs(), 1L);
        animator.setRepeatCount(repeatCount);
        return animator;
    }

    public static ValueAnimator createValueAnimator(Drawable animatedDrawable, int loopCount, long loopDurationMs) {
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{0, (int)loopDurationMs});
        animator.setDuration(loopDurationMs);
        animator.setRepeatCount(loopCount != 0 ? loopCount : -1);
        animator.setRepeatMode(1);
        animator.setInterpolator(null);
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = AnimatedDrawable2ValueAnimatorHelper.createAnimatorUpdateListener(animatedDrawable);
        animator.addUpdateListener(animatorUpdateListener);
        return animator;
    }

    public static ValueAnimator.AnimatorUpdateListener createAnimatorUpdateListener(Drawable drawable) {
        return animation -> drawable.setLevel(((Integer)animation.getAnimatedValue()).intValue());
    }

    private AnimatedDrawable2ValueAnimatorHelper() {
    }
}

