/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.frame;

import com.facebook.common.internal.VisibleForTesting;
import com.facebook.fresco.animation.backend.AnimationInformation;
import com.facebook.fresco.animation.frame.FrameScheduler;

public class DropFramesFrameScheduler
implements FrameScheduler {
    private static final int UNSET = -1;
    private final AnimationInformation mAnimationInformation;
    private long mLoopDurationMs = -1L;

    public DropFramesFrameScheduler(AnimationInformation animationInformation) {
        this.mAnimationInformation = animationInformation;
    }

    @Override
    public int getFrameNumberToRender(long animationTimeMs, long lastFrameTimeMs) {
        long loopCount;
        long loopDurationMs = this.getLoopDurationMs();
        if (loopDurationMs == 0L) {
            return this.getFrameNumberWithinLoop(0L);
        }
        if (!this.isInfiniteAnimation() && (loopCount = animationTimeMs / loopDurationMs) >= (long)this.mAnimationInformation.getLoopCount()) {
            return -1;
        }
        long timeInCurrentLoopMs = animationTimeMs % loopDurationMs;
        return this.getFrameNumberWithinLoop(timeInCurrentLoopMs);
    }

    @Override
    public long getLoopDurationMs() {
        if (this.mLoopDurationMs != -1L) {
            return this.mLoopDurationMs;
        }
        this.mLoopDurationMs = 0L;
        int frameCount = this.mAnimationInformation.getFrameCount();
        for (int i = 0; i < frameCount; ++i) {
            this.mLoopDurationMs += (long)this.mAnimationInformation.getFrameDurationMs(i);
        }
        return this.mLoopDurationMs;
    }

    @Override
    public long getTargetRenderTimeMs(int frameNumber) {
        long targetRenderTimeMs = 0L;
        for (int i = 0; i < frameNumber; ++i) {
            targetRenderTimeMs += (long)this.mAnimationInformation.getFrameDurationMs(frameNumber);
        }
        return targetRenderTimeMs;
    }

    @Override
    public long getTargetRenderTimeForNextFrameMs(long animationTimeMs) {
        long loopCount;
        long loopDurationMs = this.getLoopDurationMs();
        if (loopDurationMs == 0L) {
            return -1L;
        }
        if (!this.isInfiniteAnimation() && (loopCount = animationTimeMs / this.getLoopDurationMs()) >= (long)this.mAnimationInformation.getLoopCount()) {
            return -1L;
        }
        long timePassedInCurrentLoopMs = animationTimeMs % loopDurationMs;
        long timeOfNextFrameInLoopMs = 0L;
        int frameCount = this.mAnimationInformation.getFrameCount();
        for (int i = 0; i < frameCount && timeOfNextFrameInLoopMs <= timePassedInCurrentLoopMs; timeOfNextFrameInLoopMs += (long)this.mAnimationInformation.getFrameDurationMs(i), ++i) {
        }
        long timeUntilNextFrameInLoopMs = timeOfNextFrameInLoopMs - timePassedInCurrentLoopMs;
        return animationTimeMs + timeUntilNextFrameInLoopMs;
    }

    @Override
    public boolean isInfiniteAnimation() {
        return this.mAnimationInformation.getLoopCount() == 0;
    }

    @VisibleForTesting
    int getFrameNumberWithinLoop(long timeInCurrentLoopMs) {
        int frame = 0;
        long currentDuration = 0L;
        while (timeInCurrentLoopMs >= (currentDuration += (long)this.mAnimationInformation.getFrameDurationMs(++frame))) {
        }
        return frame - 1;
    }
}

