/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable.animator;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import com.facebook.fresco.animation.drawable.AnimatedDrawable2;

@TargetApi(value=11)
public class AnimatedDrawable2ValueAnimatorHelper {
    public static ValueAnimator createValueAnimator(AnimatedDrawable2 animatedDrawable, int maxDurationMs) {
        ValueAnimator animator = AnimatedDrawable2ValueAnimatorHelper.createValueAnimator(animatedDrawable);
        if (animator == null) {
            return null;
        }
        int repeatCount = (int)Math.max((long)maxDurationMs / animatedDrawable.getLoopDurationMs(), 1L);
        animator.setRepeatCount(repeatCount);
        return animator;
    }

    public static ValueAnimator createValueAnimator(AnimatedDrawable2 animatedDrawable) {
        int loopCount = animatedDrawable.getLoopCount();
        ValueAnimator animator = new ValueAnimator();
        animator.setIntValues(new int[]{0, (int)animatedDrawable.getLoopDurationMs()});
        animator.setDuration(animatedDrawable.getLoopDurationMs());
        animator.setRepeatCount(loopCount != 0 ? loopCount : -1);
        animator.setRepeatMode(1);
        animator.setInterpolator(null);
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = AnimatedDrawable2ValueAnimatorHelper.createAnimatorUpdateListener(animatedDrawable);
        animator.addUpdateListener(animatorUpdateListener);
        return animator;
    }

    public static ValueAnimator.AnimatorUpdateListener createAnimatorUpdateListener(final AnimatedDrawable2 drawable) {
        return new ValueAnimator.AnimatorUpdateListener(){

            @TargetApi(value=11)
            public void onAnimationUpdate(ValueAnimator animation) {
                drawable.setLevel((Integer)animation.getAnimatedValue());
            }
        };
    }

    private AnimatedDrawable2ValueAnimatorHelper() {
    }
}

