/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fresco.animation.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import com.facebook.common.logging.FLog;
import com.facebook.drawable.base.DrawableWithCaches;
import com.facebook.drawee.drawable.DrawableProperties;
import com.facebook.fresco.animation.backend.AnimationBackend;
import com.facebook.fresco.animation.drawable.AnimationListener;
import com.facebook.fresco.animation.drawable.BaseAnimationListener;
import com.facebook.fresco.animation.frame.DropFramesFrameScheduler;
import com.facebook.fresco.animation.frame.FrameScheduler;
import javax.annotation.Nullable;

public class AnimatedDrawable2
extends Drawable
implements Animatable,
DrawableWithCaches {
    private static final Class<?> TAG = AnimatedDrawable2.class;
    private static final AnimationListener NO_OP_LISTENER = new BaseAnimationListener();
    private static final int DEFAULT_FRAME_SCHEDULING_DELAY_MS = 8;
    private static final int DEFAULT_FRAME_SCHEDULING_OFFSET_MS = 0;
    @Nullable
    private AnimationBackend mAnimationBackend;
    @Nullable
    private FrameScheduler mFrameScheduler;
    private volatile boolean mIsRunning;
    private long mStartTimeMs;
    private long mLastFrameAnimationTimeMs;
    private long mExpectedRenderTimeMs;
    private int mLastDrawnFrameNumber;
    private long mFrameSchedulingDelayMs = 8L;
    private long mFrameSchedulingOffsetMs = 0L;
    private int mDroppedFrames;
    private volatile AnimationListener mAnimationListener = NO_OP_LISTENER;
    @Nullable
    private volatile DrawListener mDrawListener = null;
    @Nullable
    private DrawableProperties mDrawableProperties;
    private final Runnable mInvalidateRunnable = new Runnable(){

        @Override
        public void run() {
            AnimatedDrawable2.this.unscheduleSelf(AnimatedDrawable2.this.mInvalidateRunnable);
            AnimatedDrawable2.this.invalidateSelf();
        }
    };

    public AnimatedDrawable2() {
        this(null);
    }

    public AnimatedDrawable2(@Nullable AnimationBackend animationBackend) {
        this.mAnimationBackend = animationBackend;
        this.mFrameScheduler = AnimatedDrawable2.createSchedulerForBackendAndDelayMethod(this.mAnimationBackend);
    }

    public int getIntrinsicWidth() {
        if (this.mAnimationBackend == null) {
            return super.getIntrinsicWidth();
        }
        return this.mAnimationBackend.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        if (this.mAnimationBackend == null) {
            return super.getIntrinsicHeight();
        }
        return this.mAnimationBackend.getIntrinsicHeight();
    }

    public void start() {
        if (this.mIsRunning || this.mAnimationBackend == null || this.mAnimationBackend.getFrameCount() <= 1) {
            return;
        }
        this.mIsRunning = true;
        this.mExpectedRenderTimeMs = this.mStartTimeMs = this.now();
        this.mLastFrameAnimationTimeMs = -1L;
        this.mLastDrawnFrameNumber = -1;
        this.invalidateSelf();
        this.mAnimationListener.onAnimationStart(this);
    }

    public void stop() {
        if (!this.mIsRunning) {
            return;
        }
        this.mIsRunning = false;
        this.mExpectedRenderTimeMs = this.mStartTimeMs = 0L;
        this.mLastFrameAnimationTimeMs = -1L;
        this.mLastDrawnFrameNumber = -1;
        this.unscheduleSelf(this.mInvalidateRunnable);
        this.mAnimationListener.onAnimationStop(this);
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.setBounds(bounds);
        }
    }

    public void draw(Canvas canvas) {
        DrawListener listener;
        if (this.mAnimationBackend == null || this.mFrameScheduler == null) {
            return;
        }
        long actualRenderTimeStartMs = this.now();
        long animationTimeMs = this.mIsRunning ? actualRenderTimeStartMs - this.mStartTimeMs + this.mFrameSchedulingOffsetMs : Math.max(this.mLastFrameAnimationTimeMs, 0L);
        int frameNumberToDraw = this.mFrameScheduler.getFrameNumberToRender(animationTimeMs, this.mLastFrameAnimationTimeMs);
        if (frameNumberToDraw == -1) {
            frameNumberToDraw = this.mAnimationBackend.getFrameCount() - 1;
            this.mAnimationListener.onAnimationStop(this);
            this.mIsRunning = false;
        } else if (frameNumberToDraw == 0 && this.mLastDrawnFrameNumber != -1 && actualRenderTimeStartMs >= this.mExpectedRenderTimeMs) {
            this.mAnimationListener.onAnimationRepeat(this);
        }
        boolean frameDrawn = this.mAnimationBackend.drawFrame(this, canvas, frameNumberToDraw);
        if (frameDrawn) {
            this.mAnimationListener.onAnimationFrame(this, frameNumberToDraw);
            this.mLastDrawnFrameNumber = frameNumberToDraw;
        }
        if (!frameDrawn) {
            this.onFrameDropped();
        }
        long targetRenderTimeForNextFrameMs = -1L;
        long scheduledRenderTimeForNextFrameMs = -1L;
        long actualRenderTimeEnd = this.now();
        if (this.mIsRunning && (targetRenderTimeForNextFrameMs = this.mFrameScheduler.getTargetRenderTimeForNextFrameMs(actualRenderTimeEnd - this.mStartTimeMs)) != -1L) {
            scheduledRenderTimeForNextFrameMs = targetRenderTimeForNextFrameMs + this.mFrameSchedulingDelayMs;
            this.scheduleNextFrame(scheduledRenderTimeForNextFrameMs);
        }
        if ((listener = this.mDrawListener) != null) {
            listener.onDraw(this, this.mFrameScheduler, frameNumberToDraw, frameDrawn, this.mIsRunning, this.mStartTimeMs, animationTimeMs, this.mLastFrameAnimationTimeMs, actualRenderTimeStartMs, actualRenderTimeEnd, targetRenderTimeForNextFrameMs, scheduledRenderTimeForNextFrameMs);
        }
        this.mLastFrameAnimationTimeMs = animationTimeMs;
    }

    public void setAlpha(int alpha) {
        if (this.mDrawableProperties == null) {
            this.mDrawableProperties = new DrawableProperties();
        }
        this.mDrawableProperties.setAlpha(alpha);
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        if (this.mDrawableProperties == null) {
            this.mDrawableProperties = new DrawableProperties();
        }
        this.mDrawableProperties.setColorFilter(colorFilter);
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.setColorFilter(colorFilter);
        }
    }

    public int getOpacity() {
        return -3;
    }

    public void setAnimationBackend(@Nullable AnimationBackend animationBackend) {
        this.mAnimationBackend = animationBackend;
        if (this.mAnimationBackend != null) {
            this.mFrameScheduler = new DropFramesFrameScheduler(this.mAnimationBackend);
            this.mAnimationBackend.setBounds(this.getBounds());
            if (this.mDrawableProperties != null) {
                this.mDrawableProperties.applyTo((Drawable)this);
            }
        }
        this.mFrameScheduler = AnimatedDrawable2.createSchedulerForBackendAndDelayMethod(this.mAnimationBackend);
        this.stop();
    }

    @Nullable
    public AnimationBackend getAnimationBackend() {
        return this.mAnimationBackend;
    }

    public long getDroppedFrames() {
        return this.mDroppedFrames;
    }

    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    public boolean isInfiniteAnimation() {
        return this.mFrameScheduler != null && this.mFrameScheduler.isInfiniteAnimation();
    }

    public void jumpToFrame(int targetFrameNumber) {
        if (this.mAnimationBackend == null || this.mFrameScheduler == null) {
            return;
        }
        this.mLastFrameAnimationTimeMs = this.mFrameScheduler.getTargetRenderTimeMs(targetFrameNumber);
        this.mExpectedRenderTimeMs = this.mStartTimeMs = this.now() - this.mLastFrameAnimationTimeMs;
        this.invalidateSelf();
    }

    public long getLoopDurationMs() {
        if (this.mAnimationBackend == null) {
            return 0L;
        }
        if (this.mFrameScheduler != null) {
            return this.mFrameScheduler.getLoopDurationMs();
        }
        int loopDurationMs = 0;
        for (int i = 0; i < this.mAnimationBackend.getFrameCount(); ++i) {
            loopDurationMs += this.mAnimationBackend.getFrameDurationMs(i);
        }
        return loopDurationMs;
    }

    public int getFrameCount() {
        return this.mAnimationBackend == null ? 0 : this.mAnimationBackend.getFrameCount();
    }

    public int getLoopCount() {
        return this.mAnimationBackend == null ? 0 : this.mAnimationBackend.getLoopCount();
    }

    public void setFrameSchedulingDelayMs(long frameSchedulingDelayMs) {
        this.mFrameSchedulingDelayMs = frameSchedulingDelayMs;
    }

    public void setFrameSchedulingOffsetMs(long frameSchedulingOffsetMs) {
        this.mFrameSchedulingOffsetMs = frameSchedulingOffsetMs;
    }

    public void setAnimationListener(@Nullable AnimationListener animationListener) {
        this.mAnimationListener = animationListener != null ? animationListener : NO_OP_LISTENER;
    }

    public void setDrawListener(@Nullable DrawListener drawListener) {
        this.mDrawListener = drawListener;
    }

    private void scheduleNextFrame(long targetAnimationTimeMs) {
        this.mExpectedRenderTimeMs = this.mStartTimeMs + targetAnimationTimeMs;
        this.scheduleSelf(this.mInvalidateRunnable, this.mExpectedRenderTimeMs);
    }

    private void onFrameDropped() {
        ++this.mDroppedFrames;
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"Dropped a frame. Count: %s", (Object)this.mDroppedFrames);
        }
    }

    private long now() {
        return SystemClock.uptimeMillis();
    }

    @Nullable
    private static FrameScheduler createSchedulerForBackendAndDelayMethod(@Nullable AnimationBackend animationBackend) {
        if (animationBackend == null) {
            return null;
        }
        return new DropFramesFrameScheduler(animationBackend);
    }

    protected boolean onLevelChange(int level) {
        if (this.mIsRunning) {
            return false;
        }
        if (this.mLastFrameAnimationTimeMs != (long)level) {
            this.mLastFrameAnimationTimeMs = level;
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    public void dropCaches() {
        if (this.mAnimationBackend != null) {
            this.mAnimationBackend.clear();
        }
    }

    public static interface DrawListener {
        public void onDraw(AnimatedDrawable2 var1, FrameScheduler var2, int var3, boolean var4, boolean var5, long var6, long var8, long var10, long var12, long var14, long var16, long var18);
    }
}

